/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.pay.business.component.PayCertBackgroundService;
import cn.kinyun.pay.business.dto.request.OrderQuerySimpleRequest;
import cn.kinyun.pay.business.dto.request.OrderRequest;
import cn.kinyun.pay.business.dto.request.PayConfigListReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.OrderData;
import cn.kinyun.pay.business.dto.response.OrderQueryData;
import cn.kinyun.pay.business.dto.response.PayConfigGroup;
import cn.kinyun.pay.business.dto.response.PayConfigListResp;
import cn.kinyun.pay.business.dto.vo.OrderHeaderDto;
import cn.kinyun.pay.business.enums.PayChannelType;
import cn.kinyun.pay.business.service.PayInnerCertService;
import cn.kinyun.pay.business.service.PayOrderService;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.GoodsValidType;
import com.kuaike.scrm.common.enums.MeetingWatchType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.IpUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.SignUtil;
import com.kuaike.scrm.coupon.enums.CouponType;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerCoupon;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerOrderRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerCouponMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerOrderRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.goods.enums.GoodsSkuStatus;
import com.kuaike.scrm.goods.enums.GoodsSpuStatus;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.meeting.dto.reponse.MeetingOrderStatusResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingPayInitResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingPayResp;
import com.kuaike.scrm.meeting.dto.request.MeetingJSAPIConfigDto;
import com.kuaike.scrm.meeting.dto.request.MeetingOrderStatusReq;
import com.kuaike.scrm.meeting.dto.request.MeetingPayDataDto;
import com.kuaike.scrm.meeting.dto.request.MeetingPayInitReq;
import com.kuaike.scrm.meeting.dto.request.MeetingPayReqDto;
import com.kuaike.scrm.meeting.service.MeetingPayService;
import com.kuaike.scrm.order.dto.AddressInfo;
import com.kuaike.scrm.order.dto.ExtInfo;
import com.kuaike.scrm.order.dto.ShopSkuDto;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.model.OrderEsModel;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.order.service.GoodsOrderService;
import com.kuaike.scrm.order.service.OrderNotificationService;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import com.kuaike.trace.utils.TraceIdUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;

@Service
@Import(value={PayCertBackgroundService.class})
public class MeetingPayServiceImpl
implements MeetingPayService {
    private static final Logger log = LoggerFactory.getLogger(MeetingPayServiceImpl.class);
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private ComponentTokenService componentTokenService;
    @Resource
    private IdGen idGen;
    @Resource
    private PayOrderService payOrderService;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private ParamEncryMapper paramEncryMapper;
    @Resource
    private ShopSkuMapper shopSkuMapper;
    @Resource
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingCustomerCouponMapper meetingCustomerCouponMapper;
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private OrderNotificationService orderNotificationService;
    @Resource
    private MeetingCustomerOrderRelationMapper meetingCustomerOrderRelationMapper;
    @Resource
    private GoodsOrderService goodsOrderService;
    @Resource
    private PayCertBackgroundService payCertBackgroundService;
    @Resource
    private PayInnerCertService payInnerCertService;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private ScrmPayConfigService scrmPayConfigService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private MeetingPayService self;
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private PayRecordMapper payRecordMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;

    @Override
    public MeetingPayInitResp payInit(MeetingPayInitReq req) {
        log.info("payInit req:{}", (Object)req);
        req.validate();
        Meeting meeting = this.checkMeeting(req.getRoomId());
        Long bizId = meeting.getBizId();
        MeetingPayInitResp resp = new MeetingPayInitResp();
        MeetingJSAPIConfigDto configData = new MeetingJSAPIConfigDto();
        configData.setAppId(this.getAppId(bizId, req.getType(), req.getAppId()));
        this.buildConfigData(configData, req.getUrl());
        resp.setConfigData(configData);
        return resp;
    }

    private String getAppId(Long bizId, Integer payType, String appId) {
        if (PayChannelType.WEIXIN_JSAPI.getValue().equals(payType)) {
            OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId);
            Preconditions.checkArgument((officialAccount != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u76f4\u64ad\u95f4\u6682\u672a\u5f00\u901a\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8");
            return officialAccount.getAppId();
        }
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        Preconditions.checkArgument((appletInfo != null && appletInfo.getBizId().equals(bizId) ? 1 : 0) != 0, (Object)"\u672a\u6388\u6743\u8be5\u5c0f\u7a0b\u5e8f");
        return appletInfo.getAppId();
    }

    private String getPayAppId(Long bizId, Integer payChannelType) {
        PayChannelType channelType = PayChannelType.get((Integer)payChannelType);
        String payChannelDesc = channelType.getDesc();
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        PayConfigListReq req = new PayConfigListReq();
        req.setPayChannelType(payChannelType);
        req.setEnable(Integer.valueOf(1));
        req.setCorpId(businessCustomer.getCorpId());
        PayConfigListResp payConfigListResp = this.scrmPayConfigService.queryConfigList(req);
        log.info("getPayAppId,payConfigListResp:{}", (Object)payConfigListResp);
        Preconditions.checkArgument((payConfigListResp != null && CollectionUtils.isNotEmpty((Collection)payConfigListResp.getList()) ? 1 : 0) != 0, (Object)("\u672a\u914d\u7f6e" + payChannelDesc));
        return ((PayConfigGroup)payConfigListResp.getList().get(0)).getAppId();
    }

    @Override
    public MeetingPayResp pay(HttpServletRequest request, MeetingPayReqDto dto) {
        boolean zeroOrder;
        BigDecimal realPay;
        String customerOpenId;
        Meeting meeting;
        StopWatchDto timer = new StopWatchDto("meetingPay", true, log);
        log.info("MeetingPayService pay dto:{}", (Object)dto);
        dto.validate();
        MeetingPayResp resp = new MeetingPayResp();
        timer.start("selectMeeting");
        if (StringUtils.isNotBlank((CharSequence)dto.getMeetingId())) {
            Meeting select = new Meeting();
            select.setIsDeleted(Integer.valueOf(0));
            select.setNum(dto.getMeetingId());
            meeting = (Meeting)this.meetingMapper.selectOne((Object)select);
            Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u95f4\u4e0d\u5b58\u5728");
        } else {
            meeting = this.checkMeeting(dto.getRoomId());
        }
        timer.stop();
        Long bizId = meeting.getBizId();
        String corpId = meeting.getCorpId();
        timer.start("getPayAppId");
        timer.stop();
        ShopSkuDto shopSkuDto = new ShopSkuDto();
        timer.start("validateGoods");
        ShopSku shopSku = this.validateGoods(dto.getRoomId(), dto.getSkuId(), bizId);
        timer.stop();
        timer.start("validateSpu");
        ShopSpu shopSpu = this.validateSpu(bizId, shopSku.getProductId(), shopSkuDto);
        timer.stop();
        String spuBody = shopSpu.getSpuBody();
        SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)spuBody, SpuCreateReq.class);
        Preconditions.checkArgument((spuCreateReq.getNeedAddress() == null || spuCreateReq.getNeedAddress().equals(0) || StringUtils.isNotBlank((CharSequence)dto.getAddress()) ? 1 : 0) != 0, (Object)"\u8bf7\u586b\u5199\u5730\u5740");
        MeetingCustomerInfo meetingCustomerInfo = null;
        if (PayChannelType.WEIXIN_H5.equals((Object)PayChannelType.get((Integer)dto.getType())) || PayChannelType.WEIXIN_NATIVE.equals((Object)PayChannelType.get((Integer)dto.getType()))) {
            customerOpenId = "";
            realPay = this.calculateRealPayByH5(dto, shopSku, meeting, shopSkuDto);
            meetingCustomerInfo = this.insertMeetingCustomerInfoByH5(dto, meeting);
        } else {
            timer.start("selectParamEncry");
            ParamEncry selectParamEncry = new ParamEncry();
            selectParamEncry.setNum(dto.getCustomerStr());
            ParamEncry paramEncry = (ParamEncry)this.paramEncryMapper.selectOne((Object)selectParamEncry);
            timer.stop();
            Preconditions.checkArgument((paramEncry != null ? 1 : 0) != 0, (Object)"\u60a8\u7684\u8eab\u4efd\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6388\u6743\u8fdb\u5165\u76f4\u64ad\u95f4");
            MeetingParams meetingParams = (MeetingParams)JSON.parseObject((String)paramEncry.getParams(), MeetingParams.class);
            customerOpenId = meetingParams.getOpenId();
            timer.start("selectParamEncryRelation");
            MeetingCustomerParamEncryRelation selectRelation = new MeetingCustomerParamEncryRelation();
            selectRelation.setMeetingId(meeting.getId());
            selectRelation.setEncryNum(dto.getCustomerStr());
            List relations = this.meetingCustomerParamEncryRelationMapper.select((Object)selectRelation);
            timer.stop();
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)relations), (Object)"\u60a8\u7684\u8eab\u4efd\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6388\u6743\u8fdb\u5165\u76f4\u64ad\u95f4");
            ArrayList<String> customerInfoNums = new ArrayList<String>();
            MeetingCustomerParamEncryRelation relation = (MeetingCustomerParamEncryRelation)relations.get(0);
            log.info("MeetingPayService pay relation:{}", (Object)relation);
            if (StringUtils.isBlank((CharSequence)relation.getBjyNumber())) {
                relation.setBjyNumber(dto.getUserNumber());
                this.meetingCustomerParamEncryRelationMapper.updateByPrimaryKeySelective((Object)relation);
            }
            if (MeetingWatchType.PLAY_BACK.getValue() == relation.getWatchType().intValue()) {
                String num = this.idGen.getNum();
                meetingCustomerInfo = new MeetingCustomerInfo();
                meetingCustomerInfo.setBizId(bizId);
                meetingCustomerInfo.setCustomerStr(dto.getCustomerStr());
                meetingCustomerInfo.setNum(num);
                meetingCustomerInfo.setName(dto.getName());
                meetingCustomerInfo.setAvatar(relation.getBjyAvatar());
                customerInfoNums.add(num);
            } else {
                MeetingCustomerInfo select = new MeetingCustomerInfo();
                select.setBizId(meeting.getBizId());
                select.setMeetingId(meeting.getId());
                select.setBjyNumber(dto.getUserNumber());
                timer.start("selectMeetingCustomerInfoByUserNumber");
                List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
                timer.stop();
                if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
                    meetingCustomerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
                }
                if (meetingCustomerInfo == null) {
                    select = new MeetingCustomerInfo();
                    select.setMeetingId(meeting.getId());
                    select.setCustomerStr(dto.getCustomerStr());
                    timer.start("selectMeetingCustomerInfo");
                    List customerInfos = this.meetingCustomerInfoMapper.select((Object)select);
                    if (CollectionUtils.isNotEmpty((Collection)customerInfos)) {
                        meetingCustomerInfo = (MeetingCustomerInfo)customerInfos.get(0);
                    }
                    timer.stop();
                }
                if (meetingCustomerInfo == null) {
                    timer.start("insertOrUpdateMeetingCustomerInfo");
                    meetingCustomerInfo = this.insertOrUpdateMeetingCustomerInfo(relation, meeting.getId(), meeting.getRoomId());
                    timer.stop();
                } else {
                    timer.start("updateCustomerInfo");
                    this.updateCustomerInfo(meetingCustomerInfo, dto.getMobile(), dto.getCustomerStr(), relation);
                    timer.stop();
                }
                customerInfoNums.add(meetingCustomerInfo.getNum());
            }
            timer.start("calculateRealPay");
            realPay = this.calculateRealPay(dto, shopSku, meetingCustomerInfo, shopSkuDto, customerInfoNums);
            timer.stop();
        }
        BeanUtils.copyProperties((Object)shopSku, (Object)shopSkuDto);
        shopSkuDto.setAmount(dto.getAmount());
        String goodsName = spuCreateReq.getTitle();
        shopSkuDto.setTitle(goodsName);
        Date now = new Date();
        MeetingPayDataDto payData = new MeetingPayDataDto();
        payData.setTimeStamp(String.valueOf(now.getTime() / 1000L));
        String bizOrderId = this.idGen.getNum();
        String outOrderNum = "0";
        PayChannelType payChannelType = PayChannelType.get((Integer)dto.getType());
        boolean bl = zeroOrder = realPay.compareTo(BigDecimal.ZERO) == 0;
        if (!zeroOrder) {
            timer.start("executePay");
            OrderRequest orderRequest = this.buildOrderRequest(dto.getType(), corpId, goodsName, realPay.longValue(), bizOrderId);
            if (PayChannelType.WEIXIN_H5.equals((Object)PayChannelType.get((Integer)dto.getType()))) {
                this.fillExtraParamsByWxH5(orderRequest, request, dto.getSkuId(), dto.getWapUrl());
            } else if (PayChannelType.WEIXIN_NATIVE.equals((Object)PayChannelType.get((Integer)dto.getType()))) {
                this.fillExtraParamsByWxNative(orderRequest, dto.getSkuId());
            } else {
                this.fillExtraParams(orderRequest, request, customerOpenId, this.getAppId(bizId, dto.getType(), dto.getAppId()));
            }
            String signParams = this.payCertBackgroundService.getSign((Object)orderRequest);
            log.info("MeetingPayService pay params\u52a0\u5bc6\u524d:{},\u52a0\u5bc6\u540e:{}", (Object)orderRequest.getParams(), (Object)signParams);
            orderRequest.setSign(signParams);
            OrderData orderData = this.executePay(3, orderRequest);
            timer.stop();
            Preconditions.checkArgument((orderData != null ? 1 : 0) != 0, (Object)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            this.buildPayData(payData, orderData, payChannelType);
            resp.setPayData(payData);
            outOrderNum = orderData.getOrderNum();
            Long operatorId = -1L;
            operatorId = this.getBelongUserId(dto, corpId, bizId, operatorId);
            timer.start("insert into payOrder and payOrderRecord");
            this.insertPayOrder(bizId, corpId, realPay.divide(BigDecimal.valueOf(100L)), bizOrderId, operatorId);
            this.insertPayRecord(bizId, corpId, realPay.divide(BigDecimal.valueOf(100L)), goodsName, bizOrderId, orderRequest, orderData, operatorId);
            timer.stop();
        }
        ExtInfo extInfo = new ExtInfo();
        extInfo.setMeetingId(meeting.getId());
        extInfo.setCustomerName(dto.getName());
        extInfo.setCustomerStr(dto.getCustomerStr());
        extInfo.setBjyNumber(dto.getUserNumber());
        timer.start("insertShopOrderToDb");
        ShopOrder shopOrder = this.insertShopOrderToDb(bizId, meeting.getCorpId(), bizOrderId, outOrderNum, payData, shopSku, dto, realPay, customerOpenId, goodsName, payChannelType);
        timer.stop();
        timer.print();
        MeetingCustomerInfo finalMeetingCustomerInfo = meetingCustomerInfo;
        String traceId = TraceIdUtils.getTraceId();
        TraceExecutorWrapUtil.wrapCompletableFutureRunAsync(() -> {
            TraceIdUtils.setTraceId((String)traceId);
            OrderEsModel orderEsModel = null;
            try {
                orderEsModel = this.goodsOrderEsService.insertByShopOrder(shopOrder, Collections.singletonList(shopSkuDto), extInfo, OrderSource.MEETING_ORDER, finalMeetingCustomerInfo, cn.kinyun.customer.center.enums.PayChannelType.get((Integer)dto.getType()), Long.valueOf(realPay.longValue()));
            }
            catch (Exception e) {
                log.error("GoodsOrder\u8ba2\u5355 \u5199\u5165ES\u5f02\u5e38", (Throwable)e);
            }
            if (!zeroOrder) {
                this.orderNotificationService.addOrder(bizId, shopOrder.getCreateTime(), shopOrder.getOrderId());
            }
            this.insertOrderRelation(meeting, shopOrder, finalMeetingCustomerInfo);
            if (zeroOrder && orderEsModel != null) {
                try {
                    this.goodsOrderService.paySuccessHandleCoupon(orderEsModel, bizId);
                }
                catch (Exception e) {
                    log.error("GoodsOrder\u96f6\u5143\u8ba2\u5355 \u5904\u7406\u4f18\u60e0\u5238\u76f8\u5173\u903b\u8f91\u5f02\u5e38", (Throwable)e);
                }
                try {
                    this.goodsOrderService.handlePerformanceAndLeads(orderEsModel, bizId, shopOrder.getCorpId(), shopOrder.getOrderId().toString());
                }
                catch (Exception e) {
                    log.error("GoodsOrder\u96f6\u5143\u8ba2\u5355 \u5904\u7406\u4e1a\u7ee9\u548c\u7ebf\u7d22\u76f8\u5173\u903b\u8f91\u5f02\u5e38", (Throwable)e);
                }
            }
        });
        if (zeroOrder) {
            resp.setPaySuccess(true);
            try {
                this.goodsOrderService.pushOrderToNetSchool(bizId, corpId, shopSkuDto.getProductId(), shopOrder, extInfo);
            }
            catch (Exception e) {
                log.error("zero order push net school error:", (Throwable)e);
            }
        }
        return resp;
    }

    private Long getBelongUserId(MeetingPayReqDto dto, String corpId, Long bizId, Long operatorId) {
        try {
            CrmLeadsInfoReq req = new CrmLeadsInfoReq();
            req.setCorpId(corpId);
            req.setMobile(dto.getMobile());
            boolean exists = this.crmLeadsService.exists(req);
            if (exists) {
                CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                crmLeadsInfoReq.setCorpId(corpId);
                crmLeadsInfoReq.setMobile(dto.getMobile());
                CrmLeadsInfoResp crmLeadsInfoResp = this.crmLeadsService.getLeads(crmLeadsInfoReq);
                if (crmLeadsInfoResp != null) {
                    operatorId = crmLeadsInfoResp.getBindingUserId();
                }
            }
            if (operatorId == null) {
                operatorId = this.goodsOrderService.selectInviteUserId(bizId, dto.getCustomerStr());
            }
            if (operatorId == null) {
                operatorId = -1L;
            }
        }
        catch (Exception e) {
            log.error("query crm Leads with error", (Throwable)e);
        }
        return operatorId;
    }

    private void insertPayRecord(Long bizId, String corpId, BigDecimal realPay, String goodsName, String bizOrderId, OrderRequest orderRequest, OrderData orderData, Long operatorId) {
        PayRecord payRecord = new PayRecord();
        payRecord.setPayInfo(JSON.toJSONString((Object)orderData));
        payRecord.setStatus(Integer.valueOf(PayStatusEnum.UNPAID.getValue()));
        payRecord.setBizId(bizId);
        payRecord.setOrderNum(bizOrderId);
        payRecord.setAmount(Long.valueOf(realPay.longValue()));
        payRecord.setPayChannelType(orderRequest.getChannelType());
        payRecord.setCorpId(corpId);
        payRecord.setCreateBy(operatorId);
        payRecord.setCreateTime(new Date());
        payRecord.setPayTradeNum(orderData.getOrderNum());
        payRecord.setTotalAmount(Long.valueOf(realPay.longValue()));
        payRecord.setRemark(StringUtils.abbreviate((String)("\u76f4\u64ad\u5e26\u8d27:" + goodsName), (int)500));
        payRecord.setRequestId(orderRequest.getRequestId());
        payRecord.setTradeSeq(orderData.getOutOrderNum());
        payRecord.setUpdateBy(operatorId);
        payRecord.setUpdateTime(new Date());
        this.payRecordMapper.insert((Object)payRecord);
    }

    private void insertPayOrder(Long bizId, String corpId, BigDecimal realPay, String bizOrderId, Long operatorId) {
        PayOrder payOrder = new PayOrder();
        payOrder.setPayAmount(Long.valueOf(0L));
        payOrder.setPayStatus(Integer.valueOf(PayStatusEnum.UNPAID.getValue()));
        payOrder.setOrderNum(bizOrderId);
        payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.NONE.getValue()));
        payOrder.setPayRefundAmount(Long.valueOf(0L));
        payOrder.setBizId(bizId);
        payOrder.setCorpId(corpId);
        payOrder.setCreateBy(operatorId);
        payOrder.setOfflineRefundAmount(Long.valueOf(0L));
        payOrder.setTotalAmount(Long.valueOf(realPay.longValue()));
        payOrder.setCreateTime(new Date());
        payOrder.setUpdateBy(operatorId);
        payOrder.setUpdateTime(new Date());
        this.payOrderMapper.insert((Object)payOrder);
    }

    private MeetingCustomerInfo insertMeetingCustomerInfoByH5(MeetingPayReqDto dto, Meeting meeting) {
        String userNumber = dto.getUserNumber();
        MeetingCustomerInfo select = new MeetingCustomerInfo();
        select.setBizId(meeting.getBizId());
        select.setMeetingId(meeting.getId());
        select.setBjyNumber(userNumber);
        List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
        if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
            log.info("insertMeetingCustomerInfoByH5 meetingCustomerInfo exist");
            MeetingCustomerInfo customerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
            if (StringUtils.isNotBlank((CharSequence)dto.getMobile()) && !Objects.equals(customerInfo.getBjyMobile(), dto.getMobile())) {
                customerInfo.setBjyMobile(dto.getMobile());
                this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
            }
            return customerInfo;
        }
        MeetingCustomerInfo customerInfo = new MeetingCustomerInfo();
        customerInfo.setNum(this.idGen.getNum());
        customerInfo.setBizId(meeting.getBizId());
        customerInfo.setRoomId(meeting.getRoomId());
        customerInfo.setMeetingId(meeting.getId());
        customerInfo.setAppId("");
        customerInfo.setOpenId("");
        customerInfo.setUnionId("");
        customerInfo.setContactId("");
        customerInfo.setCustomerStr(dto.getCustomerStr() == null ? "" : dto.getCustomerStr());
        customerInfo.setName(dto.getName());
        customerInfo.setBjyNumber(userNumber);
        customerInfo.setBjyMobile(dto.getMobile());
        customerInfo.setInfoId(userNumber);
        Date curTime = new Date();
        customerInfo.setArrivalTime(curTime);
        customerInfo.setCreateTime(curTime);
        customerInfo.setUpdateTime(curTime);
        log.info("insertMeetingCustomerInfoByH5 customerInfo:{}", (Object)customerInfo);
        this.meetingCustomerInfoMapper.insertSelective((Object)customerInfo);
        return customerInfo;
    }

    private MeetingCustomerInfo insertOrUpdateMeetingCustomerInfo(MeetingCustomerParamEncryRelation relation, Long meetingId, String roomId) {
        Date curTime = new Date();
        MeetingCustomerInfo select = new MeetingCustomerInfo();
        select.setBizId(relation.getBizId());
        select.setMeetingId(meetingId);
        select.setBjyNumber(relation.getBjyNumber());
        MeetingCustomerInfo meetingCustomerInfo = (MeetingCustomerInfo)this.meetingCustomerInfoMapper.selectOne((Object)select);
        if (meetingCustomerInfo != null) {
            log.info("insertOrUpdateMeetingCustomerInfo \u901a\u8fc7bjyNumber\u5339\u914d\u5230\u4e86meetingCustomerInfo");
            meetingCustomerInfo.setCustomerStr(relation.getEncryNum());
            this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)meetingCustomerInfo);
            return meetingCustomerInfo;
        }
        String unionId = relation.getUnionId();
        String appId = relation.getAppId();
        String openId = relation.getOpenId();
        MeetingCustomerInfo customerInfo = new MeetingCustomerInfo();
        customerInfo.setNum(this.idGen.getNum());
        customerInfo.setBizId(relation.getBizId());
        customerInfo.setRoomId(roomId);
        customerInfo.setMeetingId(meetingId);
        customerInfo.setAppId(appId);
        customerInfo.setOpenId(openId);
        customerInfo.setContactId(relation.getContactId());
        customerInfo.setCustomerStr(relation.getEncryNum());
        customerInfo.setName(relation.getBjyName());
        customerInfo.setBjyNumber(relation.getBjyNumber());
        if (MobileUtils.isPhone((String)relation.getBjyNumber())) {
            customerInfo.setBjyMobile(relation.getBjyNumber());
        }
        String infoId = relation.getBjyNumber();
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            infoId = unionId;
            customerInfo.setUnionId(unionId);
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appId, openId})) {
            infoId = appId + openId;
        }
        customerInfo.setInfoId(infoId);
        customerInfo.setArrivalTime(curTime);
        customerInfo.setCreateTime(curTime);
        customerInfo.setUpdateTime(curTime);
        customerInfo.setAvatar(relation.getBjyAvatar());
        log.info("MeetingPayService insertOrUpdateMeetingCustomerInfo :{}", (Object)customerInfo);
        this.meetingCustomerInfoMapper.insertSelective((Object)customerInfo);
        return customerInfo;
    }

    private void updateCustomerInfo(MeetingCustomerInfo customerInfo, String mobile, String customerStr, MeetingCustomerParamEncryRelation relation) {
        String bjyAvatar;
        if (customerInfo == null) {
            return;
        }
        boolean needUpdate = false;
        if (StringUtils.isNotBlank((CharSequence)mobile) && !Objects.equals(customerInfo.getBjyMobile(), mobile)) {
            customerInfo.setBjyMobile(mobile);
            needUpdate = true;
        }
        if (StringUtils.isBlank((CharSequence)customerInfo.getCustomerStr()) && StringUtils.isNotBlank((CharSequence)customerStr)) {
            customerInfo.setCustomerStr(customerStr);
            needUpdate = true;
        }
        if (StringUtils.isNotBlank((CharSequence)(bjyAvatar = relation.getBjyAvatar())) && StringUtils.isBlank((CharSequence)customerInfo.getAvatar())) {
            customerInfo.setAvatar(bjyAvatar);
            needUpdate = true;
        }
        if (needUpdate) {
            log.info("updateCustomerInfo,customerInfo:{}", (Object)customerInfo);
            this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)customerInfo);
        }
    }

    private void insertOrderRelation(Meeting meeting, ShopOrder shopOrder, MeetingCustomerInfo meetingCustomerInfo) {
        Date now = new Date();
        MeetingCustomerOrderRelation relation = new MeetingCustomerOrderRelation();
        relation.setBizId(meeting.getBizId());
        relation.setMeetingId(meeting.getId());
        relation.setMeetingCustomerNum(meetingCustomerInfo.getNum());
        relation.setMeetingCustomerName(meetingCustomerInfo.getName());
        relation.setOrderId(shopOrder.getOrderId());
        relation.setCreateTime(now);
        relation.setUpdateTime(now);
        this.meetingCustomerOrderRelationMapper.insertSelective((Object)relation);
    }

    private ShopOrder insertShopOrderToDb(Long bizId, String corpId, String orderId, String outOrderId, MeetingPayDataDto payData, ShopSku shopSku, MeetingPayReqDto dto, BigDecimal realPay, String openId, String goodsName, PayChannelType payChannelType) {
        ShopOrder insert = new ShopOrder();
        insert.setNum(this.idGen.getNum());
        insert.setBizId(bizId);
        insert.setCorpId(corpId);
        insert.setAppId("-1");
        insert.setOrderId(orderId);
        insert.setOutOrderId(outOrderId);
        insert.setStatus(realPay.compareTo(BigDecimal.ZERO) == 0 ? OrderStatus.PAID.getStatus() : OrderStatus.WAIT_PAY.getStatus());
        insert.setPayTime(realPay.compareTo(BigDecimal.ZERO) == 0 ? new Date() : null);
        insert.setPayMethod(payChannelType.getDesc());
        insert.setPrepayId(payData.getPrepayId());
        insert.setProductTitle(goodsName);
        insert.setPrepayTime(new Date(Long.parseLong(payData.getTimeStamp()) * 1000L));
        BigDecimal originPay = new BigDecimal(dto.getAmount());
        originPay = originPay.multiply(new BigDecimal(shopSku.getSalePrice()));
        insert.setProductPrice(Long.valueOf(originPay.longValue()));
        insert.setOrderPrice(Long.valueOf(realPay.longValue()));
        insert.setFreight(Long.valueOf(0L));
        insert.setIsDiscounted(Boolean.valueOf(false));
        insert.setDiscountedPrice(Long.valueOf(originPay.subtract(realPay).longValue()));
        if (originPay.compareTo(realPay) > 0) {
            insert.setIsDiscounted(Boolean.valueOf(true));
        }
        insert.setOpenId(openId);
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setUserName(dto.getName());
        addressInfo.setTelNumber(dto.getMobile());
        addressInfo.setDetailInfo(dto.getAddress());
        addressInfo.setProvinceCode(dto.getProvinceCode());
        addressInfo.setCityCode(dto.getCityCode());
        addressInfo.setCountyCode(dto.getCountyCode());
        insert.setAddressinfo(JSON.toJSONString((Object)addressInfo));
        insert.setDeliveryInfo("{}");
        insert.setCreateBy(Long.valueOf(-1L));
        Date now = new Date();
        insert.setCreateTime(now);
        insert.setUpdateBy(Long.valueOf(-1L));
        insert.setUpdateTime(now);
        insert.setIsDeleted(Integer.valueOf(0));
        insert.setSource(shopSku.getSource());
        this.shopOrderMapper.insert((Object)insert);
        return insert;
    }

    private BigDecimal calculateRealPayByH5(MeetingPayReqDto dto, ShopSku shopSku, Meeting meeting, ShopSkuDto shopSkuDto) {
        BigDecimal realPay = new BigDecimal(dto.getAmount());
        realPay = realPay.multiply(new BigDecimal(shopSku.getSalePrice()));
        String userNumber = dto.getUserNumber();
        log.info("calculateRealPayByH5 originRealPay:{}", (Object)realPay.doubleValue());
        if (StringUtils.isBlank((CharSequence)dto.getCouponId())) {
            return realPay;
        }
        MeetingCustomerInfo select = new MeetingCustomerInfo();
        select.setBizId(meeting.getBizId());
        select.setMeetingId(meeting.getId());
        select.setBjyNumber(userNumber);
        List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)select);
        if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
            log.info("calculateRealPayByH5 meetingCustomerInfos isEmpty");
            return realPay;
        }
        Set customerInfoNums = meetingCustomerInfos.stream().map(MeetingCustomerInfo::getNum).collect(Collectors.toSet());
        List customerCoupons = this.meetingCustomerCouponMapper.queryUnUseByMeetingCustomerNums(meeting.getBizId(), customerInfoNums, dto.getCouponId());
        if (CollectionUtils.isEmpty((Collection)customerCoupons)) {
            log.info("calculateRealPayByH5 userNumber:{} \u6ca1\u6709\u8be5\u4f18\u60e0\u5238couponNum:{} \u65e0\u6cd5\u4f7f\u7528\u4f18\u60e0 realPay:{}", new Object[]{userNumber, dto.getCouponId(), realPay.doubleValue()});
            return realPay;
        }
        return this.calculateCouponRealPay(realPay, dto, customerCoupons, shopSkuDto);
    }

    private BigDecimal calculateCouponRealPay(BigDecimal originPay, MeetingPayReqDto dto, List<MeetingCustomerCoupon> customerCoupons, ShopSkuDto shopSkuDto) {
        BigDecimal fullPrice;
        ShopCoupon selectCoupon = new ShopCoupon();
        selectCoupon.setNum(dto.getCouponId());
        ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)selectCoupon);
        if (shopCoupon == null || shopCoupon.getUsageScenario() != 2) {
            log.info("calculateCouponRealPay \u4f18\u60e0\u5238\u4e0d\u5b58\u5728\u6216\u975e\u76f4\u64ad\u5e26\u8d27\u4f18\u60e0\u5238 \u65e0\u6cd5\u4f7f\u7528\u4f18\u60e0 realPay:{} shopCoupon:{}", (Object)originPay.doubleValue(), (Object)shopCoupon);
            return originPay;
        }
        Integer validType = shopCoupon.getValidType();
        Date now = new Date();
        if (GoodsValidType.COUPON_VALID_TYPE_TIME.getType().equals(validType)) {
            Date validStartTime = shopCoupon.getValidStartTime();
            if (now.before(validStartTime)) {
                log.info("calculateCouponRealPay \u4f18\u60e0\u5238\u6682\u672a\u751f\u6548 \u65e0\u6cd5\u4f7f\u7528 now:{} validStartTime:{} \u4f18\u60e0\u5238couponNum:{}", new Object[]{now, validStartTime, dto.getCouponId()});
                return originPay;
            }
            Date validEndTime = shopCoupon.getValidEndTime();
            if (now.after(validEndTime)) {
                log.info("calculateCouponRealPay \u4f18\u60e0\u5238\u5df2\u8fc7\u751f\u6548\u65f6\u95f4 \u65e0\u6cd5\u4f7f\u7528 now:{} validEndTime:{} \u4f18\u60e0\u5238couponNum:{}", new Object[]{now, validEndTime, dto.getCouponId()});
                return originPay;
            }
        } else {
            Date createTime = customerCoupons.get(0).getCreateTime();
            Integer validDayNum = shopCoupon.getValidDayNum();
            int quotByDays = DateUtil.getQuotByDays((Date)createTime, (Date)now);
            if (quotByDays > validDayNum) {
                log.info("calculateCouponRealPay \u4f18\u60e0\u5238\u5df2\u8fc7\u751f\u6548\u65f6\u95f4 \u65e0\u6cd5\u4f7f\u7528 now:{} \u9886\u53d6\u65f6\u95f4createTime:{}  {}\u5929\u5185\u6709\u6548  \u4f18\u60e0\u5238couponNum:{}", new Object[]{now, createTime, validDayNum, dto.getCouponId()});
                return originPay;
            }
        }
        shopSkuDto.setCouponIds(Collections.singletonList(shopCoupon.getCouponId()));
        if (CouponType.PRODUCT_DIRECT_DISCOUNT.getType().equals(shopCoupon.getType())) {
            if ((originPay = originPay.subtract(new BigDecimal(shopCoupon.getDiscountFee()))).doubleValue() <= 0.0) {
                originPay = BigDecimal.ZERO;
            }
        } else if (CouponType.PRODUCT_FULL_DISCOUNT.getType().equals(shopCoupon.getType()) && originPay.compareTo(fullPrice = new BigDecimal(shopCoupon.getProductPrice())) >= 0 && (originPay = originPay.subtract(new BigDecimal(shopCoupon.getDiscountFee()))).doubleValue() <= 0.0) {
            originPay = BigDecimal.ZERO;
        }
        return originPay;
    }

    private BigDecimal calculateRealPay(MeetingPayReqDto dto, ShopSku shopSku, MeetingCustomerInfo meetingCustomerInfo, ShopSkuDto shopSkuDto, List<String> customerInfoNums) {
        BigDecimal realPay = new BigDecimal(dto.getAmount());
        realPay = realPay.multiply(new BigDecimal(shopSku.getSalePrice()));
        log.info("calculateRealPay originRealPay:{}", (Object)realPay.doubleValue());
        if (StringUtils.isNotBlank((CharSequence)dto.getCouponId())) {
            List customerCoupons = this.meetingCustomerCouponMapper.queryUnUseByMeetingCustomerNums(meetingCustomerInfo.getBizId(), customerInfoNums, dto.getCouponId());
            if (CollectionUtils.isEmpty((Collection)customerCoupons)) {
                log.info("calculateRealPay customerStr:{} \u6ca1\u6709\u8be5\u4f18\u60e0\u5238couponNum:{} \u65e0\u6cd5\u4f7f\u7528\u4f18\u60e0 realPay:{}", new Object[]{meetingCustomerInfo.getCustomerStr(), dto.getCouponId(), realPay.doubleValue()});
                return realPay;
            }
            realPay = this.calculateCouponRealPay(realPay, dto, customerCoupons, shopSkuDto);
        }
        log.info("calculateRealPay realPay:{}", (Object)realPay.doubleValue());
        return realPay;
    }

    private ShopSpu validateSpu(Long bizId, String productId, ShopSkuDto shopSkuDto) {
        ShopSpu select = new ShopSpu();
        select.setBizId(bizId);
        select.setProductId(productId);
        ShopSpu shopSpu = (ShopSpu)this.shopSpuMapper.selectOne((Object)select);
        Preconditions.checkArgument((shopSpu != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((GoodsSpuStatus.LISTING.getStatus() == shopSpu.getStatus().intValue() ? 1 : 0) != 0, (Object)"\u8be5\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\u4e86");
        SpuCreateReq spuCreateReq = (SpuCreateReq)JSON.parseObject((String)shopSpu.getSpuBody(), SpuCreateReq.class);
        List headImg = spuCreateReq.getHeadImg();
        if (CollectionUtils.isNotEmpty((Collection)headImg)) {
            shopSkuDto.setSpuFirstHeadImg((String)headImg.get(0));
        }
        return shopSpu;
    }

    private ShopSku validateGoods(String roomId, String skuId, Long bizId) {
        ShopSku select = new ShopSku();
        select.setBizId(bizId);
        select.setSkuId(skuId);
        select.setIsDeleted(Integer.valueOf(0));
        ShopSku shopSku = (ShopSku)this.shopSkuMapper.selectOne((Object)select);
        Preconditions.checkArgument((shopSku != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((GoodsSkuStatus.LISTING.getStatus() == shopSku.getStatus().intValue() ? 1 : 0) != 0, (Object)"\u8be5\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6\u4e86");
        MeetingGoodsRel selectRel = new MeetingGoodsRel();
        selectRel.setBizId(bizId);
        selectRel.setGoodsProductId(shopSku.getProductId());
        selectRel.setRoomId(roomId);
        selectRel.setStatus(YnEnum.YES.getValue());
        MeetingGoodsRel meetingGoodsRel = (MeetingGoodsRel)this.meetingGoodsRelMapper.selectOne((Object)selectRel);
        Preconditions.checkArgument((meetingGoodsRel != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u4e0d\u5b58\u5728");
        return shopSku;
    }

    private Meeting checkMeeting(String roomId) {
        List meetings = this.meetingMapper.selectByRoomIdUseMeeting(roomId);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)meetings), (Object)"\u76f4\u64ad\u95f4\u4e0d\u5b58\u5728");
        return (Meeting)meetings.get(0);
    }

    private void buildPayData(MeetingPayDataDto payData, OrderData orderData, PayChannelType payChannelType) {
        Map extraData = orderData.getExtraData();
        if (PayChannelType.WEIXIN_H5.equals((Object)payChannelType)) {
            payData.setMwebUrl((String)extraData.get("mwebUrl"));
            payData.setJumpUrl(orderData.getJumpUrl());
            payData.setOrderNum(orderData.getOrderNum());
        } else if (PayChannelType.WEIXIN_NATIVE.equals((Object)payChannelType)) {
            payData.setCodeUrl((String)extraData.get("codeUrl"));
            payData.setOrderNum(orderData.getOrderNum());
        } else {
            payData.setTimeStamp((String)extraData.get("timeStamp"));
            payData.setMchId((String)extraData.get("mchId"));
            payData.setPayPackage((String)extraData.get("package"));
            payData.setAppId((String)extraData.get("appId"));
            payData.setSign((String)extraData.get("sign"));
            payData.setSignType((String)extraData.get("signType"));
            payData.setNonceStr((String)extraData.get("nonceStr"));
        }
        payData.setPrepayId((String)extraData.get("prepayId"));
        payData.setTradeType((String)extraData.get("tradeType"));
    }

    private OrderData executePay(int retryTimes, OrderRequest orderRequest) {
        BaseResponse baseResponse;
        if (retryTimes == 0) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            return null;
        }
        log.info("\u5f00\u59cb\u53d1\u8d77\u652f\u4ed8\u8bf7\u6c42,orderRequest:{}", (Object)orderRequest);
        try {
            baseResponse = this.payOrderService.order(orderRequest);
            log.info("executePay baseResponse:{}", (Object)baseResponse);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u53d1\u8d77\u652f\u4ed8\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryTimes, (Object)ex);
            return this.executePay(--retryTimes, orderRequest);
        }
        if (!baseResponse.isSuccess()) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u53d1\u8d77\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryTimes);
            return this.executePay(--retryTimes, orderRequest);
        }
        return (OrderData)baseResponse.getData();
    }

    private void fillExtraParams(OrderRequest orderRequest, HttpServletRequest request, String openId, String appId) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("spbillCreateIp", IpUtils.getIp((HttpServletRequest)request));
        extraParams.put("openid", openId);
        extraParams.put("wxAppId", appId);
        orderRequest.setParams(JsonUtil.toStr(extraParams));
    }

    private void fillExtraParamsByWxNative(OrderRequest orderRequest, String skuId) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("productId", skuId);
        orderRequest.setParams(JsonUtil.toStr(extraParams));
    }

    private void fillExtraParamsByWxH5(OrderRequest orderRequest, HttpServletRequest request, String skuId, String wapUrl) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("productId", skuId);
        extraParams.put("spbillCreateIp", IpUtils.getIp((HttpServletRequest)request));
        HashMap sceneInfo = Maps.newHashMap();
        HashMap h5Info = Maps.newHashMap();
        h5Info.put("type", "Wap");
        h5Info.put("wap_url", wapUrl);
        int index = wapUrl.indexOf("?");
        if (index != -1) {
            String baseUrl = wapUrl.substring(0, index);
            h5Info.put("wap_url", baseUrl);
        }
        sceneInfo.put("h5_info", h5Info);
        extraParams.put("sceneInfo", JSONObject.toJSONString((Object)h5Info));
        orderRequest.setParams(JsonUtil.toStr(extraParams));
    }

    private OrderRequest buildOrderRequest(Integer payChannelType, String corpId, String goodsName, Long totalAmount, String bizOrderNum) {
        OrderRequest orderRequest = new OrderRequest();
        String requestId = UUID.randomUUID().toString().replace("-", "");
        orderRequest.setRequestId(requestId);
        orderRequest.setChannelType(payChannelType);
        orderRequest.setCorpId(corpId);
        orderRequest.setSubject(goodsName);
        orderRequest.setTotalAmount(String.valueOf(totalAmount / 100L));
        OrderHeaderDto orderHeaderDto = new OrderHeaderDto();
        orderHeaderDto.setAmount(String.valueOf(totalAmount / 100L));
        orderHeaderDto.setBizOrderNum(bizOrderNum);
        orderRequest.setOrderHeaderDto(orderHeaderDto);
        return orderRequest;
    }

    private void buildConfigData(MeetingJSAPIConfigDto configData, String url) {
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        String jsapiTicket = this.componentTokenService.getComponentJsapiTicket();
        signMap.put("jsapi_ticket", jsapiTicket);
        String nonceStr = this.idGen.getNum();
        signMap.put("noncestr", nonceStr);
        int index = url.lastIndexOf(35);
        if (index != -1) {
            url = url.substring(0, index);
        }
        signMap.put("url", url);
        Integer timestamp = DateUtil.getCurTimeInt();
        signMap.put("timestamp", timestamp);
        String sign = SignUtil.formatUrlMap(signMap, (boolean)false, (boolean)true);
        configData.setTimeStamp(timestamp);
        configData.setNonceStr(nonceStr);
        configData.setSignature(sign);
    }

    @Override
    public MeetingOrderStatusResp orderStatus(MeetingOrderStatusReq req) {
        log.info("orderStatus,req:{}", (Object)req);
        req.validate();
        ShopOrder select = new ShopOrder();
        select.setOutOrderId(req.getOrderId());
        ShopOrder shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)select);
        Preconditions.checkArgument((shopOrder != null ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        OrderQuerySimpleRequest request = new OrderQuerySimpleRequest();
        request.setOrderNum(shopOrder.getOutOrderId());
        OrderQueryData orderQueryData = this.queryOrderFromPayCenter(3, request);
        MeetingOrderStatusResp resp = new MeetingOrderStatusResp();
        if (orderQueryData == null) {
            resp.setStatus(cn.kinyun.pay.business.status.OrderStatus.UNPAID.getValue());
            return resp;
        }
        resp.setStatus(orderQueryData.getOrderStatus().getValue());
        return resp;
    }

    private OrderQueryData queryOrderFromPayCenter(int retryTimes, OrderQuerySimpleRequest request) {
        BaseResponse baseResponse;
        if (retryTimes == 0) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        log.info("\u5f00\u59cb\u53d1\u8d77\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u8bf7\u6c42,request:{}", (Object)request);
        try {
            baseResponse = this.payOrderService.queryOrderSimple(request);
            log.info("queryOrderFromPayCenter baseResponse:{}", (Object)baseResponse);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryTimes, (Object)ex);
            return this.queryOrderFromPayCenter(--retryTimes, request);
        }
        if (!baseResponse.isSuccess()) {
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryTimes);
            return this.queryOrderFromPayCenter(--retryTimes, request);
        }
        return (OrderQueryData)baseResponse.getData();
    }
}

