/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.impl.PlaceHolderService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.coupon.enums.CouponUsageScenario;
import com.kuaike.scrm.coupon.resp.BjyGoodsResp;
import com.kuaike.scrm.coupon.service.impl.HandleBjyApiService;
import com.kuaike.scrm.dal.meeting.dto.MeetingGoodsRelDto;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCouponRel;
import com.kuaike.scrm.dal.meeting.entity.MeetingCouponRelCriteria;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRelCriteria;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCouponRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopCouponProduct;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponProductMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.meeting.dto.request.MeetingGoodsAddParam;
import com.kuaike.scrm.meeting.service.MeetingGoodsRelService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingGoodsRelServiceImpl
implements MeetingGoodsRelService {
    private static final Logger log = LoggerFactory.getLogger(MeetingGoodsRelServiceImpl.class);
    @Resource
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Resource
    private ShopCouponProductMapper shopCouponProductMapper;
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Autowired
    private IdGen idGen;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private MeetingCouponRelMapper meetingCouponRelMapper;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private HandleBjyApiService handleBjyApiService;
    @Autowired
    private PlaceHolderService placeHolderService;
    private static final Set<Integer> MEETING_GOODS_SOURCES = Sets.newHashSet((Object[])new Integer[]{GoodsOrderSource.MEETING_COMMERCE.getSource(), GoodsOrderSource.NET_SCHOOL.getSource()});
    @Resource
    private ShopSkuMapper skuMapper;

    @Override
    public List<MeetingGoodsRelDto> listByMeetingId(MeetingGoodsRelDto dto) {
        Preconditions.checkArgument((boolean)Objects.nonNull(dto.getMeetingId()), (Object)"\u76f4\u64ad\u95f4Id\u4e0d\u80fd\u4e3a\u7a7a");
        MeetingGoodsRelCriteria criteria = new MeetingGoodsRelCriteria();
        criteria.createCriteria().andBizIdEqualTo(LoginUtils.getCurrentUserBizId()).andMeetingIdEqualTo(dto.getMeetingId()).andStatusEqualTo(YnEnum.YES.getValue());
        List meetingGoodsRels = this.meetingGoodsRelMapper.selectByExample((Object)criteria);
        if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
            return Lists.newArrayList();
        }
        return meetingGoodsRels.stream().map(item -> {
            ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(item.getGoodsProductId());
            List shopSkus = this.skuMapper.queryByStringProductId(dto.getGoodsProductId());
            List sortedShopSkus = shopSkus.stream().filter(sku -> Objects.nonNull(sku.getSource()) && MEETING_GOODS_SOURCES.contains(sku.getSource())).sorted(Comparator.comparing(ShopSku::getSalePrice)).collect(Collectors.toList());
            ShopSku shopSku = CollectionUtils.isNotEmpty(sortedShopSkus) ? (ShopSku)sortedShopSkus.get(0) : new ShopSku();
            return this.entityConvertToDto(shopSpu, shopSku, (MeetingGoodsRel)item);
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMeetingGoods(MeetingGoodsAddParam param) {
        Meeting meeting = this.addMeetingGoodsParamCheck(param.getMeetingGoodsDtoList(), param.getMeetingId(), LoginUtils.getCurrentUserBizId());
        for (MeetingGoodsRelDto dto : param.getMeetingGoodsDtoList()) {
            this.addMeetingGoodsItem(dto, meeting);
        }
    }

    private Meeting addMeetingGoodsParamCheck(List<MeetingGoodsRelDto> dtos, Long meetingId, Long bizId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(dtos), (Object)"\u5173\u8054\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingId), (Object)"\u76f4\u64ad\u95f4Id\u4e0d\u80fd\u4e3a\u7a7a");
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)meetingId);
        if (Objects.isNull(meeting)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u627e\u5230id \u4e3a" + meetingId + "\u7684\u76f4\u64ad\u95f4");
        }
        for (MeetingGoodsRelDto dto : dtos) {
            Preconditions.checkArgument((boolean)Objects.nonNull(dto.getGoodsProductId()), (Object)"\u5546\u54c1productId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List goodsProductIds = dtos.stream().map(MeetingGoodsRelDto::getGoodsProductId).collect(Collectors.toList());
        List meetingGoodsRels = this.meetingGoodsRelMapper.seleByMeetingIdAndProductIds(bizId, meeting.getId(), goodsProductIds);
        if (CollectionUtils.isNotEmpty((Collection)meetingGoodsRels)) {
            List goodsNames = meetingGoodsRels.stream().map(MeetingGoodsRel::getGoodsProductId).collect(Collectors.toList());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u95f4:" + meeting.getTitle() + "\u5df2\u6dfb\u52a0\u5546\u54c1: " + JSON.toJSONString(goodsNames) + " \u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
        }
        return meeting;
    }

    public void addMeetingGoodsItem(MeetingGoodsRelDto dto, Meeting meeting) {
        List shopCouponProducts;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingGoodsRel goodsRel = this.buildAddParam(dto, currentUser, meeting);
        this.meetingGoodsRelMapper.insert((Object)goodsRel);
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(dto.getGoodsProductId());
        List shopSkus = this.skuMapper.queryByStringProductId(dto.getGoodsProductId());
        List sortedShopSkus = shopSkus.stream().filter(item -> Objects.nonNull(item.getSource()) && MEETING_GOODS_SOURCES.contains(item.getSource())).sorted(Comparator.comparing(ShopSku::getSalePrice)).collect(Collectors.toList());
        ShopSku shopSku = CollectionUtils.isNotEmpty(sortedShopSkus) ? (ShopSku)sortedShopSkus.get(0) : new ShopSku();
        MeetingGoodsRelDto goodsRelDto = this.entityConvertToDto(shopSpu, shopSku, goodsRel);
        BjyGoodsResp goodsSyncResp = this.handleBjyApiService.handleAddBjyGoodsRoom(goodsRelDto);
        if (StringUtils.isNotBlank((CharSequence)goodsSyncResp.getGoodsId())) {
            MeetingGoodsRel update = new MeetingGoodsRel();
            update.setId(goodsRel.getId());
            update.setBjyGoodsId(goodsSyncResp.getGoodsId());
            this.meetingGoodsRelMapper.updateByPrimaryKeySelective((Object)update);
        }
        if (CollectionUtils.isEmpty((Collection)(shopCouponProducts = this.shopCouponProductMapper.selectCouponByProductIds(currentUser.getBizId(), (Collection)Lists.newArrayList((Object[])new String[]{goodsRel.getGoodsProductId()}))))) {
            return;
        }
        List couponIds = shopCouponProducts.stream().map(ShopCouponProduct::getCouponId).collect(Collectors.toList());
        log.info("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5546\u54c1\u3011biId:{}, productId:{}, \u5f85\u5173\u8054\u4f18\u60e0\u5238ids:{}", new Object[]{currentUser.getBizId(), goodsRel.getGoodsProductId(), JSON.toJSONString(couponIds)});
        List unOvertimeCoupon = this.shopCouponMapper.selectByIdsAndHadButchNo(currentUser.getBizId(), couponIds, CouponUsageScenario.MEETING.getType(), new Date());
        if (CollectionUtils.isEmpty((Collection)unOvertimeCoupon)) {
            log.warn("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5546\u54c1\u3011 \u5546\u54c1\u7ed1\u5b9a\u4f18\u60e0\u5238\u65e0\u6548, couponIds:{},goodProductId:{},goodName:{}", new Object[]{JSON.toJSONString(couponIds), goodsRel.getGoodsProductId(), goodsRelDto.getGoodsName()});
            return;
        }
        List couponButchNoList = unOvertimeCoupon.stream().map(ShopCoupon::getCouponButchNo).collect(Collectors.toList());
        MeetingCouponRelCriteria couponRelCriteria = new MeetingCouponRelCriteria();
        couponRelCriteria.createCriteria().andCouponBatchNoIn(couponButchNoList).andBizIdEqualTo(currentUser.getBizId()).andStatusEqualTo(YnEnum.YES.getValue()).andRoomIdEqualTo(meeting.getRoomId());
        List meetingCouponRels = this.meetingCouponRelMapper.selectByExample((Object)couponRelCriteria);
        if (CollectionUtils.isNotEmpty((Collection)meetingCouponRels)) {
            List exitCouponBatchNo = meetingCouponRels.stream().map(MeetingCouponRel::getCouponBatchNo).collect(Collectors.toList());
            couponButchNoList.removeAll(exitCouponBatchNo);
        }
        if (CollectionUtils.isEmpty(couponButchNoList)) {
            return;
        }
        this.handleBjyApiService.handleBjyCouponAssociateMeeting(meeting.getRoomId(), couponButchNoList);
        for (ShopCoupon shopCoupon : unOvertimeCoupon) {
            MeetingCouponRel meetingCouponRel = new MeetingCouponRel();
            meetingCouponRel.setNum(this.idGen.getNum());
            meetingCouponRel.setMeetingId(meeting.getId());
            meetingCouponRel.setRoomId(meeting.getRoomId());
            meetingCouponRel.setBizId(currentUser.getBizId());
            meetingCouponRel.setCreateBy(currentUser.getId());
            meetingCouponRel.setUpdateTime(new Date());
            meetingCouponRel.setCreateTime(new Date());
            meetingCouponRel.setUpdateBy(currentUser.getId());
            meetingCouponRel.setCouponId(shopCoupon.getCouponId());
            meetingCouponRel.setCouponBatchNo(shopCoupon.getCouponButchNo());
            meetingCouponRel.setStatus(YnEnum.YES.getValue());
            try {
                this.meetingCouponRelMapper.insert((Object)meetingCouponRel);
            }
            catch (Exception e) {
                log.error("\u63d2\u5165\u4f18\u60e0\u5238\u4e0e\u76f4\u64ad\u95f4\u7684\u5173\u8054\u5173\u7cfb\u5931\u8d25\uff1aroomId :{}; couponButchList:{}", (Object)meeting.getRoomId(), (Object)JSON.toJSONString(couponButchNoList));
                this.handleBjyApiService.handBjyCouponUnAssociateMeeting(meeting.getRoomId(), couponButchNoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMeetingGoods(MeetingGoodsRelDto dto) {
        Preconditions.checkArgument((boolean)Objects.nonNull(dto.getMeetingId()), (Object)"\u76f4\u64ad\u95f4Id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(dto.getGoodsProductId()), (Object)"\u5546\u54c1sku \u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        MeetingGoodsRel condition = new MeetingGoodsRel();
        condition.setGoodsProductId(dto.getGoodsProductId());
        condition.setMeetingId(dto.getMeetingId());
        condition.setStatus(YnEnum.YES.getValue());
        condition.setBizId(currentUser.getBizId());
        MeetingGoodsRel goodsRel = (MeetingGoodsRel)this.meetingGoodsRelMapper.selectOne((Object)condition);
        if (Objects.isNull(goodsRel)) {
            log.error("\u3010\u76f4\u64ad\u95f4\u5173\u8054\u5546\u54c1\u3011\u5220\u9664\u76f4\u64ad\u95f4\u5173\u8054\u5546\u54c1\u5931\u8d25\uff1aparam:{},\u5f53\u524dsku \u672a\u5173\u8054\u76f4\u64ad\u95f4", (Object)JSON.toJSONString((Object)dto));
            return;
        }
        condition.setId(goodsRel.getId());
        condition.setStatus(YnEnum.NO.getValue());
        condition.setUpdateTime(new Date());
        this.meetingGoodsRelMapper.updateByPrimaryKeySelective((Object)condition);
        if (StringUtils.isBlank((CharSequence)goodsRel.getBjyGoodsId())) {
            return;
        }
        ShopSpu shopSpu = this.shopSpuMapper.queryByProductId(dto.getGoodsProductId());
        List shopSkus = this.skuMapper.queryByStringProductId(dto.getGoodsProductId());
        List sortedShopSkus = shopSkus.stream().filter(item -> Objects.nonNull(item.getSource()) && MEETING_GOODS_SOURCES.contains(item.getSource())).sorted(Comparator.comparing(ShopSku::getSalePrice)).collect(Collectors.toList());
        ShopSku shopSku = CollectionUtils.isNotEmpty(sortedShopSkus) ? (ShopSku)sortedShopSkus.get(0) : new ShopSku();
        MeetingGoodsRelDto meetingGoodsRelDto = this.entityConvertToDto(shopSpu, shopSku, goodsRel);
        meetingGoodsRelDto.setCorpId(currentUser.getCorpId());
        this.handleBjyApiService.handDelBjyGoodsRoom(meetingGoodsRelDto);
    }

    public MeetingGoodsRel buildAddParam(MeetingGoodsRelDto dto, CurrentUserInfo userInfo, Meeting meeting) {
        MeetingGoodsRel goodsRel = this.dtoConvertToEntity(dto);
        goodsRel.setBizId(userInfo.getBizId());
        goodsRel.setMeetingId(meeting.getId());
        goodsRel.setRoomId(meeting.getRoomId());
        goodsRel.setNum(this.idGen.getNum());
        goodsRel.setCreateBy(userInfo.getId());
        goodsRel.setCreateTime(new Date());
        goodsRel.setUpdateTime(new Date());
        goodsRel.setRoomId(meeting.getRoomId());
        goodsRel.setGoodsProductId(dto.getGoodsProductId());
        String scrmGoodDetailUrl = this.placeHolderService.getRealScrmGoodDetailUrl();
        if (scrmGoodDetailUrl.contains("${roomId}")) {
            scrmGoodDetailUrl = scrmGoodDetailUrl.replace("${roomId}", meeting.getRoomId());
        }
        if (scrmGoodDetailUrl.contains("${productId}")) {
            scrmGoodDetailUrl = scrmGoodDetailUrl.replace("${productId}", dto.getGoodsProductId());
        }
        if (scrmGoodDetailUrl.contains("${meetingId}")) {
            scrmGoodDetailUrl = scrmGoodDetailUrl.replace("${meetingId}", meeting.getNum());
        }
        goodsRel.setGoodsDetailUrl(scrmGoodDetailUrl);
        goodsRel.setStatus(YnEnum.YES.getValue());
        return goodsRel;
    }

    public MeetingGoodsRel dtoConvertToEntity(MeetingGoodsRelDto dto) {
        MeetingGoodsRel goodsRel = new MeetingGoodsRel();
        BeanUtils.copyProperties((Object)dto, (Object)goodsRel);
        return goodsRel;
    }

    public MeetingGoodsRelDto entityConvertToDto(ShopSpu shopSpu, ShopSku shopSku, MeetingGoodsRel meetingGoodsRel) {
        String goodsUrl;
        MeetingGoodsRelDto meetingGoodsRelDto = new MeetingGoodsRelDto();
        String spuBody = shopSpu.getSpuBody();
        JSONObject jsonObject = JSON.parseObject((String)spuBody);
        String subTitle = jsonObject.getString("subTitle");
        String title = jsonObject.getString("title");
        JSONArray headImgs = jsonObject.getJSONArray("headImg");
        String string = goodsUrl = CollectionUtils.isNotEmpty((Collection)headImgs) ? (String)headImgs.get(0) : "";
        if (Objects.isNull(shopSku.getMarketPrice()) || shopSku.getMarketPrice() == 0L) {
            shopSku.setMarketPrice(shopSku.getSalePrice());
        }
        if (Objects.nonNull(shopSku.getMarketPrice()) && shopSku.getMarketPrice() < shopSku.getSalePrice()) {
            shopSku.setMarketPrice(shopSku.getSalePrice());
        }
        meetingGoodsRelDto.setGoodsDiscountPrice(shopSku.getSalePrice());
        meetingGoodsRelDto.setGoodsOriginPrice(shopSku.getMarketPrice());
        meetingGoodsRelDto.setGoodsDes(subTitle);
        meetingGoodsRelDto.setGoodsName(title);
        meetingGoodsRelDto.setMeetingId(meetingGoodsRel.getId());
        meetingGoodsRelDto.setRoomId(meetingGoodsRel.getRoomId());
        meetingGoodsRelDto.setGoodsUrl(goodsUrl);
        meetingGoodsRelDto.setGoodsDetailUrl(meetingGoodsRel.getGoodsDetailUrl());
        meetingGoodsRelDto.setGoodsSource(shopSpu.getSource());
        meetingGoodsRelDto.setBizId(shopSpu.getBizId());
        meetingGoodsRelDto.setGoodsProductId(shopSpu.getProductId());
        meetingGoodsRelDto.setBjyGoodsId(meetingGoodsRel.getBjyGoodsId());
        return meetingGoodsRelDto;
    }
}

