/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.RestfulResult;
import com.kuaike.scrm.common.utils.BaijiacloudServiceUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.UrlUtils;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.meeting.dto.reponse.BaijiaCloudMeetingInfoResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudBatchUserListResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudBatchUserResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudClassUserResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudCreateRoomResponse;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudDeleteRoomResponse;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudExportChatMsgRespDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudExportChatMsgResponse;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudExportLiveReportData;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudExportLiveReportResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudPullUrlResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudPushUrlResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRelayListResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRelaySelectListResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRoomListResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRoomListRespDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudStudentCodeResponse;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudUpdateRoomResponse;
import com.kuaike.scrm.meeting.dto.reponse.GetRoomPlaybackTokenResponse;
import com.kuaike.scrm.meeting.dto.reponse.GoodsSyncResp;
import com.kuaike.scrm.meeting.dto.reponse.KeywordResp;
import com.kuaike.scrm.meeting.dto.request.AddOrEditLiveRequestDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudBaseReqDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudPushUrlReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayAddReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayDelReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayEnableReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayListReq;
import com.kuaike.scrm.meeting.dto.request.BjyUserBaseDto;
import com.kuaike.scrm.meeting.dto.request.ExportChatMsgRequestDto;
import com.kuaike.scrm.meeting.dto.request.ExportLiveReportReqDto;
import com.kuaike.scrm.meeting.dto.request.GetRoomPlaybackTokenRequest;
import com.kuaike.scrm.meeting.dto.request.SetShareInfoDto;
import com.kuaike.scrm.meeting.service.BaijiacloudApiService;
import com.kuaike.scrm.service.MeetingSettingService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BaijiacloudApiServiceImpl
implements BaijiacloudApiService {
    private static final Logger log = LoggerFactory.getLogger(BaijiacloudApiServiceImpl.class);
    @Value(value="${baijiacloud.create.room.get.url}")
    private String createRoomUrl;
    @Value(value="${baijiacloud.update.room.get.url}")
    private String updateRoomUrl;
    @Value(value="${baijiacloud.delete.room.get.url}")
    private String deleteRoomUrl;
    @Value(value="${baijiacloud.get.room.playback.url}")
    private String getRoomPlaybackUrl;
    @Value(value="${baijiacloud.export.room.chat.url}")
    private String getRoomChatMsgUrl;
    @Value(value="${baijiacloud.get.room.info.url}")
    private String getRoomInfoUrl;
    @Value(value="${baijiacloud.get.room.studentCode.url}")
    private String getStudentCodeUrl;
    private String exportLiveReportUrl;
    @Value(value="${baijiacloud.init.account.url}")
    private String initScrmAccount;
    @Value(value="${baijiacloud.get.room.list.url}")
    private String getRoomList;
    @Value(value="${baijiacloud.batchAddStudent.url}")
    private String batchAddStudent;
    @Value(value="${baijiacloud.bindStudentBatch.url}")
    private String bindStudentBatch;
    @Value(value="${baijiacloud.classRemoveStudentBatch.url}")
    private String removeBindStudentBatch;
    @Value(value="${baijiacloud.buildClassStudent.url}")
    private String buildClassStudent;
    @Value(value="${baijiacloud.set.room.shareInfo.url}")
    private String setShareInfoUrl;
    @Value(value="${baijiacloud.get.room.push.url}")
    private String getRoomPushUrl;
    @Value(value="${baijiacloud.get.room.pull.url}")
    private String getRoomPullUrl;
    @Value(value="${baijiacloud.relay.room.select.url}")
    private String getSelectRelayRoomUrl;
    @Value(value="${baijiacloud.relay.room.get.url}")
    private String getRelayRoomUrl;
    @Value(value="${baijiacloud.relay.room.add.url}")
    private String addRelayRoomUrl;
    @Value(value="${baijiacloud.get.room.del.url}")
    private String delRelayRoomUrl;
    @Value(value="${baijiacloud.get.room.enable.url}")
    private String enableRelayRoomUrl;
    @Autowired
    private MeetingSettingService meetingSettingService;
    TypeReference<RestfulResult<BaijiacloudCreateRoomResponse>> createRoomTypeToken = new TypeReference<RestfulResult<BaijiacloudCreateRoomResponse>>(){};
    TypeReference<RestfulResult<BaijiacloudUpdateRoomResponse>> updateRoomTypeToken = new TypeReference<RestfulResult<BaijiacloudUpdateRoomResponse>>(){};
    TypeReference<RestfulResult<GetRoomPlaybackTokenResponse>> getRoomPlaybackToken = new TypeReference<RestfulResult<GetRoomPlaybackTokenResponse>>(){};
    TypeReference<RestfulResult<BaijiacloudDeleteRoomResponse>> deleteRoomTypeToken = new TypeReference<RestfulResult<BaijiacloudDeleteRoomResponse>>(){};
    TypeReference<RestfulResult<BaijiacloudExportChatMsgRespDto>> exportChatMsgTypeToken = new TypeReference<RestfulResult<BaijiacloudExportChatMsgRespDto>>(){};
    TypeReference<RestfulResult<BaijiaCloudMeetingInfoResp>> meetingInfoMsgTypeToken = new TypeReference<RestfulResult<BaijiaCloudMeetingInfoResp>>(){};
    TypeReference<RestfulResult<BaijiacloudStudentCodeResponse>> meetingStudentCodeTypeToken = new TypeReference<RestfulResult<BaijiacloudStudentCodeResponse>>(){};
    TypeReference<RestfulResult<BaijiacloudExportLiveReportData>> exportLiveReportMsgTypeToken = new TypeReference<RestfulResult<BaijiacloudExportLiveReportData>>(){};
    TypeReference<RestfulResult<BaijiacloudExportLiveReportData>> initScrmAccountTypeToken = new TypeReference<RestfulResult<BaijiacloudExportLiveReportData>>(){};
    TypeReference<RestfulResult<BaijiacloudRoomListRespDto>> roomListTypeToken = new TypeReference<RestfulResult<BaijiacloudRoomListRespDto>>(){};
    TypeReference<RestfulResult<BaijiacloudBatchUserListResp>> batchUserListToken = new TypeReference<RestfulResult<BaijiacloudBatchUserListResp>>(){};
    TypeReference<RestfulResult<BaijiacloudClassUserResp>> getClassUserListToken = new TypeReference<RestfulResult<BaijiacloudClassUserResp>>(){};
    TypeReference<RestfulResult<GoodsSyncResp>> goodsSyncResp = new TypeReference<RestfulResult<GoodsSyncResp>>(){};
    TypeReference<RestfulResult<KeywordResp>> keywordsResp = new TypeReference<RestfulResult<KeywordResp>>(){};
    TypeReference<RestfulResult<SetShareInfoDto>> setShareInfoToken = new TypeReference<RestfulResult<SetShareInfoDto>>(){};
    TypeReference<RestfulResult<BaijiacloudPushUrlResp>> getRoomPushToken = new TypeReference<RestfulResult<BaijiacloudPushUrlResp>>(){};
    TypeReference<RestfulResult<BaijiacloudPullUrlResp>> getRoomPullToken = new TypeReference<RestfulResult<BaijiacloudPullUrlResp>>(){};
    TypeReference<RestfulResult<BaijiacloudRelaySelectListResp>> getSelectRelayRoomList = new TypeReference<RestfulResult<BaijiacloudRelaySelectListResp>>(){};
    TypeReference<RestfulResult<BaijiacloudRelayListResp>> getRelayRoomList = new TypeReference<RestfulResult<BaijiacloudRelayListResp>>(){};
    TypeReference<RestfulResult<Boolean>> booleanResp = new TypeReference<RestfulResult<Boolean>>(){};
    @Autowired
    private IdGen idGen;

    @Override
    public BaijiacloudCreateRoomResponse createRoom(AddOrEditLiveRequestDto params) {
        HashMap map = Maps.newHashMap();
        map.put("title", params.getName());
        map.put("start_time", String.valueOf(params.getStartTime() / 1000L));
        map.put("end_time", String.valueOf(params.getEndTime() / 1000L));
        map.put("type", String.valueOf(params.getType()));
        map.put("max_users", String.valueOf(params.getCapacity()));
        if (params.getType() == 0) {
            map.put("speak_camera_turnon", "2");
        } else {
            map.put("speak_camera_turnon", "1");
        }
        map.put("is_private", String.valueOf(params.getIsPrivate()));
        if (params.getLiveSellTemplate() != null && params.getLiveSellTemplate() == 3) {
            map.put("sell_goods_in_large_class", "1");
        } else {
            map.put("enable_live_sell", String.valueOf(params.getLiveSellTemplate()));
        }
        map.put("is_push_live", String.valueOf(params.getIsPushLive()));
        map.put("template_name", params.getTemplateName());
        map.put("enable_end_link_to_playback", "1");
        map.put("enable_live_sell_pc_student", "1");
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String createUrl = privateDomain + this.createRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)createUrl, (Map)map, null, this.createRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("createRoom.params:{},  response:{}", (Object)map, (Object)response);
            if (response.getCode() != 0) {
                log.error("createRoom response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudCreateRoomResponse)response.getData();
        }
        catch (Exception e) {
            log.error("request createRoom error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u4f1a\u8bae\u6559\u5ba4\u5931\u8d25");
        }
    }

    @Override
    public void updateRoomInfo(AddOrEditLiveRequestDto params, String roomId) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        map.put("is_private", String.valueOf(params.getIsPrivate()));
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String updateUrl = privateDomain + this.updateRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)updateUrl, (Map)map, null, this.updateRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("updateRoomInfo.params:{}, response:{}, roomId:{}", new Object[]{params, response, roomId});
            if (response.getCode() != 0) {
                log.error("updateRoomInfo response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("request updateRoomInfo error", (Throwable)e);
            if (StringUtils.equals((CharSequence)"\u8be5\u623f\u95f4\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (CharSequence)e.getMessage())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u66f4\u65b0\u4f1a\u8bae\u6559\u5ba4\u5931\u8d25");
        }
    }

    @Override
    public void delRoom(BaijiacloudBaseReqDto params, String roomId) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String delUrl = privateDomain + this.deleteRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)delUrl, (Map)map, null, this.deleteRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("delRoom.response:{}, roomId:{}", (Object)response, (Object)roomId);
            if (response.getCode() != 0) {
                log.error("delRoom response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("delRoom error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5220\u9664\u4f1a\u8bae\u6559\u5ba4\u5931\u8d25");
        }
    }

    @Override
    public BaijiaCloudMeetingInfoResp getRoomInfo(BaijiacloudBaseReqDto params, String roomId) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String infoUrl = privateDomain + this.getRoomInfoUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)infoUrl, (Map)map, null, this.meetingInfoMsgTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("roomInfo.response:{}, roomId:{}", (Object)response, (Object)roomId);
            if (response.getCode() != 0) {
                log.error("roomInfo response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiaCloudMeetingInfoResp)response.getData();
        }
        catch (Exception e) {
            log.error("roomInfo error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u76f4\u64ad\u95f4\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public BaijiacloudStudentCodeResponse getRoomStudentCode(BaijiacloudBaseReqDto params, String roomId) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        map.put("user_number", "0");
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String studentCodeUrl = privateDomain + this.getStudentCodeUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)studentCodeUrl, (Map)map, null, this.meetingStudentCodeTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("getRoomStudentCode.response:{}, roomId:{}", (Object)response, (Object)roomId);
            if (response.getCode() != 0) {
                log.error("getRoomStudentCode response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudStudentCodeResponse)response.getData();
        }
        catch (Exception e) {
            log.error("getRoomStudentCode error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u76f4\u64ad\u95f4\u4fe1\u606f\u5931\u8d25");
        }
    }

    @Override
    public GetRoomPlaybackTokenResponse getRoomPlaybackToken(GetRoomPlaybackTokenRequest params) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", params.getRoomId());
        map.put("expires_in", String.valueOf(params.getExpiresIn()));
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String playbackTokenUrl = privateDomain + this.getRoomPlaybackUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)playbackTokenUrl, (Map)map, null, this.getRoomPlaybackToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("getRoomPlaybackToken.response:{}, roomId:{}", (Object)response, (Object)params.getRoomId());
            if (response.getCode() != 0) {
                log.error("getRoomPlaybackToken response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (GetRoomPlaybackTokenResponse)response.getData();
        }
        catch (Exception e) {
            log.error("request getRoomPlaybackToken error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u6559\u5ba4\u56de\u653e\u64ad\u653etoken\u5931\u8d25");
        }
    }

    @Override
    public List<BaijiacloudExportChatMsgResponse> exportChatMsg(ExportChatMsgRequestDto params) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", String.valueOf(params.getRoomId()));
        map.put("date", params.getDate());
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String roomChatMsgUrl = privateDomain + this.getRoomChatMsgUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)roomChatMsgUrl, (Map)map, null, this.exportChatMsgTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("exportChatMsg.response:{}, roomId:{}", (Object)response, (Object)params.getRoomId());
            if (response.getCode() != 0) {
                log.error("exportChatMsg response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            List<Object> data = Lists.newArrayList();
            BaijiacloudExportChatMsgRespDto result = (BaijiacloudExportChatMsgRespDto)response.getData();
            if (result != null) {
                data = result.getList();
            }
            return data;
        }
        catch (Exception e) {
            log.error("request exportChatMsg error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u76f4\u64ad\u95f4\u804a\u5929\u8bb0\u5f55\u5931\u8d25");
        }
    }

    @Override
    public List<BaijiacloudExportLiveReportResp> exportLiveReport(ExportLiveReportReqDto reqDto) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", reqDto.getRoomId());
        map.put("date", reqDto.getDate());
        try {
            String privateDomain = reqDto.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String exportUrl = privateDomain + this.exportLiveReportUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)exportUrl, (Map)map, null, this.exportLiveReportMsgTypeToken, (String)reqDto.getPartnerId(), (String)reqDto.getPartnerKey());
            log.info("exportLiveReport.response:{}, roomId:{}", (Object)response, (Object)reqDto.getRoomId());
            if (response.getCode() != 0) {
                log.error("exportLiveReport response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            List<Object> data = Lists.newArrayList();
            BaijiacloudExportLiveReportData result = (BaijiacloudExportLiveReportData)response.getData();
            if (result != null) {
                data = result.getList();
            }
            log.info("exportLiveReport.data:{}, roomId:{}", (Object)data, (Object)reqDto.getRoomId());
            return data;
        }
        catch (Exception e) {
            log.error("request exportLiveReport error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u76f4\u64ad\u95f4\u804a\u5929\u8bb0\u5f55\u5931\u8d25");
        }
    }

    @Override
    public void initScrmAccount(BaijiacloudBaseReqDto params) {
        HashMap map = Maps.newHashMap();
        map.put("secret", "scrmyyds123");
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            log.info("initAccount.param:{}", (Object)params);
            String initUrl = privateDomain + this.initScrmAccount;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)initUrl, (Map)map, null, this.updateRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("initAccount.response:{}", (Object)response);
            if (response.getCode() != 0) {
                log.error("initAccount response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("initAccount error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f1a\u8bae\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public List<BaijiacloudRoomListResp> exportRoomList(BaijiacloudBaseReqDto params, Integer page, Integer limit) {
        HashMap map = Maps.newHashMap();
        if (page != null) {
            map.put("page", String.valueOf(page));
        }
        if (limit != null) {
            map.put("limit", String.valueOf(limit));
        } else {
            map.put("limit", "800");
        }
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String exportUrl = privateDomain + this.getRoomList;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)exportUrl, (Map)map, null, this.roomListTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("exportRoomList.response:{}", (Object)response);
            if (response.getCode() != 0) {
                log.error("exportRoomList response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            List<Object> data = Lists.newArrayList();
            BaijiacloudRoomListRespDto result = (BaijiacloudRoomListRespDto)response.getData();
            if (result != null) {
                data = result.getList();
            }
            log.info("exportRoomList.data:{}", (Object)data);
            return data;
        }
        catch (Exception e) {
            log.error("request exportRoomList error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u4f1a\u8bae\u8bb0\u5f55\u5931\u8d25");
        }
    }

    @Override
    public List<BaijiacloudBatchUserResp> batchAddStudentUser(BaijiacloudBaseReqDto params, List<String> mobiles) {
        ArrayList userBaseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(mobiles)) {
            mobiles.forEach(a -> {
                BjyUserBaseDto baseDto = new BjyUserBaseDto();
                userBaseDtos.add(baseDto);
                baseDto.setUserSn((String)a);
                baseDto.setName("bjy_" + a);
                baseDto.setPhoneNumber((String)a);
                baseDto.setPassword("123456");
            });
        }
        List<Object> userResps = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)userBaseDtos)) {
            HashMap map = Maps.newHashMap();
            map.put("user_json", JacksonUtil.obj2Str((Object)userBaseDtos));
            log.info("batchAddStudentUser. map:{}", (Object)map);
            try {
                String privateDomain = params.getPrivateDomain();
                if (!privateDomain.endsWith("/")) {
                    privateDomain = privateDomain + "/";
                }
                String batchUrl = privateDomain + this.batchAddStudent;
                log.info("classBindStudentBatch.param:{}\uff0c batchUrl: {}", (Object)params, (Object)batchUrl);
                RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)batchUrl, (Map)map, null, this.batchUserListToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
                log.info("batchAddStudentUser.response:{}", (Object)response);
                if (response.getCode() != 0) {
                    log.error("batchAddStudentUser response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
                }
                BaijiacloudBatchUserListResp result = (BaijiacloudBatchUserListResp)response.getData();
                if (result != null) {
                    userResps = result.getList();
                    log.info("batchAddStudentUser.userResps:{}", (Object)userResps);
                }
            }
            catch (Exception e) {
                log.error("request batchAddStudentUser error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7ed1\u5b9a\u5931\u8d25");
            }
        }
        return userResps;
    }

    @Override
    public void classBindStudentBatch(BaijiacloudBaseReqDto params, String roomId, List<String> uids) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        String userIds = Joiner.on((String)",").join(uids);
        map.put("user_ids", userIds);
        log.info("classBindStudentBatch. map:{}", (Object)map);
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String bindStudentUrl = privateDomain + this.bindStudentBatch;
            log.info("classBindStudentBatch.param:{}\uff0c bindStudentUrl: {}", (Object)params, (Object)bindStudentUrl);
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)bindStudentUrl, (Map)map, null, this.updateRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("classBindStudentBatch.response:{}", (Object)response);
            if (response.getCode() != 0) {
                log.error("classBindStudentBatch response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("classBindStudentBatch error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6559\u5ba4\u6279\u91cf\u5173\u8054\u5b66\u5458\u5931\u8d25");
        }
    }

    @Override
    public void removeClassBindStudentBatch(BaijiacloudBaseReqDto params, String roomId, List<String> uids) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        String userIds = Joiner.on((String)",").join(uids);
        map.put("user_ids", userIds);
        log.info("removeClassBindStudentBatch. map:{}", (Object)map);
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String bindStudentUrl = privateDomain + this.removeBindStudentBatch;
            log.info("removeClassBindStudentBatch.param:{}\uff0c bindStudentUrl: {}", (Object)params, (Object)bindStudentUrl);
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)bindStudentUrl, (Map)map, null, this.updateRoomTypeToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("removeClassBindStudentBatch.response:{}", (Object)response);
            if (response.getCode() != 0) {
                log.error("removeClassBindStudentBatch response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("removeClassBindStudentBatch error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6559\u5ba4\u6279\u91cf\u5173\u8054\u5b66\u5458\u5931\u8d25");
        }
    }

    @Override
    public List<BaijiacloudBatchUserResp> getClassStudentList(BaijiacloudBaseReqDto params, String roomId) {
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        map.put("page", "1");
        map.put("page_size", "10000");
        List<Object> resps = Lists.newArrayList();
        try {
            String privateDomain = params.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String getStudentUrl = privateDomain + this.buildClassStudent;
            log.info("getClassStudentList.param:{}\uff0c getStudentUrl: {}", (Object)params, (Object)getStudentUrl);
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)getStudentUrl, (Map)map, null, this.getClassUserListToken, (String)params.getPartnerId(), (String)params.getPartnerKey());
            log.info("getClassStudentList.response:{}", (Object)response);
            if (response.getCode() != 0) {
                log.error("getClassStudentList response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            BaijiacloudClassUserResp result = (BaijiacloudClassUserResp)response.getData();
            if (Objects.nonNull(result)) {
                resps = result.getList();
            }
            log.info("getClassStudentList.data:{}", (Object)resps);
        }
        catch (Exception e) {
            log.error("classBindStudentBatch error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u6559\u5ba4\u5173\u8054\u5b66\u5458\u5931\u8d25");
        }
        return resps;
    }

    @Override
    public GoodsSyncResp addGoodsToBaijiaCloud(BaijiacloudBaseReqDto reqDto, String url, Map<String, String> param, String operation) {
        try {
            log.info("operation: {} \u5546\u54c1\u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{} ,param:{}", new Object[]{operation, url, param});
            RestfulResult goodsResult = BaijiacloudServiceUtil.postWithDefPara((String)url, param, null, this.goodsSyncResp, (String)reqDto.getPartnerId(), (String)reqDto.getPartnerKey());
            log.info("operation: {} \u5546\u54c1\u540c\u6b65\u767e\u5bb6\u4e91\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}", (Object)operation, (Object)JacksonUtil.obj2Str((Object)goodsResult));
            if (0 != goodsResult.getCode()) {
                log.error("\u5546\u54c1\u540c\u6b65\u767e\u5bb6\u4e91 operation:{} response a error code={}, msg={}", new Object[]{operation, goodsResult.getCode(), goodsResult.getMsg()});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, goodsResult.getMsg());
            }
            return (GoodsSyncResp)Optional.ofNullable(goodsResult.getData()).orElse(new GoodsSyncResp());
        }
        catch (Exception e) {
            log.error("operation: {} \u5546\u54c1\u540c\u6b65 error", (Object)operation, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u540c\u6b65\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
    }

    @Override
    public <T extends Serializable> T postBjyApi(TypeReference<RestfulResult<T>> resultTypeToken, String apiAddress, Map<String, String> param, String corpId, String operation, String feature) {
        try {
            if (StringUtils.isBlank((CharSequence)apiAddress)) {
                log.warn("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}  \u63a5\u53e3url\u4e3a\u7a7a", new Object[]{operation, feature, apiAddress, param});
                return null;
            }
            MeetingSetting meetingSetting = this.meetingSettingService.getSettingByCorpId(corpId);
            if (Objects.isNull(meetingSetting)) {
                throw new IllegalArgumentException("meeting setings is null");
            }
            String url = UrlUtils.assembleUrl((String)meetingSetting.getDominSite(), (String)apiAddress);
            log.info("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}", new Object[]{operation, feature, url, param});
            RestfulResult restfulResult = BaijiacloudServiceUtil.postWithDefPara((String)url, param, null, resultTypeToken, (String)meetingSetting.getBjyId(), (String)meetingSetting.getBjyKey());
            log.info("operation: {} feature: {} \u540c\u6b65\u767e\u5bb6\u4e91\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}", new Object[]{operation, feature, JacksonUtil.obj2Str((Object)restfulResult)});
            if (0 != restfulResult.getCode()) {
                log.error(" operation:{} feature:{} response a error code={}, msg={}", new Object[]{operation, feature, restfulResult.getCode(), restfulResult.getMsg()});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
            return (T)((Serializable)restfulResult.getData());
        }
        catch (Exception e) {
            log.error("operation: {} feature:{}\u540c\u6b65\u767e\u5bb6\u4e91  error", new Object[]{operation, feature, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, feature + ":" + operation + "\u5931\u8d25\uff1amessage:" + e.getMessage());
        }
    }

    @Override
    public <T extends Serializable> List<T> postListBjyApi(TypeReference<RestfulResult<List<T>>> resultTypeToken, String apiAddress, Map<String, String> param, String corpId, String operation, String feature) {
        try {
            if (StringUtils.isBlank((CharSequence)apiAddress)) {
                log.warn("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}  \u63a5\u53e3url\u4e3a\u7a7a", new Object[]{operation, feature, apiAddress, param});
                return Lists.newArrayList();
            }
            MeetingSetting meetingSetting = this.meetingSettingService.getSettingByCorpId(corpId);
            if (Objects.isNull(meetingSetting)) {
                throw new IllegalArgumentException("meeting setings is null");
            }
            String url = UrlUtils.assembleUrl((String)meetingSetting.getDominSite(), (String)apiAddress);
            log.info("operation: {} feature:{} \u540c\u6b65\u767e\u5bb6\u4e91\u53c2\u6570 url:{},param:{}", new Object[]{operation, feature, url, param});
            RestfulResult restfulResult = BaijiacloudServiceUtil.postWithDefPara((String)url, param, null, resultTypeToken, (String)meetingSetting.getBjyId(), (String)meetingSetting.getBjyKey());
            log.info("operation: {} feature: {} \u540c\u6b65\u767e\u5bb6\u4e91\u8bf7\u6c42\u7ed3\u679c\uff1aresult:{}", new Object[]{operation, feature, JacksonUtil.obj2Str((Object)restfulResult)});
            if (0 != restfulResult.getCode()) {
                log.error(" operation:{} feature:{} response a error code={}, msg={}", new Object[]{operation, feature, restfulResult.getCode(), restfulResult.getMsg()});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, restfulResult.getMsg());
            }
            return (List)restfulResult.getData();
        }
        catch (Exception e) {
            log.error("operation: {} feature:{}\u540c\u6b65\u767e\u5bb6\u4e91  error", new Object[]{operation, feature, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, feature + ":" + operation + "\u5931\u8d25\uff1amessage:" + e.getMessage());
        }
    }

    @Override
    public void setShareInfo(SetShareInfoDto dto, String roomId) {
        log.info("setShareInfo dto:{} roomId:{}", (Object)dto, (Object)roomId);
        HashMap map = Maps.newHashMap();
        map.put("room_id", roomId);
        map.put("title", dto.getTitle());
        map.put("content", dto.getContent());
        map.put("img", dto.getImg());
        map.put("url", dto.getUrl());
        try {
            String privateDomain = dto.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String setUrl = privateDomain + this.setShareInfoUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)setUrl, (Map)map, null, this.setShareInfoToken, (String)dto.getPartnerId(), (String)dto.getPartnerKey());
            log.info("setShareInfo.response:{}, roomId:{}", (Object)response, (Object)roomId);
            if (response.getCode() != 0) {
                log.error("setShareInfo response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("setShareInfo error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bbe\u7f6e\u4f1a\u8bae\u5206\u4eab\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @Override
    public BaijiacloudPushUrlResp getRoomPushUrl(BaijiacloudPushUrlReq req) {
        log.info("getRoomPushUrl roomId:{}", (Object)req.getRoomId());
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String pushUrl = privateDomain + this.getRoomPushUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)pushUrl, (Map)map, null, this.getRoomPushToken, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("getRoomPushUrl.response:{}, roomId:{}", (Object)response, (Object)req.getRoomId());
            if (response.getCode() != 0) {
                log.error("getRoomPushUrl response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudPushUrlResp)response.getData();
        }
        catch (Exception e) {
            log.error("request getRoomPushUrl error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u6559\u5ba4\u56de\u653e\u64ad\u653etoken\u5931\u8d25");
        }
    }

    @Override
    public BaijiacloudPullUrlResp getRoomPullUrl(BaijiacloudPushUrlReq req) {
        log.info("getRoomPullUrl roomId:{}", (Object)req.getRoomId());
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String pullUrl = privateDomain + this.getRoomPullUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)pullUrl, (Map)map, null, this.getRoomPullToken, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("getRoomPullUrl.response:{}, roomId:{}", (Object)response, (Object)req.getRoomId());
            if (response.getCode() != 0) {
                log.error("getRoomPullUrl response a error code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudPullUrlResp)response.getData();
        }
        catch (Exception e) {
            log.error("request getRoomPullUrl error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u6559\u5ba4\u56de\u653e\u64ad\u653etoken\u5931\u8d25");
        }
    }

    @Override
    public BaijiacloudRelaySelectListResp getSelectRelayList(BaijiacloudRelayListReq req) {
        log.info("getSelectRelayList: req:{}", (Object)req);
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        if (StringUtils.isNotBlank((CharSequence)req.getQuery())) {
            map.put("query", req.getQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getPage())) {
            map.put("page", req.getPage());
        }
        if (StringUtils.isNotBlank((CharSequence)req.getPageSize())) {
            map.put("page_size", req.getPageSize());
        }
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String apiUrl = privateDomain + this.getSelectRelayRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)apiUrl, (Map)map, null, this.getSelectRelayRoomList, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("getSelectRelayList: response:{}, req:{}", (Object)response, (Object)req);
            if (response.getCode() != 0) {
                log.error("getSelectRelayList: \u67e5\u8be2\u53ef\u9009\u5217\u8868\u5f02\u5e38, code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudRelaySelectListResp)response.getData();
        }
        catch (Exception e) {
            log.error("getRelayList: \u67e5\u8be2\u53ef\u9009\u5173\u8054\u76f4\u64ad\u5217\u8868\u5f02\u5e38\uff0c error = ", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public BaijiacloudRelayListResp getRelayList(BaijiacloudRelayListReq req) {
        log.info("getRelayList: req:{}", (Object)req);
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String apiUrl = privateDomain + this.getRelayRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)apiUrl, (Map)map, null, this.getRelayRoomList, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("getRelayList: response:{}, req:{}", (Object)response, (Object)req);
            if (response.getCode() != 0) {
                log.error("getRelayList: \u67e5\u8be2\u8f6c\u64ad\u5217\u8868\u5f02\u5e38, code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
            return (BaijiacloudRelayListResp)response.getData();
        }
        catch (Exception e) {
            log.error("getRelayList: \u67e5\u8be2\u8f6c\u64ad\u5217\u8868\u5f02\u5e38\uff0c error = ", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public void addRelayRoom(BaijiacloudRelayAddReq req) {
        log.info("addRelayRoom: req:{}", (Object)req);
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        map.put("broadcast_room_ids", req.getBroadcastRoomIds());
        map.put("is_auto", req.getIsAuto());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String apiUrl = privateDomain + this.addRelayRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)apiUrl, (Map)map, null, this.booleanResp, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("addRelayRoom: response:{}, req:{}", (Object)response, (Object)req);
            if (response.getCode() != 0) {
                log.error("addRelayRoom: \u65b0\u589e\u8f6c\u64ad\u623f\u95f4\u5f02\u5e38,  code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("addRelayRoom: \u65b0\u589e\u8f6c\u64ad\u623f\u95f4\u5f02\u5e38\uff0cerror = ", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public void delRelayRoom(BaijiacloudRelayDelReq req) {
        log.info("delRelayRoom: req:{}", (Object)req);
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        map.put("broadcast_room_ids", req.getBroadcastRoomIds());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String apiUrl = privateDomain + this.delRelayRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)apiUrl, (Map)map, null, this.booleanResp, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("delRelayRoom: response:{}, req:{}", (Object)response, (Object)req);
            if (response.getCode() != 0) {
                log.error("delRelayRoom: \u5220\u9664\u8f6c\u64ad\u623f\u95f4\u5f02\u5e38\uff0ccode={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("delRelayRoom: \u5220\u9664\u8f6c\u64ad\u623f\u95f4\u5f02\u5e38\uff0c error = ", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    @Override
    public void enableRelayRoom(BaijiacloudRelayEnableReq req) {
        log.info("enableRelayRoom: req:{}", (Object)req);
        HashMap map = Maps.newHashMap();
        map.put("room_id", req.getRoomId());
        map.put("broadcast_room_ids", req.getBroadcastRoomId());
        map.put("is_auto", req.getIsAuto());
        try {
            String privateDomain = req.getPrivateDomain();
            if (!privateDomain.endsWith("/")) {
                privateDomain = privateDomain + "/";
            }
            String apiUrl = privateDomain + this.enableRelayRoomUrl;
            RestfulResult response = BaijiacloudServiceUtil.postWithDefPara((String)apiUrl, (Map)map, null, this.booleanResp, (String)req.getPartnerId(), (String)req.getPartnerKey());
            log.info("enableRelayRoom: response:{}, req:{}", (Object)response, (Object)req);
            if (response.getCode() != 0) {
                log.error("enableRelayRoom: \u64cd\u4f5c\u81ea\u52a8\u8f6c\u64ad\u5f02\u5e38\uff0c code={}, msg={}", (Object)response.getCode(), (Object)response.getMsg());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("enableRelayRoom: \u64cd\u4f5c\u81ea\u52a8\u8f6c\u64ad\u5f02\u5e38\uff0c error = ", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }
}

