/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.reponse;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.MeetingSource;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingJoinQuitLog;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class JoinMeetingCountRespDto {
    private Date joinTime;
    private Date quitTime;
    private Integer duration;
    private String avatar;
    private String nickname;
    private Integer source;
    private String sourceDesc;

    public static JoinMeetingCountRespDto buildDto(MeetingJoinQuitLog log, Meeting meeting, WeworkContact weworkContact, WeworkUser weworkUser, Map<String, String> weworkUserNum2IdMap, Map<String, WeworkContactRelation> weworkContactRelationMap) {
        JoinMeetingCountRespDto respDto = new JoinMeetingCountRespDto();
        respDto.setJoinTime(log.getJoinTime());
        respDto.setQuitTime(log.getQuitTime());
        respDto.setDuration(JoinMeetingCountRespDto.getDurationNoZero(log.getDuration()));
        respDto.setSource(log.getSource());
        respDto.setSourceDesc(MeetingSource.get((int)log.getSource()).getDesc());
        MeetingType type = MeetingType.get((int)meeting.getType());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("\u4e0d\u652f\u6301\u7684\u76f4\u64ad\u7c7b\u578b:" + meeting.getType()));
        switch (type) {
            case EXTERNAL_MEETING: {
                String key;
                WeworkContactRelation relation;
                if (Objects.nonNull(weworkContact)) {
                    respDto.setAvatar(weworkContact.getAvatar());
                    respDto.setNickname(weworkContact.getName());
                }
                if (!Objects.nonNull(weworkUserNum2IdMap) || !Objects.nonNull(weworkContactRelationMap) || !Objects.nonNull(log.getContactId()) || !Objects.nonNull(relation = weworkContactRelationMap.get(key = JoinMeetingCountRespDto.buildKey(weworkUserNum2IdMap.get(log.getWeworkUserNum()), log.getContactId()))) || !Objects.nonNull(relation.getRemark())) break;
                respDto.setNickname(relation.getRemark());
                break;
            }
            case INTERNAL_MEETING: {
                if (!Objects.nonNull(weworkUser)) break;
                respDto.setAvatar(weworkUser.getAvatar());
                respDto.setNickname(weworkUser.getName());
                break;
            }
        }
        return respDto;
    }

    private static Integer getDurationNoZero(Integer duration) {
        return duration != null && duration == 0 ? null : duration;
    }

    private static String buildKey(String key, String value) {
        return key + "_" + value;
    }

    public Date getJoinTime() {
        return this.joinTime;
    }

    public Date getQuitTime() {
        return this.quitTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Integer getSource() {
        return this.source;
    }

    public String getSourceDesc() {
        return this.sourceDesc;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    public void setQuitTime(Date quitTime) {
        this.quitTime = quitTime;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public void setSourceDesc(String sourceDesc) {
        this.sourceDesc = sourceDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinMeetingCountRespDto)) {
            return false;
        }
        JoinMeetingCountRespDto other = (JoinMeetingCountRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Integer this$source = this.getSource();
        Integer other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Date this$joinTime = this.getJoinTime();
        Date other$joinTime = other.getJoinTime();
        if (this$joinTime == null ? other$joinTime != null : !((Object)this$joinTime).equals(other$joinTime)) {
            return false;
        }
        Date this$quitTime = this.getQuitTime();
        Date other$quitTime = other.getQuitTime();
        if (this$quitTime == null ? other$quitTime != null : !((Object)this$quitTime).equals(other$quitTime)) {
            return false;
        }
        String this$avatar = this.getAvatar();
        String other$avatar = other.getAvatar();
        if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$sourceDesc = this.getSourceDesc();
        String other$sourceDesc = other.getSourceDesc();
        return !(this$sourceDesc == null ? other$sourceDesc != null : !this$sourceDesc.equals(other$sourceDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinMeetingCountRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Integer $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Date $joinTime = this.getJoinTime();
        result = result * 59 + ($joinTime == null ? 43 : ((Object)$joinTime).hashCode());
        Date $quitTime = this.getQuitTime();
        result = result * 59 + ($quitTime == null ? 43 : ((Object)$quitTime).hashCode());
        String $avatar = this.getAvatar();
        result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $sourceDesc = this.getSourceDesc();
        result = result * 59 + ($sourceDesc == null ? 43 : $sourceDesc.hashCode());
        return result;
    }

    public String toString() {
        return "JoinMeetingCountRespDto(joinTime=" + this.getJoinTime() + ", quitTime=" + this.getQuitTime() + ", duration=" + this.getDuration() + ", avatar=" + this.getAvatar() + ", nickname=" + this.getNickname() + ", source=" + this.getSource() + ", sourceDesc=" + this.getSourceDesc() + ")";
    }
}

