/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.material.dto.request.MaterialReqDto;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class AddMaterialReqDto {
    private Long fkId;
    private Integer fkType;
    private List<MaterialReqDto> materialReqDtoList;
    private Date startTime;
    private Date endTime;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.fkId), (Object)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.fkType), (Object)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.materialReqDtoList), (Object)"\u7d20\u6750\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (MaterialReqDto dto : this.materialReqDtoList) {
            dto.validate();
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(this.startTime), (Object)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.endTime), (Object)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.endTime.getTime() > this.startTime.getTime() ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
    }

    public Long getFkId() {
        return this.fkId;
    }

    public Integer getFkType() {
        return this.fkType;
    }

    public List<MaterialReqDto> getMaterialReqDtoList() {
        return this.materialReqDtoList;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setFkId(Long fkId) {
        this.fkId = fkId;
    }

    public void setFkType(Integer fkType) {
        this.fkType = fkType;
    }

    public void setMaterialReqDtoList(List<MaterialReqDto> materialReqDtoList) {
        this.materialReqDtoList = materialReqDtoList;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMaterialReqDto)) {
            return false;
        }
        AddMaterialReqDto other = (AddMaterialReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fkId = this.getFkId();
        Long other$fkId = other.getFkId();
        if (this$fkId == null ? other$fkId != null : !((Object)this$fkId).equals(other$fkId)) {
            return false;
        }
        Integer this$fkType = this.getFkType();
        Integer other$fkType = other.getFkType();
        if (this$fkType == null ? other$fkType != null : !((Object)this$fkType).equals(other$fkType)) {
            return false;
        }
        List<MaterialReqDto> this$materialReqDtoList = this.getMaterialReqDtoList();
        List<MaterialReqDto> other$materialReqDtoList = other.getMaterialReqDtoList();
        if (this$materialReqDtoList == null ? other$materialReqDtoList != null : !((Object)this$materialReqDtoList).equals(other$materialReqDtoList)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddMaterialReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fkId = this.getFkId();
        result = result * 59 + ($fkId == null ? 43 : ((Object)$fkId).hashCode());
        Integer $fkType = this.getFkType();
        result = result * 59 + ($fkType == null ? 43 : ((Object)$fkType).hashCode());
        List<MaterialReqDto> $materialReqDtoList = this.getMaterialReqDtoList();
        result = result * 59 + ($materialReqDtoList == null ? 43 : ((Object)$materialReqDtoList).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "AddMaterialReqDto(fkId=" + this.getFkId() + ", fkType=" + this.getFkType() + ", materialReqDtoList=" + this.getMaterialReqDtoList() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

