/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sidebarsharecustomer.service.impl;

import cn.kinyun.customer.center.dto.req.follow.BaseInfoDto;
import cn.kinyun.customer.center.dto.req.follow.CsBaseInfo;
import cn.kinyun.customer.center.dto.req.follow.CsStage;
import cn.kinyun.customer.center.dto.req.follow.CsTag;
import cn.kinyun.customer.center.dto.req.follow.FollowReq;
import cn.kinyun.customer.center.dto.req.follow.JsonContentDto;
import cn.kinyun.customer.center.dto.req.follow.StageInfoDto;
import cn.kinyun.customer.center.dto.req.follow.TagInfoDto;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.dto.req.ShareCustomerConfigDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.contactstage.mapper.WeworkContactStageMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.lockcustomer.dto.NoticeSalesReq;
import com.kuaike.scrm.lockcustomer.dto.ShareCustomerReq;
import com.kuaike.scrm.lockcustomer.dto.ShareCustomerResp;
import com.kuaike.scrm.lockcustomer.service.ShareCustomerSupport;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.sidebarsharecustomer.service.SidebarShareCustomerService;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.dto.WeworkUserDto;
import com.kuaike.scrm.wework.contact.service.ContactMobileService;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.scrm.wework.contacttag.service.ContactTagService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SidebarShareCustomerServiceImpl
implements SidebarShareCustomerService {
    private static final Logger log = LoggerFactory.getLogger(SidebarShareCustomerServiceImpl.class);
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private ContactTagService contactTagService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private ShareCustomerSupport shareCustomerSupport;
    @Autowired
    private WeworkContactStageMapper weworkContactStageMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerFollowRecordService ccCustomerFollowRecordService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    @Lazy
    private ContactMobileService contactMobileService;
    @Autowired
    @Lazy
    private RemindService remindService;
    private static final String REMIND_CONTENT = "\u3010\u5ba2\u6237\u4fe1\u606f\u901a\u77e5\u3011\n \u6210\u5458\uff1a{0}\u7ed9\u60a8\u53d1\u9001\u4e00\u6761\u5ba2\u6237\u300c{1}\u300d\u4fe1\u606f\u901a\u77e5\n \u901a\u77e5\u5185\u5bb9\uff1a{2}\n";

    @Override
    public List<WeworkUserDto> queryContactOwnerWeworkUser(String contactId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        String weworkUserId = userInfo.getWeworkUserId();
        List list = this.weworkContactRelationMapper.queryContactOfWeworkUsers(corpId, contactId);
        HashSet weworkUserIds = Sets.newHashSet();
        for (WeworkContactRelation contactRelation : list) {
            if (contactRelation.getIsDeleted() == 1 || contactRelation.getWeworkUserId().equals(weworkUserId)) continue;
            weworkUserIds.add(contactRelation.getWeworkUserId());
        }
        List weworkUsers = this.weworkUserMapper.queryWeworkUserInfoList(corpId, (Collection)weworkUserIds);
        ArrayList result = Lists.newArrayList();
        for (WeworkUser weworkUser : weworkUsers) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setWeworkUserId(weworkUser.getNum());
            weworkUserDto.setAvatar(weworkUser.getAvatar());
            weworkUserDto.setNickname(weworkUser.getName());
            result.add(weworkUserDto);
        }
        return result;
    }

    @Override
    public void shareContact(String contactId, String weworkUserNum) {
        log.info("shareContact contactId:{}, weworkUserNum:{}", (Object)contactId, (Object)weworkUserNum);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contactId, weworkUserNum}), (Object)"\u5ba2\u6237id\u548c\u5206\u4eab\u7684\u6210\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)weworkUserId), (Object)"\u627e\u4e0d\u5230\u6210\u5458");
        String curWeworkUserId = userInfo.getWeworkUserId();
        String curWeworkUserNum = userInfo.getWeworkUserNum();
        ShareCustomerReq shareCustomerReq = new ShareCustomerReq();
        shareCustomerReq.setWeworkUserNum(curWeworkUserNum);
        ShareCustomerResp shareResp = this.shareCustomerSupport.hasShareCustomerPermission(shareCustomerReq);
        if (shareResp.getHasPermission() == 0) {
            log.warn("contactId: {}, weworkUserNum: {}", (Object)contactId, (Object)weworkUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u6210\u5458\u6ca1\u6709\u5171\u4eab\u6743\u9650");
        }
        ShareCustomerReq req = new ShareCustomerReq();
        req.setType(SettingEnum.SHARE_CUSTOMER);
        ShareCustomerResp resp = this.shareCustomerSupport.queryShareCustomer(req);
        if (resp == null) {
            log.warn("share customer config resp is null");
            return;
        }
        ShareCustomerConfigDto configDto = resp.getCustomerConfigDto();
        if (configDto == null) {
            log.warn("share customer switch config is null");
            return;
        }
        boolean shareRemark = configDto.getShareCusRemark() != null && configDto.getShareCusRemark() == 1;
        boolean shareTag = configDto.getShareCusTag() != null && configDto.getShareCusTag() == 1;
        boolean shareStage = configDto.getShareCusStage() != null && configDto.getShareCusStage() == 1;
        boolean shareMobile = configDto.getShareCusMobile() != null && configDto.getShareCusMobile() == 1;
        boolean shareDesc = configDto.getShareCusDesc() != null && configDto.getShareCusDesc() == 1;
        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(userInfo.getBizId(), contactId, null);
        FollowReq followReq = new FollowReq();
        followReq.setBizId(userInfo.getBizId());
        followReq.setWeworkUserNum(weworkUserNum);
        followReq.setUserId(userInfo.getId());
        followReq.setCustomerNum(customerNum);
        followReq.setSource("scrm");
        followReq.setFollowType(Integer.valueOf(FollowRecordType.SHARE_CUSTOMER_FOLLOW.getValue()));
        followReq.setViewContent("");
        followReq.setFollowTime(new Date());
        followReq.setWeworkUserName(userInfo.getName());
        JsonContentDto jsonContentDto = new JsonContentDto();
        followReq.setJsonContent(jsonContentDto);
        if (shareRemark || shareTag || shareStage || shareMobile || shareDesc) {
            if (shareRemark || shareMobile || shareDesc) {
                this.shareRemark(userInfo.getBizId(), userInfo.getCorpId(), contactId, curWeworkUserId, weworkUserId, shareRemark, shareDesc, shareMobile, jsonContentDto);
            }
            if (shareTag) {
                this.shareTag(userInfo.getBizId(), userInfo.getCorpId(), contactId, curWeworkUserId, weworkUserId, jsonContentDto);
            }
            if (shareStage) {
                this.shareStage(userInfo.getCorpId(), contactId, curWeworkUserNum, weworkUserNum, userInfo.getId(), jsonContentDto);
            }
            try {
                this.ccCustomerFollowRecordService.add(followReq);
            }
            catch (Exception e) {
                log.error("add follow record to center error: ", (Throwable)e);
            }
        } else {
            log.info("share config is empty");
        }
    }

    @Override
    public void noticeSales(NoticeSalesReq req) {
        log.info("noticeSales req:{}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        String curWeworkUserNum = userInfo.getWeworkUserNum();
        WeworkContact contact = this.weworkContactMapper.queryContactByContactId(corpId, req.getContactId());
        if (contact == null) {
            log.info("noticeSales, contactId:{}", (Object)req.getContactId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        List toWeworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(req.getToWeworkUserNums());
        if (CollectionUtils.isEmpty((Collection)toWeworkUserIds)) {
            log.info("noticeSales, toWeworkUserNums:{}", req.getToWeworkUserNums());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u4e0d\u5230\u552e\u540e\u4eba\u5458\u4fe1\u606f");
        }
        String weworkUserName = "";
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(curWeworkUserNum);
        if (weworkUser != null) {
            weworkUserName = weworkUser.getName();
        }
        String content = MessageFormat.format(REMIND_CONTENT, weworkUserName, contact.getName(), req.getContent());
        log.info("noticeSales, corpId:{}, toWeworkUserIds:{}, content:{}", new Object[]{corpId, toWeworkUserIds, content});
        for (String weworkUserId : toWeworkUserIds) {
            try {
                this.remindService.asyncSendMsg(corpId, weworkUserId, content);
            }
            catch (Exception e) {
                log.error("noticeSales, error ", (Throwable)e);
            }
        }
    }

    private void shareRemark(Long bizId, String corpId, String contactId, String fromWeworkUserId, String weworkUserId, boolean shareRemark, boolean shareDesc, boolean shareMobile, JsonContentDto followReqDto) {
        WeworkContactRelation rel = this.weworkContactRelationMapper.get(corpId, fromWeworkUserId, contactId);
        WeworkContactRelation exist = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
        if (rel == null || exist == null) {
            log.info("rel or exist is null, corpId:{}, contactId: {}, fromWeworkUserId: {}\uff0c weworkUserId:{}", new Object[]{corpId, contactId, fromWeworkUserId, weworkUserId});
            return;
        }
        BaseInfoDto baseInfo = new BaseInfoDto();
        CsBaseInfo newInfo = new CsBaseInfo();
        CsBaseInfo oldInfo = new CsBaseInfo();
        baseInfo.setNewBasicInfo(newInfo);
        baseInfo.setOldBasicInfo(oldInfo);
        followReqDto.setBaseInfo(baseInfo);
        String newRemark = "";
        String newDesc = "";
        List newRemarkMobiles = null;
        if (shareRemark && StringUtils.isNotBlank((CharSequence)rel.getRemark()) && !rel.getRemark().equals(exist.getRemark())) {
            newInfo.setRemarkName(rel.getRemark());
            oldInfo.setRemarkName(exist.getRemark());
            newRemark = rel.getRemark();
        }
        if (shareDesc && StringUtils.isNotBlank((CharSequence)rel.getDescription()) && !rel.getDescription().equals(exist.getDescription())) {
            newInfo.setDescription(rel.getDescription());
            oldInfo.setDescription(exist.getDescription());
            newDesc = rel.getDescription();
        }
        if (shareMobile) {
            List fromRemarkMobiles = this.contactMobileService.getRemarkMobile(corpId, fromWeworkUserId, contactId, Integer.valueOf(0));
            List toRemarkMobiles = this.contactMobileService.getRemarkMobile(corpId, weworkUserId, contactId, Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty((Collection)fromRemarkMobiles) && !CollectionUtils.isEqualCollection((Collection)fromRemarkMobiles, (Collection)toRemarkMobiles)) {
                newInfo.setRemarkMobile(fromRemarkMobiles);
                oldInfo.setRemarkMobile(toRemarkMobiles);
                newRemarkMobiles = fromRemarkMobiles;
            }
        }
        this.opModifyRemark(bizId, corpId, weworkUserId, contactId, newRemark, newDesc, newRemarkMobiles);
    }

    private void opModifyRemark(Long bizId, String corpId, String weworkUserId, String contactId, String remark, String desc, List<String> remarkMobiles) {
        log.info("opModifyRemark: \u4fee\u6539\u5907\u6ce8\uff0cbizId:{}\uff0ccorpId:{}\uff0cweworkUserId:{}\uff0ccontactId:{}\uff0cremark:{}\uff0cdesc:{}\uff0cremarkMobiles:{}", new Object[]{bizId, corpId, weworkUserId, contactId, remark, desc, remarkMobiles});
        if (StringUtils.isBlank((CharSequence)remark) && StringUtils.isBlank((CharSequence)desc) && CollectionUtils.isEmpty(remarkMobiles)) {
            log.info("remark and desc and remarkMobiles is empty");
            return;
        }
        ModifyRemarkDto modifyRemarkDto = new ModifyRemarkDto();
        modifyRemarkDto.setBizId(bizId);
        modifyRemarkDto.setCorpId(corpId);
        modifyRemarkDto.setContactId(contactId);
        modifyRemarkDto.setWeworkUserId(weworkUserId);
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            modifyRemarkDto.setRemark(remark);
        }
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            modifyRemarkDto.setDescription(desc);
        }
        if (CollectionUtils.isNotEmpty(remarkMobiles)) {
            modifyRemarkDto.setRemarkMobiles(remarkMobiles);
        }
        log.info("\u4fee\u6539\u6210\u5458\u5907\u6ce8\u4fe1\u606f\uff1a{}", (Object)modifyRemarkDto);
        try {
            this.contactOpService.modifyRemark(modifyRemarkDto);
        }
        catch (Exception e) {
            log.error("share remark: ", (Throwable)e);
        }
    }

    private void shareTag(Long bizId, String corpId, String contactId, String fromWeworkUserId, String weworkUserId, JsonContentDto followReqDto) {
        boolean isSame;
        List shareTags = this.contactTagService.getWeworkTags(corpId, fromWeworkUserId, contactId, Integer.valueOf(0));
        List existTags = this.contactTagService.getWeworkTags(corpId, weworkUserId, contactId, Integer.valueOf(0));
        TagInfoDto tagInfo = new TagInfoDto();
        ArrayList oldTags = Lists.newArrayList();
        ArrayList newTags = Lists.newArrayList();
        existTags.forEach(it -> {
            CsTag dto = new CsTag();
            dto.setTagId(it.getId());
            dto.setTagName(it.getName());
            oldTags.add(dto);
        });
        shareTags.forEach(it -> {
            CsTag dto = new CsTag();
            dto.setTagId(it.getId());
            dto.setTagName(it.getName());
            newTags.add(dto);
        });
        tagInfo.setOldTag((List)oldTags);
        tagInfo.setNewTag((List)newTags);
        List<Object> existIds = Lists.newArrayList();
        if (!CollectionUtils.isNotEmpty((Collection)shareTags)) {
            log.info("share tag addTags is empty fromWeworkUserId: {}, contactId: {}", (Object)fromWeworkUserId, (Object)contactId);
            return;
        }
        List shareTagIds = shareTags.stream().map(it -> it.getId()).filter(it -> StringUtils.isNotBlank((CharSequence)it)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)existTags)) {
            existIds = existTags.stream().map(it -> it.getId()).filter(it -> StringUtils.isNotBlank((CharSequence)it)).collect(Collectors.toList());
        }
        if (isSame = CollectionUtils.isEqualCollection(shareTagIds, (Collection)existIds)) {
            log.info("tag not need update addTagIds: {}, rmTagIds: {}", shareTagIds, (Object)existIds);
            return;
        }
        List addTagIds = (List)CollectionUtils.subtract(shareTagIds, (Iterable)existIds);
        List removeIds = (List)CollectionUtils.subtract((Iterable)existIds, shareTagIds);
        followReqDto.setTagInfo(tagInfo);
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        modifyTagDto.setBizId(bizId);
        modifyTagDto.setCorpId(corpId);
        modifyTagDto.setWeworkUserId(weworkUserId);
        modifyTagDto.setContactId(contactId);
        modifyTagDto.setAddTagIds(addTagIds);
        modifyTagDto.setRemoveTagIds(removeIds);
        try {
            this.contactOpService.modifyTag(modifyTagDto);
        }
        catch (Exception e) {
            log.error("share tag error: ", (Throwable)e);
        }
    }

    private void shareStage(String corpId, String contactId, String fromWeworkUserNum, String weworkUserNum, Long userId, JsonContentDto followReqDto) {
        WeworkContactStage fromContactStage = this.weworkContactStageMapper.selectCurrentStageByParams(corpId, fromWeworkUserNum, contactId);
        WeworkContactStage contactStage = this.weworkContactStageMapper.selectCurrentStageByParams(corpId, weworkUserNum, contactId);
        if (fromContactStage == null) {
            log.warn("share stage oldContactStage is null");
            return;
        }
        StageInfoDto stageInfoDto = new StageInfoDto();
        CsStage oldStage = new CsStage();
        CsStage newStage = new CsStage();
        newStage.setStageId(fromContactStage.getStageId());
        CustomerStage stage = this.customerStageMapper.queryStageByPrimaryKey(fromContactStage.getStageId());
        if (stage != null) {
            newStage.setStageValue(stage.getStageValue());
            newStage.setStageName(stage.getStageName());
            newStage.setType(stage.getType());
        }
        stageInfoDto.setNewStage(newStage);
        followReqDto.setStageInfo(stageInfoDto);
        if (contactStage != null) {
            oldStage.setStageId(contactStage.getStageId());
            stage = this.customerStageMapper.queryStageByPrimaryKey(contactStage.getStageId());
            if (stage != null) {
                oldStage.setStageName(stage.getStageName());
                oldStage.setStageValue(stage.getStageValue());
                oldStage.setType(stage.getType());
            }
            stageInfoDto.setOldStage(oldStage);
            contactStage.setStatus(fromContactStage.getStatus());
            contactStage.setStageId(fromContactStage.getStageId());
            contactStage.setFinalStageId(fromContactStage.getFinalStageId());
            contactStage.setStageReasonId(fromContactStage.getStageReasonId());
            contactStage.setRemark(fromContactStage.getRemark());
            contactStage.setUpdateBy(userId);
            contactStage.setUpdateTime(new Date());
            contactStage.setIsDeleted(fromContactStage.getIsDeleted());
            this.weworkContactStageMapper.updateByPrimaryKeySelective((Object)contactStage);
        } else {
            contactStage = new WeworkContactStage();
            contactStage.setBizId(fromContactStage.getBizId());
            contactStage.setCorpId(corpId);
            contactStage.setContactId(contactId);
            contactStage.setWeworkUserNum(weworkUserNum);
            contactStage.setStatus(fromContactStage.getStatus());
            contactStage.setStageId(fromContactStage.getStageId());
            contactStage.setFinalStageId(fromContactStage.getFinalStageId());
            contactStage.setStageReasonId(fromContactStage.getStageReasonId());
            contactStage.setRemark(fromContactStage.getRemark());
            contactStage.setCreateBy(userId);
            contactStage.setCreateTime(new Date());
            contactStage.setUpdateBy(userId);
            contactStage.setUpdateTime(new Date());
            contactStage.setIsDeleted(fromContactStage.getIsDeleted());
            this.weworkContactStageMapper.batchInsert(Collections.singletonList(contactStage));
        }
        try {
            this.customerCenterService.pushCustomerStage(contactStage);
        }
        catch (Exception e) {
            log.error("share stage push customer stage error: ", (Throwable)e);
        }
    }
}

