/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.LongIdAndNameDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.marketing.dto.PlanDeptDto;
import com.kuaike.scrm.dal.marketing.dto.PlanWeworkUserDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlanGroupUser;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupUserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserDto;
import com.kuaike.scrm.marketing.service.MarketingUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MarketingUserServiceImp
implements MarketingUserService {
    private static final Logger log = LoggerFactory.getLogger(MarketingUserServiceImp.class);
    @Resource
    private MarketingPlanGroupUserMapper marketingPlanGroupUserMapper;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public boolean saveMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums, List<Long> orgIds, Map<String, Integer> weworkUerIdWeightMap, Map<Long, Integer> deptIdWeightMap) {
        List<MarketingPlanGroupUser> list = this.queryGroupUser(bizId, corpId, planId, planGroupId);
        boolean isUpdateGroupUser = false;
        ArrayList insertList = Lists.newArrayList();
        ArrayList delList = Lists.newArrayList();
        ArrayList<MarketingPlanGroupUser> updateList = new ArrayList<MarketingPlanGroupUser>();
        ArrayList insertOrgIdList = Lists.newArrayList();
        ArrayList delOrgIdList = Lists.newArrayList();
        for (MarketingPlanGroupUser planGroupUser : list) {
            Integer newWeight;
            String weworkUserId = planGroupUser.getWeworkUserNum();
            Long orgId = planGroupUser.getOrgId();
            Integer oldWeight = planGroupUser.getWeight();
            if (orgId > 0L) {
                if (!orgIds.contains(orgId)) {
                    delOrgIdList.add(orgId);
                } else {
                    orgIds.remove(orgId);
                }
                newWeight = deptIdWeightMap.get(orgId);
            } else {
                if (!weworkUserNums.contains(weworkUserId)) {
                    delList.add(weworkUserId);
                } else {
                    weworkUserNums.remove(weworkUserId);
                }
                newWeight = weworkUerIdWeightMap.get(weworkUserId);
            }
            if (newWeight != null && !newWeight.equals(oldWeight)) {
                planGroupUser.setWeight(newWeight);
                updateList.add(planGroupUser);
            }
            if (oldWeight == null || oldWeight.equals(newWeight)) continue;
            planGroupUser.setWeight(newWeight);
            updateList.add(planGroupUser);
        }
        if (!CollectionUtils.isEmpty(weworkUserNums)) {
            insertList.addAll(weworkUserNums);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            insertOrgIdList.addAll(orgIds);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.marketingPlanGroupUserMapper.batchUpdate(updateList);
        }
        if (!CollectionUtils.isEmpty((Collection)insertList) || !CollectionUtils.isEmpty((Collection)delList)) {
            isUpdateGroupUser = true;
        }
        if (!CollectionUtils.isEmpty((Collection)insertOrgIdList) || !CollectionUtils.isEmpty((Collection)delOrgIdList)) {
            isUpdateGroupUser = true;
        }
        this.delMarketingUser(bizId, corpId, userId, planId, planGroupId, delList, delOrgIdList);
        this.insertMarketingUser(bizId, corpId, userId, planId, planGroupId, insertList, insertOrgIdList, weworkUerIdWeightMap, deptIdWeightMap);
        return isUpdateGroupUser;
    }

    @Override
    public List<MarketingPlanGroupUser> queryGroupUser(Long bizId, String corpId, Long planId, Long planGroupId) {
        return this.marketingPlanGroupUserMapper.queryGroupUser(bizId, corpId, planId, planGroupId);
    }

    @Override
    public void insertMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums, List<Long> insertOrgIdList, Map<String, Integer> weworkUerIdWeightMap, Map<Long, Integer> deptIdWeightMap) {
        MarketingPlanGroupUser marketingPlanGroupUser;
        if (CollectionUtils.isEmpty(weworkUserNums) && CollectionUtils.isEmpty(insertOrgIdList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(weworkUserNums)) {
            for (String weworkUserId : weworkUserNums) {
                marketingPlanGroupUser = new MarketingPlanGroupUser();
                marketingPlanGroupUser.setNum(this.idGen.getNum());
                marketingPlanGroupUser.setBizId(bizId);
                marketingPlanGroupUser.setCorpId(corpId);
                marketingPlanGroupUser.setPlanId(planId);
                marketingPlanGroupUser.setPlanGroupId(planGroupId);
                marketingPlanGroupUser.setWeworkUserNum(weworkUserId);
                marketingPlanGroupUser.setOrgId(NumberUtils.LONG_ZERO);
                marketingPlanGroupUser.setCreateBy(userId);
                marketingPlanGroupUser.setCreateTime(new Date());
                marketingPlanGroupUser.setUpdateBy(userId);
                marketingPlanGroupUser.setUpdateTime(new Date());
                marketingPlanGroupUser.setIsDeleted(Integer.valueOf(0));
                marketingPlanGroupUser.setWeight(Integer.valueOf(0));
                if (weworkUerIdWeightMap.containsKey(weworkUserId)) {
                    marketingPlanGroupUser.setWeight(weworkUerIdWeightMap.get(weworkUserId));
                }
                list.add(marketingPlanGroupUser);
            }
        }
        if (!CollectionUtils.isEmpty(insertOrgIdList)) {
            for (Long orgId : insertOrgIdList) {
                marketingPlanGroupUser = new MarketingPlanGroupUser();
                marketingPlanGroupUser.setNum(this.idGen.getNum());
                marketingPlanGroupUser.setBizId(bizId);
                marketingPlanGroupUser.setCorpId(corpId);
                marketingPlanGroupUser.setPlanId(planId);
                marketingPlanGroupUser.setPlanGroupId(planGroupId);
                marketingPlanGroupUser.setWeworkUserNum("");
                marketingPlanGroupUser.setOrgId(orgId);
                marketingPlanGroupUser.setCreateBy(userId);
                marketingPlanGroupUser.setCreateTime(new Date());
                marketingPlanGroupUser.setUpdateBy(userId);
                marketingPlanGroupUser.setUpdateTime(new Date());
                marketingPlanGroupUser.setIsDeleted(Integer.valueOf(0));
                marketingPlanGroupUser.setWeight(Integer.valueOf(0));
                if (deptIdWeightMap.containsKey(orgId)) {
                    marketingPlanGroupUser.setWeight(deptIdWeightMap.get(orgId));
                }
                list.add(marketingPlanGroupUser);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.marketingPlanGroupUserMapper.batchInsert((Collection)list);
        }
    }

    @Override
    public void delMarketingUser(Long bizId, String corpId, Long userId, Long planId, Long planGroupId, List<String> weworkUserNums, List<Long> orgIds) {
        if (!CollectionUtils.isEmpty(weworkUserNums)) {
            this.marketingPlanGroupUserMapper.batchDel(bizId, corpId, planId, planGroupId, userId, weworkUserNums);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            this.marketingPlanGroupUserMapper.batchDelByOrgIds(bizId, corpId, planId, planGroupId, userId, orgIds);
        }
    }

    @Override
    public void delMarketingUserByPlanGroup(Long bizId, String corpId, Long userId, Long planId, List<Long> planGroupIds) {
        if (!CollectionUtils.isEmpty(planGroupIds)) {
            this.marketingPlanGroupUserMapper.delByPlanGroupId(bizId, corpId, planId, planGroupIds, userId);
        }
    }

    @Override
    public Map<Long, List<WeworkUserDto>> getPlanOfWeworkUser(String corpId, List<Long> planIds) {
        List list = this.marketingPlanGroupUserMapper.queryPlanOfWeworkUser(corpId, planIds);
        HashMap<Long, List<WeworkUserDto>> result = new HashMap<Long, List<WeworkUserDto>>();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            Long planId = planWeworkUserDto.getPlanId();
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            if (result.containsKey(planId)) {
                ((List)result.get(planId)).add(weworkUserDto);
                continue;
            }
            ArrayList values = Lists.newArrayList();
            values.add(weworkUserDto);
            result.put(planId, values);
        }
        return result;
    }

    @Override
    public List<WeworkUserDto> getPlanGroupUserInfo(Long planId, Long planGroupId) {
        List list = this.marketingPlanGroupUserMapper.queryPlanGroupUserInfo(planId, planGroupId);
        ArrayList result = Lists.newArrayList();
        for (PlanWeworkUserDto planWeworkUserDto : list) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setId(planWeworkUserDto.getWeworkUserNum());
            weworkUserDto.setAvatar(planWeworkUserDto.getAvatar());
            weworkUserDto.setNickname(planWeworkUserDto.getNickname());
            weworkUserDto.setWeight(planWeworkUserDto.getWeight());
            result.add(weworkUserDto);
        }
        return result;
    }

    @Override
    public List<LongIdAndNameDto> getPlanGroupDeptInfo(Long planId, Long planGroupId) {
        log.info("getPlanGroupDeptInfo: planId:{}, planGroupId:{}", (Object)planId, (Object)planGroupId);
        List list = this.marketingPlanGroupUserMapper.queryPlanGroupDeptInfo(planId, planGroupId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("getPlanGroupDeptInfo: \u67e5\u8be2\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a:{}, planGroupId:{}", (Object)planId, (Object)planGroupId);
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (PlanDeptDto planDeptDto : list) {
            if (planDeptDto == null) continue;
            LongIdAndNameDto respDto = new LongIdAndNameDto();
            respDto.setId(planDeptDto.getDeptId());
            respDto.setName(planDeptDto.getDeptName());
            respDto.setWeight(planDeptDto.getWeight());
            result.add(respDto);
        }
        return result;
    }

    @Override
    public Map<Long, List<LongIdAndNameDto>> getPlanOfDept(Long bizId, List<Long> planIds) {
        log.info("getPlanOfDept: bizId:{}, planIds:{}", (Object)bizId, planIds);
        List list = this.marketingPlanGroupUserMapper.queryPlanOfDept(bizId, planIds);
        HashMap<Long, List<LongIdAndNameDto>> result = new HashMap<Long, List<LongIdAndNameDto>>();
        for (PlanDeptDto planDeptDto : list) {
            Long planId = planDeptDto.getPlanId();
            LongIdAndNameDto respDto = new LongIdAndNameDto();
            respDto.setId(planDeptDto.getDeptId());
            respDto.setName(planDeptDto.getDeptName());
            if (result.containsKey(planId)) {
                ((List)result.get(planId)).add(respDto);
                continue;
            }
            ArrayList values = Lists.newArrayList();
            values.add(respDto);
            result.put(planId, values);
        }
        return result;
    }
}

