/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.StatisticType;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.marketing.dto.PlanChannelDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.marketing.dto.MarketingChannelDetailDto;
import com.kuaike.scrm.marketing.service.MarketingChannelService;
import com.kuaike.scrm.marketing.service.MarketingPlanStatisticService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MarketingChannelServiceImp
implements MarketingChannelService {
    private static final Logger log = LoggerFactory.getLogger(MarketingChannelServiceImp.class);
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${marketing.url.format}")
    private String marketingPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${region-plan.url.format}")
    private String regionPlanUrlFormat;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${room-plan.url.format}")
    private String roomPlanUrlFormat;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private MarketingPlanStatisticService marketingPlanStatisticService;

    @Override
    public void saveMarketingChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds, Integer statisticType, PlanType planType) {
        if (CollectionUtils.isEmpty(channelIds)) {
            log.warn("saveMarketingChannels channels is null");
            return;
        }
        List list = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        ArrayList insertChannels = Lists.newArrayList();
        ArrayList delChannels = Lists.newArrayList();
        ArrayList updateChannels = Lists.newArrayList();
        for (MarketingChannel marketingChannel : list) {
            Long channelId = marketingChannel.getChannelId();
            if (!channelIds.contains(channelId)) {
                delChannels.add(channelId);
                continue;
            }
            channelIds.remove(channelId);
            updateChannels.add(marketingChannel);
        }
        insertChannels.addAll(channelIds);
        this.insertMarketingChannels(bizId, corpId, userId, planId, insertChannels, statisticType, planType);
        this.delMarketingChannels(bizId, corpId, userId, planId, delChannels);
        this.updateMarketingChannels(bizId, updateChannels, statisticType, planType);
    }

    public void insertMarketingChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds, Integer statisticType, PlanType planType) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return;
        }
        ArrayList marketingChannels = Lists.newArrayList();
        for (Long channelId : channelIds) {
            MarketingChannel marketingChannel = new MarketingChannel();
            marketingChannel.setNum(this.idGen.getNum());
            marketingChannel.setBizId(bizId);
            marketingChannel.setCorpId(corpId);
            marketingChannel.setPlanId(planId);
            marketingChannel.setChannelId(channelId);
            if (statisticType.intValue() == StatisticType.STATISTIC_UV_DETAIL.getValue()) {
                String shortUrl = this.weworkOauthService.wrapUrl(bizId, corpId, this.createChannelUrl(marketingChannel.getNum(), planType), marketingChannel.getNum());
                marketingChannel.setUrl(shortUrl);
            } else {
                marketingChannel.setUrl(this.createChannelUrl(marketingChannel.getNum(), planType));
            }
            marketingChannel.setCreateBy(userId);
            marketingChannel.setCreateTime(new Date());
            marketingChannel.setUpdateBy(userId);
            marketingChannel.setUpdateTime(new Date());
            marketingChannel.setIsDeleted(Integer.valueOf(0));
            marketingChannels.add(marketingChannel);
        }
        this.marketingChannelMapper.batchInsert((Collection)marketingChannels);
    }

    public void delMarketingChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return;
        }
        channelIds.remove(-1L);
        if (CollectionUtils.isEmpty(channelIds)) {
            return;
        }
        this.marketingChannelMapper.batchDel(bizId, corpId, planId, userId, channelIds);
    }

    private void updateMarketingChannels(Long bizId, List<MarketingChannel> channelList, Integer statisticType, PlanType planType) {
        for (MarketingChannel marketingChannel : channelList) {
            if (statisticType.intValue() == StatisticType.STATISTIC_UV_DETAIL.getValue()) {
                String shortUrl = this.weworkOauthService.wrapUrl(bizId, marketingChannel.getCorpId(), this.createChannelUrl(marketingChannel.getNum(), planType), marketingChannel.getNum());
                marketingChannel.setUrl(shortUrl);
            } else {
                marketingChannel.setUrl(this.createChannelUrl(marketingChannel.getNum(), planType));
            }
            this.marketingChannelMapper.updateByPrimaryKey((Object)marketingChannel);
        }
    }

    @Override
    public Map<Long, List<ChannelDto>> queryPlanOfChannel(String corpId, List<Long> planIds, Integer showInnerChannel) {
        List marketingChannels = this.marketingChannelMapper.queryPlanChannels(corpId, planIds);
        HashMap<Long, List<ChannelDto>> result = new HashMap<Long, List<ChannelDto>>();
        for (PlanChannelDto planChannelDto : marketingChannels) {
            if (YnEnum.YES.getValue().equals(showInnerChannel) && Objects.nonNull(SysChannelEnum.getInnerChannelByCode((String)planChannelDto.getNum()))) continue;
            Long planId = planChannelDto.getPlanId();
            ChannelDto channelDto = new ChannelDto();
            channelDto.setId(planChannelDto.getNum());
            channelDto.setName(planChannelDto.getName());
            if (result.containsKey(planId)) {
                ((List)result.get(planId)).add(channelDto);
                continue;
            }
            ArrayList list = Lists.newArrayList();
            list.add(channelDto);
            result.put(planId, list);
        }
        return result;
    }

    @Override
    public void delMarketingChannelOfPlan(Long bizId, String corpId, Long userId, Long planId) {
        this.marketingChannelMapper.delChannelOfPlan(bizId, corpId, userId, planId);
    }

    private String createChannelUrl(String num, PlanType planType) {
        if (planType == PlanType.CHANNEL_PLAN) {
            return MessageFormat.format(this.marketingPlanUrlFormat, num);
        }
        if (planType == PlanType.REGION_PLAN) {
            return MessageFormat.format(this.regionPlanUrlFormat, num);
        }
        if (planType == PlanType.ROOM_PLAN) {
            return MessageFormat.format(this.roomPlanUrlFormat, num);
        }
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef");
    }

    @Override
    public MarketingChannel getMarketingChannel(String num) {
        MarketingChannel marketingChannel = new MarketingChannel();
        marketingChannel.setNum(num);
        return (MarketingChannel)this.marketingChannelMapper.selectOne((Object)marketingChannel);
    }

    @Override
    public List<MarketingChannelDetailDto> getChannelList(BaseDto params) {
        log.info("getChannelList params: {}", (Object)params);
        String num = params.getId();
        if (StringUtils.isEmpty((Object)num)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u662f\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setBizId(bizId);
        marketingPlan.setCorpId(corpId);
        marketingPlan.setNum(num);
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8id\u53c2\u6570\u4e0d\u5bf9");
        }
        if (marketingPlan.getIsDraft() == 1 || marketingPlan.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u662f\u8349\u7a3f\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        List marketingChannels = this.marketingChannelMapper.queryPlanOfChannel(corpId, marketingPlan.getId());
        ArrayList result = Lists.newArrayList();
        Set planDelChannelIds = this.marketingChannelMapper.queryPlanDelChannelIds(corpId, marketingPlan.getId());
        if (CollectionUtils.isEmpty((Collection)marketingChannels) && CollectionUtils.isEmpty((Collection)planDelChannelIds)) {
            return result;
        }
        List planCurChannelIds = marketingChannels.stream().map(marketingChannel -> marketingChannel.getChannelId()).collect(Collectors.toList());
        ArrayList channelIds = Lists.newArrayList(planCurChannelIds);
        for (Long channelId : planDelChannelIds) {
            if (channelIds.contains(channelId)) continue;
            channelIds.add(channelId);
        }
        List channels = this.channelMapper.queryChannels(bizId, (Collection)channelIds);
        Map channelMap = channels.stream().collect(Collectors.toMap(channel -> channel.getId(), Function.identity()));
        Map<Long, Integer> channelPvMap = this.marketingPlanStatisticService.getPlanChannelPv(marketingPlan.getId(), channelIds);
        Map<Long, Integer> channelUvMap = this.marketingPlanStatisticService.getPlanChannelUv(marketingPlan.getId(), channelIds);
        Map<Long, Integer> channelAddFriendsMap = this.marketingPlanStatisticService.getPlanChannelAddFriends(marketingPlan.getId(), channelIds, corpId);
        HashMap channelQrcodeMap = Maps.newHashMap();
        if (marketingPlan.getQrcodeType() == 2) {
            List qrcodeList = this.marketingQrcodeMapper.getPlanGroupQrcodeByPlanId(marketingPlan.getId());
            for (MarketingQrcode qrcode : qrcodeList) {
                channelQrcodeMap.put(qrcode.getChannelId(), qrcode.getQrCodeUrl());
            }
        }
        for (MarketingChannel marketingChannel2 : marketingChannels) {
            Long channelId = marketingChannel2.getChannelId();
            MarketingChannelDetailDto channelDetailDto = new MarketingChannelDetailDto();
            channelDetailDto.setId(marketingChannel2.getNum());
            if (channelMap.get(channelId) != null) {
                channelDetailDto.setChannelId(((Channel)channelMap.get(channelId)).getNum());
                channelDetailDto.setChannelName(((Channel)channelMap.get(channelId)).getName());
            } else {
                channelDetailDto.setChannelId("-1");
                channelDetailDto.setChannelName(null);
            }
            if (marketingPlan.getQrcodeType() == 2) {
                channelDetailDto.setShortUrl((String)channelQrcodeMap.get(channelId));
            } else {
                channelDetailDto.setShortUrl(marketingChannel2.getUrl());
            }
            channelDetailDto.setPv(channelPvMap.getOrDefault(channelId, 0));
            channelDetailDto.setUv(channelUvMap.getOrDefault(channelId, 0));
            channelDetailDto.setAddFriendsCount(channelAddFriendsMap.getOrDefault(channelId, 0));
            channelDetailDto.setIsDeleted(0);
            channelDetailDto.setQrcodeType(marketingPlan.getQrcodeType());
            result.add(channelDetailDto);
        }
        for (Long channelId : planDelChannelIds) {
            if (planCurChannelIds.contains(channelId)) continue;
            MarketingChannelDetailDto channelDetailDto = new MarketingChannelDetailDto();
            channelDetailDto.setIsDeleted(1);
            if (channelMap.get(channelId) != null) {
                channelDetailDto.setChannelId(((Channel)channelMap.get(channelId)).getNum());
                channelDetailDto.setChannelName(((Channel)channelMap.get(channelId)).getName());
            } else {
                channelDetailDto.setChannelId("-1");
                channelDetailDto.setChannelName(null);
            }
            channelDetailDto.setPv(channelPvMap.getOrDefault(channelId, 0));
            channelDetailDto.setUv(channelUvMap.getOrDefault(channelId, 0));
            channelDetailDto.setAddFriendsCount(channelAddFriendsMap.getOrDefault(channelId, 0));
            result.add(channelDetailDto);
        }
        return result;
    }

    @Override
    public Long getBizIdByNum(String marketingChannelNum) {
        log.info("getBizIdByNum,marketingChannelNum:{}", (Object)marketingChannelNum);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)marketingChannelNum)) {
            log.warn("getBizIdByNum,marketingChannelNum is null");
            return null;
        }
        return this.marketingChannelMapper.selectBizIdByNum(marketingChannelNum);
    }
}

