/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.marketing.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.marketing.dto.IdsReq;
import com.kuaike.scrm.marketing.dto.MarketingAddFriendExportDto;
import com.kuaike.scrm.marketing.service.MarketingPlanStatisticService;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="marketingPlanAddFriendExport")
public class ExportMarketingAddFriendServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportMarketingAddFriendServiceImpl.class);
    @Resource
    private ExportTaskMapper exportTaskMapper;
    @Resource
    private MarketingPlanStatisticService marketingPlanStatisticService;

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        Long bizId = task.getBizId();
        Long userId = LoginUtils.getCurrentUserId();
        this.createCorpDir(corpId);
        File dirFile = null;
        IdsReq idsReq = (IdsReq)JSON.parseObject((String)json, IdsReq.class);
        String filePath = this.createFilePath(corpId, ExportTaskType.MARKETING_ADD_FRIEND, "\u6e20\u9053\u6d3b\u7801\u52a0\u597d\u53cb\u5bfc\u51fa");
        String sheetName = "\u6e20\u9053\u6d3b\u7801\u52a0\u597d\u53cb\u5bfc\u51fa";
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            excelWriter = EasyExcel.write((String)filePath, MarketingAddFriendExportDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0, (String)sheetName).build();
            List<MarketingAddFriendExportDto> list = this.marketingPlanStatisticService.queryAddFriendListByPlanIds(corpId, bizId, idsReq);
            excelWriter.write(list, writeSheet);
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("createPlanAddFriendExportFile BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("createPlanAddFriendExportFile error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
            if (Objects.nonNull(dirFile) && dirFile.exists() && dirFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)dirFile);
                    log.info("delete dir:{}", (Object)dirFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error("delete dir:{} fail", (Object)dirFile.getAbsolutePath(), (Object)e);
                }
            }
        }
        return url;
    }

    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (task == null) {
                log.info("build plan add friend task is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }
}

