/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendfission.service.impl;

import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.ChannelDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.PlanType;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.marketing.dto.ChannelListItemDto;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannel;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.friendfission.dto.RelateChannelRes;
import com.kuaike.scrm.friendfission.dto.SpreadUrlDto;
import com.kuaike.scrm.friendfission.service.FissionChannelService;
import com.kuaike.scrm.marketing.service.MarketingQrcodeService;
import com.kuaike.scrm.system.service.ChannelService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FissionChannelServiceImpl
implements FissionChannelService {
    private static final Logger log = LoggerFactory.getLogger(FissionChannelServiceImpl.class);
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${friend-fission.url.format}")
    private String friendFissionUrlFormat;
    @Resource
    private MarketingPlanMapper marketingPlanMapper;
    @Resource
    private MarketingChannelMapper marketingChannelMapper;
    @Resource
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private MarketingQrcodeService marketingQrcodeService;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public void addRelate(RelateChannelRes params) {
        log.info("add relate params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long userId = userInfo.getId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            log.info("fission plan is not exist");
            return;
        }
        if (marketingPlan.getIsDeleted() == 1) {
            log.info("fission plan status error");
            return;
        }
        if (marketingPlan.getType().intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("is not friend fission plan type");
            return;
        }
        Long planId = marketingPlan.getId();
        List channelIdList = this.channelService.getChannelIdByNum(params.getChannelIds());
        this.addFissionChannels(bizId, corpId, userId, planId, channelIdList);
        this.marketingQrcodeService.saveMarketingQrcode(bizId, corpId, userId, planId, false);
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(planId);
    }

    @Override
    public List<ChannelListItemDto> list(BaseDto params) {
        log.info("fission channel list params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null || marketingPlan.getType().intValue() != PlanType.FRIEND_FISSION_PLAN.getValue()) {
            log.info("fission plan is not exist");
            return null;
        }
        Long planId = marketingPlan.getId();
        if (params.getPageDto() != null) {
            int total = this.marketingChannelMapper.queryPlanChannelCount(corpId, planId, params.getName());
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        List channelList = this.marketingChannelMapper.queryPlanChannelList(corpId, planId, params.getName(), params.getPageDto());
        ArrayList result = Lists.newArrayListWithCapacity((int)channelList.size());
        for (ChannelListItemDto itemDto : channelList) {
            if (StringUtils.isEmpty((Object)itemDto.getName())) {
                itemDto.setName("\u4f01\u4e1a\u5fae\u4fe1");
            }
            result.add(itemDto);
        }
        return result;
    }

    @Override
    public SpreadUrlDto getSpreadUrl(BaseDto params) {
        log.info("fission channel spread url params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingChannel marketingChannel = new MarketingChannel();
        marketingChannel.setNum(params.getId());
        marketingChannel.setCorpId(corpId);
        marketingChannel = (MarketingChannel)this.marketingChannelMapper.selectOne((Object)marketingChannel);
        if (marketingChannel == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        SpreadUrlDto spreadUrlDto = new SpreadUrlDto();
        spreadUrlDto.setPlanPageUrl(marketingChannel.getUrl());
        MarketingQrcode qrcode = this.marketingQrcodeMapper.queryFriendFissionQrcode(marketingChannel.getPlanId(), marketingChannel.getChannelId());
        if (qrcode != null) {
            spreadUrlDto.setQrcodeUrl(qrcode.getQrCodeUrl());
        }
        return spreadUrlDto;
    }

    @Override
    @Transactional
    public void del(BaseDto params) {
        log.info("fission channel del params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MarketingChannel marketingChannel = new MarketingChannel();
        marketingChannel.setNum(params.getId());
        marketingChannel = (MarketingChannel)this.marketingChannelMapper.selectOne((Object)marketingChannel);
        if (marketingChannel == null || marketingChannel.getIsDeleted() == 1) {
            log.info("marketing channel not exists or deleted");
            return;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        marketingChannel.setIsDeleted(Integer.valueOf(1));
        marketingChannel.setUpdateTime(new Date());
        marketingChannel.setUpdateBy(userInfo.getId());
        this.marketingChannelMapper.updateByPrimaryKey((Object)marketingChannel);
        this.marketingQrcodeMapper.delMarketingQrcodeByChannel(userInfo.getId(), marketingChannel.getPlanId(), (Collection)Lists.newArrayList((Object[])new Long[]{marketingChannel.getChannelId()}));
        this.marketingQrcodeService.sendNotSyncQrCodeToKafka(marketingChannel.getPlanId());
    }

    @Override
    public List<ChannelDto> remainChannelList(BaseDto params) {
        log.info("fission remain channel params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)params.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        MarketingPlan marketingPlan = new MarketingPlan();
        marketingPlan.setNum(params.getId());
        marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectOne((Object)marketingPlan);
        if (marketingPlan == null) {
            log.info("fission plan is not exist");
            return null;
        }
        Long planId = marketingPlan.getId();
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            int total = this.marketingChannelMapper.queryPlanRemainChannelCount(corpId, planId, params.getName());
            pageDto.setCount(Integer.valueOf(total));
        }
        List list = this.marketingChannelMapper.queryPlanRemainChannelList(corpId, planId, params.getName(), params.getPageDto());
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (Channel channel : list) {
            ChannelDto channelDto = new ChannelDto();
            channelDto.setId(channel.getNum());
            SysChannelEnum innerChannel = SysChannelEnum.getInnerChannelByCode((String)channel.getNum());
            if (Objects.nonNull(innerChannel)) continue;
            channelDto.setName(channel.getName());
            result.add(channelDto);
        }
        return result;
    }

    @Override
    public void addFissionChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds) {
        if (CollectionUtils.isEmpty(channelIds)) {
            log.warn("saveMarketingChannels channels is null");
            return;
        }
        List list = this.marketingChannelMapper.queryPlanOfChannel(corpId, planId);
        List curChannelIds = list.stream().map(it -> it.getChannelId()).collect(Collectors.toList());
        channelIds.removeAll(curChannelIds);
        this.insertMarketingChannels(bizId, corpId, userId, planId, channelIds);
    }

    private void insertMarketingChannels(Long bizId, String corpId, Long userId, Long planId, List<Long> channelIds) {
        if (CollectionUtils.isEmpty(channelIds)) {
            return;
        }
        ArrayList marketingChannels = Lists.newArrayList();
        for (Long channelId : channelIds) {
            MarketingChannel marketingChannel = new MarketingChannel();
            marketingChannel.setNum(this.idGen.getNum());
            marketingChannel.setBizId(bizId);
            marketingChannel.setCorpId(corpId);
            marketingChannel.setPlanId(planId);
            marketingChannel.setChannelId(channelId);
            String url = MessageFormat.format(this.friendFissionUrlFormat, marketingChannel.getNum());
            String shortUrl = this.weworkOauthService.wrapUrl(bizId, corpId, url, marketingChannel.getNum());
            marketingChannel.setUrl(shortUrl);
            marketingChannel.setCreateBy(userId);
            marketingChannel.setCreateTime(new Date());
            marketingChannel.setUpdateBy(userId);
            marketingChannel.setUpdateTime(new Date());
            marketingChannel.setIsDeleted(Integer.valueOf(0));
            marketingChannels.add(marketingChannel);
        }
        this.marketingChannelMapper.batchInsert((Collection)marketingChannels);
    }
}

