/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmLeadsTagService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsTagReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.crm.common.service.dto.resp.LeadsTagResp;
import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.req.SetStageReq;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerStageService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateDetailDto;
import com.kuaike.scrm.customerupdate.dto.CustomerUpdateTaskDto;
import com.kuaike.scrm.customerupdate.enums.CuHandlerStatusEnum;
import com.kuaike.scrm.customerupdate.enums.RemarkHandlerWayEnum;
import com.kuaike.scrm.customerupdate.enums.TagHandlerType;
import com.kuaike.scrm.customerupdate.enums.TaskTypeEnum;
import com.kuaike.scrm.customerupdate.enums.ValidateStatusEnum;
import com.kuaike.scrm.dal.marketing.entity.CustomerUpdateTaskDetail;
import com.kuaike.scrm.dal.marketing.mapper.CustomerUpdateTaskDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.follow.record.dto.StageReq;
import com.kuaike.scrm.follow.record.service.FollowRecordService;
import com.kuaike.scrm.wework.contact.dto.ModifyRemarkDto;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerUpdateSupport {
    private static final Logger log = LoggerFactory.getLogger(CustomerUpdateSupport.class);
    @Resource
    private CrmLeadsTagService crmLeadsTagService;
    @Resource
    private CustomerCenterService customerCenterService;
    @Resource
    private CustomerUpdateTaskDetailMapper taskDetailMapper;
    @Resource
    private CcCustomerDetailService customerDetailService;
    @Resource
    private CcCustomerNumService customerNumService;
    @Resource
    IdGen idGen;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private ContactOpService contactOpService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactTagMapper weworkContactTagMapper;
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Resource
    private CcCustomerStageService customerStageService;
    @Autowired
    private FollowRecordService followRecordService;
    private static final int DEQUE_LEN = 100;
    private static final ExecutorService customerUpdateExecutor = new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(100), (ThreadFactory)new NamedThreadFactory("customer-update-executor"));

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)customerUpdateExecutor);
    }

    public void syncUpdateCustomerInfo(CustomerUpdateTaskDto cuTaskDto, List<CustomerUpdateDetailDto> customerUpdateDetailDto) {
        log.info("\u5ba2\u6237\u66f4\u65b0\u4efb\u52a1\u6570\u636e\uff1acuTaskDto:{}", (Object)JSON.toJSONString((Object)cuTaskDto));
        if (Objects.isNull(cuTaskDto.getTaskType())) {
            log.error("\u5ba2\u6237\u66f4\u65b0\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        TraceExecutorWrapUtil.wrapExecute((Executor)customerUpdateExecutor, () -> {
            HashMap updatedMobiles = Maps.newHashMap();
            CurrentUserInfo currentUserInfo = new CurrentUserInfo();
            currentUserInfo.setId(cuTaskDto.getOperatorUserId());
            currentUserInfo.setBizId(cuTaskDto.getBizId());
            currentUserInfo.setCorpId(cuTaskDto.getCorpId());
            LoginUtils.setCurrentUser((CurrentUserInfo)currentUserInfo);
            try {
                List partition = Lists.partition((List)customerUpdateDetailDto, (int)500);
                partition.forEach(item -> {
                    if (cuTaskDto.getTaskType().intValue() == TaskTypeEnum.WEWORK_CUSTOMER_UPDATE.getValue()) {
                        this.updateWeworkContactInfo(cuTaskDto, (List<CustomerUpdateDetailDto>)item, updatedMobiles);
                    } else if (cuTaskDto.getTaskType().intValue() == TaskTypeEnum.MOBILE_CUSTOMER_UPDATE.getValue()) {
                        this.updateCrmCustomerInfo(cuTaskDto, (List<CustomerUpdateDetailDto>)item);
                    }
                });
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5ba2\u6237\u66f4\u65b0\u5931\u8d25\uff1a:{}", (Object)e.getMessage(), (Object)e);
            }
            LoginUtils.clear();
        });
    }

    public void updateCrmCustomerInfo(CustomerUpdateTaskDto cuTaskDto, List<CustomerUpdateDetailDto> customerUpdateDetailDto) {
        Set matchMobiles = customerUpdateDetailDto.stream().map(CustomerUpdateDetailDto::getMobile).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        List leadsList = null;
        try {
            CrmLeadsInfoReq req = new CrmLeadsInfoReq();
            req.setBizId(cuTaskDto.getBizId());
            req.setCorpId(cuTaskDto.getCorpId());
            req.setProductLineId(cuTaskDto.getProductLineId());
            req.setMobiles(matchMobiles);
            log.info("\u8c03\u7528 crmLeadsService.getLeadsList param:{} ", (Object)req);
            leadsList = this.crmLeadsService.getLeadsList(req);
            log.info("\u8c03\u7528 crmLeadsService.getLeadsList result {}", (Object)JSON.toJSONString((Object)leadsList));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528crmLeadsService.getLeadsList \u5f02\u5e38\uff1aerrMsg:{}", (Object)e.getMessage(), (Object)e);
            Set<Long> taskDetailsIds = customerUpdateDetailDto.stream().map(CustomerUpdateDetailDto::getTaskDetailId).collect(Collectors.toSet());
            this.batchUpdateStatus(taskDetailsIds, 3, e.getMessage(), cuTaskDto.getBizId(), cuTaskDto.getOperatorUserId());
            return;
        }
        try {
            leadsList = leadsList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getProductLineNum()) && StringUtils.equals((CharSequence)item.getProductLineNum(), (CharSequence)cuTaskDto.getProductLineNum())).collect(Collectors.toList());
            Map existMobileLeads = leadsList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMobile())).collect(Collectors.toMap(CrmLeadsInfoResp::getMobile, Function.identity()));
            Map existMobileLeads1 = leadsList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMobile1())).collect(Collectors.toMap(CrmLeadsInfoResp::getMobile1, Function.identity()));
            for (CustomerUpdateDetailDto dto : customerUpdateDetailDto) {
                CrmLeadsInfoResp existLeads = (CrmLeadsInfoResp)existMobileLeads.get(dto.getMobile());
                if (Objects.nonNull(existLeads)) {
                    this.doUpdateCrm(cuTaskDto, dto, existLeads);
                    continue;
                }
                CrmLeadsInfoResp existLeads1 = (CrmLeadsInfoResp)existMobileLeads1.get(dto.getMobile());
                if (Objects.nonNull(existLeads1)) {
                    this.doUpdateCrm(cuTaskDto, dto, existLeads1);
                    continue;
                }
                this.updateDetailStatus(dto.getTaskDetailId(), ValidateStatusEnum.FAIL.getValue(), "\u624b\u673a\u7ebf\u7d22\u672a\u627e\u5230", cuTaskDto.getBizId(), CuHandlerStatusEnum.FAIL.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u53c2\u6570\uff0c\u8c03\u7528\u63a5\u53e3\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void doUpdateCrm(CustomerUpdateTaskDto cuTaskDto, CustomerUpdateDetailDto dto, CrmLeadsInfoResp existLeads) {
        boolean executeStatus;
        List existTagIds = null;
        log.info("update crm param: dto{}; existLieads:{}", (Object)JSON.toJSONString((Object)dto), (Object)JSON.toJSONString((Object)existLeads));
        try {
            CrmLeadsTagReq leadsTagReq = new CrmLeadsTagReq();
            leadsTagReq.setBizId(cuTaskDto.getBizId());
            leadsTagReq.setCorpId(cuTaskDto.getCorpId());
            leadsTagReq.setLeadsId(existLeads.getId());
            leadsTagReq.setProductLineId(cuTaskDto.getProductLineId());
            LeadsTagResp tagResp = this.crmLeadsTagService.queryLeadsTag(leadsTagReq);
            log.info("\u67e5\u8be2\u5b58\u91cf\u6807\u7b7e\u4fe1\u606f:result:{};", (Object)JSON.toJSONString((Object)tagResp));
            if (Objects.nonNull(tagResp)) {
                existTagIds = tagResp.getTagIds();
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7ebf\u7d22\u6807\u7b7e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            this.updateTaskDetailStatus(dto.getTaskDetailId(), CuHandlerStatusEnum.FAIL.getValue(), e.getMessage(), cuTaskDto.getBizId());
            return;
        }
        if (cuTaskDto.getInputType() == 1) {
            dto.setTagIds(cuTaskDto.getTagIds());
            dto.setChannelId(cuTaskDto.getChannelId());
            dto.setChannelNum(cuTaskDto.getChannelNum());
        }
        HashSet toAddTagIds = Sets.newHashSet();
        if (cuTaskDto.getTagHandleWay().intValue() == TagHandlerType.OVERLAY.getValue()) {
            if (CollectionUtils.isNotEmpty((Collection)existTagIds)) {
                toAddTagIds.addAll(existTagIds);
            }
            if (CollectionUtils.isNotEmpty(dto.getTagIds())) {
                toAddTagIds.addAll(dto.getTagIds());
            }
        } else if (CollectionUtils.isNotEmpty(dto.getTagIds())) {
            toAddTagIds.addAll(dto.getTagIds());
        }
        if (!(executeStatus = this.updateCrmTag(cuTaskDto, dto, toAddTagIds, existLeads))) {
            return;
        }
        executeStatus = this.updateCrmLeadsDetail(cuTaskDto, dto, existLeads);
        if (!executeStatus) {
            return;
        }
        this.updateTaskDetailStatus(dto.getTaskDetailId(), CuHandlerStatusEnum.SUCCESS.getValue(), "", cuTaskDto.getBizId());
    }

    public void updateWeworkContactInfo(CustomerUpdateTaskDto cuTaskDto, List<CustomerUpdateDetailDto> cudDto, Map<String, String> updatedMobiles) {
        Collection values;
        Map existedComunicateMobiles;
        List<String> tagIds = cuTaskDto.getTagIds();
        Long channelId = cuTaskDto.getChannelId();
        Map<String, List<CustomerUpdateDetailDto>> groupByUnionIds = cudDto.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUnionid())).collect(Collectors.groupingBy(CustomerUpdateDetailDto::getUnionid));
        Set<String> unionIds = groupByUnionIds.keySet();
        Map<String, List<CustomerUpdateDetailDto>> groupByMobile = cudDto.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMobile())).collect(Collectors.groupingBy(CustomerUpdateDetailDto::getMobile));
        Set<String> mobiles = groupByMobile.keySet();
        ConcurrentMap wcrGroupByUnionIds = Maps.newConcurrentMap();
        ConcurrentMap contactMobilesMap = Maps.newConcurrentMap();
        ConcurrentMap wcrByMobilesMap = Maps.newConcurrentMap();
        ConcurrentMap interFlowMobile = Maps.newConcurrentMap();
        Set<String> weworkUserIds = this.filterByUnionId(unionIds, cuTaskDto, wcrGroupByUnionIds, contactMobilesMap, interFlowMobile);
        Set<String> weworkUserIdByMobiles = this.filterByMobileId(mobiles, cuTaskDto, wcrByMobilesMap, contactMobilesMap);
        weworkUserIds.addAll(weworkUserIdByMobiles);
        Set comunicateMobiles = cudDto.stream().map(CustomerUpdateDetailDto::getCommunicationMobile).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        HashSet existMobiles = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(comunicateMobiles) && MapUtils.isNotEmpty((Map)(existedComunicateMobiles = this.customerNumService.batchGetContactIdByMobile(cuTaskDto.getBizId(), comunicateMobiles))) && CollectionUtils.isNotEmpty(values = existedComunicateMobiles.values())) {
            for (List value : values) {
                existMobiles.addAll(value);
            }
        }
        Map weworkUserMaps = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(cuTaskDto.getCorpId(), weworkUserIds);
        for (CustomerUpdateDetailDto dto : cudDto) {
            String errorMsg;
            List contactRelations = null;
            if (StringUtils.isNotBlank((CharSequence)dto.getUnionid())) {
                contactRelations = (List)wcrGroupByUnionIds.get(dto.getUnionid());
            }
            log.info("unionId \u627e\u5230\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a:{}", (Object)JSON.toJSONString(contactRelations));
            if (CollectionUtils.isEmpty((Collection)contactRelations)) {
                if (StringUtils.isBlank((CharSequence)dto.getMobile())) {
                    this.updateDetailStatus(dto.getTaskDetailId(), ValidateStatusEnum.FAIL.getValue(), "unionId \u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237", cuTaskDto.getBizId(), CuHandlerStatusEnum.FAIL.getValue());
                    continue;
                }
                contactRelations = (List)wcrByMobilesMap.get(dto.getMobile());
                if (CollectionUtils.isEmpty((Collection)contactRelations)) {
                    log.error("unionId \u548c\u624b\u673a\u53f7\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237 mobile:{};unionId:{}", (Object)dto.getMobile(), (Object)dto.getUnionid());
                    this.updateDetailStatus(dto.getTaskDetailId(), ValidateStatusEnum.FAIL.getValue(), "unionId \u548c\u624b\u673a\u53f7\u90fd\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237", cuTaskDto.getBizId(), CuHandlerStatusEnum.FAIL.getValue());
                    continue;
                }
                log.info("\u624b\u673a\u53f7; \u627e\u5230\u5ba2\u6237\u4fe1\u606f\uff1amobile:{} contactRelations size:{}", (Object)dto.getMobile(), (Object)CollectionUtils.size((Object)contactRelations));
                dto.setMatchByMobile(true);
            } else {
                log.info("unionId; \u627e\u5230\u5ba2\u6237\u4fe1\u606f\uff1aunionId:{} contactRelations size:{}", (Object)dto.getUnionid(), (Object)CollectionUtils.size((Object)contactRelations));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCommunicationMobile())) {
                String updatedContactId = updatedMobiles.get(dto.getCommunicationMobile());
                String toUpdateContactId = ((WeworkContactRelation)contactRelations.get(0)).getContactId();
                if (StringUtils.equals((CharSequence)toUpdateContactId, (CharSequence)updatedContactId)) {
                    log.error("\u4e92\u901a\u624b\u673a\u53f7\u5df2\u5b58\u5728:unionId{}; communicationMobile:{}", (Object)dto.getUnionid(), (Object)dto.getCommunicationMobile());
                    this.updateTaskDetailStatus(dto.getTaskDetailId(), CuHandlerStatusEnum.FAIL.getValue(), "\u4e92\u901a\u624b\u673a\u53f7\u5df2\u5b58\u5728", cuTaskDto.getBizId());
                    continue;
                }
            }
            if (cuTaskDto.getInputType() == 1) {
                dto.setTagIds(tagIds);
                dto.setChannelId(channelId);
                dto.setChannelNum(cuTaskDto.getChannelNum());
            }
            StringBuilder errMsgBuilder = new StringBuilder();
            HashSet alreadyAddedTags = Sets.newHashSet();
            HashSet alreadyDeletedTags = Sets.newHashSet();
            for (WeworkContactRelation wcr : contactRelations) {
                String errMsg;
                Set existTagIds = this.weworkContactTagMapper.selectTagIdsByParams(cuTaskDto.getCorpId(), wcr.getWeworkUserId(), wcr.getContactId());
                ArrayList toAddTagId = Lists.newArrayList();
                ArrayList toDelTagId = Lists.newArrayList();
                if (cuTaskDto.getTagHandleWay().intValue() == TagHandlerType.OVERLAY.getValue()) {
                    if (CollectionUtils.isNotEmpty(dto.getTagIds())) {
                        toAddTagId.addAll(dto.getTagIds());
                        toAddTagId.removeAll(existTagIds);
                    }
                } else {
                    if (CollectionUtils.isNotEmpty(dto.getTagIds())) {
                        toAddTagId.addAll(dto.getTagIds());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)existTagIds)) {
                        toDelTagId.addAll(existTagIds);
                    }
                }
                Integer tagNotLog = YnEnum.NO.getValue();
                if (alreadyAddedTags.containsAll(toAddTagId) && alreadyDeletedTags.containsAll(toDelTagId)) {
                    log.info("\u5f53\u524d\u6807\u7b7e\u5df2\u8bb0\u5f55\u65e5\u5fd7\uff1b\u65e0\u9700\u91cd\u590d\u8bb0\u5f55\u65e5\u5fd7: toAddedTag:{}; toDeledTag:{}", (Object)toAddTagId, (Object)toDelTagId);
                    tagNotLog = YnEnum.YES.getValue();
                }
                if (StringUtils.isNotBlank((CharSequence)(errMsg = this.modifyScrmTag(cuTaskDto, toAddTagId, toDelTagId, wcr, tagNotLog))) && !errMsgBuilder.toString().contains(errMsg)) {
                    errMsgBuilder.append(";").append(errMsg);
                } else {
                    alreadyAddedTags.addAll(toAddTagId);
                    alreadyDeletedTags.addAll(toDelTagId);
                }
                String remarkMsg = this.modifyScrmRemark(cuTaskDto, dto, wcr, contactMobilesMap, existMobiles);
                if (StringUtils.isNotBlank((CharSequence)remarkMsg) && !errMsgBuilder.toString().contains(remarkMsg)) {
                    errMsgBuilder.append(";").append(remarkMsg);
                }
                StageReq stageReq = new StageReq();
                stageReq.setStageId(dto.getStageId());
                String weworkUserNum = (String)weworkUserMaps.get(wcr.getWeworkUserId());
                String stageErr = this.handleScrmStage(cuTaskDto, weworkUserNum, wcr.getContactId(), stageReq, dto.getTaskDetailId());
                if (!StringUtils.isNotBlank((CharSequence)stageErr) || errMsgBuilder.toString().contains(stageErr)) continue;
                errMsgBuilder.append(";").append(stageErr);
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getCommunicationMobile())) {
                updatedMobiles.put(dto.getCommunicationMobile(), ((WeworkContactRelation)contactRelations.get(0)).getContactId());
            }
            if ((errorMsg = errMsgBuilder.toString()).startsWith(";")) {
                errorMsg = errorMsg.substring(1);
            }
            CuHandlerStatusEnum statusEnum = CuHandlerStatusEnum.SUCCESS;
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                statusEnum = CuHandlerStatusEnum.FAIL;
            }
            this.updateTaskDetailStatus(dto.getTaskDetailId(), statusEnum.getValue(), errorMsg, cuTaskDto.getBizId());
        }
    }

    private Set<String> filterByMobileId(Set<String> mobiles, CustomerUpdateTaskDto cuTaskDto, Map<String, List<WeworkContactRelation>> wcrByMobilesMap, Map<String, List<WeworkContactMobile>> contactMobilesMap) {
        Map contactIdsToMobiles;
        if (CollectionUtils.isEmpty(mobiles)) {
            log.info("\u672a\u627e\u5230\u901a\u8fc7\u624b\u673a\u53f7\u66f4\u65b0\u5ba2\u6237\u7684\u6570\u636e");
            return Sets.newHashSet();
        }
        List weworkContactMobiles = this.weworkContactMobileMapper.batchSelectByMobiles(cuTaskDto.getCorpId(), mobiles);
        Map<String, List<WeworkContactMobile>> contactMobilesMapDb = weworkContactMobiles.stream().peek(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId())).collect(Collectors.groupingBy(WeworkContactMobile::getWeworkUserAndContactId));
        if (MapUtils.isNotEmpty(contactMobilesMapDb)) {
            contactMobilesMap.putAll(contactMobilesMapDb);
        }
        if (MapUtils.isEmpty((Map)(contactIdsToMobiles = this.customerNumService.batchGetContactIdByMobile(cuTaskDto.getBizId(), mobiles)))) {
            return Sets.newHashSet();
        }
        Set contactIds = contactIdsToMobiles.keySet();
        List weworkContactRelations = this.weworkContactRelationMapper.queryByCorpIdAndContactIds(cuTaskDto.getCorpId(), contactIds);
        Map<String, List<WeworkContactRelation>> groupByContactIds = weworkContactRelations.stream().collect(Collectors.groupingBy(WeworkContactRelation::getContactId));
        contactIdsToMobiles.forEach((contact, existMobiles) -> {
            List contactRelations = groupByContactIds.getOrDefault(contact, Lists.newArrayList());
            if (CollectionUtils.isNotEmpty((Collection)existMobiles)) {
                for (String mobile : existMobiles) {
                    List existGroupByMobiles = wcrByMobilesMap.getOrDefault(mobile, Lists.newArrayList());
                    contactRelations.addAll(existGroupByMobiles);
                    wcrByMobilesMap.put(mobile, contactRelations);
                }
            }
        });
        return weworkContactRelations.stream().map(WeworkContactRelation::getWeworkUserId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private Set<String> filterByUnionId(Set<String> unionIds, CustomerUpdateTaskDto cuTaskDto, Map<String, List<WeworkContactRelation>> wcrGroupByUnionIds, Map<String, List<WeworkContactMobile>> contactMobilesMap, Map<String, String> interFlowMobile) {
        if (CollectionUtils.isEmpty(unionIds)) {
            return Sets.newHashSet();
        }
        List weworkContactRelations = this.weworkContactRelationMapper.selectByUnionIds(cuTaskDto.getCorpId(), unionIds);
        Map<String, List<WeworkContactRelation>> wcrGroupByUnionIdsDb = weworkContactRelations.stream().peek(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId())).filter(item -> StringUtils.isNotBlank((CharSequence)item.getUnionId())).collect(Collectors.groupingBy(WeworkContactRelation::getUnionId));
        if (MapUtils.isNotEmpty(wcrGroupByUnionIdsDb)) {
            wcrGroupByUnionIds.putAll(wcrGroupByUnionIdsDb);
        }
        List contactIds = weworkContactRelations.stream().map(WeworkContactRelation::getContactId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Set<String> weworkUserIds = weworkContactRelations.stream().map(WeworkContactRelation::getWeworkUserId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        List weworkContactMobiles = this.weworkContactMobileMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(cuTaskDto.getCorpId(), contactIds, weworkUserIds);
        Map<String, List<WeworkContactMobile>> contactMobilesMapDb = weworkContactMobiles.stream().peek(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId())).collect(Collectors.groupingBy(WeworkContactMobile::getWeworkUserAndContactId));
        if (MapUtils.isNotEmpty(contactMobilesMapDb)) {
            contactMobilesMap.putAll(contactMobilesMapDb);
        }
        return weworkUserIds;
    }

    private String handleScrmStage(CustomerUpdateTaskDto cuTaskDto, String weworkUserNum, String weworkContactId, StageReq reqDto, Long taskDetailId) {
        try {
            log.info(" \u66f4\u65b0stage param: bizId{};corpId:{};weworkUser:{}; weworkContactId:{};reqDto:{}", new Object[]{cuTaskDto.getBizId(), cuTaskDto.getCorpId(), weworkUserNum, weworkContactId, reqDto});
            if (Objects.nonNull(reqDto.getStageId()) && StringUtils.isBlank((CharSequence)weworkUserNum)) {
                String errMsg = "\u672a\u627e\u5230\u5728\u804c\u6210\u5458,\u65e0\u6cd5\u66f4\u65b0\u9636\u6bb5";
                log.error(errMsg);
                return errMsg;
            }
            this.followRecordService.handleStage(cuTaskDto.getBizId(), cuTaskDto.getCorpId(), weworkUserNum, weworkContactId, reqDto, null);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539Stage \u4fe1\u606f\u4fe1\u606f\u5f02\u5e38\uff1aerrMsg:{}", (Object)e.getMessage(), (Object)e);
            return e.getMessage();
        }
        return null;
    }

    private String modifyScrmTag(CustomerUpdateTaskDto cuTaskDto, List<String> toAddTagId, List<String> toDelTagId, WeworkContactRelation wcr, Integer tagNotLog) {
        if (CollectionUtils.isEmpty(toAddTagId) && CollectionUtils.isEmpty(toDelTagId)) {
            log.warn("\u5bfc\u5165\u6570\u636e\u4e2d\u6807\u7b7e\u4e3a\u7a7a: \u4e0d\u540c\u6b65\u6807\u7b7e\u4fe1\u606f bizId:{}; taskId:{}", (Object)cuTaskDto.getBizId(), (Object)cuTaskDto.getTaskId());
            return null;
        }
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        try {
            modifyTagDto.setAddTagIds(toAddTagId);
            modifyTagDto.setContactId(wcr.getContactId());
            modifyTagDto.setWeworkUserId(wcr.getWeworkUserId());
            modifyTagDto.setRemoveTagIds(toDelTagId);
            modifyTagDto.setBizId(cuTaskDto.getBizId());
            modifyTagDto.setCorpId(cuTaskDto.getCorpId());
            if (Objects.nonNull(tagNotLog)) {
                modifyTagDto.setTagNotLog(tagNotLog);
            }
            this.contactOpService.modifyTag(modifyTagDto);
            this.contactOpService.saveContactTag(modifyTagDto, cuTaskDto.getOperatorUserId());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6807\u7b7e\u4fe1\u606f\u5f02\u5e38:errMsg{}; param:{}", new Object[]{e.getMessage(), modifyTagDto, e});
            return e.getMessage();
        }
        return null;
    }

    private String modifyScrmRemark(CustomerUpdateTaskDto cuTaskDto, CustomerUpdateDetailDto dto, WeworkContactRelation wcr, Map<String, List<WeworkContactMobile>> contactMobilesMap, Set<String> existedComunicateMobiles) {
        if (StringUtils.isEmpty((CharSequence)dto.getChannelNum()) && StringUtils.isEmpty((CharSequence)dto.getRemarkName()) && StringUtils.isEmpty((CharSequence)dto.getDescription()) && StringUtils.isEmpty((CharSequence)dto.getCommunicationMobile())) {
            log.warn("\u5ba2\u6237\u66f4\u65b0 \u6ca1\u6709\u9700\u8981\u53d8\u66f4\u7684\u5ba2\u6237\u4fe1\u606f: bizId:{};dto:{},", (Object)cuTaskDto.getBizId(), (Object)JSON.toJSONString((Object)dto));
            return null;
        }
        String contactRemark = null;
        contactRemark = cuTaskDto.getRemarkNameHandleWay().intValue() == RemarkHandlerWayEnum.REPLACE.getValue() ? dto.getRemarkName() : (cuTaskDto.getRemarkNameHandleWay().intValue() == RemarkHandlerWayEnum.PREFIX_REMARK.getValue() ? (StringUtils.isBlank((CharSequence)dto.getRemarkName()) ? wcr.getRemark() : wcr.getRemark() + dto.getRemarkName()) : (StringUtils.isBlank((CharSequence)dto.getRemarkName()) ? wcr.getRemark() : dto.getRemarkName() + wcr.getRemark()));
        ModifyRemarkDto remarkDto = new ModifyRemarkDto();
        try {
            if (StringUtils.isNotBlank((CharSequence)dto.getCommunicationMobile())) {
                if (dto.getMatchByMobile().booleanValue()) {
                    log.error("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u5339\u914d\u624b\u673a\u53f7\uff1b\u5f53\u524d\u5339\u914d\u624b\u673a\u53f7\uff1amatchMobile:{}; \u4fee\u6539\u624b\u673a\uff1a:{}", (Object)dto.getMobile(), (Object)dto.getCommunicationMobile());
                    return "\u6682\u4e0d\u652f\u6301\u4fee\u6539\u4e92\u901a\u624b\u673a\u53f7,\u8bf7\u624b\u52a8\u4fee\u6539";
                }
                if (existedComunicateMobiles.contains(dto.getCommunicationMobile())) {
                    log.error("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u5339\u914d\u624b\u673a\u53f7\uff1b\u5f53\u524d\u5339\u914d\u624b\u673a\u53f7\uff1amatchMobile:{}; \u4fee\u6539\u624b\u673a\uff1a:{}", (Object)dto.getMobile(), (Object)dto.getCommunicationMobile());
                    return "\u6682\u4e0d\u652f\u6301\u4fee\u6539\u4e92\u901a\u624b\u673a\u53f7,\u8bf7\u624b\u52a8\u4fee\u6539";
                }
                List mobilesByContactId = this.customerNumService.getMobilesByContactId(wcr.getBizId(), wcr.getContactId());
                if (CollectionUtils.isNotEmpty((Collection)mobilesByContactId) && !mobilesByContactId.contains(dto.getCommunicationMobile())) {
                    log.error("\u6682\u4e0d\u652f\u6301\u4fee\u6539\u5339\u914d\u624b\u673a\u53f7\uff1b\u5f53\u524d\u5339\u914d\u624b\u673a\u53f7\uff1amatchMobile:{}; \u4fee\u6539\u624b\u673a\uff1a:{}", (Object)dto.getMobile(), (Object)dto.getCommunicationMobile());
                    return "\u6682\u4e0d\u652f\u6301\u4fee\u6539\u4e92\u901a\u624b\u673a\u53f7,\u8bf7\u624b\u52a8\u4fee\u6539";
                }
                List<WeworkContactMobile> existContactMobile = contactMobilesMap.get(wcr.getWeworkUserAndContactId());
                if (CollectionUtils.isNotEmpty(existContactMobile)) {
                    List existMobileIds = existContactMobile.stream().filter(item -> !StringUtils.equals((CharSequence)dto.getCommunicationMobile(), (CharSequence)item.getRemarkMobile())).map(WeworkContactMobile::getId).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(existMobileIds)) {
                        this.weworkContactMobileMapper.logicDeleteByIds(existMobileIds, cuTaskDto.getOperatorUserId());
                    }
                } else {
                    this.weworkContactMobileMapper.insert((Object)this.newMobile(cuTaskDto.getBizId(), cuTaskDto.getCorpId(), wcr.getWeworkUserId(), wcr.getContactId(), dto.getCommunicationMobile()));
                }
                remarkDto.setRemarkMobiles((List)Lists.newArrayList((Object[])new String[]{dto.getCommunicationMobile()}));
            } else {
                remarkDto.setDelOldMobile(Boolean.FALSE);
            }
            remarkDto.setChannelNum(dto.getChannelNum());
            remarkDto.setRemark(contactRemark);
            remarkDto.setContactId(wcr.getContactId());
            remarkDto.setWeworkUserId(wcr.getWeworkUserId());
            remarkDto.setDescription(dto.getDescription());
            remarkDto.setBizId(cuTaskDto.getBizId());
            remarkDto.setCorpId(cuTaskDto.getCorpId());
            remarkDto.setSyncToCustomer(Boolean.valueOf(true));
            remarkDto.setMod(Boolean.TRUE);
            this.contactOpService.modifyRemark(remarkDto);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0 \u5907\u6ce8\u540d|\u624b\u673a\u53f7|\u63cf\u8ff0\u5f02\u5e38,errorMsg:{};param:{}", new Object[]{e.getMessage(), remarkDto, e});
            return e.getMessage();
        }
        return null;
    }

    private boolean updateCrmTag(CustomerUpdateTaskDto cuTaskDto, CustomerUpdateDetailDto dto, Collection<String> toAddTagId, CrmLeadsInfoResp existLeads) {
        if (CollectionUtils.isEmpty(toAddTagId)) {
            log.warn("\u6ca1\u6709\u53d8\u66f4\u7684tag\u4fe1\u606f\uff1abizId:{};taskId:{};taskDetailId:{}", new Object[]{cuTaskDto.getBizId(), cuTaskDto.getTaskId(), dto.getTaskDetailId()});
            return true;
        }
        try {
            CrmLeadsTagReq leadsTagReq = new CrmLeadsTagReq();
            leadsTagReq.setBizId(cuTaskDto.getBizId());
            leadsTagReq.setCorpId(cuTaskDto.getCorpId());
            leadsTagReq.setLeadsId(existLeads.getId());
            leadsTagReq.setTags(toAddTagId);
            leadsTagReq.setProductLineId(cuTaskDto.getProductLineId());
            this.crmLeadsTagService.saveTag(leadsTagReq);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7ebf\u7d22\u6807\u7b7e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.updateTaskDetailStatus(dto.getTaskDetailId(), 3, e.getMessage(), cuTaskDto.getBizId());
            return false;
        }
        return true;
    }

    private boolean updateCrmLeadsDetail(CustomerUpdateTaskDto cuTaskDto, CustomerUpdateDetailDto dto, CrmLeadsInfoResp existLeads) {
        if (Objects.isNull(existLeads)) {
            this.updateTaskDetailStatus(dto.getTaskDetailId(), 3, "\u5f53\u524d\u7ebf\u7d22\u672a\u627e\u5230", cuTaskDto.getBizId());
            return false;
        }
        try {
            CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
            crmLeadsReq.setProductLineId(cuTaskDto.getProductLineId());
            crmLeadsReq.setLeadId(existLeads.getId());
            crmLeadsReq.setBizId(cuTaskDto.getBizId());
            crmLeadsReq.setCorpId(cuTaskDto.getCorpId());
            if (StringUtils.isNotBlank((CharSequence)dto.getCustomerName()) && dto.getCustomerName().length() > 32) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5ba2\u6237\u540d\u79f0\u592a\u957f");
            }
            crmLeadsReq.setName(dto.getCustomerName());
            crmLeadsReq.setAllocUserId(dto.getBindingUserId());
            crmLeadsReq.setMarketUserId(dto.getMarketUserId());
            crmLeadsReq.setChannelId(dto.getChannelId());
            crmLeadsReq.setStageId(dto.getStageId());
            crmLeadsReq.setP1(dto.getP1());
            crmLeadsReq.setP2(dto.getP2());
            crmLeadsReq.setP3(dto.getP3());
            crmLeadsReq.setP4(dto.getP4());
            crmLeadsReq.setP5(dto.getP5());
            crmLeadsReq.setP6(dto.getP6());
            crmLeadsReq.setP7(dto.getP7());
            crmLeadsReq.setP8(dto.getP8());
            crmLeadsReq.setP9(dto.getP9());
            crmLeadsReq.setP10(dto.getP10());
            crmLeadsReq.setP11(dto.getP11());
            crmLeadsReq.setP12(dto.getP12());
            crmLeadsReq.setP13(dto.getP13());
            crmLeadsReq.setP14(dto.getP14());
            crmLeadsReq.setP15(dto.getP15());
            crmLeadsReq.setP16(dto.getP16());
            crmLeadsReq.setP17(dto.getP17());
            crmLeadsReq.setP18(dto.getP18());
            crmLeadsReq.setP19(dto.getP19());
            crmLeadsReq.setP20(dto.getP20());
            crmLeadsReq.setOperator(cuTaskDto.getOperatorUserId());
            this.crmLeadsService.modLeadsAndAllocateAllInfo(crmLeadsReq);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u7ebf\u7d22\u6570\u636e\u5f02\u5e38: errorMsg{}", (Object)e.getMessage(), (Object)e);
            this.updateTaskDetailStatus(dto.getTaskDetailId(), 3, e.getMessage(), cuTaskDto.getBizId());
            return false;
        }
        try {
            ModMobileReq modMobileReq = new ModMobileReq();
            modMobileReq.setDescription(dto.getDescription());
            modMobileReq.setChannelId(dto.getChannelNum());
            modMobileReq.setName(dto.getCustomerName());
            modMobileReq.setBizId(cuTaskDto.getBizId());
            modMobileReq.setCustomerNum(existLeads.getCustomerNum());
            this.customerDetailService.updateCustomerDetail(modMobileReq, cuTaskDto.getCorpId());
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u6570\u636e\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38: errorMsg{}", (Object)e.getMessage(), (Object)e);
            this.updateTaskDetailStatus(dto.getTaskDetailId(), 3, e.getMessage(), cuTaskDto.getBizId());
            return false;
        }
        try {
            SetStageReq setStageReq = new SetStageReq();
            setStageReq.setBizId(cuTaskDto.getBizId());
            setStageReq.setSource("crm");
            setStageReq.setCustomerNum(existLeads.getCustomerNum());
            setStageReq.setProductLineId(cuTaskDto.getProductLineNum());
            setStageReq.setStageId(dto.getStageId());
            this.customerStageService.setStage(setStageReq);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u6570\u636e\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38: errorMsg{}", (Object)e.getMessage(), (Object)e);
            this.updateTaskDetailStatus(dto.getTaskDetailId(), CuHandlerStatusEnum.FAIL.getValue(), e.getMessage(), cuTaskDto.getBizId());
            return false;
        }
        return true;
    }

    private void updateTaskDetailStatus(Long taskDetailId, Integer status, String errorMsg, Long bizId) {
        if (Objects.isNull(status) || Objects.isNull(taskDetailId)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            log.error("\u5ba2\u6237\u66f4\u65b0\u5f02\u5e38\uff1ataskDetailId:{}; status:{}; errorMsg:{}; bizId:{}", new Object[]{taskDetailId, status, errorMsg, bizId});
        }
        this.taskDetailMapper.batchUpdateStatus((Collection)Lists.newArrayList((Object[])new Long[]{taskDetailId}), status, errorMsg, bizId, NumberUtils.LONG_MINUS_ONE);
    }

    private void batchUpdateStatus(Collection<Long> taskDetailIds, Integer status, String errorMsg, Long bizId, Long operator) {
        if (Objects.isNull(status) || CollectionUtils.isEmpty(taskDetailIds)) {
            return;
        }
        this.taskDetailMapper.batchUpdateStatus(taskDetailIds, status, errorMsg, bizId, operator);
    }

    private WeworkContactMobile newMobile(Long bizId, String corpId, String weworkUserId, String contactId, String mobile) {
        WeworkContactMobile weworkContactMobile = new WeworkContactMobile();
        weworkContactMobile.setNum(this.idGen.getNum());
        weworkContactMobile.setBizId(bizId);
        weworkContactMobile.setCorpId(corpId);
        weworkContactMobile.setWeworkUserId(weworkUserId);
        weworkContactMobile.setContactId(contactId);
        weworkContactMobile.setIsDeleted(YnEnum.NO.getValue());
        weworkContactMobile.setRemarkMobile(mobile);
        Date now = new Date();
        weworkContactMobile.setCreateBy(Long.valueOf(-1L));
        weworkContactMobile.setCreateTime(now);
        weworkContactMobile.setUpdateBy(Long.valueOf(-1L));
        weworkContactMobile.setUpdateTime(now);
        return weworkContactMobile;
    }

    private void updateDetailStatus(Long taskDetailId, Integer status, String errorMsg, Long bizId, Integer handleStatus) {
        if (Objects.isNull(taskDetailId)) {
            log.error("\u66f4\u65b0taskDetail \u72b6\u6001\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CustomerUpdateTaskDetail taskDetail = new CustomerUpdateTaskDetail();
        taskDetail.setBizId(bizId);
        taskDetail.setUpdateTime(new Date());
        taskDetail.setId(taskDetailId);
        taskDetail.setValidateFailReason(errorMsg);
        taskDetail.setValidateStatus(status);
        if (Objects.nonNull(handleStatus)) {
            taskDetail.setHandleStatus(handleStatus);
        }
        this.taskDetailMapper.updateByPrimaryKeySelective((Object)taskDetail);
    }
}

