/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.friendfission.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.entity.MarketingTagRule;
import com.kuaike.scrm.dal.marketing.entity.MarketingTagRuleItem;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleItemMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingTagRuleMapper;
import com.kuaike.scrm.friendfission.dto.FissionAttachTagRuleDto;
import com.kuaike.scrm.friendfission.service.FissionTagRuleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FissionTagRuleServiceImpl
implements FissionTagRuleService {
    private static final Logger log = LoggerFactory.getLogger(FissionTagRuleServiceImpl.class);
    @Resource
    private MarketingTagRuleMapper marketingTagRuleMapper;
    @Resource
    private MarketingTagRuleItemMapper marketingTagRuleItemMapper;

    @Override
    public void save(Long planId, List<FissionAttachTagRuleDto> tagRules, Boolean isAdd) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        if (tagRules == null) {
            tagRules = Lists.newArrayList();
        }
        List curTagRules = this.marketingTagRuleMapper.queryTagRules(corpId, planId, null);
        Map<Long, MarketingTagRule> tagRuleMap = curTagRules.stream().collect(Collectors.toMap(MarketingTagRule::getId, Function.identity()));
        for (FissionAttachTagRuleDto tagRuleDto : tagRules) {
            if (tagRuleDto.getId() == null || isAdd.booleanValue()) {
                this.insertTagRule(planId, tagRuleDto);
                continue;
            }
            this.updateTagRule(tagRuleMap, tagRuleDto);
            tagRuleMap.remove(tagRuleDto.getId());
        }
        for (MarketingTagRule tagRule : tagRuleMap.values()) {
            this.delTagRule(tagRule);
        }
    }

    @Override
    public List<FissionAttachTagRuleDto> getTagRules(String corpId, Long planId) {
        List tagRuleList = this.marketingTagRuleMapper.queryTagRules(corpId, planId, Integer.valueOf(0));
        ArrayList result = Lists.newArrayListWithCapacity((int)tagRuleList.size());
        for (MarketingTagRule tagRule : tagRuleList) {
            FissionAttachTagRuleDto tagRuleDto = new FissionAttachTagRuleDto();
            tagRuleDto.setId(tagRule.getId());
            tagRuleDto.setType(tagRule.getType());
            if (tagRuleDto.getType() == 2) {
                tagRuleDto.setInviteCount(tagRule.getInviteCount());
            } else if (tagRuleDto.getType() == 3) {
                tagRuleDto.setStage(tagRule.getStage());
            }
            tagRuleDto.setTags(this.marketingTagRuleItemMapper.queryTagRuleItemInfo(corpId, planId, tagRule.getId()));
            result.add(tagRuleDto);
        }
        return result;
    }

    private void insertTagRule(Long planId, FissionAttachTagRuleDto tagRuleDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingTagRule tagRule = new MarketingTagRule();
        tagRule.setBizId(userInfo.getBizId());
        tagRule.setCorpId(userInfo.getCorpId());
        tagRule.setPlanId(planId);
        tagRule.setType(tagRuleDto.getType());
        tagRule.setInviteCount(tagRuleDto.getInviteCount());
        tagRule.setStage(tagRuleDto.getStage());
        tagRule.setIsDeleted(Integer.valueOf(0));
        tagRule.setCreateBy(userInfo.getId());
        tagRule.setUpdateBy(userInfo.getId());
        tagRule.setCreateTime(new Date());
        tagRule.setUpdateTime(new Date());
        this.marketingTagRuleMapper.insertSelective((Object)tagRule);
        Long tagRuleId = tagRule.getId();
        List<String> tagIds = tagRuleDto.getTagIds();
        ArrayList tagRuleItems = Lists.newArrayListWithCapacity((int)tagIds.size());
        for (String tagId : tagIds) {
            tagRuleItems.add(this.buildTagRuleItem(planId, tagRuleId, tagId));
        }
        this.marketingTagRuleItemMapper.batchInsert((Collection)tagRuleItems);
    }

    private void updateTagRule(Map<Long, MarketingTagRule> tagRuleMap, FissionAttachTagRuleDto tagRuleDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingTagRule tagRule = tagRuleMap.get(tagRuleDto.getId());
        if (tagRule == null) {
            return;
        }
        tagRule.setType(tagRuleDto.getType());
        tagRule.setInviteCount(tagRuleDto.getInviteCount());
        tagRule.setStage(tagRuleDto.getStage());
        tagRule.setIsDeleted(Integer.valueOf(0));
        tagRule.setUpdateBy(userInfo.getId());
        tagRule.setUpdateTime(new Date());
        this.marketingTagRuleMapper.updateByPrimaryKey((Object)tagRule);
        List tagRuleItems = this.marketingTagRuleItemMapper.queryTagRuleItems(userInfo.getCorpId(), tagRule.getPlanId(), tagRule.getId(), null);
        Map tagRuleItemMap = tagRuleItems.stream().collect(Collectors.toMap(MarketingTagRuleItem::getTagId, Function.identity()));
        ArrayList insertList = Lists.newArrayList();
        for (String tagId : tagRuleDto.getTagIds()) {
            if (tagRuleItemMap.containsKey(tagId)) {
                MarketingTagRuleItem tagRuleItem = (MarketingTagRuleItem)tagRuleItemMap.get(tagId);
                if (tagRuleItem.getIsDeleted() == 1) {
                    tagRuleItem.setIsDeleted(Integer.valueOf(0));
                    this.marketingTagRuleItemMapper.updateByPrimaryKeySelective((Object)tagRuleItem);
                }
                tagRuleItemMap.remove(tagId);
                continue;
            }
            insertList.add(this.buildTagRuleItem(tagRule.getPlanId(), tagRule.getId(), tagId));
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.marketingTagRuleItemMapper.batchInsert((Collection)insertList);
        }
        if (tagRuleItemMap.size() > 0) {
            List ids = tagRuleItemMap.values().stream().map(it -> it.getId()).collect(Collectors.toList());
            this.marketingTagRuleItemMapper.delTagRuleItems(userInfo.getId(), ids);
        }
    }

    private void delTagRule(MarketingTagRule tagRule) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        this.marketingTagRuleMapper.deleteByPrimaryKey((Object)tagRule);
        this.marketingTagRuleItemMapper.delTagRuleItemsByRuleId(userInfo.getId(), tagRule.getId());
    }

    private MarketingTagRuleItem buildTagRuleItem(Long planId, Long tagRuleId, String tagId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        MarketingTagRuleItem tagRuleItem = new MarketingTagRuleItem();
        tagRuleItem.setBizId(userInfo.getBizId());
        tagRuleItem.setCorpId(userInfo.getCorpId());
        tagRuleItem.setPlanId(planId);
        tagRuleItem.setTagRuleId(tagRuleId);
        tagRuleItem.setTagId(tagId);
        tagRuleItem.setIsDeleted(Integer.valueOf(0));
        tagRuleItem.setCreateBy(userInfo.getId());
        tagRuleItem.setUpdateBy(userInfo.getId());
        tagRuleItem.setCreateTime(new Date());
        tagRuleItem.setUpdateTime(new Date());
        return tagRuleItem;
    }
}

