/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.customerupdate.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.marketing.dto.CustomerUpdateListDto;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

public class CustomerUpdateListReq {
    private Integer taskType;
    private String name;
    private Long creatorId;
    private Date startTime;
    private Date endTime;
    private PageDto pageDto;

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.taskType), (Object)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageNum()), (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageSize()), (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public CustomerUpdateListDto convert2UpdateListDto(Long bizId, Set<Long> manageUserIds) {
        CustomerUpdateListDto listDto = new CustomerUpdateListDto();
        listDto.setBizId(bizId);
        listDto.setTaskType(this.taskType);
        listDto.setName(this.name);
        listDto.setStartTime(this.startTime);
        listDto.setEndTime(this.endTime);
        listDto.setManageUserIds(manageUserIds);
        listDto.setOffset(Integer.valueOf(this.pageDto.getOffset()));
        listDto.setPageSize(this.pageDto.getPageSize());
        return listDto;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getName() {
        return this.name;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerUpdateListReq)) {
            return false;
        }
        CustomerUpdateListReq other = (CustomerUpdateListReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomerUpdateListReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "CustomerUpdateListReq(taskType=" + this.getTaskType() + ", name=" + this.getName() + ", creatorId=" + this.getCreatorId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageDto=" + this.getPageDto() + ")";
    }
}

