/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkUserIdMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.sop.service.UserConvertService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserConvertServiceImpl
implements UserConvertService {
    private static final Logger log = LoggerFactory.getLogger(UserConvertServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private AgentDecryptWeworkUserIdMapper agentDecryptWeworkUserIdMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;

    @Override
    public Map<Long, String> convertUserId(Set<Long> userIds, OperatorResultMemberType memberType) {
        if (memberType == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6210\u5458\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<Object, Object> result = Maps.newHashMap();
        switch (memberType) {
            case WEWORK_USER_ID: {
                result = this.convertWeworkUserId(userIds);
                break;
            }
            case WEWORK_USER_NUM: {
                result = this.convertWeworkUserNum(userIds);
                break;
            }
            case DECRY_WEWORK_USER_ID: {
                result = this.convertDecryWeworkUserId(userIds);
                break;
            }
            case WEWORK_DIGIT_ID: {
                result = this.convertWeworkDigitId(userIds);
                break;
            }
            default: {
                log.warn("convert memberType: {}", (Object)memberType);
            }
        }
        return result;
    }

    @Override
    public Map<Long, String> convertWeworkUserNum(Set<Long> userIds) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(userIds)) {
            return result;
        }
        User user = (User)this.userMapper.selectByPrimaryKey(Lists.newArrayList(userIds).get(0));
        String corpId = user.getCorpId();
        Map weworkUserIdMap = this.userMapper.queryUserAndWeworkUserMap(userIds);
        Map weworkUserIdNumMap = this.weworkUserMapper.queryUserNumIdMap(corpId, weworkUserIdMap.values());
        for (Long userId : userIds) {
            String weworkUserId = (String)weworkUserIdMap.get(userId);
            String weworkUserNum = null;
            if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
                weworkUserNum = (String)weworkUserIdNumMap.get(weworkUserId);
            }
            result.put(userId, weworkUserNum);
        }
        return result;
    }

    @Override
    public Map<String, Long> convertUserIdByWeworkUserNum(Set<String> weworkUserNums) {
        Map result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return result;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum((String)Lists.newArrayList(weworkUserNums).get(0));
        Map weworkUserNumIdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
        result = this.userMapper.queryUserIdByWeworkUserId(weworkUser.getBizId(), weworkUserNumIdMap.values());
        return result;
    }

    @Override
    public Map<Long, String> convertWeworkUserId(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        return this.userMapper.queryUserAndWeworkUserMap(userIds);
    }

    @Override
    public Map<String, Long> convertUserIdByWeworkUserId(Long bizId, Set<String> weworkUserIds) {
        if (CollectionUtils.isEmpty(weworkUserIds)) {
            return Maps.newHashMap();
        }
        return this.userMapper.queryUserIdByWeworkUserId(bizId, weworkUserIds);
    }

    @Override
    public Map<Long, String> convertDecryWeworkUserId(Set<Long> userIds) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(userIds)) {
            return result;
        }
        User user = (User)this.userMapper.selectByPrimaryKey(Lists.newArrayList(userIds).get(0));
        Long bizId = user.getBizId();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        Integer isNewDkf = weworkCorp.getIsNewDkf();
        Map weworkUserIdMap = this.userMapper.queryUserAndWeworkUserMap(userIds);
        if (isNewDkf == 0) {
            return weworkUserIdMap;
        }
        Map decryUserIdMap = this.agentDecryptWeworkUserIdMapper.queryMapByEncryptUserIds(bizId, weworkUserIdMap.values());
        for (Long userId : userIds) {
            String weworkUserId = (String)weworkUserIdMap.get(userId);
            String decryWeworkUserId = null;
            if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
                decryWeworkUserId = (String)decryUserIdMap.get(weworkUserId);
            }
            result.put(userId, decryWeworkUserId);
        }
        return result;
    }

    @Override
    public Map<String, Long> convertUserIdByDecryWeworkUserId(Long bizId, Set<String> decryWeworkUserIds) {
        if (CollectionUtils.isEmpty(decryWeworkUserIds)) {
            return Maps.newHashMap();
        }
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByBizId(bizId);
        Integer isNewDkf = weworkCorp.getIsNewDkf();
        if (isNewDkf == 0) {
            return this.userMapper.queryUserIdByWeworkUserId(bizId, decryWeworkUserIds);
        }
        Map decryUserIdMap = this.agentDecryptWeworkUserIdMapper.queryMapByDecryptUserIds(bizId, decryWeworkUserIds);
        return this.userMapper.queryUserIdByWeworkUserId(bizId, decryUserIdMap.values());
    }

    @Override
    public Map<Long, String> convertWeworkDigitId(Set<Long> userIds) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(userIds)) {
            return result;
        }
        User user = (User)this.userMapper.selectByPrimaryKey(Lists.newArrayList(userIds).get(0));
        String corpId = user.getCorpId();
        Map weworkUserIdMap = this.userMapper.queryUserAndWeworkUserMap(userIds);
        List weworkUsers = this.weworkUserMapper.queryVipUserByWeworkUserId(corpId, weworkUserIdMap.values());
        HashMap digitUserIdMap = Maps.newHashMap();
        for (WeworkUser weworkUser : weworkUsers) {
            digitUserIdMap.put(weworkUser.getWeworkUserId(), weworkUser.getWeworkDigitId());
        }
        for (Long userId : userIds) {
            String weworkUserId = (String)weworkUserIdMap.get(userId);
            String digitUserId = null;
            if (StringUtils.isNotBlank((CharSequence)weworkUserId)) {
                digitUserId = (String)digitUserIdMap.get(weworkUserId);
            }
            result.put(userId, digitUserId);
        }
        return result;
    }

    @Override
    public Map<String, Long> convertUserIdByWeworkDigitId(Set<String> weworkDigitIds) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(weworkDigitIds)) {
            return result;
        }
        List weworkUsers = this.weworkUserMapper.queryByDigitIds(weworkDigitIds);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            return result;
        }
        Long bizId = ((WeworkUser)weworkUsers.get(0)).getBizId();
        Set weworkUserIds = weworkUsers.stream().map(it -> it.getWeworkUserId()).collect(Collectors.toSet());
        Map userIdMap = this.userMapper.queryUserIdByWeworkUserId(bizId, weworkUserIds);
        for (WeworkUser weworkUser : weworkUsers) {
            result.put(weworkUser.getWeworkDigitId(), userIdMap.get(weworkUser.getWeworkUserId()));
        }
        return result;
    }
}

