/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.BatchSetBindingReq;
import cn.kinyun.customer.center.dto.req.CustomerBindReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerBindService;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.call.enums.StatusEnum;
import com.kuaike.scrm.common.dto.CountResult;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.YesOrNoEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.resp.OrgListRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.agent.mapper.AgentDecryptWeworkContactIdMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.call.entity.CallTaskDetail;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskMapper;
import com.kuaike.scrm.dal.marketing.dto.SopWorkspaceListDto;
import com.kuaike.scrm.dal.marketing.dto.sop.SopTaskListReq;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskDetailMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.sop.dto.SopWorkspaceCountResp;
import com.kuaike.scrm.sop.dto.req.GroupSendDto;
import com.kuaike.scrm.sop.dto.req.SopWorkspaceListReq;
import com.kuaike.scrm.sop.dto.req.SopWorkspaceTaskDetailReq;
import com.kuaike.scrm.sop.dto.resp.SopWorkspaceTaskDetailResp;
import com.kuaike.scrm.sop.service.SopWorkspaceService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SopWorkspaceServiceImpl
implements SopWorkspaceService {
    private static final Logger log = LoggerFactory.getLogger(SopWorkspaceServiceImpl.class);
    @Resource
    private SopTaskDetailMapper sopTaskDetailMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private AgentDecryptWeworkContactIdMapper agentDecryptWeworkContactIdMapper;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private OrgService orgService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Resource
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private UserRoleCommonService userRoleCommonService;
    @Resource
    private CallTaskDetailMapper callTaskDetailMapper;
    @Resource
    private CallTaskMapper callTaskMapper;
    @Resource
    private WeworkCorpService weworkCorpService;
    @Resource
    private CcCustomerDetailService customerDetailService;
    @Resource
    private CcCustomerNumService customerNumService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private CallRecordMapper callRecordMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CcCustomerBindService ccCustomerBindService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    private static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final ExecutorService recoverExecutor = new ThreadPoolExecutor(PROCESSORS, 2 * PROCESSORS, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("recoverCustomerBindingData"));

    @Override
    public List<SopWorkspaceListDto> workspaceList(SopWorkspaceListReq req) {
        req.check();
        PageDto pageDto = Optional.ofNullable(req.getPageDto()).orElse(new PageDto());
        req.setPageDto(pageDto);
        SopTaskListReq sopTaskListReq = this.buildParam(req);
        log.info("sop \u5de5\u4f5c\u53f0 \u5217\u8868\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSON.toJSONString((Object)sopTaskListReq));
        Page pageResult = PageHelper.startPage((int)req.getPageDto().getPageNum(), (int)req.getPageDto().getPageSize()).doSelectPage(() -> this.sopTaskDetailMapper.selectByStatusAndTaskTypeAndUserId(sopTaskListReq));
        req.getPageDto().setCount(Integer.valueOf((int)pageResult.getTotal()));
        List result = pageResult.getResult();
        WeworkCorp weworkCorp = this.weworkCorpService.getByCorpId(LoginUtils.getCurrentUserCorpId());
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(LoginUtils.getCurrentUserBizId());
        for (SopWorkspaceListDto dto : result) {
            this.fullFillDto(dto, weworkCorp, req.getStatus(), mobileEncrypt);
        }
        return result;
    }

    @Override
    public SopWorkspaceTaskDetailResp workspaceTaskDetail(SopWorkspaceTaskDetailReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.preCheck();
        SopTaskListReq sopTaskListReq = new SopTaskListReq();
        sopTaskListReq.setTaskId(req.getTaskId());
        sopTaskListReq.setTaskType(req.getTaskType());
        sopTaskListReq.setBizId(currentUser.getBizId());
        log.info("sop \u5de5\u4f5c\u53f0 \u5217\u8868\u67e5\u8be2\u6761\u4ef6:{}", (Object)sopTaskListReq);
        List sopWorkspaceListDtos = this.sopTaskDetailMapper.selectByStatusAndTaskTypeAndUserId(sopTaskListReq);
        if (CollectionUtils.isEmpty((Collection)sopWorkspaceListDtos)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u4efb\u52a1\u6ca1\u6709\u67e5\u5230\u53ef\u6267\u884c\u8be6\u60c5");
        }
        if (CollectionUtils.size((Object)sopWorkspaceListDtos) > 1) {
            log.error("\u5f53\u524d\u4efb\u52a1id \u6709\u591a\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)sopWorkspaceListDtos));
        }
        SopWorkspaceListDto dto = (SopWorkspaceListDto)sopWorkspaceListDtos.get(0);
        log.info("workspaceTaskDetail get dto: {}", (Object)dto);
        SopWorkspaceTaskDetailResp resp = new SopWorkspaceTaskDetailResp();
        resp.setExecUserId(dto.getExecUserId());
        String userName = this.userMapper.getUserNameByUserId(dto.getExecUserId());
        resp.setExecUserName(userName);
        resp.setContent(dto.getTaskContent());
        SopTaskType type = SopTaskType.getType((Integer)dto.getTaskType());
        if (SopTaskType.GROUP_SEND.equals((Object)type) && dto.getTaskContent().contains("contentList")) {
            try {
                GroupSendDto sendDto = (GroupSendDto)JSON.parseObject((String)dto.getTaskContent(), GroupSendDto.class);
                if (sendDto != null) {
                    List<UniformMsgDto> content = sendDto.getContentList();
                    String taskContent = JSON.toJSONString(content);
                    resp.setContent(taskContent);
                }
            }
            catch (Exception e) {
                log.error("parseObject TaskContent error ", (Throwable)e);
            }
        }
        resp.setTaskStartTime(dto.getExecTime());
        resp.setSopName(dto.getSopName());
        resp.setSopStageName(dto.getSopStageName());
        resp.setTaskType(dto.getTaskType());
        resp.setTaskTypeName(SopTaskType.getDescByValue((Integer)dto.getTaskType()));
        resp.setContactName(dto.getContactName());
        resp.setContactId(dto.getContactId());
        resp.setContactAvatar(dto.getContactAvatar());
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(currentUser.getBizId());
        OperatorResultCustomerType customerType = OperatorResultCustomerType.getByType((Integer)dto.getCustomerType());
        if (OperatorResultCustomerType.MOBILE.equals((Object)customerType) && mobileEncrypt) {
            String contactId = MobileUtils.encryptMobile((String)dto.getContactId());
            String contactName = MobileUtils.encryptMobile((String)dto.getContactName());
            resp.setContactName(contactName);
            resp.setContactId(contactId);
        }
        if (SopTaskType.TEL_ADD_FRIEND.getValue() == dto.getTaskType().intValue()) {
            String statusDesc = this.getTelAddFriendStatusDesc(currentUser.getBizId(), dto.getFkId(), dto.getExecUserId(), dto.getContactId());
            resp.setStatusDesc(statusDesc);
        }
        String customerNum = this.customerNumService.getCustomerNumByWeworkContactId(currentUser.getBizId(), dto.getContactId(), null);
        resp.setCustomerNum(customerNum);
        log.info("workspaceTaskDetail get resp : {}", (Object)resp);
        return resp;
    }

    private String getTelAddFriendStatusDesc(Long bizId, Long fkId, Long userId, String mobile) {
        String telAddFriendTaskNum = this.telAddFriendTaskMapper.queryNumById(fkId);
        String weworkUserId = this.userMapper.getWeworkUserIdByUserId(userId);
        String weworkUserNum = this.weworkUserMapper.getNumByBizIdAndWeworkUserId(bizId, weworkUserId);
        log.info("getTelAddFriendStatusDesc get weworkUser by userId: {}, weworkUserId: {}, weworkUserNum: {}", new Object[]{userId, weworkUserId, weworkUserNum});
        int addFriendStatus = this.telAddFriendTaskDetailMapper.queryStatusByTaskNumAndPhone(bizId, telAddFriendTaskNum, mobile, weworkUserNum);
        log.info("getTelAddFriendStatusDesc get fkId: {}, taskNum: {}, mobile: {}, status: {}", new Object[]{fkId, telAddFriendTaskNum, mobile, addFriendStatus});
        return TelAddFriendStatus.getTelAddFriendStatus((Integer)addFriendStatus).getDesc();
    }

    @Override
    public SopWorkspaceCountResp queryWorkspaceCount() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Set managerUserIds = this.userRoleCommonService.getManageUserIds();
        managerUserIds.add(currentUser.getId());
        managerUserIds.add(-1L);
        ArrayList executeStatus = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus(), TaskRunStatusEnum.FAIL.getStatus()});
        ArrayList waitExecuteStatus = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.WAIT_EXECUTE.getStatus(), TaskRunStatusEnum.CREATED.getStatus()});
        ArrayList unexecuteStatus = Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.UNEXECUTE.getStatus()});
        Integer executeCount = this.sopTaskDetailMapper.queryCountByTaskStatus(currentUser.getBizId(), (List)executeStatus, (Collection)managerUserIds);
        Integer waitExecuteCount = this.sopTaskDetailMapper.queryCountByTaskStatus(currentUser.getBizId(), (List)waitExecuteStatus, (Collection)managerUserIds);
        Integer unexecuteCount = this.sopTaskDetailMapper.queryCountByTaskStatus(currentUser.getBizId(), (List)unexecuteStatus, (Collection)managerUserIds);
        SopWorkspaceCountResp resp = new SopWorkspaceCountResp();
        resp.setWaitExecuteCount(waitExecuteCount);
        resp.setExecuteCount(executeCount);
        resp.setUnexecuteCount(unexecuteCount);
        return resp;
    }

    @Override
    public CountResult sopWorkspaceStatics() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        SopTaskListReq sopTaskListReq = new SopTaskListReq();
        sopTaskListReq.setBizId(currentUser.getBizId());
        sopTaskListReq.setUserIds((Set)Sets.newHashSet((Object[])new Long[]{currentUser.getId()}));
        log.info("sopWorkspaceStatics: \u5217\u8868\u67e5\u8be2\u6761\u4ef6\uff1a:{}", (Object)sopTaskListReq);
        Map taskTypeCount = this.sopTaskDetailMapper.selectCountByStatusAndTaskTypeAndUserId(sopTaskListReq);
        CountResult countResult = new CountResult();
        if (MapUtils.isEmpty((Map)taskTypeCount)) {
            return countResult;
        }
        countResult.setSopCallCount(taskTypeCount.getOrDefault(SopTaskType.CALL.getValue(), 0L));
        countResult.setSopAddWechatCount(taskTypeCount.getOrDefault(SopTaskType.TEL_ADD_FRIEND.getValue(), 0L));
        countResult.setSopGSendCount(taskTypeCount.getOrDefault(SopTaskType.GROUP_SEND.getValue(), 0L));
        return countResult;
    }

    private SopTaskListReq buildParam(SopWorkspaceListReq req) {
        List userInfoByNums;
        log.info("\u5f53\u524dsop \u5de5\u4f5c\u53f0\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)JSON.toJSONString((Object)req));
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        SopTaskListReq sopTaskListReq = new SopTaskListReq();
        sopTaskListReq.setTaskType(req.getTaskType());
        if (Objects.nonNull(req.getStatus())) {
            ArrayList taskStatus = req.getStatus().intValue() == TaskRunStatusEnum.EXECUTED.getStatus() ? Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.EXECUTED.getStatus(), TaskRunStatusEnum.SUCCESS.getStatus(), TaskRunStatusEnum.FAIL.getStatus()}) : (req.getStatus().intValue() == TaskRunStatusEnum.WAIT_EXECUTE.getStatus() ? Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.WAIT_EXECUTE.getStatus(), TaskRunStatusEnum.CREATED.getStatus()}) : Lists.newArrayList((Object[])new Integer[]{TaskRunStatusEnum.UNEXECUTE.getStatus()}));
            sopTaskListReq.setTaskStatusList((List)taskStatus);
        }
        sopTaskListReq.setTaskStartTime(req.getTaskStartTime());
        sopTaskListReq.setTaskEndTime(req.getTaskEndTime());
        sopTaskListReq.setBizId(currentUser.getBizId());
        Set<Long> userIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(req.getNodeIds())) {
            List orgListRespDtos = this.orgService.selectOrgByNums(req.getNodeIds(), currentUser.getBizId(), currentUser.getCorpId());
            List flatOrgListResps = this.orgService.getWeworkOrgId(orgListRespDtos);
            List orgIds = flatOrgListResps.stream().map(OrgListRespDto::getId).collect(Collectors.toList());
            Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
            orgIds.retainAll(manageNodeIds);
            Set orgUserIds = this.userMapper.queryUserIdsByNodeIds(orgIds, Boolean.valueOf(true));
            log.info("\u901a\u8fc7\u7ec4\u7ec7\u90e8\u95e8 \u67e5\u8be2\u7684userId:{}", (Object)JSON.toJSONString((Object)orgUserIds));
            if (CollectionUtils.isEmpty((Collection)orgUserIds)) {
                userIds.add(currentUser.getId());
            } else {
                userIds.addAll(orgUserIds);
            }
        }
        if (CollectionUtils.isNotEmpty(req.getUserIds()) && CollectionUtils.isNotEmpty((Collection)(userInfoByNums = this.userMapper.getUserInfoByNums(req.getUserIds())))) {
            Set managerUserIds = this.userRoleCommonService.getManageUserIds();
            Set queryByUser = userInfoByNums.stream().map(User::getId).collect(Collectors.toSet());
            managerUserIds.retainAll(queryByUser);
            log.info("\u901a\u8fc7\u67e5\u8be2\u5458\u5de5 \u67e5\u8be2\u5230\u7684\u67e5\u8be2\u7684userId:{}", (Object)managerUserIds);
            if (CollectionUtils.isNotEmpty((Collection)managerUserIds)) {
                userIds.addAll(managerUserIds);
            }
        }
        if (CollectionUtils.isEmpty(req.getUserIds()) && CollectionUtils.isEmpty(req.getNodeIds())) {
            userIds = this.userRoleCommonService.getManageUserIds();
            userIds.add(currentUser.getId());
            userIds.add(-1L);
        }
        sopTaskListReq.setUserIds((Set)userIds);
        return sopTaskListReq;
    }

    private void fullFillDto(SopWorkspaceListDto dto, WeworkCorp weworkCorp, Integer status, boolean encryptMobile) {
        OperatorResultCustomerType customerType;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        SopTaskType type = SopTaskType.getType((Integer)dto.getTaskType());
        dto.setStatusName(TaskRunStatusEnum.getDescByStatus((Integer)dto.getStatus()));
        dto.setTaskTypeName((String)Optional.ofNullable(type).map(SopTaskType::getDesc).orElse(null));
        if (Objects.nonNull(dto.getExecUserId())) {
            if (dto.getExecUserId() == -1L) {
                dto.setExecUserName("\u7cfb\u7edf");
            } else {
                User userInfoById = this.userMapper.getUserInfoById(dto.getExecUserId());
                dto.setExecUserName(userInfoById.getName());
            }
        }
        if (SopTaskType.CALL.equals((Object)type) && Objects.nonNull(dto.getFkId())) {
            CallTask callTask = (CallTask)this.callTaskMapper.selectByPrimaryKey((Object)dto.getFkId());
            if (Objects.isNull(callTask)) {
                return;
            }
            dto.setCallTaskSource(callTask.getSource());
            List callTaskDetails = this.callTaskDetailMapper.queryByTaskIdAndPhones(dto.getFkId(), (List)Lists.newArrayList((Object[])new String[]{dto.getContactId()}));
            if (CollectionUtils.isNotEmpty((Collection)callTaskDetails)) {
                dto.setCallTaskDetailId(((CallTaskDetail)callTaskDetails.get(0)).getId());
            }
            if (status.intValue() == TaskRunStatusEnum.EXECUTED.getStatus()) {
                Long callTaskDetailId = dto.getCallTaskDetailId();
                Integer callStatus = this.callRecordMapper.getStatusByCallDetailId(currentUser.getBizId(), callTaskDetailId, dto.getContactId());
                StatusEnum callStatusEnum = StatusEnum.get((Integer)callStatus);
                if (callStatusEnum != null) {
                    dto.setStatusName(callStatusEnum.getDesc());
                }
            }
        }
        if (SopTaskType.TEL_ADD_FRIEND.equals((Object)type) && Objects.nonNull(dto.getFkId()) && status.intValue() == TaskRunStatusEnum.EXECUTED.getStatus()) {
            String statusDesc = this.getTelAddFriendStatusDesc(currentUser.getBizId(), dto.getFkId(), dto.getExecUserId(), dto.getContactId());
            dto.setStatusName(statusDesc);
        }
        if (Objects.isNull(customerType = OperatorResultCustomerType.getByType((Integer)dto.getCustomerType()))) {
            return;
        }
        WeworkContact weworkContact = null;
        switch (customerType) {
            case LEADS_ID: {
                CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
                crmLeadsInfoReq.setBizId(currentUser.getBizId());
                crmLeadsInfoReq.setCorpId(currentUser.getCorpId());
                crmLeadsInfoReq.setLeadsNum(dto.getContactId());
                CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(crmLeadsInfoReq);
                if (Objects.isNull(leads)) {
                    return;
                }
                dto.setContactName(leads.getName());
                dto.setContactId(leads.getIdNum());
                break;
            }
            case MOBILE: {
                String mobile = dto.getContactId();
                if (encryptMobile) {
                    mobile = MobileUtils.encryptMobile((String)mobile);
                }
                dto.setContactId(mobile);
                dto.setContactName(mobile);
                break;
            }
            case WEWORK_CONTACT_ID: {
                weworkContact = this.weworkContactMapper.queryWeworkContact(currentUser.getBizId(), currentUser.getCorpId(), dto.getContactId());
                if (Objects.isNull(weworkContact)) {
                    return;
                }
                dto.setContactName(weworkContact.getName());
                dto.setCorpName(weworkContact.getCorpName());
                dto.setContactId(weworkContact.getContactId());
                dto.setContactAvatar(weworkContact.getAvatar());
                dto.setCustomerNum(weworkContact.getCustomerNum());
                break;
            }
            case DECRY_WEWORK_CONTACT_ID: {
                Integer isAgent = Optional.ofNullable(weworkCorp).map(WeworkCorp::getIsNewDkf).orElse(YesOrNoEnum.NO.getValue());
                if (YnEnum.YES.getValue().equals(isAgent)) {
                    Map contactIds = this.agentDecryptWeworkContactIdMapper.queryByDecryptContactIds(currentUser.getBizId(), (List)Lists.newArrayList((Object[])new String[]{dto.getContactId()}));
                    if (MapUtils.isEmpty((Map)contactIds)) {
                        return;
                    }
                    for (String value : contactIds.values()) {
                        weworkContact = this.weworkContactMapper.queryWeworkContact(currentUser.getBizId(), currentUser.getCorpId(), value);
                        if (Objects.isNull(weworkContact)) {
                            return;
                        }
                        dto.setContactName(weworkContact.getName());
                        dto.setCorpName(weworkContact.getCorpName());
                        dto.setContactId(weworkContact.getContactId());
                        dto.setContactAvatar(weworkContact.getAvatar());
                        dto.setCustomerNum(weworkContact.getCustomerNum());
                    }
                    break;
                }
                weworkContact = this.weworkContactMapper.queryWeworkContact(currentUser.getBizId(), currentUser.getCorpId(), dto.getContactId());
                if (Objects.isNull(weworkContact)) {
                    return;
                }
                dto.setCorpName(weworkContact.getCorpName());
                dto.setContactName(weworkContact.getName());
                dto.setContactId(weworkContact.getContactId());
                dto.setContactAvatar(weworkContact.getAvatar());
                dto.setCustomerNum(weworkContact.getCustomerNum());
                break;
            }
            case WEWORK_CONTACT_DIGIT_ID: {
                weworkContact = this.weworkContactMapper.queryContactByDigitId(currentUser.getCorpId(), dto.getContactId());
                if (Objects.isNull(weworkContact)) {
                    return;
                }
                dto.setContactName(weworkContact.getName());
                dto.setCorpName(weworkContact.getCorpName());
                dto.setContactId(weworkContact.getContactId());
                dto.setContactAvatar(weworkContact.getAvatar());
                dto.setCustomerNum(weworkContact.getCustomerNum());
                break;
            }
            case CUSTOMER_MAIN_ID: 
            case CUSTOMER_NUM: {
                CustomerDetailResp customerDetail = this.customerDetailService.queryCustomerDetail(currentUser.getBizId(), dto.getContactId());
                if (Objects.isNull(customerDetail)) {
                    return;
                }
                dto.setContactName(customerDetail.getName());
                dto.setCorpName(customerDetail.getCorpName());
                dto.setContactId(customerDetail.getCustomerNum());
                dto.setContactAvatar(customerDetail.getAvatar());
                dto.setCustomerNum(customerDetail.getMainNum());
                break;
            }
        }
        log.info("\u6267\u884csopWorkspaceList\u6570\u636e\u586b\u5145\u7ed3\u679c\uff1a:{}", (Object)dto);
    }

    @Override
    public void recoverCustomerBindingData(Long bizId) {
        log.info("recoverCustomerBindingData bizId: {}", (Object)bizId);
        List relations = this.weworkContactRelationMapper.selectAllRelationsByBizId(bizId);
        if (CollectionUtils.isEmpty((Collection)relations)) {
            return;
        }
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        this.recoverExecutor.execute(() -> {
            List partition = Lists.partition((List)relations, (int)100);
            for (List pRelations : partition) {
                ArrayList bindReqs = Lists.newArrayList();
                List weworkUserIds = pRelations.stream().map(WeworkContactRelation::getWeworkUserId).collect(Collectors.toList());
                Map weworkUserId2NumMaps = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, weworkUserIds);
                Map weworkUserIdMaps = this.userMapper.queryUserIdByWeworkUserId(bizId, weworkUserIds);
                List contactIds = pRelations.stream().map(WeworkContactRelation::getContactId).collect(Collectors.toList());
                Map customerNumMap = this.ccCustomerNumService.butchGetCustomerNumByContactId(bizId, contactIds);
                log.info("recoverCustomerBindingData weworkUserId2NumMaps: {}, weworkUserIdMaps: {}, customerNumMap: {}", new Object[]{weworkUserId2NumMaps, weworkUserIdMaps, customerNumMap});
                for (WeworkContactRelation relation : pRelations) {
                    CustomerBindReq req = new CustomerBindReq();
                    if (customerNumMap != null) {
                        String customerNum = (String)customerNumMap.get(relation.getContactId());
                        if (StringUtils.isBlank((CharSequence)customerNum)) {
                            log.warn("customerNum is empty,id={}", (Object)relation.getId());
                            continue;
                        }
                        req.setCustomerNum(customerNum);
                    }
                    if (weworkUserIdMaps != null) {
                        Long userId = (Long)weworkUserIdMaps.get(relation.getWeworkUserId());
                        req.setUserId(userId);
                    }
                    if (weworkUserId2NumMaps != null) {
                        String weworkUserNum = (String)weworkUserId2NumMaps.get(relation.getWeworkUserId());
                        req.setWeworkUserNum(weworkUserNum);
                    }
                    req.setIsDeleted(relation.getIsDeleted());
                    if (Objects.nonNull(relation.getIsDeleted()) && relation.getIsDeleted() == 1) {
                        req.setDeleteTime(relation.getDeletedTime());
                    }
                    if (req.getUserId() == null && StringUtils.isEmpty((CharSequence)req.getWeworkUserNum())) {
                        log.info("recoverCustomerBindingData UserId is null and WeworkUserNum is empty, relationId: {}", (Object)relation.getId());
                        continue;
                    }
                    bindReqs.add(req);
                }
                log.info("recoverCustomerBindingData bindReqs: {}", (Object)bindReqs);
                if (!CollectionUtils.isNotEmpty((Collection)bindReqs)) continue;
                try {
                    BatchSetBindingReq param = new BatchSetBindingReq();
                    param.setBizId(bizId);
                    param.setList((List)bindReqs);
                    param.setSource("scrm");
                    param.validate();
                    this.ccCustomerBindService.batchSetBinding(param);
                    log.info("recoverCustomerBindingData batchSetBinding bizId: {}, size: {}", (Object)bizId, (Object)bindReqs.size());
                }
                catch (Exception e) {
                    log.error("batchSetBinding error", (Throwable)e);
                }
            }
        });
    }
}

