/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.call.dto.CallTaskQueryId;
import com.kuaike.scrm.dal.call.dto.CallTaskQueryResp;
import com.kuaike.scrm.dal.call.mapper.CallRecordMapper;
import com.kuaike.scrm.dal.call.mapper.CallTaskDetailMapper;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.marketing.dto.sop.SopUserDetailTaskQuery;
import com.kuaike.scrm.dal.marketing.dto.sop.SopUserTaskDto;
import com.kuaike.scrm.dal.marketing.dto.sop.SopUserTaskQuery;
import com.kuaike.scrm.dal.marketing.mapper.SopContentMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskDetailMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.teladdfriend.dto.TelAddFriendQueryResp;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.groupsend.dto.request.GroupSendDetailStatusReq;
import com.kuaike.scrm.groupsend.dto.response.GroupSendDetailStatusRespDto;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.sop.dto.SopUserDetailReq;
import com.kuaike.scrm.sop.dto.SopUserDetailResp;
import com.kuaike.scrm.sop.dto.SopUserReq;
import com.kuaike.scrm.sop.dto.SopUserResp;
import com.kuaike.scrm.sop.service.SopTaskRecordService;
import com.kuaike.scrm.wework.chatroom.service.ChatRoomService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SopTaskRecordServiceImpl
implements SopTaskRecordService {
    private static final Logger log = LoggerFactory.getLogger(SopTaskRecordServiceImpl.class);
    public static final String MEETING_PLACEHOLDER = "${customstr}";
    public static final String WEWORKUSER_PLACEHOLDER = "{\u6210\u5458\u6635\u79f0}";
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private SopTaskDetailMapper sopTaskDetailMapper;
    @Autowired
    private MessageGroupSendTaskMapper groupSendTaskMapper;
    @Resource
    private CallRecordMapper callRecordMapper;
    @Autowired
    private ChatRoomService chatRoomService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private SopMapper sopMapper;
    @Autowired
    private SopContentMapper sopContentMapper;
    @Autowired
    private MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private CallTaskDetailMapper callTaskDetailMapper;
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Autowired
    private GroupSendService groupSendService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private SettingService settingService;

    @Override
    public List<SopUserResp> userList(SopUserReq params) {
        List userTaskDtos;
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.getPageDto() == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Set userIds = this.userRoleCommonService.getManageUserIds();
        if (StringUtils.isNotBlank((CharSequence)params.getUserId())) {
            Long user = this.userMapper.getIdByNum(params.getUserId());
            userIds = Sets.intersection((Set)userIds, (Set)Sets.newHashSet((Object[])new Long[]{user}));
        }
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Lists.newArrayList();
        }
        Long sopId = this.sopMapper.getIdByNum(params.getSopId());
        SopUserTaskQuery query = this.getUserTaskQuery(userInfo.getBizId(), sopId, userIds, params.getSopName());
        if (params.getPageDto() != null) {
            int total = this.sopTaskDetailMapper.userTaskListCount(query);
            params.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(userTaskDtos = this.sopTaskDetailMapper.userTaskList(query)))) {
            return Lists.newArrayList();
        }
        Map userMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), (Collection)userIds);
        Set sopIds = userTaskDtos.stream().map(it -> it.getSopId()).collect(Collectors.toSet());
        Set sopContentIds = userTaskDtos.stream().map(it -> it.getSopContentId()).collect(Collectors.toSet());
        Map sopMap = this.sopMapper.querySopNameMap(userInfo.getBizId(), sopIds);
        Map sopContentMap = this.sopContentMapper.queryContentMap(userInfo.getBizId(), sopContentIds);
        return this.buildUserTaskList(userTaskDtos, userMap, sopMap, sopContentMap);
    }

    private SopUserTaskQuery getUserTaskQuery(Long bizId, Long sopId, Set<Long> userIds, String sopName) {
        SopUserTaskQuery query = new SopUserTaskQuery();
        query.setBizId(bizId);
        query.setUserIds(userIds);
        query.setSopId(sopId);
        query.setSopName(sopName);
        return query;
    }

    private List<SopUserResp> buildUserTaskList(List<SopUserTaskDto> userTaskDtos, Map<Long, String> userMap, Map<Long, String> sopMap, Map<Long, String> sopContentMap) {
        ArrayList result = Lists.newArrayList();
        HashSet groupSendTaskIds = Sets.newHashSet();
        HashSet callTaskIds = Sets.newHashSet();
        HashSet addFriendTaskIds = Sets.newHashSet();
        for (SopUserTaskDto taskDto : userTaskDtos) {
            if (taskDto.getTaskType().intValue() == SopTaskType.GROUP_SEND.getValue()) {
                groupSendTaskIds.add(taskDto.getFkId());
                continue;
            }
            if (taskDto.getTaskType().intValue() == SopTaskType.CALL.getValue()) {
                callTaskIds.add(taskDto.getFkId());
                continue;
            }
            if (taskDto.getTaskType().intValue() != SopTaskType.TEL_ADD_FRIEND.getValue()) continue;
            addFriendTaskIds.add(taskDto.getFkId());
        }
        for (SopUserTaskDto taskDto : userTaskDtos) {
            SopUserResp resp = new SopUserResp();
            resp.setFkId(taskDto.getFkId());
            resp.setUserName(userMap.get(taskDto.getUserId()));
            resp.setTaskType(taskDto.getTaskType());
            resp.setTaskTypeDesc(SopTaskType.getDescByValue((Integer)taskDto.getTaskType()));
            resp.setSopName(sopMap.get(taskDto.getSopId()));
            resp.setStageName(sopContentMap.get(taskDto.getSopContentId()));
            resp.setSopContentId(taskDto.getSopContentId());
            resp.setDate(DateUtil.getDate((String)taskDto.getRunTimeStr()));
            resp.setDateStr(taskDto.getRunTimeStr());
            result.add(resp);
        }
        this.groupSendTaskInfo(groupSendTaskIds, result);
        this.callTaskInfo(callTaskIds, result);
        this.addFriendTaskInfo(addFriendTaskIds, result);
        return result;
    }

    private void groupSendTaskInfo(Set<Long> taskIds, List<SopUserResp> sopUserRespList) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return;
        }
        List id2StatusCounts = this.groupSendDetailMapper.queryStatusByTaskIds(taskIds, null, null);
        HashMap statusMap = Maps.newHashMap();
        for (Id2StatusCount dto : id2StatusCounts) {
            statusMap.put(dto.getId(), dto);
        }
        for (SopUserResp resp : sopUserRespList) {
            Id2StatusCount statusCount;
            if (resp.getTaskType().intValue() != SopTaskType.GROUP_SEND.getValue() || (statusCount = (Id2StatusCount)statusMap.get(resp.getFkId())) == null) continue;
            resp.setWait(statusCount.getTobeSendCount() == null ? 0 : statusCount.getTobeSendCount());
            resp.setFinish(statusCount.getFinishedCount() == null ? 0 : statusCount.getFinishedCount());
            resp.setFail(statusCount.getExpireCount() == null ? 0 : statusCount.getExpireCount());
            int total = resp.getWait() + resp.getFinish() + resp.getFail();
            int finish = resp.getFinish() + resp.getFail();
            resp.setProcess(this.calFinishRate(total, finish));
        }
    }

    private void callTaskInfo(Set<Long> taskIds, List<SopUserResp> sopUserRespList) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Map callTotalMap = this.callTaskDetailMapper.callTaskCount(userInfo.getBizId(), taskIds);
        Map calledTaskMap = this.callTaskDetailMapper.calledTaskCount(userInfo.getBizId(), taskIds);
        for (SopUserResp resp : sopUserRespList) {
            if (resp.getTaskType().intValue() != SopTaskType.CALL.getValue()) continue;
            Integer total = callTotalMap.getOrDefault(resp.getFkId(), 0);
            Integer calledCount = calledTaskMap.getOrDefault(resp.getFkId(), 0);
            resp.setWait(total - calledCount);
            resp.setFinish(calledCount);
            resp.setProcess(this.calFinishRate(total, calledCount));
        }
    }

    private void addFriendTaskInfo(Set<Long> taskIds, List<SopUserResp> sopUserRespList) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return;
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Map taskNumMap = this.telAddFriendTaskMapper.queryTaskNums(bizId, taskIds);
        Map waitAddMap = this.telAddFriendTaskDetailMapper.queryTaskStatusCount(bizId, Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()), taskNumMap.values());
        Map waitPass = this.telAddFriendTaskDetailMapper.queryTaskStatusCount(bizId, Integer.valueOf(TelAddFriendStatus.APPLY_ING.getStatus()), taskNumMap.values());
        Map successAdd = this.telAddFriendTaskDetailMapper.queryTaskStatusCount(bizId, Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()), taskNumMap.values());
        Map expire = this.telAddFriendTaskDetailMapper.queryTaskStatusCount(bizId, Integer.valueOf(TelAddFriendStatus.EXPIRE.getStatus()), taskNumMap.values());
        Map failMap = this.telAddFriendTaskDetailMapper.queryTaskStatusCount(bizId, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), taskNumMap.values());
        for (SopUserResp resp : sopUserRespList) {
            if (resp.getTaskType().intValue() != SopTaskType.TEL_ADD_FRIEND.getValue()) continue;
            String taskNum = (String)taskNumMap.get(resp.getFkId());
            resp.setWait(waitAddMap.getOrDefault(taskNum, 0));
            resp.setWaitPass(waitPass.getOrDefault(taskNum, 0));
            resp.setFinish(successAdd.getOrDefault(taskNum, 0));
            int fail = expire.getOrDefault(taskNum, 0) + failMap.getOrDefault(taskNum, 0);
            resp.setFail(fail);
            int total = resp.getWait() + resp.getWaitPass() + resp.getFinish() + resp.getFail();
            resp.setProcess(this.calFinishRate(total, resp.getFinish() + resp.getWaitPass()));
        }
    }

    public Double calFinishRate(int total, int finish) {
        if (total == 0) {
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("###.00");
        Double taskProcess = (double)finish * 1.0 / (double)total * 100.0;
        return Double.valueOf(df.format(taskProcess));
    }

    private List<SopUserDetailResp> queryGroupSendDetail(String taskNum, Integer detailStatus, PageDto pageDto) {
        GroupSendDetailStatusReq query = new GroupSendDetailStatusReq();
        query.setTaskNum(taskNum);
        query.setDetailStatus(detailStatus);
        query.setPageDto(pageDto);
        List groupSendDetailList = this.groupSendService.taskStatus(query);
        ArrayList results = Lists.newArrayList();
        for (GroupSendDetailStatusRespDto taskDto : groupSendDetailList) {
            SopUserDetailResp resp = new SopUserDetailResp();
            resp.setSend(taskDto.getSendWeworkNickName());
            resp.setReceive(taskDto.getReceiveName());
            resp.setDeadlineTime(taskDto.getDeadlineTime());
            resp.setEnableSendTime(taskDto.getSendTime());
            resp.setSendTime(taskDto.getSendCompleteTime());
            if (taskDto.getStatusValue().intValue() == SendStatus.TO_BE_SEND.getValue() || taskDto.getStatusValue().intValue() == SendStatus.SENDING.getValue()) {
                resp.setSendStatus(SendStatus.TO_BE_SEND.getDesc());
            } else if (taskDto.getStatusValue().intValue() == SendStatus.ALREADY_SEND.getValue()) {
                resp.setSendStatus(SendStatus.ALREADY_SEND.getDesc());
            } else if (taskDto.getStatusValue().intValue() == SendStatus.ALREADY_EXPIRE.getValue() || taskDto.getStatusValue().intValue() == SendStatus.SEND_FAIL.getValue()) {
                resp.setSendStatus(SendStatus.SEND_FAIL.getDesc());
            }
            resp.setFailReason(taskDto.getRemark());
            resp.setMsg(taskDto.getContent());
            results.add(resp);
        }
        return results;
    }

    @Override
    public List<SopUserDetailResp> userDetailList(SopUserDetailReq params) {
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.valid();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        int taskType = params.getTaskType();
        Integer runStatus = params.getRunStatus();
        SopUserDetailTaskQuery query = new SopUserDetailTaskQuery();
        query.setBizId(userInfo.getBizId());
        query.setFkId(params.getFkId());
        query.setRunStatus(params.getRunStatus());
        query.setPageDto(params.getPageDto());
        if (taskType == 1) {
            Long fkId = params.getFkId();
            String taskNum = this.groupSendTaskMapper.queryTaskNum(fkId);
            MessageGroupSendTask task = this.groupSendTaskMapper.queryByTaskNum(taskNum);
            if (task == null || task.getIsDeleted() == 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            return this.queryGroupSendDetail(task.getNum(), runStatus, params.getPageDto());
        }
        if (taskType == 2) {
            return this.calledDetail(bizId, params.getFkId(), params.getUserId(), params.getRunStatus(), params.getStatus(), params.getPageDto());
        }
        if (taskType == 4) {
            List res;
            Long callTaskId = params.getFkId();
            TelAddFriendTask task = (TelAddFriendTask)this.telAddFriendTaskMapper.selectByPrimaryKey((Object)callTaskId);
            if (task == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u52a0\u597d\u53cb\u4efb\u52a1");
            }
            String telTaskNum = task.getNum();
            if (params.getPageDto() != null) {
                int total = this.telAddFriendTaskDetailMapper.selectDetailCountByTaskId(bizId, telTaskNum, params.getUserId(), runStatus);
                params.getPageDto().setCount(Integer.valueOf(total));
            }
            if (CollectionUtils.isEmpty((Collection)(res = this.telAddFriendTaskDetailMapper.selectDetailByTaskId(bizId, telTaskNum, params.getUserId(), runStatus, params.getPageDto())))) {
                return Lists.newArrayList();
            }
            Set contactIds = res.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getContactId())).map(it -> it.getContactId()).collect(Collectors.toSet());
            Map contactMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(contactIds)) {
                contactMap = this.weworkContactMapper.queryContactNameMap(task.getCorpId(), contactIds);
            }
            Set<String> mobiles = res.stream().map(it -> it.getTel()).collect(Collectors.toSet());
            Map<String, String> mobileNameMap = this.getMobileNameMap(bizId, mobiles);
            boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
            ArrayList results = Lists.newArrayList();
            for (TelAddFriendQueryResp taskDto : res) {
                SopUserDetailResp resp = new SopUserDetailResp();
                resp.setRunUser(taskDto.getRunUser());
                if (StringUtils.isNotBlank((CharSequence)taskDto.getContactId())) {
                    resp.setName((String)contactMap.get(taskDto.getContactId()));
                } else {
                    resp.setName(mobileNameMap.get(taskDto.getTel()));
                }
                if (mobileEncrypt) {
                    resp.setMobile(MobileUtils.encryptMobile((String)taskDto.getTel()));
                } else {
                    resp.setMobile(taskDto.getTel());
                }
                resp.setStatus(taskDto.getStatus());
                if (resp.getStatus().intValue() == TelAddFriendStatus.FAILED.getStatus()) {
                    resp.setStatus(TelAddFriendStatus.EXPIRE.getStatus());
                }
                results.add(resp);
            }
            return results;
        }
        return Lists.newArrayList();
    }

    private List<SopUserDetailResp> calledDetail(Long bizId, Long taskId, String userId, Integer runStatus, Integer callStatus, PageDto pageDto) {
        List res;
        Long user = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            user = this.userMapper.getIdByNum(userId);
        }
        CallTaskQueryId callParam = new CallTaskQueryId();
        callParam.setBizId(bizId);
        callParam.setCallTaskId(taskId);
        callParam.setPageDto(pageDto);
        callParam.setUserId(user);
        callParam.setRunStatus(runStatus);
        callParam.setStatus(callStatus);
        if (pageDto != null) {
            int total = this.callTaskDetailMapper.selectDetailCountByTaskId(callParam);
            pageDto.setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(res = this.callTaskDetailMapper.selectDetailByTaskId(callParam)))) {
            return Lists.newArrayList();
        }
        Set userIds = res.stream().filter(it -> it.getRunUserId() != null).map(it -> it.getRunUserId()).collect(Collectors.toSet());
        Map userNameMap = this.userMapper.queryUserNameByIds(userIds);
        Set<String> mobiles = res.stream().map(it -> it.getMobile()).collect(Collectors.toSet());
        Map<String, String> mobileNameMap = this.getMobileNameMap(bizId, mobiles);
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        ArrayList results = Lists.newArrayList();
        for (CallTaskQueryResp taskDto : res) {
            SopUserDetailResp resp = new SopUserDetailResp();
            resp.setName(taskDto.getName());
            if (StringUtils.isBlank((CharSequence)resp.getName())) {
                resp.setName(mobileNameMap.get(taskDto.getMobile()));
            }
            if (mobileEncrypt) {
                resp.setMobile(MobileUtils.encryptMobile((String)taskDto.getMobile()));
            } else {
                resp.setMobile(taskDto.getMobile());
            }
            resp.setRunStatus(runStatus);
            if (taskDto.getStatus() == null) {
                resp.setRunStatus(1);
            } else {
                resp.setRunStatus(2);
            }
            resp.setCallDuration(taskDto.getCallDuration());
            resp.setVoiceUrl(taskDto.getVoiceUrl());
            resp.setCallTime(taskDto.getCallTime());
            resp.setStatus(taskDto.getStatus());
            resp.setRunUser((String)userNameMap.get(taskDto.getRunUserId()));
            results.add(resp);
        }
        return results;
    }

    private Map<String, String> getMobileNameMap(Long bizId, Set<String> mobiles) {
        HashMap result = Maps.newHashMap();
        if (CollectionUtils.isEmpty(mobiles)) {
            return result;
        }
        Map mobileCustomerMap = this.ccCustomerNumService.batchGetCustomerNumByMobile(bizId, mobiles);
        List respList = this.ccCustomerDetailService.queryCustomerDetails(bizId, mobileCustomerMap.values());
        HashMap customerNameMap = Maps.newHashMap();
        for (CustomerDetailResp detailResp : respList) {
            customerNameMap.put(detailResp.getCustomerNum(), detailResp.getName());
        }
        for (String mobile : mobiles) {
            String customerNum = (String)mobileCustomerMap.get(mobile);
            result.put(mobile, customerNameMap.get(customerNum));
        }
        return result;
    }
}

