/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.scrm.vip.dto.req.VipAddFriendAddReqDto;
import cn.kinyun.scrm.vip.service.VipFriendService;
import com.alibaba.fastjson.JSONObject;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.call.dto.req.CallTaskReqDto;
import com.kuaike.scrm.call.service.CallTaskService;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.dto.OperatorResultItemDto;
import com.kuaike.scrm.common.dto.addfriend.TelAndRemarkDto;
import com.kuaike.scrm.common.enums.BizStatus;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.OperatorResultStatus;
import com.kuaike.scrm.common.enums.ReceiveType;
import com.kuaike.scrm.common.enums.SopTemplateTaskTypeEnum;
import com.kuaike.scrm.common.enums.addfriend.AddFriendsTaskType;
import com.kuaike.scrm.common.enums.addfriend.TelAddType;
import com.kuaike.scrm.common.enums.sop.SopRemindType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.CustomerDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.marketing.dto.sop.SopFinalCustomerBatchUpdateDto;
import com.kuaike.scrm.dal.marketing.entity.Sop;
import com.kuaike.scrm.dal.marketing.entity.SopContent;
import com.kuaike.scrm.dal.marketing.entity.SopFinalCustomer;
import com.kuaike.scrm.dal.marketing.entity.SopStageCalculate;
import com.kuaike.scrm.dal.marketing.entity.SopTaskDetail;
import com.kuaike.scrm.dal.marketing.entity.SopTaskScanLog;
import com.kuaike.scrm.dal.marketing.entity.SopTemplate;
import com.kuaike.scrm.dal.marketing.entity.SopTemplateTimes;
import com.kuaike.scrm.dal.marketing.entity.SopTemplateTimesTask;
import com.kuaike.scrm.dal.marketing.entity.SopUser;
import com.kuaike.scrm.dal.marketing.mapper.SopContentMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopFinalCustomerMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopStageCalculateMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskDetailMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTaskScanLogMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopTemplateTimesTaskMapper;
import com.kuaike.scrm.dal.marketing.mapper.SopUserMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkUserInfo;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupsend.dto.WeworkUserSendTargetPair;
import com.kuaike.scrm.groupsend.dto.request.AddOrModInnerGroupSendReq;
import com.kuaike.scrm.groupsend.service.GroupSendWrapService;
import com.kuaike.scrm.remind.dto.req.AddSopRemindDto;
import com.kuaike.scrm.remind.dto.req.DelSopRemindDto;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.sms.dto.SmsTaskReqDto;
import com.kuaike.scrm.sms.service.SmsTaskService;
import com.kuaike.scrm.sop.dto.CallSopCalcTaskReq;
import com.kuaike.scrm.sop.dto.NextExecuteTaskDto;
import com.kuaike.scrm.sop.dto.req.BatchAddFriendDto;
import com.kuaike.scrm.sop.dto.req.GroupSendDto;
import com.kuaike.scrm.sop.dto.req.ManualCallDto;
import com.kuaike.scrm.sop.dto.req.SmsDto;
import com.kuaike.scrm.sop.enums.CalculateStatusEnum;
import com.kuaike.scrm.sop.operators.convert.ConvertServiceImpl;
import com.kuaike.scrm.sop.service.OperatorResultService;
import com.kuaike.scrm.sop.service.SopCalTaskService;
import com.kuaike.scrm.sop.service.SopTaskExecuteService;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendAddReqDto;
import com.kuaike.scrm.teladdfriend.service.TelAddFriendService;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SopTaskExecuteServiceImpl
implements SopTaskExecuteService {
    private static final Logger log = LoggerFactory.getLogger(SopTaskExecuteServiceImpl.class);
    @Value(value="${marketing.sop.advanceJob.gapSeconds}")
    private Integer advanceJobGapSeconds;
    @Value(value="${marketing.sop.advanceJob.includeFeatureTaskSeconds}")
    private Integer includeFeatureTaskSeconds;
    @Value(value="${marketing.sop.advanceJob.taskDetailFeatureSeconds}")
    private Integer taskDetailFeatureSeconds;
    @Value(value="${marketing.sop.advanceJob.calculateNormalExpendSeconds}")
    private Integer calculateNormalExpendSeconds;
    @Resource
    private SopMapper sopMapper;
    @Resource
    private SopContentMapper sopContentMapper;
    @Resource
    private SopTemplateMapper sopTemplateMapper;
    @Resource
    private SopTemplateTimesMapper sopTemplateTimesMapper;
    @Resource
    private SopTemplateTimesTaskMapper sopTemplateTimesTaskMapper;
    @Resource
    private SopUserMapper sopUserMapper;
    @Resource
    private SopStageCalculateMapper sopStageCalculateMapper;
    @Resource
    private SopFinalCustomerMapper sopFinalCustomerMapper;
    @Resource
    private SopTaskDetailMapper sopTaskDetailMapper;
    @Resource
    private SopTaskScanLogMapper sopTaskScanLogMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private RemindService remindService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private OperateService operateService;
    @Resource
    private SmsTaskService smsTaskService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private CallTaskService callTaskService;
    @Resource
    private SopCalTaskService sopCalTaskService;
    @Resource
    private OperatorResultService operatorResultService;
    @Resource
    private ConvertServiceImpl convertServiceImpl;
    @Resource
    private TelAddFriendService telAddFriendService;
    @Resource
    private VipFriendService vipFriendService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private GroupSendWrapService groupSendWrapService;
    @Autowired
    private DistributedLock lock;
    @Resource
    private SettingService settingService;
    @Resource
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService sopTaskExeService = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("sopTaskExeService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void generateTasksInAdvance(Long sopId) {
        List sopList;
        Date taskExecTime = new Date();
        log.info("generateTasksInAdvance taskExecTime:{}", (Object)taskExecTime);
        Sop selectSop = new Sop();
        selectSop.setIsEnable(Integer.valueOf(1));
        if (sopId != null) {
            selectSop.setId(sopId);
        }
        if (CollectionUtils.isEmpty((Collection)(sopList = this.sopMapper.select((Object)selectSop)))) {
            log.info("generateTasksInAdvance end, enable sopList is empty");
            return;
        }
        Set bizIds = sopList.stream().map(Sop::getBizId).collect(Collectors.toSet());
        List businessCustomers = this.businessCustomerMapper.selectByIds(bizIds);
        if (CollectionUtils.isEmpty((Collection)sopList)) {
            log.info("generateTasksInAdvance end, businessCustomers is empty");
            return;
        }
        Set normalBizIds = businessCustomers.stream().filter(x -> BizStatus.NORMAL.getValue() == x.getStatus().intValue()).map(BusinessCustomer::getId).collect(Collectors.toSet());
        Map bizIsAuthMap = this.corpCustomizedTokenMapper.selectIsAuthByBizIds(bizIds);
        if (bizIsAuthMap.isEmpty()) {
            log.info("generateTasksInAdvance end, bizIsAuthMap is empty");
            return;
        }
        HashSet<Long> corpIsAuthBizIds = new HashSet<Long>();
        for (Map.Entry entry : bizIsAuthMap.entrySet()) {
            Long bizId = (Long)entry.getKey();
            Integer isAuth = (Integer)entry.getValue();
            if (!NumberUtils.INTEGER_ONE.equals(isAuth)) continue;
            corpIsAuthBizIds.add(bizId);
        }
        normalBizIds.retainAll(corpIsAuthBizIds);
        log.info("generateTasksInAdvance,valid biz:{}", normalBizIds);
        for (Sop sop : sopList) {
            if (!normalBizIds.contains(sop.getBizId())) {
                log.info("generateTasksInAdvance,biz status is not normal,bizId:{}", (Object)sop.getBizId());
                continue;
            }
            try {
                this.doBusinessBySop(sop, false, null, null);
            }
            catch (Exception e) {
                log.error("generateTasksInAdvance, doBusinessBySop error", (Throwable)e);
            }
        }
    }

    private void doBusinessBySop(Sop sop, boolean allStageCustomerCalculateDone, Long sopContentId, List<NextExecuteTaskDto> nextExecuteTaskDtos) {
        List sopContents;
        String nowDay;
        log.info("doBusinessBySop,sopId:{},allStageCustomerCalculateDone:{},sopContentId:{}", new Object[]{sop.getId(), allStageCustomerCalculateDone, sopContentId});
        Date now = new Date();
        Date updateTime = sop.getUpdateTime();
        String updateDay = DateUtil.format((Date)updateTime, (String)"yyyy-MM-dd");
        String executeDay = nowDay = DateUtil.format((Date)now, (String)"yyyy-MM-dd");
        if (updateDay.equals(nowDay)) {
            String nextTaskExecDay;
            DateTime nextTaskExecTime = DateUtil.offsetSecond((Date)now, (int)this.advanceJobGapSeconds);
            DateTime nextDayDateTime = DateUtil.offsetDay((Date)now, (int)1);
            String nextDay = DateUtil.format((Date)nextDayDateTime, (String)"yyyy-MM-dd");
            if (!nextDay.equals(nextTaskExecDay = DateUtil.format((Date)nextTaskExecTime, (String)"yyyy-MM-dd"))) {
                log.info("doBusinessBySop,sopId:{},sop\u66f4\u65b0\u65f6\u95f4\u662f\u5f53\u5929,\u672c\u6b21\u4e0d\u6267\u884c,updateDay:{},nextTaskExecDay:{}", new Object[]{sop.getId(), updateDay, nextTaskExecDay});
                return;
            }
            executeDay = nextDay;
        }
        SopContent select = new SopContent();
        select.setSopId(sop.getId());
        select.setIsDeleted(Integer.valueOf(0));
        if (sopContentId != null) {
            select.setId(sopContentId);
        }
        if (CollectionUtils.isEmpty((Collection)(sopContents = this.sopContentMapper.select((Object)select)))) {
            log.info("doBusinessBySop,sopId:{},\u65c5\u7a0b\u9636\u6bb5\u4e3a\u7a7a", (Object)sop.getId());
            return;
        }
        for (SopContent sopContent : sopContents) {
            try {
                this.doBusinessBySopContent(sop, sopContent, sopContents, allStageCustomerCalculateDone, executeDay, nextExecuteTaskDtos);
            }
            catch (Exception e) {
                log.error("doBusinessBySop,sopId:{},doBusinessBySopContent error", (Object)sop.getId(), (Object)e);
            }
        }
    }

    private void doBusinessBySopContent(Sop sop, SopContent sopContent, List<SopContent> sopContents, boolean allStageCustomerCalculateDone, String executeDay, List<NextExecuteTaskDto> nextExecuteTaskDtos) {
        Set<Long> sopUserIds;
        log.info("doBusinessBySopContent,sopId:{},sopContentId:{},allStageCustomerCalculateDone:{},executeDay:{}", new Object[]{sop.getId(), sopContent.getId(), allStageCustomerCalculateDone, executeDay});
        if (!allStageCustomerCalculateDone) {
            String endDateFormatDay;
            Date endDate = sopContent.getEndDate();
            if (endDate != null && (endDate = DateUtil.parseDate((CharSequence)((endDateFormatDay = DateUtil.format((Date)endDate, (String)"yyyy-MM-dd")) + " 23:59:59"))).before(new Date())) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u65c5\u7a0b\u9636\u6bb5\u5df2\u8fbe\u4efb\u52a1\u7ed3\u675f\u65e5\u671f,endDate:{}", new Object[]{sop.getId(), sopContent.getId(), endDate});
                return;
            }
            Long remindGapDay = sopContent.getRemindGap();
            DateTime executeDayTime = DateUtil.parse((CharSequence)executeDay, (String)"yyyy-MM-dd");
            String updateDayString = DateUtil.format((Date)sop.getUpdateTime(), (String)"yyyy-MM-dd");
            DateTime updateDayTime = DateUtil.parse((CharSequence)updateDayString, (String)"yyyy-MM-dd");
            long sopGapDay = DateUtil.between((Date)updateDayTime, (Date)executeDayTime, (DateUnit)DateUnit.DAY);
            if (sopGapDay % remindGapDay != 0L) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u5f53\u524d\u5929\u4e0d\u662f\u6bcfX\u5929,remindGapDay:{},sopUpdateTime:{},sopGapDay:{}", new Object[]{sop.getId(), sopContent.getId(), remindGapDay, sop.getUpdateTime(), sopGapDay});
                return;
            }
        }
        if (CollectionUtils.isEmpty(sopUserIds = this.querySopUsers(sop.getId()))) {
            log.info("doBusinessBySopContent,sopId:{},sopContentId:{},SOP\u6267\u884c\u5458\u5de5\u4e3a\u7a7a", (Object)sop.getId(), (Object)sopContent.getId());
            return;
        }
        if (sopContent.getSopTmpId() == null || sopContent.getSopTmpId().equals(0L)) {
            boolean alreadyHandled;
            if (!allStageCustomerCalculateDone && (alreadyHandled = this.judgeRemindAlreadyHandled(executeDay, sopContent))) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u5f53\u524d\u8981\u6267\u884c\u7684\u63d0\u9192\u5904\u7406\u8fc7", (Object)sop.getId(), (Object)sopContent.getId());
                return;
            }
            log.info("doBusinessBySopContent,sopId:{},sopContentId:{},SOP\u6ca1\u6709\u914d\u7f6e\u6a21\u677f", (Object)sop.getId(), (Object)sopContent.getId());
            try {
                this.remindUserByNoTemplate(sop, allStageCustomerCalculateDone, sopContent, sopUserIds, executeDay, sopContents);
            }
            catch (Exception e) {
                log.error("doBusinessBySopContent,sopId:{},sopContentId:{},remindUserByNoTemplate error", new Object[]{sop.getId(), sopContent.getId(), e});
            }
        } else {
            if (!allStageCustomerCalculateDone) {
                try {
                    nextExecuteTaskDtos = this.judgeHaveExecuteTask(sop, sopContent, executeDay);
                }
                catch (Exception e) {
                    log.error("doBusinessBySopContent,sopId:{},sopContentId:{},judgeHaveExecuteTask error", new Object[]{sop.getId(), sopContent.getId(), e});
                }
            }
            if (CollectionUtils.isEmpty(nextExecuteTaskDtos)) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u63a5\u4e0b\u6765{}\u79d2\u6ca1\u6709\u8981\u6267\u884c\u7684\u4efb\u52a1", new Object[]{sop.getId(), sopContent.getId(), this.includeFeatureTaskSeconds});
                return;
            }
            if (allStageCustomerCalculateDone) {
                ArrayList<NextExecuteTaskDto> nextExecuteTaskDtosBySnapshot = new ArrayList<NextExecuteTaskDto>();
                Date now = new Date();
                for (NextExecuteTaskDto nextExecuteTaskDto : nextExecuteTaskDtos) {
                    if (now.after(nextExecuteTaskDto.getExecuteTime())) continue;
                    nextExecuteTaskDtosBySnapshot.add(nextExecuteTaskDto);
                }
                if (CollectionUtils.isEmpty(nextExecuteTaskDtosBySnapshot)) {
                    log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u4ece\u8ba1\u7b97\u5feb\u7167\u4e2d\u83b7\u53d6\u5230\u8981\u6267\u884c\u7684\u4efb\u52a1,\u4efb\u52a1\u5df2\u7ecf\u5168\u90e8\u8fc7\u4e86\u6267\u884c\u65f6\u95f4", (Object)sop.getId(), (Object)sopContent.getId());
                    return;
                }
                nextExecuteTaskDtos = nextExecuteTaskDtosBySnapshot;
            }
            if (!allStageCustomerCalculateDone && CollectionUtils.isEmpty(nextExecuteTaskDtos = this.judgeNextExecuteTaskAlreadyHandled(nextExecuteTaskDtos, sop.getId(), sopContent.getId()))) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},\u5f53\u524d\u8981\u6267\u884c\u7684\u4efb\u52a1\u88ab\u4e4b\u524d\u7684\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8fc7", (Object)sop.getId(), (Object)sopContent.getId());
                return;
            }
            try {
                this.executeTaskInAdvance(sop, sopContent, nextExecuteTaskDtos, allStageCustomerCalculateDone, sopContents, sopUserIds);
            }
            catch (Exception e) {
                log.info("doBusinessBySopContent,sopId:{},sopContentId:{},executeTaskInAdvance error", new Object[]{sop.getId(), sopContent.getId(), e});
            }
        }
    }

    private boolean judgeRemindAlreadyHandled(String executeDay, SopContent sopContent) {
        String remindTimeHMSString = sopContent.getRemindTime();
        DateTime remindTime = DateUtil.parse((CharSequence)(executeDay + " " + remindTimeHMSString), (String)"yyyy-MM-dd HH:mm:ss");
        SopTaskScanLog select = new SopTaskScanLog();
        select.setBizId(sopContent.getBizId());
        select.setSopId(sopContent.getSopId());
        select.setSopContentId(sopContent.getId());
        select.setSopTaskTemplateId(Long.valueOf(-1L));
        select.setSopTaskTemplateTimesId(Long.valueOf(-1L));
        select.setSopTaskTemplateTimesTaskId(Long.valueOf(-1L));
        select.setSopTaskTemplateTimesUpdateTime((Date)remindTime);
        select.setRunTime((Date)remindTime);
        int count = this.sopTaskScanLogMapper.selectCount((Object)select);
        return count != 0;
    }

    private void remindUserByNoTemplate(Sop sop, boolean allStageCustomerCalculateDone, SopContent sopContent, Set<Long> sopUserIds, String executeDay, List<SopContent> sopContents) {
        log.info("remindUserByNoTemplate,sopId:{},allStageCustomerCalculateDone:{},sopContentId:{},sopUserIds:{},executeDay:{}", new Object[]{sop.getId(), allStageCustomerCalculateDone, sopContent.getId(), sopUserIds, executeDay});
        Integer sopType = sop.getSopType();
        if (sopType == 0) {
            if (allStageCustomerCalculateDone) {
                this.insertRemindByNoTemplate(sopContent, sopUserIds, executeDay);
            } else {
                Map<Long, SopContent> sopContentIdMap = sopContents.stream().collect(Collectors.toMap(SopContent::getId, Function.identity()));
                try {
                    this.createCalculateTask(sop.getBizId(), sopContentIdMap, null, null, sopContent.getId(), executeDay);
                }
                catch (Exception e) {
                    log.error("remindUserByNoTemplate,sopId:{},allStageCustomerCalculateDone:{},sopContentId:{},sopUserIds:{},executeDay:{}, \u521b\u5efa\u5708\u5ba2\u8ba1\u7b97\u4efb\u52a1\u5f02\u5e38", new Object[]{sop.getId(), false, sopContent.getId(), sopUserIds, executeDay, e});
                }
            }
        } else if (sopType == 1) {
            if (allStageCustomerCalculateDone) {
                this.insertRemindByNoTemplate(sopContent, sopUserIds, executeDay);
            } else {
                SopStageCalculate staticSopFirstCalculate = this.sopStageCalculateMapper.selectStaticSopFirstCalculate(sop.getId(), sop.getUpdateTime(), Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
                if (staticSopFirstCalculate != null) {
                    log.info("remindUserByNoTemplate,sopId:{},allStageCustomerCalculateDone:{},sopContentId:{},\u9759\u6001\u5708\u5ba2\u8c03\u7528\u7b97\u5b50\u8ba1\u7b97,staticSopFirstCalculate:{}", new Object[]{sop.getId(), allStageCustomerCalculateDone, sopContent.getId(), staticSopFirstCalculate.getId()});
                    Map<Long, SopContent> sopContentIdMap = sopContents.stream().collect(Collectors.toMap(SopContent::getId, Function.identity()));
                    try {
                        this.createCalculateTask(sop.getBizId(), sopContentIdMap, staticSopFirstCalculate.getId(), null, sopContent.getId(), executeDay);
                    }
                    catch (Exception e) {
                        log.error("remindUserByNoTemplate,sopId:{},allStageCustomerCalculateDone:{},sopContentId:{},sopUserIds:{},executeDay:{}, \u521b\u5efa\u5708\u5ba2\u8ba1\u7b97\u4efb\u52a1\u5f02\u5e38", new Object[]{sop.getId(), false, sopContent.getId(), sopUserIds, executeDay, e});
                    }
                }
            }
        }
    }

    private void insertRemindByNoTemplate(SopContent sopContent, Set<Long> sopUserIds, String executeDay) {
        Long sopContentId = sopContent.getId();
        Long sopId = sopContent.getSopId();
        Long bizId = sopContent.getBizId();
        log.info("insertRemindByNoTemplate,sopId:{},sopContentId:{},sopUserIds:{}", new Object[]{sopId, sopContentId, sopUserIds});
        List sopFinalCustomerList = this.sopFinalCustomerMapper.selectBySopIdAndSopContentIdAndUserIds(sopId, sopContentId, sopUserIds);
        if (CollectionUtils.isEmpty((Collection)sopFinalCustomerList)) {
            log.info("insertRemindByNoTemplate,sopId:{},sopContentId:{},\u7b5b\u9009\u51fa\u7684\u5ba2\u6237\u4e3a\u7a7a", (Object)sopId, (Object)sopContentId);
            return;
        }
        String remindTimeHMSString = sopContent.getRemindTime();
        DateTime remindTime = DateUtil.parse((CharSequence)(executeDay + " " + remindTimeHMSString), (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<AddSopRemindDto> remindList = new ArrayList<AddSopRemindDto>();
        String sopRemindMainNum = this.idGen.getNum();
        for (SopFinalCustomer sopFinalCustomer : sopFinalCustomerList) {
            AddSopRemindDto dto = new AddSopRemindDto();
            dto.setBizId(bizId);
            dto.setRemindTime((Date)remindTime);
            dto.setUserId(sopFinalCustomer.getUserId());
            dto.setCustomerId(sopFinalCustomer.getCustomerId());
            dto.setCustomerType(sopFinalCustomer.getCustomerType());
            dto.setMainNum(sopRemindMainNum);
            dto.setRemindContent(sopContent.getRemindContent());
            dto.setRemindType(Integer.valueOf(SopRemindType.NO_TEMPLATE.getValue()));
            dto.setSopId(sopId);
            remindList.add(dto);
        }
        if (CollectionUtils.isNotEmpty(remindList)) {
            this.remindService.addSopRemind(remindList);
        }
    }

    private List<NextExecuteTaskDto> judgeNextExecuteTaskAlreadyHandled(List<NextExecuteTaskDto> nextExecuteTaskDtos, Long sopId, Long sopContentId) {
        String key;
        log.info("judgeNextExecuteTaskAlreadyHandled,sopId:{},sopContentId:{},nextExecuteTaskDtos:{}", new Object[]{sopId, sopContentId, nextExecuteTaskDtos});
        HashMap<String, NextExecuteTaskDto> map = new HashMap<String, NextExecuteTaskDto>();
        for (NextExecuteTaskDto nextExecuteTaskDto : nextExecuteTaskDtos) {
            key = nextExecuteTaskDto.getTemplateTimesId() + "$" + nextExecuteTaskDto.getTaskUpdateTime() + "$" + nextExecuteTaskDto.getExecuteTime() + "$" + nextExecuteTaskDto.getTemplateTimesTaskId();
            map.put(key, nextExecuteTaskDto);
        }
        for (NextExecuteTaskDto nextExecuteTaskDto : nextExecuteTaskDtos) {
            key = nextExecuteTaskDto.getTemplateTimesId() + "$" + nextExecuteTaskDto.getTaskUpdateTime() + "$" + nextExecuteTaskDto.getExecuteTime() + "$" + nextExecuteTaskDto.getTemplateTimesTaskId();
            SopTaskScanLog select = new SopTaskScanLog();
            select.setSopContentId(sopContentId);
            select.setSopTaskTemplateTimesId(nextExecuteTaskDto.getTemplateTimesId());
            select.setSopTaskTemplateTimesUpdateTime(nextExecuteTaskDto.getTaskUpdateTime());
            select.setRunTime(nextExecuteTaskDto.getExecuteTime());
            select.setSopTaskTemplateTimesTaskId(nextExecuteTaskDto.getTemplateTimesTaskId());
            SopTaskScanLog sopTaskScanLog = (SopTaskScanLog)this.sopTaskScanLogMapper.selectOne((Object)select);
            if (sopTaskScanLog == null) continue;
            log.info("judgeNextExecuteTaskAlreadyHandled,sopId:{},sopContentId:{},\u5f53\u524d\u8981\u6267\u884c\u7684\u4efb\u52a1\u88ab\u4e4b\u524d\u7684\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u8fc7,tmpTimesId:{},tmpTimesUpdateTime:{},runTime:{}", new Object[]{sopId, sopContentId, nextExecuteTaskDto.getTemplateTimesId(), nextExecuteTaskDto.getTaskUpdateTime(), nextExecuteTaskDto.getExecuteTime()});
            map.remove(key);
        }
        return new ArrayList<NextExecuteTaskDto>(map.values());
    }

    private void executeTaskInAdvance(Sop sop, SopContent sopContent, List<NextExecuteTaskDto> nextExecuteTaskDtos, boolean allStageCustomerCalculateDone, List<SopContent> sopContents, Set<Long> sopUserIds) {
        log.info("executeTaskInAdvance,sopId:{},sopContentId:{},allStageCustomerCalculateDone:{},nextExecuteTaskDtos:{}", new Object[]{sop.getId(), sopContent.getId(), allStageCustomerCalculateDone, nextExecuteTaskDtos});
        Map<Long, SopContent> sopContentIdMap = sopContents.stream().collect(Collectors.toMap(SopContent::getId, Function.identity()));
        Integer sopType = sop.getSopType();
        if (sopType == 0) {
            if (!allStageCustomerCalculateDone) {
                log.info("executeTaskInAdvance,sopId:{},sopContentId:{},\u52a8\u6001SOP\u7b5b\u9009\u5ba2\u6237\u672a\u8ba1\u7b97", (Object)sop.getId(), (Object)sopContent.getId());
                try {
                    this.createCalculateTask(sop.getBizId(), sopContentIdMap, null, nextExecuteTaskDtos, sopContent.getId(), "");
                }
                catch (Exception e) {
                    log.error("executeTaskInAdvance,sopId:{},sopContentId:{},\u521b\u5efa\u5708\u5ba2\u8ba1\u7b97\u4efb\u52a1\u5f02\u5e38", new Object[]{sop.getId(), sopContent.getId(), e});
                }
            } else {
                try {
                    this.insertSopTaskDetailInAdvance(sop, sopContent, nextExecuteTaskDtos, sopUserIds, true);
                }
                catch (Exception e) {
                    log.error("executeTaskInAdvance,sopId:{},sopContentId:{},insertSopTaskDetailInAdvance error", new Object[]{sop.getId(), sopContent.getId(), e});
                }
            }
        } else if (sopType == 1) {
            SopStageCalculate staticSopFirstCalculate = this.sopStageCalculateMapper.selectStaticSopFirstCalculate(sop.getId(), sop.getUpdateTime(), Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
            log.info("executeTaskInAdvance,sopId:{},sopContentId:{},\u7b2c\u4e00\u6b21\u7b5b\u9009\u7b2c\u4e00\u9636\u6bb5\u7684\u5ba2\u6237\u662f\u5426\u8ba1\u7b97\u5b8c\u6bd5:{}", new Object[]{sop.getId(), sopContent.getId(), staticSopFirstCalculate});
            if (staticSopFirstCalculate != null) {
                if (allStageCustomerCalculateDone) {
                    try {
                        this.insertSopTaskDetailInAdvance(sop, sopContent, nextExecuteTaskDtos, sopUserIds, true);
                    }
                    catch (Exception e) {
                        log.error("executeTaskInAdvance,sopId:{},sopContentId:{},insertSopTaskDetailInAdvance error", new Object[]{sop.getId(), sopContent.getId(), e});
                    }
                } else {
                    log.info("executeTaskInAdvance,sopId:{},sopContentId:{},\u9759\u6001SOP\u7b2c\u4e00\u6b21\u7b5b\u9009\u7b2c\u4e00\u4e2a\u9636\u6bb5\u7684\u5ba2\u6237\u8ba1\u7b97\u5b8c\u6bd5,\u672c\u6b21\u63a5\u4e0b\u6765\u8981\u6267\u884c\u7684\u4efb\u52a1\u7b5b\u9009\u5ba2\u6237\u672a\u8ba1\u7b97", (Object)sop.getId(), (Object)sopContent.getId());
                    try {
                        this.createCalculateTask(sop.getBizId(), sopContentIdMap, staticSopFirstCalculate.getId(), nextExecuteTaskDtos, sopContent.getId(), "");
                    }
                    catch (Exception e) {
                        log.error("executeTaskInAdvance,sopId:{},sopContentId:{},\u521b\u5efa\u5708\u5ba2\u8ba1\u7b97\u4efb\u52a1\u5f02\u5e38", new Object[]{sop.getId(), sopContent.getId(), e});
                    }
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void createCalculateTask(Long bizId, Map<Long, SopContent> sopContentIdMap, Long staticSopFirstCalculateId, List<NextExecuteTaskDto> nextExecuteTaskDtos, Long sopContentId, String executeDay) {
        log.info("createCalculateTask,sopContentId:{},staticSopFirstCalculateId:{},executeDay:{}", new Object[]{sopContentId, staticSopFirstCalculateId, executeDay});
        String preRequestId = null;
        if (staticSopFirstCalculateId != null) {
            SopStageCalculate sopStageCalculate = (SopStageCalculate)this.sopStageCalculateMapper.selectByPrimaryKey((Object)staticSopFirstCalculateId);
            preRequestId = sopStageCalculate != null ? sopStageCalculate.getResultRequestId() : null;
        }
        ArrayList<SopStageCalculate> insertCalculateList = new ArrayList<SopStageCalculate>();
        Date now = new Date();
        SopContent currentSopContent = sopContentIdMap.get(sopContentId);
        String mainReqId = this.reqCreateCalculateTask(bizId, sopContentId, preRequestId);
        if (StringUtils.isBlank((CharSequence)mainReqId)) {
            log.error("createCalculateTask,sopContentId:{},\u521b\u5efa\u4e3b\u8ba1\u7b97\u4efb\u52a1\u5931\u8d25,\u672c\u6b21\u8c03\u7528\u7b97\u5b50\u8ba1\u7b97\u5f15\u64ce\u8df3\u8fc7", (Object)sopContentId);
            return;
        }
        SopStageCalculate insertMainCalculate = this.buildSopStageCalculate(now, bizId, currentSopContent.getSopId(), sopContentId, mainReqId, JSONObject.toJSONString(nextExecuteTaskDtos), mainReqId, currentSopContent.getStageSeq(), 0);
        insertCalculateList.add(insertMainCalculate);
        ArrayList<SopTaskScanLog> insertScanLogList = new ArrayList<SopTaskScanLog>();
        if (CollectionUtils.isNotEmpty(nextExecuteTaskDtos)) {
            for (NextExecuteTaskDto nextExecuteTaskDto : nextExecuteTaskDtos) {
                SopTaskScanLog insertScanLog = new SopTaskScanLog();
                insertScanLog.setBizId(bizId);
                insertScanLog.setSopId(currentSopContent.getSopId());
                insertScanLog.setSopContentId(sopContentId);
                insertScanLog.setSopTaskTemplateId(nextExecuteTaskDto.getTemplateId());
                insertScanLog.setSopTaskTemplateTimesId(nextExecuteTaskDto.getTemplateTimesId());
                insertScanLog.setSopTaskTemplateTimesTaskId(nextExecuteTaskDto.getTemplateTimesTaskId());
                insertScanLog.setSopTaskTemplateTimesUpdateTime(nextExecuteTaskDto.getTaskUpdateTime());
                insertScanLog.setRunTime(nextExecuteTaskDto.getExecuteTime());
                insertScanLog.setCreateTime(now);
                insertScanLogList.add(insertScanLog);
            }
        } else {
            String remindTimeHMSString = currentSopContent.getRemindTime();
            DateTime dateTime = DateUtil.parse((CharSequence)(executeDay + " " + remindTimeHMSString), (String)"yyyy-MM-dd HH:mm:ss");
            SopTaskScanLog insert = new SopTaskScanLog();
            insert.setBizId(bizId);
            insert.setSopId(currentSopContent.getSopId());
            insert.setSopContentId(sopContentId);
            insert.setSopTaskTemplateId(Long.valueOf(-1L));
            insert.setSopTaskTemplateTimesId(Long.valueOf(-1L));
            insert.setSopTaskTemplateTimesTaskId(Long.valueOf(-1L));
            insert.setSopTaskTemplateTimesUpdateTime((Date)dateTime);
            insert.setRunTime((Date)dateTime);
            insert.setCreateTime(new Date());
            insertScanLogList.add(insert);
        }
        for (Map.Entry entry : sopContentIdMap.entrySet()) {
            Long contentId = (Long)entry.getKey();
            if (contentId.equals(sopContentId)) continue;
            SopContent sopContent = (SopContent)entry.getValue();
            String reqId = this.reqCreateCalculateTask(bizId, contentId, preRequestId);
            if (StringUtils.isBlank((CharSequence)reqId)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u8ba1\u7b97\u4efb\u52a1\u5931\u8d25");
            }
            SopStageCalculate insertCalculate = this.buildSopStageCalculate(now, bizId, sopContent.getSopId(), contentId, reqId, JSONObject.toJSONString(nextExecuteTaskDtos), mainReqId, sopContent.getStageSeq(), 0);
            insertCalculateList.add(insertCalculate);
        }
        if (CollectionUtils.isNotEmpty(insertCalculateList)) {
            this.sopStageCalculateMapper.batchInsert(insertCalculateList);
        }
        if (CollectionUtils.isNotEmpty(insertScanLogList)) {
            this.sopTaskScanLogMapper.batchInsert(insertScanLogList);
        }
    }

    private SopStageCalculate buildSopStageCalculate(Date now, Long bizId, Long sopId, Long sopContentId, String reqId, String snapshotContent, String mainReqId, Long stageSeq, Integer isStaticSopFirstCalculate) {
        SopStageCalculate insertCalculate = new SopStageCalculate();
        insertCalculate.setBizId(bizId);
        insertCalculate.setSopId(sopId);
        insertCalculate.setSopContentId(sopContentId);
        insertCalculate.setResultRequestId(reqId);
        insertCalculate.setStatus(Integer.valueOf(CalculateStatusEnum.IN_CAL.getStatus()));
        insertCalculate.setCreateTime(now);
        insertCalculate.setUpdateTime(now);
        insertCalculate.setIsDeleted(Integer.valueOf(0));
        insertCalculate.setSnapshotContent(snapshotContent);
        insertCalculate.setMainResultRequestId(mainReqId);
        insertCalculate.setStageSeq(stageSeq);
        insertCalculate.setIsStaticSopFirstCalculate(isStaticSopFirstCalculate);
        return insertCalculate;
    }

    private String reqCreateCalculateTask(Long bizId, Long sopContentId, String preRequestId) {
        CallSopCalcTaskReq req = new CallSopCalcTaskReq();
        req.setBizId(bizId);
        req.setSopContentId(sopContentId);
        if (StringUtils.isNotBlank((CharSequence)preRequestId)) {
            req.setPreRequestId(preRequestId);
        }
        int tryTimes = 3;
        while (tryTimes > 0) {
            try {
                return this.sopCalTaskService.callSopCalTask(req);
            }
            catch (Exception e) {
                log.error("reqCreateCalculateTask,sopContentId:{},tryTimes:{},callSopCalTask error", new Object[]{sopContentId, --tryTimes, e});
            }
        }
        return null;
    }

    private void insertSopTaskDetailInAdvance(Sop sop, SopContent sopContent, List<NextExecuteTaskDto> nextExecuteTaskDtos, Set<Long> sopUserIds, boolean allStageCustomerCalculateDone) {
        Map map;
        log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},sopUserIds:{},nextExecuteTaskDtos:{}", new Object[]{sop.getId(), sopContent.getId(), sopUserIds, nextExecuteTaskDtos});
        List sopFinalCustomerList = this.sopFinalCustomerMapper.selectBySopIdAndSopContentIdAndUserIds(sop.getId(), sopContent.getId(), sopUserIds);
        if (CollectionUtils.isEmpty((Collection)sopFinalCustomerList)) {
            log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},\u7b5b\u9009\u51fa\u7684\u5ba2\u6237\u4e3a\u7a7a", (Object)sop.getId(), (Object)sopContent.getId());
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)sopFinalCustomerList)) {
            sopFinalCustomerList = sopFinalCustomerList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SopFinalCustomer>(Comparator.comparing(o -> o.getCustomerId() + ";" + o.getUserId()))), ArrayList::new));
        }
        HashMap<Integer, List> timesSortMap = new HashMap<Integer, List>();
        for (NextExecuteTaskDto nextExecuteTaskDto : nextExecuteTaskDtos) {
            List taskDtoList = timesSortMap.getOrDefault(nextExecuteTaskDto.getTimesSort(), new ArrayList());
            taskDtoList.add(nextExecuteTaskDto);
            timesSortMap.put(nextExecuteTaskDto.getTimesSort(), taskDtoList);
        }
        Integer frequencyType = sopContent.getFrequencyType();
        Integer timesMaxSort = nextExecuteTaskDtos.get(0).getTimesMaxSort();
        Map<Long, Integer> userIdVipOnlineMap = this.selectOnlineVipUser(sop.getBizId(), sopUserIds);
        ArrayList<SopFinalCustomer> haveTaskFinalCustomerList = new ArrayList<SopFinalCustomer>();
        HashSet<String> customerNum2MobileSet = new HashSet<String>();
        HashSet<String> customerNum2WeworkContactIdSet = new HashSet<String>();
        for (SopFinalCustomer sopFinalCustomer : sopFinalCustomerList) {
            Long nextTmpStep = sopFinalCustomer.getTmpStep() + 1L;
            if (nextTmpStep.intValue() > timesMaxSort) {
                if (frequencyType == 1) continue;
                if (timesMaxSort == 0) {
                    timesMaxSort = 1;
                }
                if ((nextTmpStep = Long.valueOf(nextTmpStep % (long)timesMaxSort.intValue())).equals(0L)) {
                    nextTmpStep = 1L;
                }
            }
            List taskDtoList = (List)timesSortMap.get(nextTmpStep.intValue());
            log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},sopFinalCustomer:{},sopFinalCustomer.tmpStep:{}", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getTmpStep()});
            if (CollectionUtils.isEmpty((Collection)taskDtoList)) {
                log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},sopFinalCustomer:{},sopFinalCustomer.tmpStep:{},\u63a5\u4e0b\u6765\u8981\u6267\u884c\u7684\u4efb\u52a1\u4e2d,\u6ca1\u6709\u7b26\u5408\u5f53\u524d\u5ba2\u6237\u7684\u6b21\u6570", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getTmpStep()});
                continue;
            }
            haveTaskFinalCustomerList.add(sopFinalCustomer);
            for (NextExecuteTaskDto taskDto : taskDtoList) {
                if (SopTemplateTaskTypeEnum.SMS.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.MANUAL_CALL.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.BATCH_ADD_FRIEND.getValue() == taskDto.getTaskType().intValue()) {
                    customerNum2MobileSet.add(sopFinalCustomer.getCustomerId());
                    continue;
                }
                customerNum2WeworkContactIdSet.add(sopFinalCustomer.getCustomerId());
            }
        }
        HashMap customerNumAndMobileMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerNum2MobileSet)) {
            Map map2;
            Map mapByCustomerNum = this.convertServiceImpl.execConvert(sop.getBizId(), customerNum2MobileSet, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.MOBILE);
            if (!mapByCustomerNum.isEmpty()) {
                mapByCustomerNum.forEach((k, v) -> {
                    String mobile = v instanceof String ? v : v.toString();
                    if (!customerNum2MobileSet.contains(k)) {
                        return;
                    }
                    customerNumAndMobileMap.put(k, mobile);
                });
            }
            HashMap customerMainNumAndNumMap = new HashMap();
            HashSet customerMainNumSet = new HashSet();
            Map customerMap = this.convertServiceImpl.execConvert(sop.getBizId(), customerNum2MobileSet, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_MAIN_ID);
            if (!customerMap.isEmpty()) {
                customerMap.forEach((k, v) -> {
                    String mainNum = v;
                    if (StringUtils.isBlank((CharSequence)mainNum)) {
                        return;
                    }
                    Set nums = customerMainNumAndNumMap.getOrDefault(mainNum, new HashSet());
                    nums.add(k);
                    customerMainNumAndNumMap.put(mainNum, nums);
                    customerMainNumSet.add(mainNum);
                });
            }
            if (CollectionUtils.isNotEmpty(customerMainNumSet) && !(map2 = this.convertServiceImpl.execConvert(sop.getBizId(), customerMainNumSet, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.MOBILE)).isEmpty()) {
                map2.forEach((k, v) -> {
                    String mobile = v;
                    if (!customerMainNumSet.contains(k)) {
                        return;
                    }
                    Set nums = (Set)customerMainNumAndNumMap.get(k);
                    for (String customerNum : nums) {
                        customerNumAndMobileMap.put(customerNum, mobile);
                    }
                });
            }
        }
        HashMap customerNumAndContactIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerNum2WeworkContactIdSet) && !(map = this.convertServiceImpl.execConvert(sop.getBizId(), customerNum2WeworkContactIdSet, (IOperatorResultType)OperatorResultCustomerType.CUSTOMER_NUM, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_ID)).isEmpty()) {
            map.forEach((k, v) -> {
                String weworkContactId = v instanceof String ? (String)v : v.toString();
                customerNumAndContactIdMap.put((String)k, weworkContactId);
            });
        }
        HashMap<Long, String> taskIdSopRemindMainNumMap = new HashMap<Long, String>();
        ArrayList<SopTaskDetail> insertList = new ArrayList<SopTaskDetail>();
        ArrayList<AddSopRemindDto> remindList = new ArrayList<AddSopRemindDto>();
        for (SopFinalCustomer sopFinalCustomer : haveTaskFinalCustomerList) {
            Long nextTmpStep = sopFinalCustomer.getTmpStep() + 1L;
            if (nextTmpStep.intValue() > timesMaxSort) {
                if (frequencyType == 1) continue;
                if (timesMaxSort == 0) {
                    timesMaxSort = 1;
                }
                if ((nextTmpStep = Long.valueOf(nextTmpStep % (long)timesMaxSort.intValue())).equals(0L)) {
                    nextTmpStep = 1L;
                }
            }
            List taskDtoList = (List)timesSortMap.get(nextTmpStep.intValue());
            log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},sopFinalCustomer:{},sopFinalCustomer.tmpStep:{}", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getTmpStep()});
            if (CollectionUtils.isEmpty((Collection)taskDtoList)) {
                log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},sopFinalCustomer:{},sopFinalCustomer.tmpStep:{},\u63a5\u4e0b\u6765\u8981\u6267\u884c\u7684\u4efb\u52a1\u4e2d,\u6ca1\u6709\u7b26\u5408\u5f53\u524d\u5ba2\u6237\u7684\u6b21\u6570", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getTmpStep()});
                continue;
            }
            for (NextExecuteTaskDto taskDto : taskDtoList) {
                String mobile = null;
                String weworkContactId = null;
                if (SopTemplateTaskTypeEnum.SMS.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.MANUAL_CALL.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.BATCH_ADD_FRIEND.getValue() == taskDto.getTaskType().intValue()) {
                    mobile = (String)customerNumAndMobileMap.get(sopFinalCustomer.getCustomerId());
                    if (StringUtils.isBlank((CharSequence)mobile)) {
                        log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},\u901a\u8fc7customerNum\u83b7\u53d6\u4e0d\u5230mobile,\u65e0\u6cd5\u6267\u884c\u4efb\u52a1,sopFinalCustomerId:{},customerNum:{}", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getCustomerId()});
                        continue;
                    }
                } else {
                    weworkContactId = (String)customerNumAndContactIdMap.get(sopFinalCustomer.getCustomerId());
                    if (StringUtils.isBlank((CharSequence)weworkContactId)) {
                        log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},\u901a\u8fc7customerNum\u83b7\u53d6\u4e0d\u5230weworkContactId,\u65e0\u6cd5\u6267\u884c\u4efb\u52a1,sopFinalCustomerId:{},customerNum:{}", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), sopFinalCustomer.getCustomerId()});
                        continue;
                    }
                }
                if (!taskIdSopRemindMainNumMap.containsKey(taskDto.getTemplateTimesTaskId())) {
                    String num = this.idGen.getNum();
                    log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},taskId:{},remindMainNum:{}", new Object[]{sop.getId(), sopContent.getId(), taskDto.getTemplateTimesTaskId(), num});
                    taskIdSopRemindMainNumMap.put(taskDto.getTemplateTimesTaskId(), num);
                }
                log.info("insertSopTaskDetailInAdvance,sopId:{},sopContentId:{},\u5f53\u524d\u5ba2\u6237\u63a5\u4e0b\u6765\u6709\u8981\u6267\u884c\u7684\u4efb\u52a1,sopFinalCustomerId:{}, nextTmpStep:{}, taskDto:{}", new Object[]{sop.getId(), sopContent.getId(), sopFinalCustomer.getId(), nextTmpStep, taskDto});
                Date now = new Date();
                SopTaskDetail insert = new SopTaskDetail();
                insert.setBizId(sopFinalCustomer.getBizId());
                insert.setSopId(sop.getId());
                insert.setSopContentId(sopContent.getId());
                insert.setUserId(sopFinalCustomer.getUserId());
                insert.setUserIdExtra(sopFinalCustomer.getUserId());
                if (SopTemplateTaskTypeEnum.SMS.getValue() == taskDto.getTaskType().intValue()) {
                    insert.setUserIdExtra(Long.valueOf(-1L));
                }
                if (SopTemplateTaskTypeEnum.SMS.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.MANUAL_CALL.getValue() == taskDto.getTaskType().intValue() || SopTemplateTaskTypeEnum.BATCH_ADD_FRIEND.getValue() == taskDto.getTaskType().intValue()) {
                    insert.setCustomerId(mobile);
                    insert.setCustomerType(OperatorResultCustomerType.MOBILE.getType());
                } else {
                    insert.setCustomerId(weworkContactId);
                    insert.setCustomerType(OperatorResultCustomerType.WEWORK_CONTACT_ID.getType());
                }
                insert.setCustomerNum(sopFinalCustomer.getCustomerId());
                insert.setSopTaskTemplateTimesId(taskDto.getTemplateTimesId());
                insert.setSopTaskTemplateId(taskDto.getTemplateId());
                insert.setTmpStep(nextTmpStep);
                insert.setSopTaskTemplateTimesTaskId(taskDto.getTemplateTimesTaskId());
                insert.setTaskType(taskDto.getTaskType());
                insert.setRunTime(taskDto.getExecuteTime());
                insert.setRunStatus(Integer.valueOf(TaskRunStatusEnum.WAIT_EXECUTE.getStatus()));
                insert.setCreateBy(Long.valueOf(-1L));
                insert.setCreateTime(now);
                insert.setUpdateBy(Long.valueOf(-1L));
                insert.setUpdateTime(now);
                insert.setIsDeleted(Integer.valueOf(0));
                insert.setTaskContent(taskDto.getContent());
                insert.setIsVip(userIdVipOnlineMap.getOrDefault(sopFinalCustomer.getUserId(), 0));
                insertList.add(insert);
                if (!allStageCustomerCalculateDone || Objects.equals(SopTemplateTaskTypeEnum.SMS.getValue(), insert.getTaskType())) continue;
                remindList.add(this.buildAddSopRemindDto((String)taskIdSopRemindMainNumMap.get(taskDto.getTemplateTimesTaskId()), insert));
            }
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.sopTaskDetailMapper.batchInsert(insertList);
        }
        if (CollectionUtils.isNotEmpty(remindList)) {
            this.remindService.addSopRemind(remindList);
        }
    }

    private Map<Long, Integer> selectOnlineVipUser(Long bizId, Set<Long> userIds) {
        log.info("selectOnlineVipUser,bizId:{},userIds:{}", (Object)bizId, userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        List weworkUserInfos = this.weworkUserMapper.queryWeworkUserByBizIdUserIds(bizId, userIds);
        if (CollectionUtils.isEmpty((Collection)weworkUserInfos)) {
            return Collections.emptyMap();
        }
        ArrayList<String> digitIds = new ArrayList<String>();
        HashMap<String, Long> digitIdUserIdMap = new HashMap<String, Long>();
        for (WeworkUserInfo weworkUserInfo : weworkUserInfos) {
            if (StringUtils.isBlank((CharSequence)weworkUserInfo.getWeworkDigitId()) || digitIds.contains(weworkUserInfo.getWeworkDigitId())) continue;
            digitIds.add(weworkUserInfo.getWeworkDigitId());
            digitIdUserIdMap.put(weworkUserInfo.getWeworkDigitId(), weworkUserInfo.getUserId());
        }
        if (CollectionUtils.isEmpty(digitIds)) {
            return Collections.emptyMap();
        }
        BaseResponse weworkStatus = this.operateService.queryWeworksStatus(bizId, digitIds);
        if (weworkStatus == null || weworkStatus.getCode() != 0L) {
            log.info("selectOnlineVipUser,bizId:{},userIds:{},queryWeworksStatus fail,weworkStatus:{}", new Object[]{bizId, userIds, weworkStatus});
            return Collections.emptyMap();
        }
        List weworkStatusInfoList = (List)weworkStatus.getData();
        if (CollectionUtils.isEmpty((Collection)weworkStatusInfoList)) {
            log.info("selectOnlineVipUser,bizId:{},userIds:{},weworkStatusInfoList is empty", (Object)bizId, userIds);
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> userIdVipOnlineMap = new HashMap<Long, Integer>();
        for (WeworkStatusInfo weworkStatusInfo : weworkStatusInfoList) {
            Long userId = (Long)digitIdUserIdMap.get(weworkStatusInfo.getWeworkId());
            if (userId == null) continue;
            userIdVipOnlineMap.put(userId, weworkStatusInfo.isOnline() ? 1 : 0);
        }
        return userIdVipOnlineMap;
    }

    private AddSopRemindDto buildAddSopRemindDto(String sopRemindMainNum, SopTaskDetail sopTaskDetail) {
        AddSopRemindDto dto = new AddSopRemindDto();
        dto.setBizId(sopTaskDetail.getBizId());
        dto.setRemindTime(sopTaskDetail.getRunTime());
        dto.setUserId(sopTaskDetail.getUserId());
        dto.setCustomerId(sopTaskDetail.getCustomerNum());
        dto.setCustomerType(OperatorResultCustomerType.CUSTOMER_NUM.getType());
        dto.setMainNum(sopRemindMainNum);
        dto.setSopId(sopTaskDetail.getSopId());
        if (Objects.equals(SopTemplateTaskTypeEnum.WEWORK_GROUP_SEND.getValue(), sopTaskDetail.getTaskType())) {
            dto.setRemindType(Integer.valueOf(SopRemindType.GROUP_SEND.getValue()));
            if (sopTaskDetail.getIsVip() == 1) {
                dto.setRemindType(Integer.valueOf(SopRemindType.YXB_SEND.getValue()));
            }
        } else if (Objects.equals(SopTemplateTaskTypeEnum.MANUAL_CALL.getValue(), sopTaskDetail.getTaskType())) {
            dto.setRemindType(Integer.valueOf(SopRemindType.CALL.getValue()));
        } else if (Objects.equals(SopTemplateTaskTypeEnum.BATCH_ADD_FRIEND.getValue(), sopTaskDetail.getTaskType())) {
            dto.setRemindType(Integer.valueOf(SopRemindType.TEL_ADD_FRIEND_OFFCIAL.getValue()));
            if (sopTaskDetail.getIsVip() == 1) {
                dto.setRemindType(Integer.valueOf(SopRemindType.TEL_ADD_FRIEND_YXB.getValue()));
            }
        }
        return dto;
    }

    private Set<Long> querySopUsers(Long sopId) {
        SopUser selectUsers = new SopUser();
        selectUsers.setIsDeleted(Integer.valueOf(0));
        selectUsers.setSopId(sopId);
        List sopUserList = this.sopUserMapper.select((Object)selectUsers);
        if (CollectionUtils.isEmpty((Collection)sopUserList)) {
            return Collections.emptySet();
        }
        Set<Long> originUserIds = sopUserList.stream().map(SopUser::getUserId).collect(Collectors.toSet());
        Set<Long> newSopUserIds = this.existRecentUpdateSopUsers(sopId, originUserIds);
        if (CollectionUtils.isEmpty(newSopUserIds)) {
            return originUserIds;
        }
        log.info("querySopUsers,sopId:{},originUserIds:{},newSopUserIds:{}", new Object[]{sopId, originUserIds, newSopUserIds});
        originUserIds.removeAll(newSopUserIds);
        return originUserIds;
    }

    private Set<Long> existRecentUpdateSopUsers(Long currentSopId, Collection<Long> currentUserIds) {
        if (currentSopId == null) {
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(currentUserIds)) {
            return Collections.emptySet();
        }
        log.info("existRecentUpdateSopUsers,currentSopId:{},currentUserIds:{}", (Object)currentSopId, currentUserIds);
        Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)currentSopId);
        if (sop == null) {
            return Collections.emptySet();
        }
        Integer policy = this.settingService.getIntegerOrDefault(sop.getBizId(), SystemParamName.SOP_USER_EFFECTIVE_POLICY.getKey(), Integer.valueOf(0));
        if (policy != null && policy.equals(1)) {
            log.info("existRecentUpdateSopUsers,currentSopId:{},\u6309\u7167SOP\u521b\u5efa\u65f6\u95f4\u5224\u65ad\u5458\u5de5\u662f\u5426\u5728\u5f53\u524dSOP\u4e2d\u751f\u6548", (Object)currentSopId);
            return this.sopUserMapper.selectByUserIdsAndGreaterThanSopId(sop.getId(), currentUserIds);
        }
        List sopUserList = this.sopUserMapper.selectUsersIsExistOtherSop(currentSopId, currentUserIds);
        if (CollectionUtils.isEmpty((Collection)sopUserList)) {
            log.info("existRecentUpdateSopUsers,currentSopId:{},\u5f53\u524d\u5458\u5de5\u662f\u4e0d\u5728\u5176\u4ed6sop\u5f53\u4e2d", (Object)currentSopId);
            return Collections.emptySet();
        }
        HashSet otherSopIds = new HashSet();
        HashMap userSopMap = new HashMap();
        sopUserList.forEach(sopUser -> {
            otherSopIds.add(sopUser.getSopId());
            userSopMap.put(sopUser.getUserId(), sopUser.getSopId());
        });
        Date currentSopUpdateTime = sop.getUpdateTime();
        Map sopUpdateMap = this.sopMapper.queryUpdateTimeByIds(sop.getBizId(), otherSopIds);
        if (sopUpdateMap == null || sopUpdateMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> existRecentUpdateSopUsers = new HashSet<Long>();
        for (Map.Entry entry : userSopMap.entrySet()) {
            Long userId = (Long)entry.getKey();
            Long sopId = (Long)entry.getValue();
            Date sopUpdateTime = (Date)sopUpdateMap.get(sopId);
            if (sopUpdateTime == null || !sopUpdateTime.after(currentSopUpdateTime)) continue;
            log.info("existRecentUpdateSopUsers,\u6210\u5458\u5728\u5176\u4ed6SOP\u5f53\u4e2d,currentSopId:{},userId:{},currentSopUpdateTime:{},newSopId:{},newSopUpdateTime:{}", new Object[]{currentSopId, userId, currentSopUpdateTime, sopId, sopUpdateTime});
            existRecentUpdateSopUsers.add(userId);
        }
        return existRecentUpdateSopUsers;
    }

    private List<NextExecuteTaskDto> judgeHaveExecuteTask(Sop sop, SopContent sopContent, String executeDay) {
        log.info("judgeHaveExecuteTask,sopId:{},sopContentId:{},executeDay:{}", new Object[]{sop.getId(), sopContent.getId(), executeDay});
        Long sopTmpId = sopContent.getSopTmpId();
        SopTemplate selectSopTemplate = new SopTemplate();
        selectSopTemplate.setId(sopTmpId);
        selectSopTemplate.setIsDeleted(Integer.valueOf(0));
        SopTemplate sopTemplate = (SopTemplate)this.sopTemplateMapper.selectOne((Object)selectSopTemplate);
        if (sopTemplate == null) {
            log.info("judgeHaveExecuteTask,sopId:{},sopContentId:{},sopTmpId:{},\u65c5\u7a0b\u9636\u6bb5\u8bbe\u7f6e\u7684\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", new Object[]{sop.getId(), sopContent.getId(), sopTmpId});
            return Collections.emptyList();
        }
        SopTemplateTimes selectTimes = new SopTemplateTimes();
        selectTimes.setTemplateId(sopTemplate.getId());
        selectTimes.setIsDeleted(Integer.valueOf(0));
        List sopTemplateTimesList = this.sopTemplateTimesMapper.select((Object)selectTimes);
        if (CollectionUtils.isEmpty((Collection)sopTemplateTimesList)) {
            log.info("judgeHaveExecuteTask,sopId:{},sopContentId:{},sopTmpId:{},\u6a21\u677f\u6b21\u6570\u4e3a\u7a7a", new Object[]{sop.getId(), sopContent.getId(), sopTmpId});
            return Collections.emptyList();
        }
        HashSet<Long> timesIds = new HashSet<Long>();
        HashMap<Long, Integer> timesSortMap = new HashMap<Long, Integer>();
        int timesMaxSort = 0;
        for (SopTemplateTimes sopTemplateTimes : sopTemplateTimesList) {
            timesIds.add(sopTemplateTimes.getId());
            timesSortMap.put(sopTemplateTimes.getId(), sopTemplateTimes.getSort());
            if (timesMaxSort > sopTemplateTimes.getSort()) continue;
            timesMaxSort = sopTemplateTimes.getSort();
        }
        List sopTemplateTimesTaskList = this.sopTemplateTimesTaskMapper.selectByTmpIdAndTmpTimesIds(sopTemplate.getId(), timesIds);
        if (CollectionUtils.isEmpty((Collection)sopTemplateTimesTaskList)) {
            log.info("judgeHaveExecuteTask,sopId:{},sopContentId:{},sopTmpId:{},sopTmpTimesIds:{},\u6a21\u677f\u6b21\u6570\u4efb\u52a1\u4e3a\u7a7a", new Object[]{sop.getId(), sopContent.getId(), sopTmpId, timesIds});
            return Collections.emptyList();
        }
        ArrayList<NextExecuteTaskDto> resList = new ArrayList<NextExecuteTaskDto>();
        Date now = new Date();
        for (SopTemplateTimesTask sopTemplateTimesTask : sopTemplateTimesTaskList) {
            Date taskTime = sopTemplateTimesTask.getTaskTime();
            String taskTimeString = DateUtil.format((Date)taskTime, (String)"HH:mm:ss");
            DateTime nowTaskTime = DateUtil.parse((CharSequence)(executeDay + " " + taskTimeString), (String)"yyyy-MM-dd HH:mm:ss");
            DateTime includeEndTime = DateUtil.offsetSecond((Date)now, (int)this.includeFeatureTaskSeconds);
            log.info("judgeHaveExecuteTask,sopId:{},sopContentId:{},sopTmpId:{},tmpTimesTaskId:{},now:{},nowTaskTime:{},includeEndTime:{}", new Object[]{sop.getId(), sopContent.getId(), sopTmpId, sopTemplateTimesTask.getId(), now, nowTaskTime, includeEndTime});
            if (nowTaskTime.before(now) || nowTaskTime.after((Date)includeEndTime)) continue;
            NextExecuteTaskDto dto = new NextExecuteTaskDto();
            dto.setTemplateId(sopTemplateTimesTask.getTemplateId());
            dto.setTemplateTimesId(sopTemplateTimesTask.getTemplateTimesId());
            dto.setTemplateTimesTaskId(sopTemplateTimesTask.getId());
            dto.setTimesSort((Integer)timesSortMap.get(sopTemplateTimesTask.getTemplateTimesId()));
            dto.setTimesMaxSort(timesMaxSort);
            dto.setTaskUpdateTime(sopTemplateTimesTask.getUpdateTime());
            dto.setTaskType(sopTemplateTimesTask.getTaskType());
            dto.setContent(sopTemplateTimesTask.getContent());
            dto.setExecuteTime((Date)nowTaskTime);
            Date expectCompleteTime = sopTemplateTimesTask.getExpectCompleteTime();
            if (expectCompleteTime != null) {
                String expectCompleteTimeString = DateUtil.format((Date)expectCompleteTime, (String)"HH:mm:ss");
                DateTime nowExpectCompleteTime = DateUtil.parse((CharSequence)(executeDay + " " + expectCompleteTimeString), (String)"yyyy-MM-dd HH:mm:ss");
                dto.setExpectCompleteTime((Date)nowExpectCompleteTime);
            }
            resList.add(dto);
        }
        return resList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateDone(String requestId) {
        log.info("calculateDone,requestId:{}", (Object)requestId);
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return;
        }
        SopStageCalculate select = new SopStageCalculate();
        select.setIsDeleted(Integer.valueOf(0));
        select.setResultRequestId(requestId);
        SopStageCalculate sopStageCalculate = (SopStageCalculate)this.sopStageCalculateMapper.selectOne((Object)select);
        if (sopStageCalculate == null) {
            log.info("calculateDone,requestId:{},\u901a\u8fc7reqId\u67e5\u8be2\u4e0d\u5230sopStageCalculate", (Object)requestId);
            return;
        }
        if (sopStageCalculate.getStatus().equals(CalculateStatusEnum.CAL_USED.getStatus())) {
            log.info("calculateDone,requestId:{},\u5f53\u524d\u8ba1\u7b97\u7ed3\u679c\u5df2\u7ecf\u88ab\u4f7f\u7528", (Object)requestId);
            return;
        }
        SopStageCalculate selectByMainReqId = new SopStageCalculate();
        selectByMainReqId.setIsDeleted(Integer.valueOf(0));
        selectByMainReqId.setMainResultRequestId(sopStageCalculate.getMainResultRequestId());
        String lockKey = "calculateDone:" + sopStageCalculate.getMainResultRequestId();
        try {
            boolean calculateDone;
            this.lock.lock(lockKey);
            List stageCalculateListByMainReqId = this.sopStageCalculateMapper.select((Object)selectByMainReqId);
            HashSet<Long> allSopStageCalculateIds = new HashSet<Long>();
            Long mainSopContentId = null;
            for (SopStageCalculate stageCalculate : stageCalculateListByMainReqId) {
                allSopStageCalculateIds.add(stageCalculate.getId());
                if (!stageCalculate.getResultRequestId().equals(stageCalculate.getMainResultRequestId())) continue;
                mainSopContentId = stageCalculate.getSopContentId();
            }
            Long sopId = sopStageCalculate.getSopId();
            Long sopContentId = sopStageCalculate.getSopContentId();
            Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
            if (sop == null) {
                log.error("calculateDone,requestId:{},sop\u4e0d\u5b58\u5728,sopId:{}", (Object)requestId, (Object)sopId);
                this.sopStageCalculateMapper.batchUpdateStatusByIds(allSopStageCalculateIds, Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
                return;
            }
            if (sop.getIsEnable() == 0) {
                log.info("calculateDone,requestId:{},SOP\u672a\u542f\u7528", (Object)requestId);
                this.sopStageCalculateMapper.batchUpdateStatusByIds(allSopStageCalculateIds, Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
                return;
            }
            if (sopStageCalculate.getIsStaticSopFirstCalculate() == 1) {
                log.info("calculateDone,requestId:{},\u5f53\u524d\u56de\u8c03\u662f\u9759\u6001\u5708\u5ba2sop\u7684\u7b2c\u4e00\u6b21\u8ba1\u7b97\u7b2c\u4e00\u4e2a\u65c5\u7a0b\u9636\u6bb5\u7684\u573a\u666f,\u5f53\u524d\u4e0d\u9700\u8981\u67e5\u8be2\u8ba1\u7b97\u7ed3\u679c", (Object)requestId);
                calculateDone = false;
            } else {
                List<SopFinalCustomer> currentCalculateSopFinalCustomerList;
                try {
                    currentCalculateSopFinalCustomerList = this.handleCalculateByReqId(requestId, sopId, sopContentId);
                }
                catch (Exception e) {
                    log.error("calculateDone,requestId:{},handleCalculateByReqId error", (Object)requestId);
                    this.lock.unlock(lockKey);
                    return;
                }
                if (CollectionUtils.isEmpty(currentCalculateSopFinalCustomerList)) {
                    log.info("calculateDone,requestId:{},\u6839\u636ereqId\u67e5\u8be2\u7ed3\u679c\u5e76\u8ba1\u7b97\u591f,\u5f53\u524d\u5708\u5ba2\u7ed3\u679c\u4e3a\u7a7a,\u9000\u51fa", (Object)requestId);
                    this.sopStageCalculateMapper.batchUpdateStatusByIds(Collections.singletonList(sopStageCalculate.getId()), Integer.valueOf(CalculateStatusEnum.CAL_DONE.getStatus()));
                    return;
                }
                try {
                    this.delLowerStageSeqFinalCustomers(sopStageCalculate, currentCalculateSopFinalCustomerList);
                }
                catch (Exception e) {
                    log.error("calculateDone,requestId:{},delLowerStageSeqFinalCustomers error", (Object)requestId);
                }
                try {
                    this.delCurrentCustomersWhenCustomerInHigherStage(sopStageCalculate, currentCalculateSopFinalCustomerList);
                }
                catch (Exception e) {
                    log.error("calculateDone,requestId:{},delCurrentCustomersWhenCustomerInHigherStage error", (Object)requestId);
                }
                calculateDone = stageCalculateListByMainReqId.size() == 1 ? true : stageCalculateListByMainReqId.stream().filter(x -> !x.getId().equals(sopStageCalculate.getId())).allMatch(x -> x.getStatus().equals(CalculateStatusEnum.CAL_DONE.getStatus()));
                if (!calculateDone) {
                    log.info("calculateDone,requestId:{},\u5f53\u524dSOP\u7684\u8ba1\u7b97\u4efb\u52a1\u672a\u5168\u90e8\u8ba1\u7b97\u5b8c,stageCalculateListByMainReqId:{}", (Object)requestId, (Object)stageCalculateListByMainReqId);
                    this.sopStageCalculateMapper.batchUpdateStatusByIds(Collections.singletonList(sopStageCalculate.getId()), Integer.valueOf(CalculateStatusEnum.CAL_DONE.getStatus()));
                    return;
                }
            }
            if (mainSopContentId == null) {
                log.info("calculateDone,requestId:{},mainSopContentId is null", (Object)requestId);
                return;
            }
            try {
                this.doBusinessBySop(sop, calculateDone, mainSopContentId, JSONObject.parseArray((String)sopStageCalculate.getSnapshotContent(), NextExecuteTaskDto.class));
                this.sopStageCalculateMapper.batchUpdateStatusByIds(allSopStageCalculateIds, Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
            }
            catch (Exception e) {
                log.error("calculateDone,requestId:{},doBusinessBySop error", (Object)requestId, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("calculateDone,requestId:{}, error", (Object)requestId, (Object)e);
        }
        finally {
            this.lock.unlock(lockKey);
        }
    }

    private void delCurrentCustomersWhenCustomerInHigherStage(SopStageCalculate sopStageCalculate, List<SopFinalCustomer> currentCalculateSopFinalCustomerList) {
        log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{}", (Object)sopStageCalculate.getId());
        if (CollectionUtils.isEmpty(currentCalculateSopFinalCustomerList)) {
            return;
        }
        HashSet<String> currentCustomerIds = new HashSet<String>();
        HashMap<String, Set> currentCustomerIdMap = new HashMap<String, Set>();
        HashSet<Long> currentCustomerDbIds = new HashSet<Long>();
        for (SopFinalCustomer sopFinalCustomer : currentCalculateSopFinalCustomerList) {
            currentCustomerIds.add(sopFinalCustomer.getCustomerId());
            Set ids = currentCustomerIdMap.getOrDefault(sopFinalCustomer.getCustomerId(), new HashSet());
            ids.add(sopFinalCustomer.getId());
            currentCustomerIdMap.put(sopFinalCustomer.getCustomerId(), ids);
            currentCustomerDbIds.add(sopFinalCustomer.getId());
        }
        log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{}, currentCustomerDbIds:{}", (Object)sopStageCalculate.getId(), currentCustomerDbIds);
        SopContent selectContent = new SopContent();
        selectContent.setIsDeleted(Integer.valueOf(0));
        selectContent.setSopId(sopStageCalculate.getSopId());
        List sopContentList = this.sopContentMapper.select((Object)selectContent);
        if (CollectionUtils.isEmpty((Collection)sopContentList)) {
            log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{},sopContentList is empty", (Object)sopStageCalculate.getId());
            return;
        }
        HashSet<Long> higherSopContentId = new HashSet<Long>();
        for (SopContent sopContent : sopContentList) {
            if (sopContent.getId().equals(sopStageCalculate.getSopContentId()) || sopContent.getStageSeq() <= sopStageCalculate.getStageSeq()) continue;
            higherSopContentId.add(sopContent.getId());
        }
        if (CollectionUtils.isEmpty(higherSopContentId)) {
            log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{},higherSopContentId is empty", (Object)sopStageCalculate.getId());
            return;
        }
        Set higherCustomerIds = this.sopFinalCustomerMapper.selectCustomerIdBySopIdAndCustomerIds(sopStageCalculate.getSopId(), currentCustomerIds, higherSopContentId);
        if (CollectionUtils.isEmpty((Collection)higherCustomerIds)) {
            log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{},higherCustomerIds is empty", (Object)sopStageCalculate.getId());
            return;
        }
        HashSet needDelCurrentCustomerIds = new HashSet();
        for (String higherCustomerId : higherCustomerIds) {
            needDelCurrentCustomerIds.addAll((Collection)currentCustomerIdMap.get(higherCustomerId));
        }
        if (CollectionUtils.isEmpty(needDelCurrentCustomerIds)) {
            log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{},needDelCurrentCustomerIds is empty", (Object)sopStageCalculate.getId());
            return;
        }
        log.info("delCurrentCustomersWhenCustomerInHigherStage,sopStageCalculateId:{},higherSopContentId:{},higherCustomerIds:{},needDelCurrentCustomerIds:{}", new Object[]{sopStageCalculate.getId(), higherSopContentId, higherCustomerIds, needDelCurrentCustomerIds});
        this.sopFinalCustomerMapper.batchDelByIds(needDelCurrentCustomerIds);
    }

    private void delLowerStageSeqFinalCustomers(SopStageCalculate sopStageCalculate, List<SopFinalCustomer> currentCalculateSopFinalCustomerList) {
        log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{}", (Object)sopStageCalculate.getId());
        if (CollectionUtils.isEmpty(currentCalculateSopFinalCustomerList)) {
            return;
        }
        HashSet<String> currentCustomerIds = new HashSet<String>();
        HashMap<String, Set> currentCustomerIdMap = new HashMap<String, Set>();
        HashSet<Long> currentCustomerDbIds = new HashSet<Long>();
        for (SopFinalCustomer sopFinalCustomer : currentCalculateSopFinalCustomerList) {
            currentCustomerIds.add(sopFinalCustomer.getCustomerId());
            Set ids = currentCustomerIdMap.getOrDefault(sopFinalCustomer.getCustomerId(), new HashSet());
            ids.add(sopFinalCustomer.getId());
            currentCustomerIdMap.put(sopFinalCustomer.getCustomerId(), ids);
            currentCustomerDbIds.add(sopFinalCustomer.getId());
        }
        log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{}, currentCustomerDbIds:{}", (Object)sopStageCalculate.getId(), currentCustomerDbIds);
        SopContent selectContent = new SopContent();
        selectContent.setIsDeleted(Integer.valueOf(0));
        selectContent.setSopId(sopStageCalculate.getSopId());
        List sopContentList = this.sopContentMapper.select((Object)selectContent);
        if (CollectionUtils.isEmpty((Collection)sopContentList)) {
            log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{},sopContentList is empty", (Object)sopStageCalculate.getId());
            return;
        }
        HashSet<Long> lowerSopContentId = new HashSet<Long>();
        for (SopContent sopContent : sopContentList) {
            if (sopStageCalculate.getSopContentId().equals(sopContent.getId()) || sopContent.getStageSeq() >= sopStageCalculate.getStageSeq()) continue;
            lowerSopContentId.add(sopContent.getId());
        }
        if (CollectionUtils.isEmpty(lowerSopContentId)) {
            log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{},lowerSopContentId is empty", (Object)sopStageCalculate.getId());
            return;
        }
        Set lowerIds = this.sopFinalCustomerMapper.selectIdBySopIdAndCustomerIds(sopStageCalculate.getSopId(), currentCustomerIds, lowerSopContentId);
        if (CollectionUtils.isEmpty((Collection)lowerIds)) {
            log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{},lowerIds is empty", (Object)sopStageCalculate.getId());
            return;
        }
        log.info("delLowerStageSeqFinalCustomers,sopStageCalculateId:{},lowerSopContentId:{},lowerIds:{}", new Object[]{sopStageCalculate.getId(), lowerSopContentId, lowerIds});
        this.sopFinalCustomerMapper.batchDelByIds((Collection)lowerIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SopFinalCustomer> handleCalculateByReqId(String reqId, Long sopId, Long sopContentId) {
        log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{}", new Object[]{reqId, sopId, sopContentId});
        String key = "batchInsertSopFinalCustomer:" + sopContentId;
        try {
            this.lock.lock(key);
            List<SopFinalCustomer> list = this.queryCalculateByReqId(reqId, sopId, sopContentId);
            return list;
        }
        catch (Exception e) {
            log.error("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},queryCalculateByReqId error", new Object[]{reqId, sopId, sopContentId, e});
        }
        finally {
            this.lock.unlock(key);
        }
        return Collections.emptyList();
    }

    private List<SopFinalCustomer> queryCalculateByReqId(String reqId, Long sopId, Long sopContentId) {
        log.info("queryCalculateByReqId,reqId:{},sopId:{},sopContentId:{}", new Object[]{reqId, sopId, sopContentId});
        OperatorResult operatorResult = this.operatorResultService.queryByRequestId(reqId);
        if (operatorResult == null) {
            log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},\u67e5\u8be2\u8ba1\u7b97\u7ed3\u679c\u4e3a\u7a7a", new Object[]{reqId, sopId, sopContentId});
            return Collections.emptyList();
        }
        if (!OperatorResultStatus.FINISH.getStatus().equals(operatorResult.getStatus())) {
            log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},\u8ba1\u7b97\u72b6\u6001\u4e0d\u662f\u6210\u529f,operatorResult:{}", new Object[]{reqId, sopId, sopContentId, operatorResult.getStatus()});
            return Collections.emptyList();
        }
        log.info("queryCalculateByReqId,reqId:{},sopId:{},sopContentId:{},operatorResult:{}", new Object[]{reqId, sopId, sopContentId, operatorResult});
        List list = operatorResult.getList();
        ArrayList<SopFinalCustomer> insertFinalCustomerList = new ArrayList<SopFinalCustomer>();
        Date now = new Date();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OperatorResultItemDto>(Comparator.comparing(o -> o.getCustomerId() + ";" + o.getMemberId()))), ArrayList::new));
        }
        SopFinalCustomer selectFinalCustomer = new SopFinalCustomer();
        selectFinalCustomer.setIsDeleted(Integer.valueOf(0));
        selectFinalCustomer.setSopId(sopId);
        selectFinalCustomer.setSopContentId(sopContentId);
        List sopFinalCustomerList = this.sopFinalCustomerMapper.select((Object)selectFinalCustomer);
        if (CollectionUtils.isNotEmpty((Collection)sopFinalCustomerList)) {
            if (CollectionUtils.isEmpty((Collection)list)) {
                Set ids = sopFinalCustomerList.stream().map(SopFinalCustomer::getId).collect(Collectors.toSet());
                this.sopFinalCustomerMapper.batchDelByIds(ids);
                log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},\u67e5\u51fa\u7684\u96c6\u5408\u4e3a\u7a7a,\u5c06\u4e4b\u524d\u67e5\u51fa\u7684\u6570\u636e\u5220\u9664,ids:{}", new Object[]{reqId, sopId, sopContentId, ids});
                return Collections.emptyList();
            }
            HashMap<String, Set> oldSopFinalCustomerMap = new HashMap<String, Set>();
            for (Object sopFinalCustomer : sopFinalCustomerList) {
                String key = sopFinalCustomer.getUserId() + "$" + sopFinalCustomer.getCustomerId();
                Set ids = oldSopFinalCustomerMap.getOrDefault(key, new HashSet());
                ids.add(sopFinalCustomer.getId());
                oldSopFinalCustomerMap.put(key, ids);
            }
            HashSet<String> newSopFinalCustomer = new HashSet<String>();
            for (OperatorResultItemDto operatorResultItemDto : list) {
                newSopFinalCustomer.add(operatorResultItemDto.getMemberId() + "$" + operatorResultItemDto.getCustomerId());
            }
            HashSet needDelOldSopFinalCustomer = new HashSet(oldSopFinalCustomerMap.keySet());
            needDelOldSopFinalCustomer.removeAll(newSopFinalCustomer);
            if (CollectionUtils.isNotEmpty(needDelOldSopFinalCustomer)) {
                HashSet ids = new HashSet();
                for (String key : needDelOldSopFinalCustomer) {
                    ids.addAll((Collection)oldSopFinalCustomerMap.get(key));
                }
                if (CollectionUtils.isNotEmpty(ids)) {
                    this.sopFinalCustomerMapper.batchDelByIds(ids);
                    log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},\u5c06\u4e0d\u5728\u65b0\u67e5\u8be2\u7ed3\u679c\u4e2d \u4e4b\u524d\u67e5\u51fa\u7684\u6570\u636e\u5220\u9664,ids:{}", new Object[]{reqId, sopId, sopContentId, ids});
                }
            }
            HashSet needInsertSopFinalCustomer = new HashSet(newSopFinalCustomer);
            needInsertSopFinalCustomer.removeAll(oldSopFinalCustomerMap.keySet());
            if (CollectionUtils.isNotEmpty(needInsertSopFinalCustomer)) {
                for (String key : needInsertSopFinalCustomer) {
                    String[] split = key.split("\\$");
                    SopFinalCustomer sopFinalCustomer = this.buildFinalCustomerByOperatorResultItemDto(operatorResult.getBizId(), sopId, sopContentId, Long.parseLong(split[0]), split[1], operatorResult.getCustomerType(), now);
                    insertFinalCustomerList.add(sopFinalCustomer);
                }
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Collections.emptyList();
            }
            for (OperatorResultItemDto operatorResultItemDto : list) {
                SopFinalCustomer sopFinalCustomer = this.buildFinalCustomerByOperatorResultItemDto(operatorResult.getBizId(), sopId, sopContentId, Long.parseLong(operatorResultItemDto.getMemberId()), operatorResultItemDto.getCustomerId(), operatorResult.getCustomerType(), now);
                insertFinalCustomerList.add(sopFinalCustomer);
            }
        }
        if (CollectionUtils.isNotEmpty(insertFinalCustomerList)) {
            this.sopFinalCustomerMapper.batchInsert(insertFinalCustomerList);
            log.info("handleCalculateByReqId,reqId:{},sopId:{},sopContentId:{},\u63d2\u5165\u65b0\u67e5\u7b5b\u9009\u51fa\u7684\u5ba2\u6237,size:{}", new Object[]{reqId, sopId, sopContentId, insertFinalCustomerList.size()});
        }
        return this.sopFinalCustomerMapper.select((Object)selectFinalCustomer);
    }

    private SopFinalCustomer buildFinalCustomerByOperatorResultItemDto(Long bizId, Long sopId, Long sopContentId, Long userId, String customerId, Integer customerType, Date now) {
        SopFinalCustomer insert = new SopFinalCustomer();
        insert.setBizId(bizId);
        insert.setSopId(sopId);
        insert.setSopContentId(sopContentId);
        insert.setUserId(userId);
        insert.setCustomerId(customerId);
        insert.setCustomerType(customerType);
        insert.setTmpStep(Long.valueOf(0L));
        insert.setCreateBy(Long.valueOf(-1L));
        insert.setCreateTime(now);
        insert.setUpdateBy(Long.valueOf(-1L));
        insert.setUpdateTime(now);
        insert.setIsDeleted(Integer.valueOf(0));
        return insert;
    }

    @Override
    public void executeTasksInAdvance(Long sopId) {
        List<SopFinalCustomerBatchUpdateDto> updateDtos;
        Date now = new Date();
        DateTime endExecuteTime = DateUtil.offsetSecond((Date)now, (int)this.taskDetailFeatureSeconds);
        log.info("executeTasksInAdvance start,now:{},endExecuteTime:{}", (Object)now, (Object)endExecuteTime);
        List sopTaskDetails = this.sopTaskDetailMapper.selectByStatusAndLessThanRunTime(Integer.valueOf(TaskRunStatusEnum.WAIT_EXECUTE.getStatus()), (Date)endExecuteTime, sopId);
        if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
            log.info("executeTasksInAdvance end,sopTaskDetails is empty,endExecuteTime:{}", (Object)endExecuteTime);
            return;
        }
        HashSet<Long> sopIds = new HashSet<Long>();
        HashMap<Long, Object> sopAndUserMap = new HashMap<Long, Object>();
        for (SopTaskDetail sopTaskDetail : sopTaskDetails) {
            sopIds.add(sopTaskDetail.getSopId());
            Set userIds = sopAndUserMap.getOrDefault(sopTaskDetail.getSopId(), new HashSet());
            userIds.add(sopTaskDetail.getUserId());
            sopAndUserMap.put(sopTaskDetail.getSopId(), userIds);
        }
        Set enableSopIds = this.sopMapper.selectSopIdByIsEnable(Integer.valueOf(1), sopIds);
        HashMap existNewSopUserMap = new HashMap();
        for (Map.Entry entry : sopAndUserMap.entrySet()) {
            Set<Long> userIds = this.existRecentUpdateSopUsers((Long)entry.getKey(), (Collection)entry.getValue());
            if (!CollectionUtils.isNotEmpty(userIds)) continue;
            existNewSopUserMap.put(entry.getKey(), userIds);
        }
        HashMap<Long, MutablePair> templateTimesTaskMap = new HashMap<Long, MutablePair>();
        HashMap<Long, MutablePair> hashMap = new HashMap<Long, MutablePair>();
        HashMap<String, List<SopTaskDetail>> smsRunTimeMobilesMap = new HashMap<String, List<SopTaskDetail>>();
        HashMap<String, List<SopTaskDetail>> batchAddFriendRunTimeMobilesMap = new HashMap<String, List<SopTaskDetail>>();
        HashMap<String, List<SopTaskDetail>> manualCallRunTimeMobilesMap = new HashMap<String, List<SopTaskDetail>>();
        HashMap<String, List<SopTaskDetail>> groupSendDetailMap = new HashMap<String, List<SopTaskDetail>>();
        for (SopTaskDetail sopTaskDetail : sopTaskDetails) {
            List mobiles;
            String key;
            SopTemplateTimes sopTemplateTimes;
            MutablePair timesMutablePair;
            SopTemplateTimesTask sopTemplateTimesTask;
            log.info("executeTasksInAdvance,sopTaskDetail:{}", (Object)sopTaskDetail);
            if (!enableSopIds.contains(sopTaskDetail.getSopId())) {
                log.info("executeTasksInAdvance,sopTaskDetailId:{},SOP\u5df2\u7981\u7528", (Object)sopTaskDetail.getId());
                this.delSopTaskDetail(sopTaskDetail, now);
                continue;
            }
            Set existNewSopUserIds = (Set)existNewSopUserMap.get(sopTaskDetail.getSopId());
            if (CollectionUtils.isNotEmpty((Collection)existNewSopUserIds) && existNewSopUserIds.contains(sopTaskDetail.getUserId())) {
                log.info("executeTasksInAdvance,sopTaskDetailId:{},\u5458\u5de5\u5b58\u5728\u65b0\u521b\u5efa\u7684SOP\u4e2d", (Object)sopTaskDetail.getId());
                this.delSopTaskDetail(sopTaskDetail, now);
                continue;
            }
            MutablePair timesTaskMutablePair = (MutablePair)templateTimesTaskMap.get(sopTaskDetail.getSopTaskTemplateTimesTaskId());
            if (timesTaskMutablePair != null && ((Boolean)timesTaskMutablePair.getLeft()).booleanValue()) {
                log.info("executeTasksInAdvance,sopTaskDetailId:{},\u6a21\u677f\u6b21\u6570\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object)sopTaskDetail.getId());
                this.delSopTaskDetail(sopTaskDetail, now);
                continue;
            }
            if (timesTaskMutablePair == null) {
                SopTemplateTimesTask select = new SopTemplateTimesTask();
                select.setIsDeleted(Integer.valueOf(0));
                select.setId(sopTaskDetail.getSopTaskTemplateTimesTaskId());
                sopTemplateTimesTask = (SopTemplateTimesTask)this.sopTemplateTimesTaskMapper.selectOne((Object)select);
                timesTaskMutablePair = MutablePair.of((Object)(sopTemplateTimesTask == null ? 1 : 0), (Object)sopTemplateTimesTask);
                templateTimesTaskMap.put(sopTaskDetail.getSopTaskTemplateTimesTaskId(), timesTaskMutablePair);
                if (sopTemplateTimesTask == null) {
                    log.info("executeTasksInAdvance,sopTaskDetailId:{},\u6a21\u677f\u6b21\u6570\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object)sopTaskDetail.getId());
                    this.delSopTaskDetail(sopTaskDetail, now);
                    continue;
                }
            } else {
                sopTemplateTimesTask = (SopTemplateTimesTask)timesTaskMutablePair.getRight();
            }
            if ((timesMutablePair = (MutablePair)hashMap.get(sopTemplateTimesTask.getTemplateTimesId())) != null && ((Boolean)timesMutablePair.getLeft()).booleanValue()) {
                log.info("executeTasksInAdvance,sopTaskDetailId:{},\u6a21\u677f\u6b21\u6570\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object)sopTaskDetail.getId());
                this.delSopTaskDetail(sopTaskDetail, now);
                continue;
            }
            if (timesMutablePair == null) {
                SopTemplateTimes select = new SopTemplateTimes();
                select.setIsDeleted(Integer.valueOf(0));
                select.setId(sopTemplateTimesTask.getTemplateTimesId());
                sopTemplateTimes = (SopTemplateTimes)this.sopTemplateTimesMapper.selectOne((Object)select);
                timesMutablePair = MutablePair.of((Object)(sopTemplateTimes == null ? 1 : 0), (Object)sopTemplateTimes);
                hashMap.put(sopTemplateTimesTask.getTemplateTimesId(), timesMutablePair);
                if (sopTemplateTimes == null) {
                    log.info("executeTasksInAdvance,sopTaskDetailId:{},\u6a21\u677f\u6b21\u6570\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object)sopTaskDetail.getId());
                    this.delSopTaskDetail(sopTaskDetail, now);
                    continue;
                }
            } else {
                sopTemplateTimes = (SopTemplateTimes)timesMutablePair.getRight();
            }
            if (!sopTemplateTimes.getSort().equals(sopTaskDetail.getTmpStep().intValue())) {
                log.info("executeTasksInAdvance,sopTaskDetailId:{},\u6a21\u677f\u6b21\u6570\u987a\u5e8f\u6539\u53d8\u4e86,tmpStep:{},timesSort:{}", new Object[]{sopTaskDetail.getId(), sopTaskDetail.getTmpStep(), sopTemplateTimes.getSort()});
                this.delSopTaskDetail(sopTaskDetail, now);
                continue;
            }
            Date runTime = sopTaskDetail.getRunTime();
            String runTimeString = DateUtil.format((Date)runTime, (String)"yyyy-MM-dd HH:mm:ss");
            Integer taskType = sopTaskDetail.getTaskType();
            if (taskType.intValue() == SopTemplateTaskTypeEnum.SMS.getValue()) {
                key = runTimeString + "$" + sopTaskDetail.getBizId() + "$" + sopTaskDetail.getSopTaskTemplateTimesTaskId() + "$" + sopTaskDetail.getSopContentId();
                mobiles = smsRunTimeMobilesMap.getOrDefault(key, new ArrayList());
                mobiles.add(sopTaskDetail);
                smsRunTimeMobilesMap.put(key, mobiles);
            }
            if (taskType.intValue() == SopTemplateTaskTypeEnum.BATCH_ADD_FRIEND.getValue()) {
                key = sopTaskDetail.getSopTaskTemplateTimesTaskId() + "$" + sopTaskDetail.getIsVip() + "$" + sopTaskDetail.getBizId() + "$" + sopTaskDetail.getSopId() + "$" + sopTaskDetail.getSopContentId();
                mobiles = batchAddFriendRunTimeMobilesMap.getOrDefault(key, new ArrayList());
                mobiles.add(sopTaskDetail);
                batchAddFriendRunTimeMobilesMap.put(key, mobiles);
            }
            if (taskType.intValue() == SopTemplateTaskTypeEnum.MANUAL_CALL.getValue()) {
                key = runTimeString + "$" + sopTaskDetail.getBizId() + "$" + sopTaskDetail.getSopTaskTemplateTimesTaskId() + "$" + sopTaskDetail.getSopContentId() + "$" + sopTaskDetail.getSopId();
                mobiles = manualCallRunTimeMobilesMap.getOrDefault(key, new ArrayList());
                mobiles.add(sopTaskDetail);
                manualCallRunTimeMobilesMap.put(key, mobiles);
            }
            if (taskType.intValue() != SopTemplateTaskTypeEnum.WEWORK_GROUP_SEND.getValue()) continue;
            key = runTimeString + "$" + sopTaskDetail.getBizId() + "$" + sopTaskDetail.getSopTaskTemplateTimesTaskId() + "$" + sopTaskDetail.getIsVip() + "$" + sopTaskDetail.getSopContentId();
            List details = groupSendDetailMap.getOrDefault(key, new ArrayList());
            details.add(sopTaskDetail);
            groupSendDetailMap.put(key, details);
        }
        ArrayList<SopFinalCustomerBatchUpdateDto> batchUpdateDtos = new ArrayList<SopFinalCustomerBatchUpdateDto>();
        if (!smsRunTimeMobilesMap.isEmpty()) {
            try {
                updateDtos = this.createSmsTask(smsRunTimeMobilesMap);
                batchUpdateDtos.addAll(updateDtos);
            }
            catch (Exception e) {
                log.error("executeTasksInAdvance,createSmsTask error", (Throwable)e);
            }
        }
        if (!batchAddFriendRunTimeMobilesMap.isEmpty()) {
            try {
                updateDtos = this.createBatchAddFriendTask(batchAddFriendRunTimeMobilesMap);
                batchUpdateDtos.addAll(updateDtos);
            }
            catch (Exception e) {
                log.error("executeTasksInAdvance,createBatchAddFriendTask error", (Throwable)e);
            }
        }
        if (!manualCallRunTimeMobilesMap.isEmpty()) {
            try {
                updateDtos = this.createManualCallTask(manualCallRunTimeMobilesMap);
                batchUpdateDtos.addAll(updateDtos);
            }
            catch (Exception e) {
                log.error("executeTasksInAdvance,createManualCallTask error", (Throwable)e);
            }
        }
        if (!groupSendDetailMap.isEmpty()) {
            try {
                updateDtos = this.createWeworkGroupSend(groupSendDetailMap);
                batchUpdateDtos.addAll(updateDtos);
            }
            catch (Exception e) {
                log.error("executeTasksInAdvance,createWeworkGroupSend error", (Throwable)e);
            }
        }
        try {
            this.updateFinalCustomerStepWhenCreated(batchUpdateDtos);
        }
        catch (Exception e) {
            log.error("executeTasksInAdvance,updateFinalCustomerStepWhenCreated error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinalCustomerStepWhenCreated(List<SopFinalCustomerBatchUpdateDto> batchUpdateDtos) {
        log.info("updateFinalCustomerStepWhenCreated,batchUpdateDtos:{}", (Object)batchUpdateDtos.size());
        HashSet<String> keys = new HashSet<String>();
        for (SopFinalCustomerBatchUpdateDto batchUpdateDto : batchUpdateDtos) {
            String key = batchUpdateDto.getCustomerId() + "$" + batchUpdateDto.getUserId() + "$" + batchUpdateDto.getSopTaskTemplateTimesId() + "$" + batchUpdateDto.getSopContentId() + "$" + batchUpdateDto.getSopId();
            log.info("updateFinalCustomerStepWhenCreated,key:{},batchUpdateDto:{}", (Object)key, (Object)batchUpdateDto);
            if (keys.contains(key)) {
                log.info("updateFinalCustomerStepWhenCreated,key:{},contains key", (Object)key);
                continue;
            }
            keys.add(key);
            try {
                this.lock.lock(key);
                SopTaskDetail select = new SopTaskDetail();
                select.setUserId(batchUpdateDto.getUserId());
                select.setCustomerNum(batchUpdateDto.getCustomerId());
                select.setSopTaskTemplateTimesId(batchUpdateDto.getSopTaskTemplateTimesId());
                select.setSopContentId(batchUpdateDto.getSopContentId());
                select.setSopId(batchUpdateDto.getSopId());
                select.setIsDeleted(Integer.valueOf(0));
                List sopTaskDetails = this.sopTaskDetailMapper.select((Object)select);
                if (CollectionUtils.isEmpty((Collection)sopTaskDetails)) {
                    log.info("updateFinalCustomerStepWhenCreated,key:{},sopTaskDetails isEmpty", (Object)key);
                    continue;
                }
                boolean allExecute = sopTaskDetails.stream().allMatch(x -> TaskRunStatusEnum.WAIT_EXECUTE.getStatus() != x.getRunStatus().intValue());
                if (!allExecute) {
                    log.info("updateFinalCustomerStepWhenCreated,key:{},allExecute:{}", (Object)key, (Object)false);
                    continue;
                }
                SopTemplateTimesTask selectTask = new SopTemplateTimesTask();
                selectTask.setIsDeleted(Integer.valueOf(0));
                selectTask.setTemplateTimesId(batchUpdateDto.getSopTaskTemplateTimesId());
                List sopTemplateTimesTasks = this.sopTemplateTimesTaskMapper.select((Object)selectTask);
                if (CollectionUtils.isEmpty((Collection)sopTemplateTimesTasks)) {
                    log.info("updateFinalCustomerStepWhenCreated,key:{},\u901a\u8fc7\u6a21\u677f\u6b21\u6570id\u67e5\u8be2\u6b21\u6570\u4efb\u52a1\u4e3a\u7a7a", (Object)key);
                    continue;
                }
                Set taskIds = sopTemplateTimesTasks.stream().map(SopTemplateTimesTask::getId).collect(Collectors.toSet());
                Set executedTaskIds = sopTaskDetails.stream().map(SopTaskDetail::getSopTaskTemplateTimesTaskId).collect(Collectors.toSet());
                taskIds.removeAll(executedTaskIds);
                if (!CollectionUtils.isEmpty(taskIds)) {
                    log.info("updateFinalCustomerStepWhenCreated,key:{},\u5f53\u524d\u5ba2\u6237\u5728\u5f53\u524dSOP\u9636\u6bb5\u5bf9\u5e94\u7684\u4efb\u52a1\u6b21\u6570\u6ca1\u6709\u5168\u90e8\u6267\u884c\u5b8c\u6bd5,taskIds:{},executedTaskIds:{}", new Object[]{key, taskIds, executedTaskIds});
                    continue;
                }
                SopFinalCustomer selectCustomer = new SopFinalCustomer();
                selectCustomer.setIsDeleted(Integer.valueOf(0));
                selectCustomer.setCustomerId(batchUpdateDto.getCustomerId());
                selectCustomer.setUserId(batchUpdateDto.getUserId());
                selectCustomer.setSopContentId(batchUpdateDto.getSopContentId());
                selectCustomer.setSopId(batchUpdateDto.getSopId());
                List finalCustomers = this.sopFinalCustomerMapper.select((Object)selectCustomer);
                if (CollectionUtils.isEmpty((Collection)finalCustomers)) {
                    log.info("updateFinalCustomerStepWhenCreated,key:{},SopFinalCustomer isEmpty", (Object)key);
                    continue;
                }
                SopFinalCustomer sopFinalCustomer = (SopFinalCustomer)finalCustomers.get(0);
                log.info("updateFinalCustomerStepWhenCreated,key:{},sopFinalCustomer:{},\u66f4\u65b0\u5ba2\u6237tmpStep", (Object)key, (Object)sopFinalCustomer);
                this.sopFinalCustomerMapper.batchUpdateStep(Collections.singletonList(batchUpdateDto));
            }
            catch (Exception e) {
                log.info("updateFinalCustomerStepWhenCreated, error", (Throwable)e);
            }
            finally {
                this.lock.unlock(key);
            }
        }
    }

    private List<SopFinalCustomerBatchUpdateDto> createWeworkGroupSend(Map<String, List<SopTaskDetail>> groupSendDetailMap) {
        log.info("createWeworkGroupSend");
        HashMap<Long, BusinessCustomer> businessCustomerMap = new HashMap<Long, BusinessCustomer>();
        ArrayList<SopFinalCustomerBatchUpdateDto> updateStepCustomers = new ArrayList<SopFinalCustomerBatchUpdateDto>();
        for (Map.Entry<String, List<SopTaskDetail>> entry : groupSendDetailMap.entrySet()) {
            String key = entry.getKey();
            String[] ids = key.split("\\$");
            String runTimeString = ids[0];
            Long bizId = Long.valueOf(ids[1]);
            Long sopTaskTemplateTimesId = Long.valueOf(ids[2]);
            Integer isVip = Integer.parseInt(ids[3]);
            List<SopTaskDetail> taskDetails = entry.getValue();
            AddOrModInnerGroupSendReq req = new AddOrModInnerGroupSendReq();
            req.setTaskName("\u8425\u9500SOP\u4f01\u5fae\u7fa4\u53d1");
            req.setSendType(Integer.valueOf(1));
            req.setSendTime((Date)DateUtil.parse((CharSequence)runTimeString, (String)"yyyy-MM-dd HH:mm:ss"));
            req.setReceiveType(Integer.valueOf(ReceiveType.CONTACT.getType()));
            req.setVisible(NumberUtils.INTEGER_ZERO);
            GroupSendDto groupSendDto = (GroupSendDto)JSONObject.parseObject((String)taskDetails.get(0).getTaskContent(), GroupSendDto.class);
            req.setFkTaskId(groupSendDto.getFkTaskId());
            req.setFkType(groupSendDto.getFkType());
            req.setContentList(groupSendDto.getContentList());
            ArrayList<WeworkUserSendTargetPair> sendTargetList = new ArrayList<WeworkUserSendTargetPair>();
            req.setBizId(bizId);
            if (!businessCustomerMap.containsKey(bizId)) {
                BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                if (businessCustomer == null) continue;
                req.setCorpId(businessCustomer.getCorpId());
                businessCustomerMap.put(bizId, businessCustomer);
            } else {
                req.setCorpId(((BusinessCustomer)businessCustomerMap.get(bizId)).getCorpId());
            }
            HashSet<Long> userIds = new HashSet<Long>();
            HashSet<String> weworkContactIds = new HashSet<String>();
            HashSet<Long> detailIds = new HashSet<Long>();
            ArrayList<SopTaskDetail> executedDetails = new ArrayList<SopTaskDetail>();
            for (SopTaskDetail sopTaskDetail : taskDetails) {
                weworkContactIds.add(sopTaskDetail.getCustomerId());
                userIds.add(sopTaskDetail.getUserId());
            }
            log.info("createWeworkGroupSend,runTimeString:{},bizId:{},sopTaskTemplateTimesId:{},isVip:{},detailIds:{}", new Object[]{runTimeString, bizId, sopTaskTemplateTimesId, isVip, detailIds});
            List weworkUserInfos = this.weworkUserMapper.queryWeworkUserByBizIdUserIds(bizId, userIds);
            Map weworkUserInfoMap = weworkUserInfos.stream().collect(Collectors.toMap(WeworkUserInfo::getUserId, Function.identity()));
            if (isVip.equals(1)) {
                req.setTaskType(Integer.valueOf(GroupSendTaskType.VIP_GROUP_SEND_CUSTOMER.getValue()));
                HashMap weworkContactIdAndDigitIdMap = new HashMap();
                Map map = this.convertServiceImpl.execConvert(bizId, weworkContactIds, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_ID, (IOperatorResultType)OperatorResultCustomerType.WEWORK_CONTACT_DIGIT_ID);
                if (!map.isEmpty()) {
                    map.forEach((k, v) -> {
                        log.info("createWeworkGroupSend,runTimeString:{},bizId:{},sopTaskTemplateTimesId:{},isVip:{},weworkContactId to digitId,{}:{}", new Object[]{runTimeString, bizId, sopTaskTemplateTimesId, isVip, k, v});
                        if (v == null) {
                            return;
                        }
                        String weworkDigitId = v instanceof String ? (String)v : v.toString();
                        weworkContactIdAndDigitIdMap.put((String)k, weworkDigitId);
                    });
                }
                for (SopTaskDetail taskDetail : taskDetails) {
                    WeworkUserInfo weworkUserInfo = (WeworkUserInfo)weworkUserInfoMap.get(taskDetail.getUserId());
                    if (weworkUserInfo == null) {
                        log.info("createWeworkGroupSend,\u901a\u8fc7userId\u83b7\u53d6\u4e0d\u5230WeworkUserInfo,userId:{}", (Object)taskDetail.getUserId());
                        continue;
                    }
                    String weworkUserDigitId = weworkUserInfo.getWeworkDigitId();
                    if (StringUtils.isBlank((CharSequence)weworkUserDigitId)) {
                        log.info("createWeworkGroupSend,\u901a\u8fc7userId\u5bf9\u5e94\u7684weworkUserDigitId\u4e3a\u7a7a");
                        continue;
                    }
                    String weworkContactDigitId = (String)weworkContactIdAndDigitIdMap.get(taskDetail.getCustomerId());
                    if (StringUtils.isBlank((CharSequence)weworkContactDigitId)) {
                        log.info("createWeworkGroupSend,\u901a\u8fc7customerNum\u83b7\u53d6\u4e0d\u5230weworkContactDigitId,customerNum:{}", (Object)taskDetail.getCustomerId());
                        continue;
                    }
                    WeworkUserSendTargetPair pair = new WeworkUserSendTargetPair();
                    pair.setWeworkUserNum(weworkUserInfo.getNum());
                    pair.setTargetId(taskDetail.getCustomerId());
                    pair.setWeworkDigitId(weworkUserDigitId);
                    pair.setTargetDigitId(weworkContactDigitId);
                    sendTargetList.add(pair);
                    detailIds.add(taskDetail.getId());
                    executedDetails.add(taskDetail);
                }
            } else {
                req.setTaskType(Integer.valueOf(GroupSendTaskType.QYAPI.getValue()));
                for (SopTaskDetail taskDetail : taskDetails) {
                    WeworkUserInfo weworkUserInfo = (WeworkUserInfo)weworkUserInfoMap.get(taskDetail.getUserId());
                    if (weworkUserInfo == null) {
                        log.info("");
                        continue;
                    }
                    WeworkUserSendTargetPair pair = new WeworkUserSendTargetPair();
                    pair.setWeworkUserNum(weworkUserInfo.getNum());
                    pair.setTargetId(taskDetail.getCustomerId());
                    sendTargetList.add(pair);
                    detailIds.add(taskDetail.getId());
                    executedDetails.add(taskDetail);
                }
            }
            req.setSendTargetPairs(sendTargetList);
            if (req.getSendTime().before(new Date())) {
                this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, null, null, Integer.valueOf(TaskRunStatusEnum.UNEXECUTE.getStatus()));
                return updateStepCustomers;
            }
            try {
                log.info("createWeworkGroupSend,sopTaskTemplateTimesId:{},runTimeString:{},req:{}", new Object[]{sopTaskTemplateTimesId, runTimeString, req});
                MessageGroupSendTask messageGroupSendTask = this.groupSendWrapService.addOrModInnerGroupSend(req);
                log.info("createWeworkGroupSend,sopTaskTemplateTimesId:{},runTimeString:{},taskId:{}", new Object[]{sopTaskTemplateTimesId, runTimeString, messageGroupSendTask.getId()});
                this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, messageGroupSendTask.getId(), null, Integer.valueOf(TaskRunStatusEnum.CREATED.getStatus()));
                for (SopTaskDetail taskDetail : executedDetails) {
                    SopFinalCustomerBatchUpdateDto batchUpdateDto = new SopFinalCustomerBatchUpdateDto();
                    batchUpdateDto.setSopId(taskDetail.getSopId());
                    batchUpdateDto.setSopContentId(taskDetail.getSopContentId());
                    batchUpdateDto.setUserId(taskDetail.getUserId());
                    batchUpdateDto.setCustomerId(taskDetail.getCustomerNum());
                    batchUpdateDto.setSopTaskTemplateTimesId(taskDetail.getSopTaskTemplateTimesId());
                    batchUpdateDto.setSopTaskTemplateId(taskDetail.getSopTaskTemplateId());
                    updateStepCustomers.add(batchUpdateDto);
                }
            }
            catch (Exception e) {
                log.error("createWeworkGroupSend,addOrModInnerGroupSend error", (Throwable)e);
            }
        }
        return updateStepCustomers;
    }

    private List<SopFinalCustomerBatchUpdateDto> createManualCallTask(Map<String, List<SopTaskDetail>> manualCallRunTimeMobilesMap) {
        HashMap<Long, BusinessCustomer> businessCustomerMap = new HashMap<Long, BusinessCustomer>();
        HashMap<Long, String> userIdMap = new HashMap<Long, String>();
        ArrayList<SopFinalCustomerBatchUpdateDto> updateStepCustomers = new ArrayList<SopFinalCustomerBatchUpdateDto>();
        HashMap<Long, SopTemplateTimesTask> taskMap = new HashMap<Long, SopTemplateTimesTask>();
        for (Map.Entry<String, List<SopTaskDetail>> entry : manualCallRunTimeMobilesMap.entrySet()) {
            SopTemplateTimesTask sopTemplateTimesTask;
            String runTimeBizId = entry.getKey();
            String[] runTimeAndBizId = runTimeBizId.split("\\$");
            String runTimeString = runTimeAndBizId[0];
            Long bizId = Long.valueOf(runTimeAndBizId[1]);
            Long sopTaskTemplateTimesTaskId = Long.valueOf(runTimeAndBizId[2]);
            Long sopId = Long.valueOf(runTimeAndBizId[4]);
            List<SopTaskDetail> sopTaskDetails = entry.getValue();
            Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
            if (!taskMap.containsKey(sopTaskTemplateTimesTaskId) && (sopTemplateTimesTask = (SopTemplateTimesTask)this.sopTemplateTimesTaskMapper.selectByPrimaryKey((Object)sopTaskTemplateTimesTaskId)) != null) {
                if (sopTemplateTimesTask.getExpectCompleteTime() != null) {
                    String runDayString = DateUtil.format((Date)sopTaskDetails.get(0).getRunTime(), (String)"yyyy-MM-dd");
                    String completeTimeString = DateUtil.format((Date)sopTemplateTimesTask.getExpectCompleteTime(), (String)"HH:mm:ss");
                    DateTime completeTime = DateUtil.parse((CharSequence)(runDayString + " " + completeTimeString), (String)"yyyy-MM-dd HH:mm:ss");
                    sopTemplateTimesTask.setExpectCompleteTime((Date)completeTime);
                }
                taskMap.put(sopTaskTemplateTimesTaskId, sopTemplateTimesTask);
            }
            HashSet<Long> detailIds = new HashSet<Long>();
            ArrayList<SopTaskDetail> executeDetails = new ArrayList<SopTaskDetail>();
            ArrayList<String> userIds = new ArrayList<String>();
            ArrayList<CustomerDto> customers = new ArrayList<CustomerDto>();
            for (SopTaskDetail sopTaskDetail : sopTaskDetails) {
                detailIds.add(sopTaskDetail.getId());
                executeDetails.add(sopTaskDetail);
                CustomerDto dto = new CustomerDto();
                dto.setPhone(sopTaskDetail.getCustomerId());
                dto.setUserId(sopTaskDetail.getUserId());
                customers.add(dto);
                String userNum = (String)userIdMap.get(sopTaskDetail.getUserId());
                if (StringUtils.isBlank((CharSequence)userNum)) {
                    User user = (User)this.userMapper.selectByPrimaryKey((Object)sopTaskDetail.getUserId());
                    if (user == null) continue;
                    userIdMap.put(sopTaskDetail.getUserId(), user.getNum());
                    userIds.add(user.getNum());
                    continue;
                }
                userIds.add(userNum);
            }
            ManualCallDto manualCallDto = (ManualCallDto)JSONObject.parseObject((String)sopTaskDetails.get(0).getTaskContent(), ManualCallDto.class);
            CallTaskReqDto reqDto = new CallTaskReqDto();
            reqDto.setCustomers(customers);
            reqDto.setName(manualCallDto.getTaskName());
            reqDto.setType(Integer.valueOf(0));
            reqDto.setAllocMode(Integer.valueOf(-1));
            reqDto.setSendType(Integer.valueOf(1));
            reqDto.setSendTime(sopTaskDetails.get(0).getRunTime());
            reqDto.setBizId(bizId);
            reqDto.setUserIds(userIds);
            SopTemplateTimesTask sopTemplateTimesTask2 = (SopTemplateTimesTask)taskMap.get(sopTaskTemplateTimesTaskId);
            if (sopTemplateTimesTask2 != null && sopTemplateTimesTask2.getExpectCompleteTime() != null) {
                reqDto.setPlanCompleteTime(sopTemplateTimesTask2.getExpectCompleteTime());
            }
            reqDto.setCreateBy(sop != null ? sop.getCreateBy() : null);
            if (!businessCustomerMap.containsKey(bizId)) {
                BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                if (businessCustomer == null) continue;
                reqDto.setCorpId(businessCustomer.getCorpId());
                businessCustomerMap.put(bizId, businessCustomer);
            } else {
                reqDto.setCorpId(((BusinessCustomer)businessCustomerMap.get(bizId)).getCorpId());
            }
            try {
                log.info("createManualCallTask,sopTaskTemplateTimesTaskId:{},runTimeString:{},req:{}", new Object[]{sopTaskTemplateTimesTaskId, runTimeString, reqDto});
                Long taskId = this.callTaskService.create(reqDto);
                log.info("createManualCallTask,sopTaskTemplateTimesTaskId:{},runTimeString:{},taskId:{}", new Object[]{sopTaskTemplateTimesTaskId, runTimeString, taskId});
                this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, taskId, null, Integer.valueOf(TaskRunStatusEnum.CREATED.getStatus()));
                for (SopTaskDetail sopTaskDetail : executeDetails) {
                    SopFinalCustomerBatchUpdateDto batchUpdateDto = new SopFinalCustomerBatchUpdateDto();
                    batchUpdateDto.setSopId(sopTaskDetail.getSopId());
                    batchUpdateDto.setSopContentId(sopTaskDetail.getSopContentId());
                    batchUpdateDto.setUserId(sopTaskDetail.getUserId());
                    batchUpdateDto.setCustomerId(sopTaskDetail.getCustomerNum());
                    batchUpdateDto.setSopTaskTemplateTimesId(sopTaskDetail.getSopTaskTemplateTimesId());
                    batchUpdateDto.setSopTaskTemplateId(sopTaskDetail.getSopTaskTemplateId());
                    updateStepCustomers.add(batchUpdateDto);
                }
            }
            catch (Exception e) {
                log.error("createManualCallTask,sopTaskTemplateTimesTaskId:{},runTimeString:{},req:{},createTask error", new Object[]{sopTaskTemplateTimesTaskId, runTimeString, reqDto, e});
            }
        }
        return updateStepCustomers;
    }

    private List<SopFinalCustomerBatchUpdateDto> createBatchAddFriendTask(Map<String, List<SopTaskDetail>> batchAddFriendRunTimeMobilesMap) {
        log.info("createBatchAddFriendTask");
        HashMap<Long, BusinessCustomer> businessCustomerMap = new HashMap<Long, BusinessCustomer>();
        ArrayList<SopFinalCustomerBatchUpdateDto> updateStepCustomers = new ArrayList<SopFinalCustomerBatchUpdateDto>();
        for (Map.Entry<String, List<SopTaskDetail>> entry : batchAddFriendRunTimeMobilesMap.entrySet()) {
            SopFinalCustomerBatchUpdateDto customerBatchUpdateDto;
            Long taskId;
            BatchAddFriendDto batchAddFriendDto;
            BusinessCustomer businessCustomer;
            VipAddFriendAddReqDto reqDto;
            Object dto;
            AbstractCollection weworkUserNums;
            Map<Long, Object> userIdMap;
            String key = entry.getKey();
            String[] ids = key.split("\\$");
            Long sopTaskTemplateTimesId = Long.valueOf(ids[0]);
            Integer isVip = Integer.valueOf(ids[1]);
            Long bizId = Long.valueOf(ids[2]);
            Long sopId = Long.valueOf(ids[3]);
            Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
            List<SopTaskDetail> taskDetails = entry.getValue();
            SopTaskDetail sopTaskDetail = taskDetails.get(0);
            HashSet<Long> userIds = new HashSet<Long>();
            for (SopTaskDetail taskDetail : taskDetails) {
                userIds.add(taskDetail.getUserId());
            }
            List weworkUserInfos = this.weworkUserMapper.queryWeworkUserByBizIdUserIds(bizId, userIds);
            if (CollectionUtils.isEmpty((Collection)weworkUserInfos)) {
                log.info("createBatchAddFriendTask,weworkUserInfos is empty,userIds:{}", userIds);
                continue;
            }
            HashSet<TelAndRemarkDto> telAndRemarkDtoList = new HashSet<TelAndRemarkDto>();
            HashSet<Long> detailIds = new HashSet<Long>();
            ArrayList<SopTaskDetail> executeDetails = new ArrayList<SopTaskDetail>();
            if (isVip.equals(1)) {
                userIdMap = weworkUserInfos.stream().collect(Collectors.toMap(WeworkUserInfo::getUserId, Function.identity()));
                weworkUserNums = new ArrayList();
                for (SopTaskDetail taskDetail : taskDetails) {
                    WeworkUserInfo weworkUserInfo = (WeworkUserInfo)userIdMap.get(taskDetail.getUserId());
                    detailIds.add(taskDetail.getId());
                    executeDetails.add(taskDetail);
                    weworkUserNums.add(weworkUserInfo.getNum());
                    dto = new TelAndRemarkDto();
                    dto.setTel(taskDetail.getCustomerId());
                    dto.setWeworkUserNum(weworkUserInfo.getNum());
                    telAndRemarkDtoList.add((TelAndRemarkDto)dto);
                }
                if (CollectionUtils.isEmpty(telAndRemarkDtoList)) {
                    log.info("createBatchAddFriendTask,telAndRemarkDtoList is empty");
                    return Collections.emptyList();
                }
                reqDto = new VipAddFriendAddReqDto();
                reqDto.setBizId(bizId);
                reqDto.setWeworkUserNums(weworkUserNums);
                reqDto.setAddType(Integer.valueOf(TelAddType.MANUAL.getValue()));
                reqDto.setTelAndRemarkDtos(telAndRemarkDtoList);
                reqDto.setIsMarketingSop(Boolean.valueOf(true));
                reqDto.setIsDistinct(Integer.valueOf(0));
                reqDto.setUserId(sop != null ? sop.getCreateBy() : null);
                reqDto.setTaskName("\u8425\u9500SOP\u6279\u91cf\u52a0\u597d\u53cb");
                reqDto.setTaskType(Integer.valueOf(AddFriendsTaskType.ENHANCE_ADD.getValue()));
                reqDto.setAllocType(NumberUtils.INTEGER_ZERO);
                if (!businessCustomerMap.containsKey(bizId)) {
                    businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                    if (businessCustomer == null) continue;
                    reqDto.setCorpId(businessCustomer.getCorpId());
                    businessCustomerMap.put(bizId, businessCustomer);
                } else {
                    reqDto.setCorpId(((BusinessCustomer)businessCustomerMap.get(bizId)).getCorpId());
                }
                batchAddFriendDto = (BatchAddFriendDto)JSONObject.parseObject((String)sopTaskDetail.getTaskContent(), BatchAddFriendDto.class);
                if (StringUtils.isNotBlank((CharSequence)batchAddFriendDto.getFriendRemark())) {
                    reqDto.setFriendRemark(batchAddFriendDto.getFriendRemark());
                }
                if (batchAddFriendDto.getFriendWelcomeDto() != null) {
                    reqDto.setFriendWelcome(batchAddFriendDto.getFriendWelcomeDto());
                }
                if (CollectionUtils.isNotEmpty(batchAddFriendDto.getTagIds())) {
                    reqDto.setTagIds(new HashSet<String>(batchAddFriendDto.getTagIds()));
                }
                try {
                    log.info("createBatchAddFriendTask,vipFriendService,sopTaskTemplateTimesId:{},req:{}", (Object)sopTaskTemplateTimesId, (Object)reqDto);
                    taskId = this.vipFriendService.add(reqDto);
                    log.info("createBatchAddFriendTask,vipFriendService,sopTaskTemplateTimesId:{},taskId:{}", (Object)sopTaskTemplateTimesId, (Object)taskId);
                    this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, taskId, null, Integer.valueOf(TaskRunStatusEnum.CREATED.getStatus()));
                    for (SopTaskDetail taskDetail : executeDetails) {
                        customerBatchUpdateDto = new SopFinalCustomerBatchUpdateDto();
                        customerBatchUpdateDto.setSopId(taskDetail.getSopId());
                        customerBatchUpdateDto.setSopContentId(taskDetail.getSopContentId());
                        customerBatchUpdateDto.setUserId(taskDetail.getUserId());
                        customerBatchUpdateDto.setCustomerId(taskDetail.getCustomerNum());
                        customerBatchUpdateDto.setSopTaskTemplateId(taskDetail.getSopTaskTemplateId());
                        customerBatchUpdateDto.setSopTaskTemplateTimesId(taskDetail.getSopTaskTemplateTimesId());
                        updateStepCustomers.add(customerBatchUpdateDto);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("createBatchAddFriendTask,vipFriendService,sopTaskTemplateTimesId:{},req:{},createTask error", new Object[]{sopTaskTemplateTimesId, reqDto, e});
                    continue;
                }
            }
            userIdMap = weworkUserInfos.stream().collect(Collectors.toMap(WeworkUserInfo::getUserId, WeworkUser::getNum));
            weworkUserNums = new HashSet();
            for (SopTaskDetail taskDetail : taskDetails) {
                String weworkUserNum = (String)userIdMap.get(taskDetail.getUserId());
                if (StringUtils.isBlank((CharSequence)weworkUserNum)) continue;
                detailIds.add(taskDetail.getId());
                executeDetails.add(taskDetail);
                weworkUserNums.add(weworkUserNum);
                dto = new TelAndRemarkDto();
                dto.setTel(taskDetail.getCustomerId());
                dto.setWeworkUserNum(weworkUserNum);
                telAndRemarkDtoList.add((TelAndRemarkDto)dto);
            }
            if (CollectionUtils.isEmpty(telAndRemarkDtoList)) {
                log.info("createBatchAddFriendTask,telAndRemarkDtoList is empty");
                return Collections.emptyList();
            }
            reqDto = new TelAddFriendAddReqDto();
            reqDto.setWeworkUserNums(weworkUserNums);
            reqDto.setAddType(Integer.valueOf(TelAddType.MANUAL.getValue()));
            reqDto.setTelAndRemarkDtos(telAndRemarkDtoList);
            reqDto.setIsMarketingSop(Boolean.valueOf(true));
            reqDto.setIsDistinct(Integer.valueOf(0));
            reqDto.setBizId(bizId);
            reqDto.setUserId(sop != null ? sop.getCreateBy() : null);
            reqDto.setTaskName("\u8425\u9500SOP\u6279\u91cf\u52a0\u597d\u53cb");
            if (!businessCustomerMap.containsKey(bizId)) {
                businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                if (businessCustomer == null) continue;
                reqDto.setCorpId(businessCustomer.getCorpId());
                businessCustomerMap.put(bizId, businessCustomer);
            } else {
                reqDto.setCorpId(((BusinessCustomer)businessCustomerMap.get(bizId)).getCorpId());
            }
            batchAddFriendDto = (BatchAddFriendDto)JSONObject.parseObject((String)sopTaskDetail.getTaskContent(), BatchAddFriendDto.class);
            if (StringUtils.isNotBlank((CharSequence)batchAddFriendDto.getFriendRemark())) {
                reqDto.setFriendRemark(batchAddFriendDto.getFriendRemark());
            }
            if (batchAddFriendDto.getFriendWelcomeDto() != null) {
                reqDto.setFriendWelcome(batchAddFriendDto.getFriendWelcomeDto());
            }
            if (CollectionUtils.isNotEmpty(batchAddFriendDto.getTagIds())) {
                reqDto.setTagIds(new HashSet<String>(batchAddFriendDto.getTagIds()));
            }
            try {
                taskId = this.telAddFriendService.add((TelAddFriendAddReqDto)reqDto);
                log.info("createBatchAddFriendTask,telAddFriendService,sopTaskTemplateTimesId:{},req:{},taskId:{}", new Object[]{sopTaskTemplateTimesId, reqDto, taskId});
                this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, taskId, null, Integer.valueOf(TaskRunStatusEnum.CREATED.getStatus()));
                for (SopTaskDetail executeDetail : executeDetails) {
                    customerBatchUpdateDto = new SopFinalCustomerBatchUpdateDto();
                    customerBatchUpdateDto.setSopId(executeDetail.getSopId());
                    customerBatchUpdateDto.setSopContentId(executeDetail.getSopContentId());
                    customerBatchUpdateDto.setUserId(executeDetail.getUserId());
                    customerBatchUpdateDto.setCustomerId(executeDetail.getCustomerNum());
                    customerBatchUpdateDto.setSopTaskTemplateId(executeDetail.getSopTaskTemplateId());
                    customerBatchUpdateDto.setSopTaskTemplateTimesId(executeDetail.getSopTaskTemplateTimesId());
                    updateStepCustomers.add(customerBatchUpdateDto);
                }
            }
            catch (Exception e) {
                log.error("createBatchAddFriendTask,telAddFriendService,sopTaskTemplateTimesId:{},req:{},createTask error", new Object[]{sopTaskTemplateTimesId, reqDto, e});
            }
        }
        return updateStepCustomers;
    }

    private List<SopFinalCustomerBatchUpdateDto> createSmsTask(Map<String, List<SopTaskDetail>> smsRunTimeMobilesMap) {
        HashMap<Long, BusinessCustomer> businessCustomerMap = new HashMap<Long, BusinessCustomer>();
        ArrayList<SopFinalCustomerBatchUpdateDto> updateStepCustomers = new ArrayList<SopFinalCustomerBatchUpdateDto>();
        for (Map.Entry<String, List<SopTaskDetail>> entry : smsRunTimeMobilesMap.entrySet()) {
            String runTimeBizId = entry.getKey();
            String[] runTimeAndBizId = runTimeBizId.split("\\$");
            String runTimeString = runTimeAndBizId[0];
            Long bizId = Long.valueOf(runTimeAndBizId[1]);
            Long sopTaskTemplateTimesId = Long.valueOf(runTimeAndBizId[2]);
            List<SopTaskDetail> sopTaskDetails = entry.getValue();
            HashSet<Long> detailIds = new HashSet<Long>();
            ArrayList<String> mobiles = new ArrayList<String>();
            ArrayList<CustomerDto> customers = new ArrayList<CustomerDto>();
            ArrayList<SopTaskDetail> executeDetails = new ArrayList<SopTaskDetail>();
            for (SopTaskDetail sopTaskDetail : sopTaskDetails) {
                detailIds.add(sopTaskDetail.getId());
                executeDetails.add(sopTaskDetail);
                mobiles.add(sopTaskDetail.getCustomerId());
                CustomerDto customerDto = new CustomerDto();
                customerDto.setPhone(sopTaskDetail.getCustomerId());
                customers.add(customerDto);
            }
            String taskContent = sopTaskDetails.get(0).getTaskContent();
            SmsDto smsDto = (SmsDto)JSONObject.parseObject((String)taskContent, SmsDto.class);
            SmsTaskReqDto req = new SmsTaskReqDto();
            req.setReason(smsDto.getReason());
            req.setSignatureId(smsDto.getSignatureId());
            req.setContentType(smsDto.getContentType());
            if (smsDto.getContentType() == 1) {
                req.setContent(smsDto.getContent());
            } else {
                req.setContent(smsDto.getTemplateId());
            }
            req.setPhones(mobiles);
            req.setCustomers(customers);
            req.setSendType(Integer.valueOf(1));
            req.setSendTime((Date)DateUtil.parse((CharSequence)runTimeString, (String)"yyyy-MM-dd HH:mm:ss"));
            req.setBizId(bizId);
            req.setAcquisitionLinkIds(smsDto.getAcquisitionLinkIds());
            if (!businessCustomerMap.containsKey(bizId)) {
                BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
                if (businessCustomer == null) continue;
                req.setCorpId(businessCustomer.getCorpId());
                businessCustomerMap.put(bizId, businessCustomer);
            } else {
                req.setCorpId(((BusinessCustomer)businessCustomerMap.get(bizId)).getCorpId());
            }
            try {
                log.info("createSmsTask,sopTaskTemplateTimesId:{},runTimeString:{},req:{}", new Object[]{sopTaskTemplateTimesId, runTimeString, req});
                Long taskId = this.smsTaskService.createTask(req);
                log.info("createSmsTask,sopTaskTemplateTimesId:{},runTimeString:{},taskId:{}", new Object[]{sopTaskTemplateTimesId, runTimeString, taskId});
                this.sopTaskDetailMapper.batchUpdateFkByIds(detailIds, taskId, null, Integer.valueOf(TaskRunStatusEnum.CREATED.getStatus()));
                for (SopTaskDetail sopTaskDetail : executeDetails) {
                    SopFinalCustomerBatchUpdateDto dto = new SopFinalCustomerBatchUpdateDto();
                    dto.setSopId(sopTaskDetail.getSopId());
                    dto.setSopContentId(sopTaskDetail.getSopContentId());
                    dto.setUserId(sopTaskDetail.getUserId());
                    dto.setCustomerId(sopTaskDetail.getCustomerNum());
                    dto.setSopTaskTemplateTimesId(sopTaskDetail.getSopTaskTemplateTimesId());
                    dto.setSopTaskTemplateId(sopTaskDetail.getSopTaskTemplateId());
                    updateStepCustomers.add(dto);
                }
            }
            catch (Exception e) {
                log.error("createSmsTask,sopTaskTemplateTimesId:{},runTimeString:{},req:{},createTask error", new Object[]{sopTaskTemplateTimesId, runTimeString, req, e});
            }
        }
        return updateStepCustomers;
    }

    private void delSopTaskDetail(SopTaskDetail sopTaskDetail, Date updateTime) {
        sopTaskDetail.setIsDeleted(Integer.valueOf(1));
        sopTaskDetail.setUpdateTime(updateTime);
        sopTaskDetail.setUpdateBy(Long.valueOf(-1L));
        this.sopTaskDetailMapper.updateByPrimaryKeySelective((Object)sopTaskDetail);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearWhenSopDisabled(Long sopId) {
        log.info("clearWhenSopDisabled,sopId:{}", (Object)sopId);
        Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
        if (sop == null) {
            log.error("clearWhenSopDisabled,sopId:{},sop\u4e0d\u5b58\u5728", (Object)sopId);
            return;
        }
        List sopTaskDetails = this.sopTaskDetailMapper.selectByStatusAndSopId(Integer.valueOf(TaskRunStatusEnum.WAIT_EXECUTE.getStatus()), sop.getId());
        if (CollectionUtils.isNotEmpty((Collection)sopTaskDetails)) {
            Set delIds = sopTaskDetails.stream().map(SopTaskDetail::getId).collect(Collectors.toSet());
            this.sopTaskDetailMapper.batchDelByIds(delIds);
            log.info("clearWhenSopDisabled,sopId:{},\u9700\u8981\u5220\u9664\u7684\u5f85\u6267\u884c\u4efb\u52a1:{}", (Object)sopId, delIds);
        }
        SopFinalCustomer selectCustomer = new SopFinalCustomer();
        selectCustomer.setIsDeleted(Integer.valueOf(0));
        selectCustomer.setSopId(sop.getId());
        List sopFinalCustomers = this.sopFinalCustomerMapper.select((Object)selectCustomer);
        if (CollectionUtils.isNotEmpty((Collection)sopFinalCustomers)) {
            Set delIds = sopFinalCustomers.stream().map(SopFinalCustomer::getId).collect(Collectors.toSet());
            this.sopFinalCustomerMapper.batchDelByIds(delIds);
            log.info("clearWhenSopDisabled,sopId:{},\u9700\u8981\u5220\u9664\u7684SopFinalCustomer:{}", (Object)sopId, delIds);
        }
        DelSopRemindDto dto = new DelSopRemindDto();
        dto.setSopId(sopId);
        try {
            this.remindService.delSopRemind(Collections.singletonList(dto));
        }
        catch (Exception e) {
            log.error("clearWhenSopDisabled,sopId:{},delSopRemind error", (Object)sopId, (Object)e);
        }
        List calculateIds = this.sopStageCalculateMapper.selectIdBySopIdAndStatus(sop.getId(), Arrays.asList(CalculateStatusEnum.IN_CAL.getStatus(), CalculateStatusEnum.CAL_DONE.getStatus()));
        if (CollectionUtils.isNotEmpty((Collection)calculateIds)) {
            this.sopStageCalculateMapper.batchDelByIds((Collection)calculateIds);
            log.info("clearWhenSopDisabled,sopId:{},\u9700\u8981\u5220\u9664\u7684sopStageCalculate:{}", (Object)sopId, (Object)calculateIds);
        }
        SopTaskScanLog delLog = new SopTaskScanLog();
        delLog.setSopId(sop.getId());
        this.sopTaskScanLogMapper.delete((Object)delLog);
    }

    @Override
    public void startWhenSopEnabled(Long sopId) {
        log.info("startWhenSopEnabled,sopId:{}", (Object)sopId);
        Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
        if (sop == null) {
            log.error("startWhenSopEnabled,sopId:{},sop\u4e0d\u5b58\u5728", (Object)sopId);
            return;
        }
        if (sop.getSopType() == 1) {
            try {
                SopContent select = new SopContent();
                select.setSopId(sopId);
                select.setStageSeq(Long.valueOf(0L));
                select.setIsDeleted(Integer.valueOf(0));
                SopContent sopContent = (SopContent)this.sopContentMapper.selectOne((Object)select);
                this.calculateByStaticSop(sop.getId(), sop.getBizId(), sopContent, null);
            }
            catch (Exception e) {
                log.error("startWhenSopEnabled,sopId:{},calculateByStaticSop error", (Object)sopId, (Object)e);
            }
            return;
        }
        try {
            this.doBusinessBySop(sop, false, null, null);
        }
        catch (Exception e) {
            log.error("startWhenSopEnabled, doBusinessBySop error", (Throwable)e);
        }
    }

    private void calculateByStaticSop(Long sopId, Long bizId, SopContent sopContent, List<SopUser> sopUsers) {
        log.info("calculateByStaticSop,sopId:{},bizId:{}", (Object)sopId, (Object)bizId);
        Set<Long> sopUserIds = CollectionUtils.isEmpty(sopUsers) ? this.querySopUsers(sopId) : sopUsers.stream().map(SopUser::getUserId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(sopUserIds)) {
            log.info("calculateByStaticSop,sopId:{},SOP\u6267\u884c\u5458\u5de5\u4e3a\u7a7a", (Object)sopId);
            return;
        }
        if (sopContent == null) {
            log.info("calculateByStaticSop,sopId:{},sopContent is null", (Object)sopId);
            return;
        }
        String mainReqId = this.reqCreateCalculateTask(bizId, sopContent.getId(), null);
        if (StringUtils.isBlank((CharSequence)mainReqId)) {
            log.error("calculateByStaticSop,sopId:{},\u521b\u5efa\u4e3b\u8ba1\u7b97\u4efb\u52a1\u5931\u8d25", (Object)sopId);
            return;
        }
        SopStageCalculate insertCalculate = this.buildSopStageCalculate(new Date(), bizId, sopContent.getSopId(), sopContent.getId(), mainReqId, null, mainReqId, sopContent.getStageSeq(), 1);
        this.sopStageCalculateMapper.insertSelective((Object)insertCalculate);
    }

    @Override
    public void doBusinessWhenSopCreated(Sop sop, List<SopUser> sopUsers, SopContent sopContent) {
        Set finalCustomerIds;
        Long sopId = sop.getId();
        log.info("doBusinessWhenSopCreated,sopId:{}", (Object)sopId);
        if (CollectionUtils.isEmpty(sopUsers)) {
            log.info("doBusinessWhenSopCreated,sopId:{},sop\u5458\u5de5\u4e3a\u7a7a", (Object)sopId);
            return;
        }
        Set userIds = sopUsers.stream().map(SopUser::getUserId).collect(Collectors.toSet());
        Set taskDetailIds = this.sopTaskDetailMapper.selectIdsBySopIdAndStatusAndUserIds(Integer.valueOf(TaskRunStatusEnum.WAIT_EXECUTE.getStatus()), sopId, userIds);
        if (CollectionUtils.isNotEmpty((Collection)taskDetailIds)) {
            log.info("doBusinessWhenSopCreated,sopId:{},\u5458\u5de5\u5b58\u5728\u65b0\u521b\u5efa\u7684SOP\u4e2d,userIds:{},\u5c06\u5f85\u53d1\u9001\u7684\u4efb\u52a1\u5220\u9664,taskDetailIds:{}", new Object[]{sopId, userIds, taskDetailIds});
            this.sopTaskDetailMapper.batchDelByIds((Collection)taskDetailIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(finalCustomerIds = this.sopFinalCustomerMapper.selectIdsBySopIdAndUserIds(sopId, userIds)))) {
            log.info("doBusinessWhenSopCreated,sopId:{},\u5458\u5de5\u5b58\u5728\u65b0\u521b\u5efa\u7684SOP\u4e2d,userIds:{},\u5c06\u65e7SOP\u7684sopFinalCustomer\u5220\u9664,finalCustomerIds:{}", new Object[]{sopId, userIds, finalCustomerIds});
            this.sopFinalCustomerMapper.batchDelByIds((Collection)finalCustomerIds);
        }
        try {
            this.remindService.delSopRemindByUserIds(sopContent.getBizId(), userIds);
        }
        catch (Exception e) {
            log.error("doBusinessWhenSopCreated,sopId:{},delSopRemindByUserIds error", (Object)sopId, (Object)e);
        }
        if (sop.getSopType() == 1) {
            try {
                this.calculateByStaticSop(sopId, sop.getBizId(), sopContent, sopUsers);
            }
            catch (Exception e) {
                log.error("doBusinessWhenSopCreated,sopId:{},calculateByStaticSop error", (Object)sopId, (Object)e);
            }
        }
    }

    @Override
    public void doBusinessWhenSopTemplateEdit(Long tmpId) {
        log.info("doBusinessWhenSopTemplateEdit,tmpId:{}", (Object)tmpId);
        SopTemplate sopTemplate = (SopTemplate)this.sopTemplateMapper.selectByPrimaryKey((Object)tmpId);
        if (sopTemplate == null) {
            log.error("doBusinessWhenSopTemplateEdit,tmpId:{},sop\u6a21\u677f\u4e0d\u5b58\u5728", (Object)tmpId);
            return;
        }
        SopContent selectContent = new SopContent();
        selectContent.setIsDeleted(Integer.valueOf(0));
        selectContent.setSopTmpId(sopTemplate.getId());
        List sopContents = this.sopContentMapper.select((Object)selectContent);
        if (CollectionUtils.isEmpty((Collection)sopContents)) {
            log.info("doBusinessWhenSopTemplateEdit,tmpId:{},\u6a21\u677f\u672a\u88abSOP\u5173\u8054", (Object)tmpId);
            return;
        }
        HashMap<Long, Long> sopIdContentMap = new HashMap<Long, Long>();
        Set sopContentIds = sopContents.stream().map(SopContent::getId).collect(Collectors.toSet());
        for (SopContent sopContent : sopContents) {
            sopContentIds.add(sopContent.getId());
            sopIdContentMap.put(sopContent.getSopId(), sopContent.getId());
        }
        List calculateIds = this.sopStageCalculateMapper.selectIdBySopContentIdsAndStatus(sopContentIds, Integer.valueOf(CalculateStatusEnum.IN_CAL.getStatus()));
        if (CollectionUtils.isNotEmpty((Collection)calculateIds)) {
            this.sopStageCalculateMapper.batchDelByIds((Collection)calculateIds);
            log.info("doBusinessWhenSopTemplateEdit,tmpId:{},\u8ba1\u7b97\u4e2d\u7684\u8ba1\u7b97\u4efb\u52a1\u66f4\u65b0\u4e3a\u5df2\u5220\u9664:{}", (Object)tmpId, (Object)calculateIds);
        }
        if (sopIdContentMap.isEmpty()) {
            return;
        }
        Set taskDetailIds = this.sopTaskDetailMapper.selectIdsBySopIdAndStatusAndTmpIdAndContentId(Integer.valueOf(TaskRunStatusEnum.WAIT_EXECUTE.getStatus()), tmpId, sopContentIds);
        if (CollectionUtils.isNotEmpty((Collection)taskDetailIds)) {
            this.sopTaskDetailMapper.batchDelByIds((Collection)taskDetailIds);
            log.info("doBusinessWhenSopTemplateEdit,tmpId:{},\u5f53\u524dSOP\u6a21\u677f\u5173\u8054\u7684SOP\u5f85\u6267\u884c\u7684\u4efb\u52a1:{}", (Object)tmpId, (Object)taskDetailIds);
        }
        for (Map.Entry entry : sopIdContentMap.entrySet()) {
            this.sopTaskExeService.submit(() -> {
                Long sopId = (Long)entry.getKey();
                Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
                if (sop == null || sop.getIsEnable() == 0) {
                    return;
                }
                SopTaskScanLog delLog = new SopTaskScanLog();
                delLog.setSopId(sop.getId());
                this.sopTaskScanLogMapper.delete((Object)delLog);
                try {
                    this.doBusinessBySop(sop, false, (Long)entry.getValue(), null);
                }
                catch (Exception e) {
                    log.error("doBusinessWhenSopTemplateEdit, doBusinessBySop error", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void continueExecuteWhenOccurError() {
        Date now = new Date();
        DateTime startCreateTime = DateUtil.offsetHour((Date)now, (int)-1);
        DateTime endCreateTime = DateUtil.offsetSecond((Date)now, (int)(-this.calculateNormalExpendSeconds.intValue()));
        log.info("continueExecuteWhenOccurError,start,now:{},startCreateTime:{},endCreateTime:{}", new Object[]{now, startCreateTime, endCreateTime});
        List sopStageCalculates = this.sopStageCalculateMapper.selectMainRecordByStatusAndCreateTime(Integer.valueOf(CalculateStatusEnum.IN_CAL.getStatus()), (Date)startCreateTime, (Date)endCreateTime);
        if (CollectionUtils.isEmpty((Collection)sopStageCalculates)) {
            log.info("continueExecuteWhenOccurError,end,now:{}", (Object)now);
            return;
        }
        for (SopStageCalculate mainSopStageCalculate : sopStageCalculates) {
            try {
                this.handleByMainCalculate(mainSopStageCalculate);
            }
            catch (Exception e) {
                log.error("continueExecuteWhenOccurError,now:{},handleByMainCalculate error", (Object)now, (Object)e);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void handleByMainCalculate(SopStageCalculate mainSopStageCalculate) {
        log.info("handleByMainCalculate,mainSopStageCalculateId:{}", (Object)mainSopStageCalculate.getId());
        Long sopId = mainSopStageCalculate.getSopId();
        Sop sop = (Sop)this.sopMapper.selectByPrimaryKey((Object)sopId);
        if (sop == null || sop.getIsEnable() == 0) {
            log.info("handleByMainCalculate,mainSopStageCalculateId:{},sop\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528,sopId:{}", (Object)mainSopStageCalculate.getId(), (Object)sopId);
            return;
        }
        if (mainSopStageCalculate.getIsStaticSopFirstCalculate() == 1 && sop.getIsEnable() == 1) {
            log.info("handleByMainCalculate,mainSopStageCalculateId:{},\u5f53\u524d\u8ba1\u7b97\u662f\u9759\u6001SOP\u7b2c\u4e00\u6b21\u7b5b\u9009\u7b2c\u4e00\u4e2a\u9636\u6bb5\u5ba2\u6237\u7684\u8ba1\u7b97", (Object)mainSopStageCalculate.getId());
            OperatorResultStatus operatorResultStatus = this.sopCalTaskService.queryStatus(mainSopStageCalculate.getResultRequestId());
            if (!OperatorResultStatus.FINISH.equals((Object)operatorResultStatus)) {
                log.info("handleByMainCalculate,mainSopStageCalculateId:{},\u5f53\u524d\u8ba1\u7b97\u662f\u9759\u6001SOP\u7b2c\u4e00\u6b21\u7b5b\u9009\u7b2c\u4e00\u4e2a\u9636\u6bb5\u5ba2\u6237\u7684\u8ba1\u7b97,\u4f46\u8ba1\u7b97\u7ed3\u679c\u4e0d\u662f\u6210\u529foperatorResultStatus:{}", (Object)mainSopStageCalculate.getId(), (Object)operatorResultStatus.getDesc());
                return;
            }
            try {
                this.doBusinessBySop(sop, false, mainSopStageCalculate.getSopContentId(), null);
                this.sopStageCalculateMapper.batchUpdateStatusByIds(Collections.singletonList(mainSopStageCalculate.getId()), Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
            }
            catch (Exception e) {
                log.error("handleByMainCalculate,mainSopStageCalculateId:{},doBusinessBySop error", (Object)mainSopStageCalculate.getId(), (Object)e);
            }
            return;
        }
        List allSopStageCalculate = this.sopStageCalculateMapper.selectByMainRecord(mainSopStageCalculate.getResultRequestId());
        HashMap<String, SopStageCalculate> allCalculateMap = new HashMap<String, SopStageCalculate>();
        HashSet<Long> allCalculateIds = new HashSet<Long>();
        HashSet<String> allCalculateReqIds = new HashSet<String>();
        for (SopStageCalculate sopStageCalculate : allSopStageCalculate) {
            allCalculateMap.put(sopStageCalculate.getResultRequestId(), sopStageCalculate);
            allCalculateIds.add(sopStageCalculate.getId());
            allCalculateReqIds.add(sopStageCalculate.getResultRequestId());
        }
        for (String calculateReqId : allCalculateReqIds) {
            OperatorResultStatus operatorResultStatus = this.sopCalTaskService.queryStatus(calculateReqId);
            if (OperatorResultStatus.FINISH.equals((Object)operatorResultStatus)) continue;
            log.info("handleByMainCalculate,mainSopStageCalculateId:{},\u5f53\u524d\u6279\u7684\u8ba1\u7b97\u8fd8\u6709\u672a\u5b8c\u6210\u7684,calculateReqId:{}", (Object)mainSopStageCalculate.getId(), (Object)calculateReqId);
            return;
        }
        try {
            this.handleCalculateRes(allCalculateMap, mainSopStageCalculate);
        }
        catch (Exception e) {
            log.error("handleByMainCalculate,mainSopStageCalculateId:{},handleCalculateRes error", (Object)mainSopStageCalculate.getId(), (Object)e);
            return;
        }
        this.sopStageCalculateMapper.batchUpdateStatusByIds(allCalculateIds, Integer.valueOf(CalculateStatusEnum.CAL_USED.getStatus()));
        try {
            this.doBusinessBySop(sop, true, mainSopStageCalculate.getSopContentId(), JSONObject.parseArray((String)mainSopStageCalculate.getSnapshotContent(), NextExecuteTaskDto.class));
        }
        catch (Exception e) {
            log.error("handleByMainCalculate,mainSopStageCalculateId:{},doBusinessBySop error", (Object)mainSopStageCalculate.getId(), (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6267\u884cSOP\u5224\u65ad\u903b\u8f91\u5f02\u5e38");
        }
    }

    private void handleCalculateRes(Map<String, SopStageCalculate> allCalculateMap, SopStageCalculate mainSopStageCalculate) {
        log.info("handleCalculateRes,mainSopStageCalculateId:{}", (Object)mainSopStageCalculate.getId());
        for (String reqId : allCalculateMap.keySet()) {
            List<SopFinalCustomer> currentSopFinalCustomerList;
            SopStageCalculate sopStageCalculate = allCalculateMap.get(reqId);
            try {
                currentSopFinalCustomerList = this.handleCalculateByReqId(reqId, sopStageCalculate.getSopId(), sopStageCalculate.getSopContentId());
            }
            catch (Exception e) {
                log.error("handleCalculateRes,mainSopStageCalculateId:{},handleCalculateByReqId error", (Object)sopStageCalculate.getId(), (Object)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u901a\u8fc7reqId\u67e5\u8be2\u8ba1\u7b97\u7ed3\u679c\u5f02\u5e38,reqId:" + reqId);
            }
            try {
                this.delLowerStageSeqFinalCustomers(sopStageCalculate, currentSopFinalCustomerList);
            }
            catch (Exception e) {
                log.error("handleCalculateRes,mainSopStageCalculateId:{},delLowerStageSeqFinalCustomers error", (Object)mainSopStageCalculate.getId(), (Object)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5904\u7406\u5ba2\u6237\u65c5\u7a0b\u9636\u6bb5\u4f18\u5148\u7ea7\u6570\u636e\u5f02\u5e38,reqId:" + reqId);
            }
            try {
                this.delCurrentCustomersWhenCustomerInHigherStage(sopStageCalculate, currentSopFinalCustomerList);
            }
            catch (Exception e) {
                log.error("handleCalculateRes,mainSopStageCalculateId:{},delCurrentCustomersWhenCustomerInHigherStage error", (Object)mainSopStageCalculate.getId(), (Object)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5904\u7406\u5ba2\u6237\u65c5\u7a0b\u9636\u6bb5\u4f18\u5148\u7ea7\u6570\u636e\u5f02\u5e38,reqId:" + reqId);
            }
        }
    }
}

