/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.enums.OperatorResultStatus;
import com.kuaike.scrm.dal.marketing.entity.SopCalTask;
import com.kuaike.scrm.dal.marketing.entity.SopCalTaskDetail;
import com.kuaike.scrm.dal.marketing.mapper.SopCalTaskDetailMapper;
import com.kuaike.scrm.sop.service.OperatorEngineService;
import com.kuaike.scrm.sop.service.OperatorResultService;
import com.kuaike.scrm.sop.service.SopCalTaskDetailService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SopCalTaskDetailServiceImpl
implements SopCalTaskDetailService {
    private static final Logger log = LoggerFactory.getLogger(SopCalTaskDetailServiceImpl.class);
    @Autowired
    private SopCalTaskDetailMapper sopCalTaskDetailMapper;
    @Autowired
    private OperatorEngineService operatorEngineService;
    @Autowired
    private OperatorResultService operatorResultService;
    @Value(value="${sopCalTaskDetail.zombieInvokeGap:120000}")
    private Long zombieInvokeGap;

    @Override
    public void batchInsertDetail(List<SopCalTaskDetail> list) {
        log.info("batchInsertDetail size={}", (Object)CollectionUtils.size(list));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.sopCalTaskDetailMapper.batchInsert(list);
    }

    @Override
    public SopCalTaskDetail queryById(Long id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(id), (Object)"id is null");
        return (SopCalTaskDetail)this.sopCalTaskDetailMapper.selectByPrimaryKey((Object)id);
    }

    @Override
    public void updateDetail(SopCalTaskDetail detail) {
        log.info("updateDetail with detail={}", (Object)detail);
        this.sopCalTaskDetailMapper.updateByPrimaryKey((Object)detail);
    }

    @Override
    public SopCalTaskDetail queryByRequestId(String requestId) {
        log.info("queryByRequestId with requestId={}", (Object)requestId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)requestId), (Object)"requestId is null or empty");
        return this.sopCalTaskDetailMapper.queryByRequestId(requestId);
    }

    @Override
    public SopCalTaskDetail queryLatestNeedMergeDetail(Long taskId, Long lastTaskDetailId) {
        log.info("queryLatestNeedMergeDetail with taskId={}, lastTaskDetailId={}", (Object)taskId, (Object)lastTaskDetailId);
        Preconditions.checkArgument((boolean)Objects.nonNull(taskId), (Object)"taskId is null");
        Integer seq = 0;
        if (Objects.nonNull(lastTaskDetailId)) {
            SopCalTaskDetail detail = (SopCalTaskDetail)this.sopCalTaskDetailMapper.selectByPrimaryKey((Object)lastTaskDetailId);
            seq = detail.getSeq() + 1;
        }
        return this.sopCalTaskDetailMapper.queryLatestNeedMergeDetail(taskId, seq);
    }

    @Override
    public boolean ifTaskFinish(SopCalTask task) {
        if (Objects.isNull(task) || task.getIsDeleted().booleanValue()) {
            return false;
        }
        Long maxSeqDetailId = this.sopCalTaskDetailMapper.queryIdByTaskIdMaxSeq(task.getId());
        return Objects.equals(task.getLastTaskDetailId(), maxSeqDetailId);
    }

    @Override
    public void retrySopCalTaskDetail() {
        List executingDetails;
        List<String> requestIds;
        List<OperatorResult> finishedRequest;
        log.info("retrySopCalTaskDetail start");
        List details = this.sopCalTaskDetailMapper.queryByStatus((List)Lists.newArrayList((Object[])new Integer[]{OperatorResultStatus.WAITING.getStatus()}), false, Integer.valueOf(10));
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            log.info("waiting sopCalTaskDetail size={}", (Object)details.size());
            for (SopCalTaskDetail detail : details) {
                this.operatorEngineService.callConditionOperator(detail.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(finishedRequest = this.operatorResultService.queryByRequestIds(requestIds = (executingDetails = this.sopCalTaskDetailMapper.queryByStatus((List)Lists.newArrayList((Object[])new Integer[]{OperatorResultStatus.EXECUTING.getStatus()}), true, null)).stream().map(a -> a.getResultRequestId()).filter(StringUtils::isNotBlank).collect(Collectors.toList())))) {
            Map<String, SopCalTaskDetail> detailMap = executingDetails.stream().collect(Collectors.toMap(a -> a.getResultRequestId(), a -> a));
            for (OperatorResult item : finishedRequest) {
                SopCalTaskDetail detail = detailMap.get(item.getRequestId());
                detail.setStatus(item.getStatus());
                this.sopCalTaskDetailMapper.updateByPrimaryKey((Object)detail);
                this.operatorEngineService.updateTask(detail.getTaskId());
            }
            Set finishedRequestIdSet = finishedRequest.stream().map(a -> a.getRequestId()).collect(Collectors.toSet());
            executingDetails = executingDetails.stream().filter(a -> !finishedRequestIdSet.contains(a.getResultRequestId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)executingDetails)) {
            log.info("executing sopCalTaskDetail is empty");
            return;
        }
        Map<String, Long> requestId2DetailId = executingDetails.stream().collect(Collectors.toMap(SopCalTaskDetail::getResultRequestId, SopCalTaskDetail::getId));
        if (MapUtils.isEmpty(requestId2DetailId)) {
            log.info("requestId2DetailId is empty");
            return;
        }
        List<String> zombieRequestIds = this.operatorResultService.queryZombieRequestId(requestId2DetailId.keySet(), System.currentTimeMillis() - this.zombieInvokeGap);
        if (CollectionUtils.isNotEmpty(zombieRequestIds)) {
            zombieRequestIds.stream().map(requestId2DetailId::get).forEach(a -> this.operatorEngineService.callConditionOperator((Long)a));
        }
        log.info("retrySopCalTaskDetail end");
    }

    @Override
    public void logicDelete(Long taskId) {
        log.info("logicDelete with taskId={}", (Object)taskId);
        this.sopCalTaskDetailMapper.logicDeleteByTaskId(taskId);
    }
}

