/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.enums.OperatorResultStatus;
import com.kuaike.scrm.sop.service.OperatorResultService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OperatorResultServiceImpl
implements OperatorResultService {
    private static final Logger log = LoggerFactory.getLogger(OperatorResultServiceImpl.class);
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private DistributedLock lock;
    @Value(value="${scrm.elasticsearch.operatorResultIndex}")
    private String operatorResultIndex;
    private static final String TYPE = "doc";

    @Override
    public void saveResult(OperatorResult result) {
        log.info("save operator result with data={}", (Object)result);
        Preconditions.checkArgument((boolean)Objects.nonNull(result), (Object)"result can not be null");
        result.validate();
        Map map = JacksonUtil.toMap((Object)result);
        IndexRequest indexRequest = new IndexRequest(this.operatorResultIndex, TYPE, result.getRequestId());
        indexRequest.source(map, XContentType.JSON);
        try {
            this.client.index(indexRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("save to operatorResult with error", (Throwable)e);
        }
    }

    @Override
    public void updateResult(OperatorResult result) {
        log.info("update operator result with data={}", (Object)result);
        Preconditions.checkArgument((boolean)Objects.nonNull(result), (Object)"result can not be null");
        result.validate();
        result.setUpdateTime(new Date());
        UpdateRequest updateRequest = new UpdateRequest(this.operatorResultIndex, TYPE, result.getRequestId());
        Map map = JacksonUtil.toMap((Object)result);
        updateRequest.doc(map, XContentType.JSON);
        try {
            this.client.update(updateRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("update operatorResult with error", (Throwable)e);
        }
    }

    @Override
    public OperatorResult queryByRequestId(String requestId) {
        log.info("query operator result with requestId={}", (Object)requestId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)requestId), (Object)"requestId is not null or empty");
        GetRequest getRequest = new GetRequest(this.operatorResultIndex, TYPE, requestId);
        GetResponse searchResponse = null;
        try {
            searchResponse = this.client.get(getRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("search operator result with error", (Throwable)e);
            return null;
        }
        if (Objects.isNull(searchResponse) || !searchResponse.isExists()) {
            log.error("requestId is not exists");
            return null;
        }
        try {
            String doc = searchResponse.getSourceAsString();
            return (OperatorResult)JacksonUtil.str2Obj((String)doc, OperatorResult.class);
        }
        catch (IOException e) {
            log.error("parse from json with error", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> queryZombieRequestId(Collection<String> requestIds, Long beforeUpdateTime) {
        log.info("queryZombieRequestId with beforeUpdateTime={}, requestIds={}", (Object)beforeUpdateTime, requestIds);
        if (CollectionUtils.isEmpty(requestIds)) {
            log.info("requestIds is empty,exit");
            return Lists.newArrayList();
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"requestId.keyword", requestIds)).must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)OperatorResultStatus.EXECUTING.getStatus())).must((QueryBuilder)QueryBuilders.rangeQuery((String)"updateTime").lt((Object)beforeUpdateTime));
        SearchResponse searchResponse = this.doSearchResponse(searchSourceBuilder, queryBuilder, new String[]{"requestId"}, "queryZombieRequestId with error");
        if (searchResponse == null) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            log.warn("searchHits is empty");
            return null;
        }
        ArrayList zombieRequestIds = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            String tmpRequestId = (String)searchHit.getSourceAsMap().get("requestId");
            zombieRequestIds.add(tmpRequestId);
        }
        return zombieRequestIds;
    }

    private SearchResponse doSearchResponse(SearchSourceBuilder searchSourceBuilder, BoolQueryBuilder queryBuilder, String[] fields, String errorMsg) {
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(fields, null);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.operatorResultIndex});
        searchRequest.types(new String[]{TYPE});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.client.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error(errorMsg, (Throwable)e);
        }
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getHits())) {
            log.error("searchResponse is null or searchResponse.getHits() is null");
            return null;
        }
        return searchResponse;
    }

    @Override
    public List<OperatorResult> queryByRequestIds(List<String> requestIds) {
        log.info("queryByRequestIds with requestIds={}", requestIds);
        if (CollectionUtils.isEmpty(requestIds)) {
            log.info("requestIds is empty,exit");
            return Lists.newArrayList();
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"requestId.keyword", requestIds)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"status").gte((Object)OperatorResultStatus.FINISH.getStatus()));
        SearchResponse searchResponse = this.doSearchResponse(searchSourceBuilder, queryBuilder, new String[]{"requestId", "status"}, "queryByRequestIds with error");
        if (searchResponse == null) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            log.error("searchHits is empty");
            return null;
        }
        ArrayList finishedResult = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            OperatorResult result = new OperatorResult();
            String tmpRequestId = (String)searchHit.getSourceAsMap().get("requestId");
            result.setRequestId(tmpRequestId);
            Integer status = (Integer)searchHit.getSourceAsMap().get("status");
            result.setStatus(status);
            finishedResult.add(result);
        }
        return finishedResult;
    }
}

