/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.OperatorResult;
import com.kuaike.scrm.common.dto.OperatorResultItemDto;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import com.kuaike.scrm.sop.operators.convert.ConvertServiceImpl;
import com.kuaike.scrm.sop.service.OperatorConvertService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperatorConvertServiceImpl
implements OperatorConvertService {
    private static final Logger log = LoggerFactory.getLogger(OperatorConvertServiceImpl.class);
    @Autowired
    private ConvertServiceImpl convertServiceImpl;

    @Override
    public OperatorResult resultConvert(OperatorResult result, Integer wantedResultType) {
        result.validate();
        Preconditions.checkArgument((boolean)Objects.nonNull(OperatorResultCustomerType.getByType((Integer)wantedResultType)), (Object)"wantedResultType is not valid");
        if (CollectionUtils.isEmpty((Collection)result.getList())) {
            result.setCustomerType(wantedResultType);
            result.setMemberType(OperatorResultMemberType.NOT_USE.getType());
            return result;
        }
        this.convertCustomer(result, wantedResultType);
        this.convertMember(result);
        return result;
    }

    private OperatorResult convertCustomer(OperatorResult result, Integer wantedResultType) {
        if (Objects.equals(result.getCustomerType(), wantedResultType)) {
            return result;
        }
        List customerIds = result.getList().stream().map(a -> a.getCustomerId()).collect(Collectors.toList());
        Map map = this.convertServiceImpl.execConvert(result.getBizId(), customerIds, (IOperatorResultType)OperatorResultCustomerType.getByType((Integer)result.getCustomerType()), (IOperatorResultType)OperatorResultCustomerType.getByType((Integer)wantedResultType));
        log.info("convert before size={}, after size={}", (Object)CollectionUtils.size((Object)result.getList()), (Object)CollectionUtils.size((Object)map));
        Map<String, String> customerId2MemberId = result.getList().stream().collect(Collectors.toMap(a -> a.getCustomerId(), a -> a.getMemberId()));
        ArrayList list = Lists.newArrayList();
        map.forEach((k, v) -> {
            OperatorResultItemDto dto = new OperatorResultItemDto();
            if (v instanceof String) {
                dto.setCustomerId((String)v);
            } else {
                dto.setCustomerId(v.toString());
            }
            dto.setMemberId((String)customerId2MemberId.get(k));
            list.add(dto);
        });
        result.setList((List)list);
        result.setCustomerType(wantedResultType);
        return result;
    }

    private OperatorResult convertMember(OperatorResult result) {
        if (Objects.equals(result.getMemberType(), OperatorResultMemberType.NOT_USE.getType()) || Objects.equals(result.getMemberType(), OperatorResultMemberType.USER_ID.getType())) {
            return result;
        }
        List memberIds = result.getList().stream().map(a -> a.getMemberId()).filter(a -> Objects.nonNull(a)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(memberIds)) {
            log.info("memberIds is empty");
            return result;
        }
        Map map = this.convertServiceImpl.execConvert(result.getBizId(), memberIds, (IOperatorResultType)OperatorResultMemberType.getByType((Integer)result.getCustomerType()), (IOperatorResultType)OperatorResultMemberType.USER_ID);
        log.info("convert before size={}, after size={}", (Object)CollectionUtils.size((Object)result.getList()), (Object)CollectionUtils.size((Object)map));
        for (OperatorResultItemDto dto : result.getList()) {
            Object newMemberId = map.get(dto.getMemberId());
            if (newMemberId instanceof String) {
                dto.setMemberId((String)newMemberId);
                continue;
            }
            dto.setMemberId(newMemberId.toString());
        }
        result.setMemberType(OperatorResultMemberType.USER_ID.getType());
        return result;
    }
}

