/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.functions.impl;

import cn.kinyun.customer.center.dto.req.operator.CustomerStageQueryReq;
import cn.kinyun.customer.center.service.CcOperatorService;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.sop.dto.OperatorCommonDto;
import com.kuaike.scrm.sop.dto.req.SopStageParseDto;
import com.kuaike.scrm.sop.enums.ConditionTypeEnum;
import com.kuaike.scrm.sop.operators.functions.AbstractOperatorInvoker;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerStageInvoker
extends AbstractOperatorInvoker<List<SopStageParseDto>> {
    private static final Logger log = LoggerFactory.getLogger(CustomerStageInvoker.class);
    @Autowired
    private CcOperatorService ccOperatorService;
    @Autowired
    private CustomerStageMapper customerStageMapper;

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.CUSTOMER_STAGE;
    }

    @Override
    public List<SopStageParseDto> getParam(String json) {
        try {
            return JacksonUtil.str2List((String)json, SopStageParseDto.class);
        }
        catch (IOException e) {
            log.error("parse json with error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void validate(List<SopStageParseDto> list) {
        Preconditions.checkArgument((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"\u9636\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        for (SopStageParseDto stageParseDto : list) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stageParseDto.getId()), (Object)"stageId\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stageParseDto.getName()), (Object)"stageName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public String invoke(OperatorCommonDto commonDto, List<SopStageParseDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            log.warn("list is empty");
            return null;
        }
        CustomerStageQueryReq req = new CustomerStageQueryReq();
        req.setBizId(commonDto.getBizId());
        req.setStageIds(list.stream().map(a -> Long.parseLong(a.getId())).collect(Collectors.toSet()));
        req.setFirstStageId(Long.valueOf(0L));
        CustomerStage firstStage = this.customerStageMapper.getFirstStageByBizId(commonDto.getBizId());
        if (firstStage != null) {
            req.setFirstStageId(firstStage.getId());
        }
        req.setUserIdWeworkUserNumMap(commonDto.getUserId2UserNums());
        return this.ccOperatorService.customerStageAsync(req);
    }
}

