/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.convert.member;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import com.kuaike.scrm.sop.operators.convert.member.AbstractUserId2OtherConverter;
import com.kuaike.scrm.sop.service.UserConvertService;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserId2DecryWeworkUserIdConverter
extends AbstractUserId2OtherConverter {
    private static final Logger log = LoggerFactory.getLogger(UserId2DecryWeworkUserIdConverter.class);
    @Autowired
    private UserConvertService userConvertService;

    @Override
    public IOperatorResultType toResultType() {
        return OperatorResultMemberType.DECRY_WEWORK_USER_ID;
    }

    @Override
    public Map convert(Long bizId, Collection<?> ids) {
        Set<Long> userIds;
        if (CollectionUtils.isEmpty(ids) || !ids.stream().findFirst().isPresent()) {
            return Maps.newHashMap();
        }
        Object obj = ids.stream().findFirst().orElseThrow(() -> new NoSuchElementException("\u4e0d\u5b58\u5728\u8be5\u5143\u7d20"));
        if (obj instanceof Long) {
            userIds = ids.stream().map(Long.class::cast).collect(Collectors.toSet());
        } else if (obj instanceof String) {
            userIds = ids.stream().map(a -> Long.valueOf((String)a)).collect(Collectors.toSet());
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u96c6\u5408\u5143\u7d20\u7c7b\u578b");
        }
        return this.userConvertService.convertDecryWeworkUserId(userIds);
    }
}

