/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.convert.customer;

import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.sop.operators.convert.customer.AbstractOther2CustomerNumConverter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerNum2WeworkDigitIdConverter
extends AbstractOther2CustomerNumConverter {
    private static final Logger log = LoggerFactory.getLogger(CustomerNum2WeworkDigitIdConverter.class);
    @Autowired
    private ScrmContactService scrmContactService;

    @Override
    public IOperatorResultType fromResultType() {
        return OperatorResultCustomerType.CUSTOMER_NUM;
    }

    @Override
    public Map convert(Long bizId, Collection<?> ids) {
        Set userIds = ids.stream().map(String.class::cast).collect(Collectors.toSet());
        return this.scrmContactService.getWeworkDigitIdsByCustomerNum(bizId, userIds);
    }
}

