/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.operators.convert;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.IOperatorResultType;
import com.kuaike.scrm.common.service.ConvertService;
import com.kuaike.scrm.sop.operators.convert.IDataConvert;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class ConvertServiceImpl
implements ApplicationListener<ContextRefreshedEvent>,
ConvertService {
    private static final Logger log = LoggerFactory.getLogger(ConvertServiceImpl.class);
    private ApplicationContext applicationContext;
    private Map<String, IDataConvert> convertMap;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.applicationContext = event.getApplicationContext();
        this.init();
    }

    public void init() {
        Map map = this.applicationContext.getBeansOfType(IDataConvert.class);
        this.convertMap = Maps.newHashMap();
        for (IDataConvert value : map.values()) {
            this.convertMap.put(value.convertName(), value);
        }
    }

    public Map execConvert(Long bizId, Collection ids, IOperatorResultType from, IOperatorResultType to) {
        Preconditions.checkArgument((Objects.nonNull(from) && Objects.nonNull(to) ? 1 : 0) != 0, (Object)"from to \u8f6c\u6362\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Maps.newHashMap();
        }
        String key = String.format("%s->%s", from.name(), to.name());
        IDataConvert converter = this.convertMap.get(key);
        if (Objects.isNull(converter)) {
            log.error("\u8be5\u8f6c\u6362\u7c7b\u578b\u6682\u4e0d\u652f\u6301\uff0ckey={}", (Object)key);
            throw new UnsupportedOperationException(key + "\u8be5\u8f6c\u6362\u7c7b\u578b\u6682\u4e0d\u652f\u6301");
        }
        return converter.convert(bizId, ids);
    }
}

