/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.sop.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.sop.dto.CustomerItem;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class CallSopCalcTaskReq {
    private Long bizId;
    private Long sopContentId;
    private Collection<CustomerItem> customerList;
    private String preRequestId;
    private Integer wantedResultType;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.bizId), (Object)"bizId is null");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.sopContentId), (Object)"sopContentId");
        if (CollectionUtils.isNotEmpty(this.customerList)) {
            for (CustomerItem customerItem : this.customerList) {
                customerItem.validate();
            }
        }
        if (Objects.isNull(this.wantedResultType) || Objects.isNull(OperatorResultCustomerType.getByType((Integer)this.wantedResultType))) {
            this.wantedResultType = OperatorResultCustomerType.CUSTOMER_NUM.getType();
        }
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Long getSopContentId() {
        return this.sopContentId;
    }

    public Collection<CustomerItem> getCustomerList() {
        return this.customerList;
    }

    public String getPreRequestId() {
        return this.preRequestId;
    }

    public Integer getWantedResultType() {
        return this.wantedResultType;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setSopContentId(Long sopContentId) {
        this.sopContentId = sopContentId;
    }

    public void setCustomerList(Collection<CustomerItem> customerList) {
        this.customerList = customerList;
    }

    public void setPreRequestId(String preRequestId) {
        this.preRequestId = preRequestId;
    }

    public void setWantedResultType(Integer wantedResultType) {
        this.wantedResultType = wantedResultType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallSopCalcTaskReq)) {
            return false;
        }
        CallSopCalcTaskReq other = (CallSopCalcTaskReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Long this$sopContentId = this.getSopContentId();
        Long other$sopContentId = other.getSopContentId();
        if (this$sopContentId == null ? other$sopContentId != null : !((Object)this$sopContentId).equals(other$sopContentId)) {
            return false;
        }
        Integer this$wantedResultType = this.getWantedResultType();
        Integer other$wantedResultType = other.getWantedResultType();
        if (this$wantedResultType == null ? other$wantedResultType != null : !((Object)this$wantedResultType).equals(other$wantedResultType)) {
            return false;
        }
        Collection<CustomerItem> this$customerList = this.getCustomerList();
        Collection<CustomerItem> other$customerList = other.getCustomerList();
        if (this$customerList == null ? other$customerList != null : !((Object)this$customerList).equals(other$customerList)) {
            return false;
        }
        String this$preRequestId = this.getPreRequestId();
        String other$preRequestId = other.getPreRequestId();
        return !(this$preRequestId == null ? other$preRequestId != null : !this$preRequestId.equals(other$preRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallSopCalcTaskReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Long $sopContentId = this.getSopContentId();
        result = result * 59 + ($sopContentId == null ? 43 : ((Object)$sopContentId).hashCode());
        Integer $wantedResultType = this.getWantedResultType();
        result = result * 59 + ($wantedResultType == null ? 43 : ((Object)$wantedResultType).hashCode());
        Collection<CustomerItem> $customerList = this.getCustomerList();
        result = result * 59 + ($customerList == null ? 43 : ((Object)$customerList).hashCode());
        String $preRequestId = this.getPreRequestId();
        result = result * 59 + ($preRequestId == null ? 43 : $preRequestId.hashCode());
        return result;
    }

    public String toString() {
        return "CallSopCalcTaskReq(bizId=" + this.getBizId() + ", sopContentId=" + this.getSopContentId() + ", customerList=" + this.getCustomerList() + ", preRequestId=" + this.getPreRequestId() + ", wantedResultType=" + this.getWantedResultType() + ")";
    }
}

