/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.dal.marketing.dto.MarketingGroupInfo;
import com.kuaike.scrm.dal.marketing.dto.MarketingPlanInfo;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanGroupMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.dto.ContactDto;
import com.kuaike.scrm.dal.wework.dto.ContactStageInfo;
import com.kuaike.scrm.dal.wework.dto.WeworkRoomDto;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPair;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPairInfo;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTag;
import com.kuaike.scrm.dal.weworktag.entity.WeworkTagGroup;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchChatroomReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchChatroomReqExt;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReqExt;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchQrCodeReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchQrCodeReqExt;
import com.kuaike.scrm.groupsend.service.GroupSendFillService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupSendFillServiceImpl
implements GroupSendFillService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendFillServiceImpl.class);
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private MarketingPlanGroupMapper marketingPlanGroupMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private NodeService nodeService;

    @Override
    public MultiSearchContactReq fillContact(Long bizId, String corpId, MultiSearchContactReq contactReq) {
        MultiSearchContactReqExt contactReqExt = new MultiSearchContactReqExt(contactReq);
        this.fillContactExtFields(bizId, corpId, contactReq, contactReqExt);
        return contactReqExt;
    }

    @Override
    public MultiSearchChatroomReq fillChatroom(String corpId, MultiSearchChatroomReq chatroomReq) {
        MultiSearchChatroomReqExt chatroomReqExt = new MultiSearchChatroomReqExt(chatroomReq);
        this.fillChatroomExtFields(corpId, chatroomReq, chatroomReqExt);
        return chatroomReqExt;
    }

    @Override
    public MultiSearchQrCodeReq fillQrCode(Long bizId, String corpId, MultiSearchQrCodeReq qrCodeReq) {
        MultiSearchQrCodeReqExt qrCodeReqExt = new MultiSearchQrCodeReqExt(qrCodeReq);
        this.fillQrCodeExtFields(bizId, corpId, qrCodeReq, qrCodeReqExt);
        return qrCodeReqExt;
    }

    private void fillQrCodeExtFields(Long bizId, String corpId, MultiSearchQrCodeReq qrCodeReq, MultiSearchQrCodeReqExt qrCodeReqExt) {
        List<ContactStageInfo> stageList = this.customerStageMapper.queryListById(bizId, corpId, qrCodeReq.getStageIds()).stream().map(a -> new ContactStageInfo(a.getId(), a.getStageName(), a.getStageValue(), a.getType())).collect(Collectors.toList());
        qrCodeReqExt.setStageList(stageList);
        List<MarketingGroupInfo> groupInfos = this.marketingPlanGroupMapper.queryByNum(qrCodeReq.getGroupIds()).stream().map(a -> new MarketingGroupInfo(a.getNum(), a.getName())).collect(Collectors.toList());
        qrCodeReqExt.setGroupInfos(groupInfos);
        List<ContactDto> notSelectContactInfos = this.weworkContactMapper.queryWeworkContactList(corpId, qrCodeReq.getNotSelect()).stream().map(a -> new ContactDto(a.getContactId(), a.getName(), a.getAvatar())).collect(Collectors.toList());
        qrCodeReqExt.setNotSelectContactInfos(notSelectContactInfos);
        Optional planOptional = this.marketingPlanMapper.queryByNums((Collection)Lists.newArrayList((Object[])new String[]{qrCodeReq.getPlanId()})).stream().findFirst();
        planOptional.ifPresent(marketingPlan -> qrCodeReqExt.setPlanName(marketingPlan.getName()));
        if (CollectionUtils.isNotEmpty(qrCodeReq.getIncludeTags()) || CollectionUtils.isNotEmpty(qrCodeReq.getNotIncludeTags())) {
            this.fillTagInfos(corpId, qrCodeReq);
        }
    }

    private void fillTagInfos(String corpId, MultiSearchQrCodeReq qrCodeReq) {
        HashSet allGroupIds = Sets.newHashSet();
        HashSet allGroupTagIds = Sets.newHashSet();
        this.fillGroupAndGroupTag(allGroupIds, allGroupTagIds, qrCodeReq.getIncludeTags());
        this.fillGroupAndGroupTag(allGroupIds, allGroupTagIds, qrCodeReq.getNotIncludeTags());
        Map<String, String> groupId2Name = this.weworkTagGroupMapper.queryTagGroups(corpId, (Collection)allGroupIds).stream().collect(Collectors.toMap(WeworkTagGroup::getGroupId, WeworkTagGroup::getGroupName));
        Map<String, String> groupTagId2TagName = this.weworkTagMapper.queryByGroupTags(corpId, (Collection)allGroupTagIds).stream().collect(Collectors.toMap(a -> a.getGroupId() + "$$" + a.getTagId(), WeworkTag::getName));
        this.fillSelectedTagInfos(qrCodeReq.getIncludeTags(), groupId2Name, groupTagId2TagName);
        this.fillSelectedTagInfos(qrCodeReq.getNotIncludeTags(), groupId2Name, groupTagId2TagName);
    }

    private void fillGroupAndGroupTag(Set<String> allGroupIds, Set<TagGroupPair> allGroupTagIds, List<TagGroupParams> params) {
        if (CollectionUtils.isNotEmpty(params)) {
            for (TagGroupParams tagGroupParam : params) {
                allGroupIds.add(tagGroupParam.getGroupId());
                for (WeworkTagParams tagDto : tagGroupParam.getWeworkTags()) {
                    TagGroupPair item = new TagGroupPair();
                    item.setGroupId(tagGroupParam.getGroupId());
                    item.setTagId(tagDto.getId());
                    allGroupTagIds.add(item);
                }
            }
        }
    }

    private void fillSelectedTagInfos(List<TagGroupParams> tagInfos, Map<String, String> groupId2Name, Map<String, String> groupTagId2TagName) {
        if (CollectionUtils.isNotEmpty(tagInfos)) {
            for (TagGroupParams tagGroupItem : tagInfos) {
                String groupName = groupId2Name.get(tagGroupItem.getGroupId());
                tagGroupItem.setGroupName(groupName);
                for (WeworkTagParams tagDto : tagGroupItem.getWeworkTags()) {
                    String groupTagKey = tagGroupItem.getGroupId() + "$$" + tagDto.getId();
                    String tagName = groupTagId2TagName.get(groupTagKey);
                    tagDto.setName(tagName);
                }
            }
        }
    }

    private void fillChatroomExtFields(String corpId, MultiSearchChatroomReq chatroomReq, MultiSearchChatroomReqExt chatroomReqExt) {
        List<WeworkRoomDto> notSelectChatroomInfos = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, chatroomReq.getNotSelect()).stream().map(a -> new WeworkRoomDto(a.getWeworkRoomId(), a.getName())).collect(Collectors.toList());
        chatroomReqExt.setNotSelectChatroomInfo(notSelectChatroomInfos);
        List weworkUserDtos = this.weworkUserService.queryWeworkUserInfoByNums(chatroomReq.getWeworkUserNumList());
        chatroomReqExt.setWeworkUserInfos(weworkUserDtos);
    }

    private void fillContactExtFields(Long bizId, String corpId, MultiSearchContactReq contactReq, MultiSearchContactReqExt contactReqExt) {
        List weworkUserDtos = this.weworkUserService.queryWeworkUserInfoByNums(contactReq.getWeworkUserNums());
        contactReqExt.setWeworkUserInfos(weworkUserDtos);
        ArrayList orgList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(contactReq.getNodeIds())) {
            Map nodeMap = this.nodeService.getNodeByIds(contactReq.getNodeIds(), bizId);
            for (Long nodeId : contactReq.getNodeIds()) {
                Node node = (Node)nodeMap.get(nodeId);
                if (node != null) {
                    orgList.add(new IdAndNameDto(Long.valueOf(node.getId()), node.getName()));
                    continue;
                }
                log.info("buildMeetingDetailRespDto: node is null, nodeId:{}", (Object)nodeId);
            }
        }
        contactReqExt.setOrgList(orgList);
        List<MarketingPlanInfo> planInfos = this.marketingPlanMapper.queryByNums(contactReq.getMarketingPlanNums()).stream().map(a -> new MarketingPlanInfo(a.getName(), a.getNum())).collect(Collectors.toList());
        contactReqExt.setPlanInfos(planInfos);
        List<WeworkRoomDto> chatRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, contactReq.getRoomIds()).stream().map(a -> new WeworkRoomDto(a.getWeworkRoomId(), a.getName())).collect(Collectors.toList());
        contactReqExt.setRoomInfos(chatRoomList);
        List<ContactStageInfo> stageList = this.customerStageMapper.queryListById(bizId, corpId, contactReq.getStageIds()).stream().map(a -> new ContactStageInfo(a.getId(), a.getStageName(), a.getStageValue(), a.getType())).collect(Collectors.toList());
        contactReqExt.setStageList(stageList);
        List<ContactDto> excludeContactInfos = this.weworkContactMapper.queryWeworkContactList(corpId, contactReq.getExcludeContactIds()).stream().map(a -> new ContactDto(a.getContactId(), a.getName(), a.getAvatar())).collect(Collectors.toList());
        contactReqExt.setExcludeContactInfos(excludeContactInfos);
        if (CollectionUtils.isNotEmpty(contactReq.getIncludeTags()) || CollectionUtils.isNotEmpty(contactReq.getExcludeTags())) {
            this.fillGroupTagInfos(corpId, contactReq, contactReqExt);
        }
    }

    private void fillGroupTagInfos(String corpId, MultiSearchContactReq contactReq, MultiSearchContactReqExt contactReqExt) {
        HashSet allGroupIds = Sets.newHashSet();
        HashSet allGroupTagIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(contactReq.getIncludeTags())) {
            Set includeGroupIds = contactReq.getIncludeTags().stream().map(TagGroupPair::getGroupId).collect(Collectors.toSet());
            allGroupIds.addAll(includeGroupIds);
            Set includeGroupTagIds = contactReq.getIncludeTags().stream().map(a -> new TagGroupPair(a.getGroupId(), a.getTagId())).collect(Collectors.toSet());
            allGroupTagIds.addAll(includeGroupTagIds);
        }
        if (CollectionUtils.isNotEmpty(contactReq.getExcludeTags())) {
            Set excludeGroupIds = contactReq.getExcludeTags().stream().map(TagGroupPair::getGroupId).collect(Collectors.toSet());
            allGroupIds.addAll(excludeGroupIds);
            Set excludeGroupTagIds = contactReq.getExcludeTags().stream().map(a -> new TagGroupPair(a.getGroupId(), a.getTagId())).collect(Collectors.toSet());
            allGroupTagIds.addAll(excludeGroupTagIds);
        }
        Map<String, String> groupId2Name = this.weworkTagGroupMapper.queryTagGroups(corpId, (Collection)allGroupIds).stream().collect(Collectors.toMap(WeworkTagGroup::getGroupId, WeworkTagGroup::getGroupName));
        Map<String, String> groupTagId2TagName = this.weworkTagMapper.queryByGroupTags(corpId, (Collection)allGroupTagIds).stream().collect(Collectors.toMap(a -> a.getGroupId() + "$$" + a.getTagId(), WeworkTag::getName));
        ArrayList includeTagInfos = Lists.newArrayList();
        this.collectTagGroupPairInfos(groupId2Name, groupTagId2TagName, includeTagInfos, contactReq.getIncludeTags());
        contactReqExt.setIncludeTagInfos(includeTagInfos);
        ArrayList excludeTagInfos = Lists.newArrayList();
        this.collectTagGroupPairInfos(groupId2Name, groupTagId2TagName, excludeTagInfos, contactReq.getExcludeTags());
        contactReqExt.setExcludeTagInfos(excludeTagInfos);
    }

    private void collectTagGroupPairInfos(Map<String, String> groupId2Name, Map<String, String> groupTagId2TagName, List<TagGroupPairInfo> list, List<TagGroupPair> tagGroupPairs) {
        if (CollectionUtils.isNotEmpty(tagGroupPairs)) {
            for (TagGroupPair tagGroupPair : tagGroupPairs) {
                String groupName = groupId2Name.get(tagGroupPair.getGroupId());
                String groupTagKey = tagGroupPair.getGroupId() + "$$" + tagGroupPair.getTagId();
                String tagName = groupTagId2TagName.get(groupTagKey);
                TagGroupPairInfo tagGroupPairInfo = new TagGroupPairInfo();
                tagGroupPairInfo.setGroupId(tagGroupPair.getGroupId());
                tagGroupPairInfo.setTagId(tagGroupPair.getTagId());
                tagGroupPairInfo.setGroupName(groupName);
                tagGroupPairInfo.setTagName(tagName);
                list.add(tagGroupPairInfo);
            }
        }
    }
}

