/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupinvite.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.dto.StrIdDto;
import com.kuaike.scrm.common.enums.EnumDto;
import com.kuaike.scrm.common.enums.EnumService;
import com.kuaike.scrm.common.enums.GroupInviteJoinStatus;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteContactDetailDto;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteContactQuery;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteTaskQuery;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteUserDto;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteUserQuery;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteUserTaskDto;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteRoom;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteTask;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteContactDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteRoomMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteUserDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.groupinvite.dto.GroupInviteContentDto;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteInviteDetailReq;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteListReq;
import com.kuaike.scrm.groupinvite.dto.req.GroupInviteSendDetailReq;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteDetailResp;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteInviteDetailResp;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteListResp;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteRoomResp;
import com.kuaike.scrm.groupinvite.dto.resp.GroupInviteSendDetailResp;
import com.kuaike.scrm.groupinvite.service.GroupInviteService;
import com.kuaike.scrm.groupsend.dto.response.MsgGroupSendTaskProcessRespDto;
import com.kuaike.scrm.system.service.UserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupInviteServiceImpl
implements GroupInviteService {
    private static final Logger log = LoggerFactory.getLogger(GroupInviteServiceImpl.class);
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Autowired
    private GroupInviteTaskMapper groupInviteTaskMapper;
    @Autowired
    private GroupInviteRoomMapper groupInviteRoomMapper;
    @Autowired
    private GroupInviteUserDetailMapper groupInviteUserDetailMapper;
    @Autowired
    private GroupInviteContactDetailMapper groupInviteContactDetailMapper;
    @Autowired
    private MessageGroupSendDetailMapper messageGroupSendDetailMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private UserService userService;

    @Override
    public List<GroupInviteListResp> list(GroupInviteListReq params) {
        log.info("query group invite list, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        this.validateLoginUser();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        GroupInviteTaskQuery query = new GroupInviteTaskQuery();
        query.setBizId(bizId);
        query.setCorpId(corpId);
        query.setManageUserIds((Collection)this.userRoleCommonService.getManageUserIds());
        query.setQuery(params.getQuery());
        query.setStartTime(params.getStartTime());
        query.setEndTime(params.getEndTime());
        query.setCreateBy(params.getCreateBy());
        query.setPageDto(params.getPageDto());
        int count = this.groupInviteTaskMapper.queryCount(query);
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        List list = this.groupInviteTaskMapper.queryList(query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (pageDto != null) {
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        List ids = list.stream().map(it -> it.getId()).collect(Collectors.toList());
        Set userIds = list.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        Map userNameMap = this.userService.getUserIdAndNameByUserIds(userIds);
        List roomList = this.groupInviteRoomMapper.queryByTaskIds(ids);
        Map taskRoomMap = roomList.stream().collect(Collectors.groupingBy(it -> it.getTaskId(), Collectors.mapping(it -> it.getWeworkRoomId(), Collectors.toList())));
        Set weworkRoomIds = roomList.stream().map(it -> it.getWeworkRoomId()).collect(Collectors.toSet());
        Map roomNameMap = this.weworkChatRoomMapper.queryNameMap(corpId, weworkRoomIds);
        Map joinCountMap = this.groupInviteContactDetailMapper.getJoinCountByTaskIds(ids);
        Map sendCountMap = this.groupInviteContactDetailMapper.getSendCountByTaskIds(ids);
        List userDetailList = this.groupInviteUserDetailMapper.queryByTaskIds(ids);
        Map<Long, List<GroupInviteUserTaskDto>> taskUserDetailMap = userDetailList.stream().collect(Collectors.groupingBy(it -> it.getTaskId()));
        Set weworkUserNums = userDetailList.stream().map(it -> it.getWeworkUserNum()).collect(Collectors.toSet());
        Map numNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, weworkUserNums);
        ArrayList results = Lists.newArrayListWithCapacity((int)list.size());
        for (GroupInviteTask it2 : list) {
            GroupInviteListResp dto = new GroupInviteListResp();
            results.add(dto);
            dto.setId(it2.getNum());
            dto.setName(it2.getName());
            List<GroupInviteUserTaskDto> detailList = taskUserDetailMap.get(it2.getId());
            Calc tmp = this.calc(detailList);
            dto.setNoSendCount(tmp.noSendNums.size());
            List<String> weworkUserNames = tmp.allNums.stream().filter(numNameMap::containsKey).map(numNameMap::get).collect(Collectors.toList());
            dto.setWeworkUserList(weworkUserNames);
            List roomIds = taskRoomMap.get(it2.getId());
            if (roomIds != null) {
                List<String> weworkRoomNames = roomIds.stream().filter(roomNameMap::containsKey).map(roomNameMap::get).collect(Collectors.toList());
                dto.setWeworkRoomList(weworkRoomNames);
            }
            dto.setPlanCount(it2.getPlanCount());
            dto.setSendCount(sendCountMap.getOrDefault(it2.getId(), 0));
            dto.setJoinCount(joinCountMap.getOrDefault(it2.getId(), 0));
            dto.setCreateTime(it2.getCreateTime());
            dto.setCreatorName((String)userNameMap.get(it2.getCreateBy()));
        }
        return results;
    }

    @Override
    public GroupInviteDetailResp detail(StrIdDto params) {
        log.info("query group invite detail, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"ID\u4e3a\u7a7a");
        this.validateLoginUser();
        String corpId = LoginUtils.getCurrentUserCorpId();
        GroupInviteTask groupInviteTask = this.groupInviteTaskMapper.getByNum(params.getId());
        Preconditions.checkArgument((groupInviteTask != null && groupInviteTask.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)manageUserIds) && manageUserIds.contains(groupInviteTask.getCreateBy()) ? 1 : 0) != 0, (Object)"\u65e0\u6743\u8bbf\u95ee\u8be5\u8d44\u6e90");
        Long taskId = groupInviteTask.getId();
        int sendCount = this.groupInviteContactDetailMapper.getSendCountByTaskId(taskId);
        int joinCount = this.groupInviteContactDetailMapper.getJoinCountByTaskId(taskId);
        GroupInviteDetailResp result = new GroupInviteDetailResp();
        result.setName(groupInviteTask.getName());
        result.setPlanCount(groupInviteTask.getPlanCount());
        result.setSendCount(sendCount);
        result.setJoinCount(joinCount);
        try {
            GroupInviteContentDto context = (GroupInviteContentDto)JacksonUtil.str2Obj((String)groupInviteTask.getContentJson(), GroupInviteContentDto.class);
            result.setContext(context);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25, json={}", (Object)groupInviteTask.getContentJson(), (Object)e);
        }
        List userDetailList = this.groupInviteUserDetailMapper.queryByTaskId(taskId);
        Calc tmp = this.calc(userDetailList);
        result.setWeworkUserSendCount(tmp.allNums.size() - tmp.noSendNums.size());
        Map numNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, tmp.allNums);
        List<StrIdAndNameDto> weworkUserList = tmp.allNums.stream().map(it -> {
            StrIdAndNameDto dto = new StrIdAndNameDto();
            dto.setId(it);
            dto.setName((String)numNameMap.get(it));
            return dto;
        }).collect(Collectors.toList());
        result.setWeworkUserList(weworkUserList);
        List inviteRoomList = this.groupInviteRoomMapper.queryByTaskId(taskId);
        List weworkRoomIds = inviteRoomList.stream().map(it -> it.getWeworkRoomId()).collect(Collectors.toList());
        List weworkRoomList = this.weworkChatRoomMapper.batchQueryChatRooms(corpId, weworkRoomIds);
        Map<String, WeworkChatRoom> weworkRoomMap = weworkRoomList.stream().collect(Collectors.toMap(it -> it.getWeworkRoomId(), it -> it));
        Set owners = weworkRoomList.stream().map(it -> it.getOwner()).collect(Collectors.toSet());
        Map ownerUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, owners);
        Map ownerContactNameMap = this.weworkContactMapper.queryContactNameMap(corpId, owners);
        Map memberCountMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, weworkRoomIds);
        ArrayList roomRespList = Lists.newArrayList();
        for (GroupInviteRoom room : inviteRoomList) {
            GroupInviteRoomResp dto = new GroupInviteRoomResp();
            roomRespList.add(dto);
            String weworkRoomId = room.getWeworkRoomId();
            dto.setId(weworkRoomId);
            dto.setQrcode(room.getQrcode());
            WeworkChatRoom weworkChatRoom = weworkRoomMap.get(weworkRoomId);
            if (weworkChatRoom != null) {
                dto.setName(weworkChatRoom.getName());
                String owner = weworkChatRoom.getOwner();
                if (ownerUserNameMap.containsKey(owner)) {
                    dto.setOwner((String)ownerUserNameMap.get(owner));
                } else if (ownerContactNameMap.containsKey(owner)) {
                    dto.setOwner((String)ownerContactNameMap.get(owner));
                } else {
                    dto.setOwner(owner);
                }
            }
            Integer memberCount = memberCountMap.getOrDefault(weworkRoomId, 0);
            dto.setMemberCount(memberCount);
        }
        result.setWeworkRoomList(roomRespList);
        return result;
    }

    private Calc calc(List<GroupInviteUserTaskDto> list) {
        HashSet exists = Sets.newHashSet();
        ArrayList allNums = Lists.newArrayList();
        for (GroupInviteUserTaskDto groupInviteUserTaskDto : list) {
            if (exists.contains(groupInviteUserTaskDto.getWeworkUserNum())) continue;
            exists.add(groupInviteUserTaskDto.getWeworkUserNum());
            allNums.add(groupInviteUserTaskDto.getWeworkUserNum());
        }
        ArrayList noSend = Lists.newArrayList();
        for (GroupInviteUserTaskDto it : list) {
            if (it.getSendStatus().intValue() == SendStatus.ALREADY_SEND.getValue() || !exists.contains(it.getWeworkUserNum())) continue;
            exists.remove(it.getWeworkUserNum());
            noSend.add(it.getWeworkUserNum());
        }
        Calc calc = new Calc();
        calc.allNums = allNums;
        calc.noSendNums = noSend;
        return calc;
    }

    @Override
    public List<GroupInviteInviteDetailResp> inviteDetail(GroupInviteInviteDetailReq params) {
        log.info("query invite detail, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"ID\u4e3a\u7a7a");
        this.validateLoginUser();
        GroupInviteTask groupInviteTask = this.groupInviteTaskMapper.getByNum(params.getId());
        Preconditions.checkArgument((groupInviteTask != null && groupInviteTask.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)manageUserIds) && manageUserIds.contains(groupInviteTask.getCreateBy()) ? 1 : 0) != 0, (Object)"\u65e0\u6743\u8bbf\u95ee\u8be5\u8d44\u6e90");
        GroupInviteContactQuery query = new GroupInviteContactQuery();
        query.setTaskId(groupInviteTask.getId());
        query.setQuery(params.getQuery());
        query.setWeworkUserNum(params.getWeworkUserNum());
        query.setWeworkRoomId(params.getWeworkRoomId());
        query.setTaskType(params.getTaskType());
        query.setPageDto(params.getPageDto());
        if (params.getSendStatus() != null) {
            SendStatus sendStatus = SendStatus.getType((Integer)params.getSendStatus());
            Preconditions.checkArgument((sendStatus != null ? 1 : 0) != 0, (Object)"\u4e0d\u5408\u6cd5\u7684\u53d1\u9001\u72b6\u6001");
            switch (sendStatus) {
                case TO_BE_SEND: {
                    query.setSendStatuses((List)Lists.newArrayList((Object[])new Integer[]{SendStatus.TO_BE_SEND.getValue(), SendStatus.SENDING.getValue()}));
                    break;
                }
                case ALREADY_SEND: {
                    query.setSendStatuses(Collections.singletonList(SendStatus.ALREADY_SEND.getValue()));
                    break;
                }
                case SEND_FAIL: {
                    query.setSendStatuses((List)Lists.newArrayList((Object[])new Integer[]{SendStatus.ALREADY_EXPIRE.getValue(), SendStatus.SEND_FAIL.getValue()}));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u53d1\u9001\u72b6\u6001");
                }
            }
        }
        int count = this.groupInviteContactDetailMapper.queryCount(query);
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        List list = this.groupInviteContactDetailMapper.queryList(query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (pageDto != null) {
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        String corpId = LoginUtils.getCurrentUserCorpId();
        Set weworkRoomIds = list.stream().map(it -> it.getWeworkRoomId()).collect(Collectors.toSet());
        Map nameMap = this.weworkChatRoomMapper.queryNameMap(corpId, weworkRoomIds);
        ArrayList results = Lists.newArrayListWithCapacity((int)list.size());
        Set contactIds = list.stream().map(it -> it.getContactId()).collect(Collectors.toSet());
        Map contactMap = null;
        if (CollectionUtils.isNotEmpty(contactIds)) {
            contactMap = this.weworkContactMapper.queryContactCustomerNum(corpId, contactIds);
        }
        for (GroupInviteContactDetailDto it2 : list) {
            GroupSendTaskType taskType;
            GroupInviteInviteDetailResp dto = new GroupInviteInviteDetailResp();
            results.add(dto);
            dto.setId(it2.getId());
            dto.setContactId(it2.getContactId());
            dto.setContactName(it2.getContactName());
            dto.setContactAvatar(it2.getContactAvatar());
            dto.setContactCorpName(it2.getContactCorpName());
            dto.setContactRemarkName(it2.getContactRemarkName());
            dto.setWeworkUserName(it2.getWeworkUserName());
            dto.setWeworkRoomName((String)nameMap.get(it2.getWeworkRoomId()));
            dto.setCustomerNum(it2.getCustomerNum());
            if (contactMap != null && contactMap.containsKey(it2.getContactId())) {
                String customerNum = (String)contactMap.get(it2.getContactId());
                dto.setCustomerNum(customerNum);
            }
            if ((taskType = GroupSendTaskType.getType((int)it2.getTaskType())) != null) {
                dto.setSendTypeEnum(EnumDto.from((EnumService)taskType));
            } else {
                dto.setSendTypeEnum(new EnumDto(it2.getTaskType().intValue(), ""));
            }
            SendStatus sendStatus = SendStatus.getType((Integer)it2.getSendStatus());
            if (sendStatus != null) {
                switch (sendStatus) {
                    case TO_BE_SEND: 
                    case SENDING: {
                        dto.setSendStatusEnum(EnumDto.from((EnumService)SendStatus.TO_BE_SEND));
                        break;
                    }
                    case ALREADY_SEND: {
                        dto.setSendStatusEnum(EnumDto.from((EnumService)SendStatus.ALREADY_SEND));
                        break;
                    }
                    case SEND_FAIL: 
                    case ALREADY_EXPIRE: {
                        dto.setSendStatusEnum(EnumDto.from((EnumService)SendStatus.SEND_FAIL));
                        break;
                    }
                }
            } else {
                dto.setSendStatusEnum(new EnumDto(it2.getSendStatus().intValue(), ""));
            }
            GroupInviteJoinStatus joinStatus = GroupInviteJoinStatus.get((Integer)it2.getJoinStatus());
            if (joinStatus != null) {
                dto.setJoinStatusEnum(EnumDto.from((EnumService)joinStatus));
                continue;
            }
            dto.setJoinStatusEnum(new EnumDto(it2.getJoinStatus().intValue(), ""));
        }
        return results;
    }

    @Override
    public List<GroupInviteSendDetailResp> sendDetail(GroupInviteSendDetailReq params) {
        log.info("query send detail, params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"ID\u4e3a\u7a7a");
        this.validateLoginUser();
        GroupInviteTask groupInviteTask = this.groupInviteTaskMapper.getByNum(params.getId());
        Preconditions.checkArgument((groupInviteTask != null && groupInviteTask.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        Preconditions.checkArgument((CollectionUtils.isNotEmpty((Collection)manageUserIds) && manageUserIds.contains(groupInviteTask.getCreateBy()) ? 1 : 0) != 0, (Object)"\u65e0\u6743\u8bbf\u95ee\u8be5\u8d44\u6e90");
        GroupInviteUserQuery query = new GroupInviteUserQuery();
        query.setTaskId(groupInviteTask.getId());
        query.setName(params.getName());
        query.setWeworkRoomId(params.getWeworkRoomId());
        query.setPageDto(params.getPageDto());
        int count = this.groupInviteUserDetailMapper.queryCount(query);
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        List list = this.groupInviteUserDetailMapper.queryList(query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (pageDto != null) {
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        List msgIds = list.stream().map(it -> it.getMsgId()).collect(Collectors.toList());
        Map joinCountMap = this.groupInviteContactDetailMapper.getJoinCountByMsgIds(msgIds);
        List id2StatusCounts = this.messageGroupSendDetailMapper.queryStatusByTaskIds(msgIds, null, null);
        Map<Long, MsgGroupSendTaskProcessRespDto> taskId2Dto = id2StatusCounts.stream().collect(Collectors.toMap(Id2StatusCount::getId, it -> MsgGroupSendTaskProcessRespDto.buildFromId2StatusCount(it)));
        ArrayList results = Lists.newArrayListWithCapacity((int)list.size());
        for (GroupInviteUserDto it2 : list) {
            GroupInviteSendDetailResp dto = new GroupInviteSendDetailResp();
            results.add(dto);
            dto.setId(it2.getId());
            dto.setWeworkUserId(it2.getWeworkUserNum());
            dto.setWeworkUserName(it2.getWeworkUserName());
            dto.setWeworkUserAvatar(it2.getWeworkUserAvatar());
            dto.setIsAgentAuth(it2.getIsAgentAuth());
            dto.setWeworkRoomId(it2.getWeworkRoomId());
            dto.setWeworkRoomName(it2.getWeworkRoomName());
            dto.setJoinCount(joinCountMap.getOrDefault(it2.getMsgId(), 0));
            SendStatus sendStatus = SendStatus.getType((Integer)it2.getSendStatus());
            if (sendStatus != null) {
                dto.setSendStatusEnum(EnumDto.from((EnumService)sendStatus));
            } else {
                dto.setSendStatusEnum(new EnumDto(it2.getSendStatus().intValue(), ""));
            }
            dto.setProcessDto(taskId2Dto.get(it2.getMsgId()));
        }
        return results;
    }

    private void validateLoginUser() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Long operatorId = currentUser.getId();
        Long bizId = currentUser.getBizId();
        String corpId = currentUser.getCorpId();
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u7528\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u4f01\u4e1aID\u4e3a\u7a7a");
    }

    private class Calc {
        List<String> allNums;
        List<String> noSendNums;

        private Calc() {
        }
    }
}

