/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupsend.service.impl;

import cn.kinyun.link.common_dto.dto.OpBaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.scrm.vip.utils.ResponseErrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.SendStatus;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.dal.groupsend.dto.GroupSendWeworkDto;
import com.kuaike.scrm.dal.groupsend.dto.Id2StatusCount;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendDetail;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendTaskMapper;
import com.kuaike.scrm.dal.groupsend.mapper.MessageGroupSendWeworkMapper;
import com.kuaike.scrm.dal.wework.dto.SendDetailDto;
import com.kuaike.scrm.groupsend.service.GroupSendStatusService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupSendStatusServiceImpl
implements GroupSendStatusService {
    private static final Logger log = LoggerFactory.getLogger(GroupSendStatusServiceImpl.class);
    @Autowired
    MessageGroupSendTaskMapper groupSendTaskMapper;
    @Autowired
    MessageGroupSendDetailMapper groupSendDetailMapper;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;
    @Resource
    private MessageGroupSendWeworkMapper messageGroupSendWeworkMapper;

    @Override
    public void freshTaskStatus(Collection<Long> taskIds, Collection<Integer> sendStatusList) {
        log.info("freshTaskStatus with taskIds={},sendStatusList={}", taskIds, sendStatusList);
        ArrayList updateStatusTasks = Lists.newArrayList();
        List taskId2StatusCounts = this.groupSendDetailMapper.queryEveryStatusCountByTaskIds(taskIds);
        taskId2StatusCounts.forEach(a -> {
            Integer status = GroupSendStatusServiceImpl.getSendStatus(a);
            if (status != null) {
                MessageGroupSendTask task = new MessageGroupSendTask();
                task.setId(a.getId());
                if (status.intValue() == SendStatus.ALREADY_SEND.getValue() || status.intValue() == SendStatus.SEND_FAIL.getValue()) {
                    task.setSendStatus(Integer.valueOf(SendStatus.ALREADY_SEND.getValue()));
                } else {
                    task.setSendStatus(status);
                }
                updateStatusTasks.add(task);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)updateStatusTasks)) {
            log.info("batchUpdateTask with ids={}", updateStatusTasks.stream().map(a -> a.getId()).collect(Collectors.toList()));
            int count = this.groupSendTaskMapper.batchUpdate((Collection)updateStatusTasks);
            log.info("update count={}", (Object)count);
        }
    }

    public Integer calcSendStatus(Id2StatusCount a, Integer fkType, MessageGroupSendTask task) {
        return GroupSendStatusServiceImpl.getSendStatus(a);
    }

    public static Integer getSendStatus(Id2StatusCount a) {
        Integer sendStatus = null;
        sendStatus = GroupSendStatusServiceImpl.isSending(a) ? Integer.valueOf(SendStatus.SENDING.getValue()) : (a.getTobeSendCount() == 0 && a.getSendingCount() == 0 ? (a.getFailCount() > 0 ? Integer.valueOf(SendStatus.SEND_FAIL.getValue()) : Integer.valueOf(SendStatus.ALREADY_SEND.getValue())) : Integer.valueOf(SendStatus.TO_BE_SEND.getValue()));
        return sendStatus;
    }

    private static boolean isSending(Id2StatusCount a) {
        return a.getSendingCount() > 0 || a.getTobeSendCount() > 0 && (a.getFinishedCount() > 0 || a.getFailCount() > 0);
    }

    @Override
    public void updateTaskStatus(List<SendDetailDto> detailDtoList) {
        HashSet taskIds = Sets.newHashSet();
        for (SendDetailDto detailDto : detailDtoList) {
            taskIds.add(detailDto.getTaskId());
        }
        if (CollectionUtils.isNotEmpty((Collection)taskIds)) {
            int count = this.groupSendTaskMapper.updateSendStatus((Collection)taskIds, SendStatus.SENDING.getValue());
            log.info("update task count={}", (Object)count);
        }
    }

    @Override
    public void handleWeworkOpResponse(OpBaseResponse opBaseResponse) {
        log.info("handleWeworkOpResponse opBaseResponse:{}", (Object)opBaseResponse);
        long start = System.currentTimeMillis();
        String requestId = opBaseResponse.getRequestId();
        if (StringUtils.isBlank((CharSequence)requestId)) {
            return;
        }
        MessageGroupSendDetail sendDetail = this.groupSendDetailMapper.queryByRequestId(requestId);
        if (sendDetail == null) {
            log.warn("messageGroupSendDetail second query null, return, requestId = {}", (Object)requestId);
            return;
        }
        this.updateDetailByResponse(opBaseResponse, requestId, sendDetail);
        this.refreshStatus(Lists.newArrayList((Object[])new Long[]{sendDetail.getTaskId()}));
        log.info("\u6d88\u606f\u7fa4\u53d1 handleWeworkOpResponse time {}, requestId:{}", (Object)(System.currentTimeMillis() - start), (Object)requestId);
    }

    @Override
    public void refreshStatus(Collection<Long> taskIds) {
        log.info("refreshStatus with taskIds={}", taskIds);
        this.freshTaskStatus(taskIds, Lists.newArrayList((Object[])new Integer[]{SendStatus.SENDING.getValue()}));
    }

    public void updateDetailByResponse(OpBaseResponse opBaseResponse, String requestId, MessageGroupSendDetail sendDetail) {
        String remark;
        Integer status;
        Integer code = opBaseResponse.getCode();
        Date sendCompleteTime = null;
        switch (ResponseCodeType.getInstance((int)code)) {
            case SUCCESS: {
                status = SendStatus.ALREADY_SEND.getValue();
                remark = this.splitLongString(opBaseResponse.getMsg());
                sendCompleteTime = new Date();
                break;
            }
            case WEWORK_OFFLINE: 
            case REQUEST_PARAM_NOT_INVALID: 
            case THRESHOLD_EXCEEDED: 
            case INTERNAL_SERVER_ERROR: 
            case SEND_TIME_OVER_24: 
            case CANCEL: {
                status = SendStatus.SEND_FAIL.getValue();
                remark = this.splitLongString(opBaseResponse.getMsg());
                break;
            }
            case EXPIRE: {
                status = SendStatus.ALREADY_EXPIRE.getValue();
                remark = "\u5df2\u8fc7\u671f";
                break;
            }
            case WEWORK_REQUEST_FREQUENTLY: {
                status = SendStatus.SEND_FAIL.getValue();
                remark = "\u5fae\u4fe1\u8fd4\u56de\uff1a\u6d88\u606f\u53d1\u9001\u9891\u7e41\u3002\u4e3a\u4e86\u60a8\u7684\u8d26\u53f7\u5b89\u5168\uff0c\u7cfb\u7edf\u5df2\u7ecf\u81ea\u52a8\u505c\u6b62\u53d1\u9001\uff0c\u5982\u987b\u518d\u6b21\u53d1\u9001\uff0c\u8bf7\u624b\u52a8\u70b9\u51fb\u4e00\u952e\u91cd\u53d1";
                break;
            }
            case CONCURRENT_MODIFY: 
            case BATCH_PUSH_CONCURRENT_MODIFY: {
                status = SendStatus.TO_BE_SEND.getValue();
                remark = this.splitLongString(opBaseResponse.getMsg());
                break;
            }
            default: {
                if (code == 2001) {
                    status = SendStatus.SEND_FAIL.getValue();
                    remark = "\u5fae\u4fe1\u8fd4\u56de\uff1a\u6d88\u606f\u53d1\u9001\u9891\u7e41\u3002\u4e3a\u4e86\u60a8\u7684\u8d26\u53f7\u5b89\u5168\uff0c\u7cfb\u7edf\u5df2\u7ecf\u81ea\u52a8\u505c\u6b62\u53d1\u9001\uff0c\u5982\u987b\u518d\u6b21\u53d1\u9001\uff0c\u8bf7\u624b\u52a8\u70b9\u51fb\u4e00\u952e\u91cd\u53d1";
                    break;
                }
                status = SendStatus.SEND_FAIL.getValue();
                remark = ResponseErrUtil.getRemark((OpBaseResponse)opBaseResponse);
            }
        }
        sendDetail.setStatus(status);
        sendDetail.setSendCompleteTime(sendCompleteTime);
        sendDetail.setRemark(remark);
        sendDetail.setRequestId(requestId);
        this.groupSendDetailMapper.updateByPrimaryKeySelective((Object)sendDetail);
        if (status.intValue() == SendStatus.SENDING.getValue()) {
            this.sopTaskStatusService.sendSopTaskStatusMsg(sendDetail.getTaskId(), sendDetail.getId(), SopTaskType.GROUP_SEND, sendDetail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.EXECUTED.getStatus()), null, sendDetail.getSendTime());
        } else if (status.intValue() == SendStatus.ALREADY_SEND.getValue()) {
            GroupSendWeworkDto dto = new GroupSendWeworkDto();
            dto.setTaskId(sendDetail.getTaskId());
            dto.setWeworkUserNum(sendDetail.getSendWeworkNum());
            dto.setSendTime(sendDetail.getSendTime());
            log.info("updateDetailByResponse,batchUpdateSendStatusToAlreadySend,dto:{}", (Object)dto);
            this.messageGroupSendWeworkMapper.batchUpdateSendStatusToAlreadySend(Collections.singletonList(dto));
            this.sopTaskStatusService.sendSopTaskStatusMsg(sendDetail.getTaskId(), sendDetail.getId(), SopTaskType.GROUP_SEND, sendDetail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, sendDetail.getSendCompleteTime());
        } else if (status.intValue() == SendStatus.ALREADY_EXPIRE.getValue() || status.intValue() == SendStatus.SEND_FAIL.getValue()) {
            this.sopTaskStatusService.sendSopTaskStatusMsg(sendDetail.getTaskId(), sendDetail.getId(), SopTaskType.GROUP_SEND, sendDetail.getReceiveId(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), remark, null);
        }
    }

    private String splitLongString(String msg) {
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return "";
        }
        if (msg.contains("errMsg")) {
            return msg.split("errMsg")[0];
        }
        return StringUtils.substring((String)msg, (int)0, (int)100);
    }
}

