/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.groupinvite.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.groupsend.dto.GroupInviteContactJoinStatusDto;
import com.kuaike.scrm.dal.groupsend.entity.GroupInviteTask;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteContactDetailMapper;
import com.kuaike.scrm.dal.groupsend.mapper.GroupInviteTaskMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.groupinvite.service.GroupInviteSyncService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupInviteSyncServiceImpl
implements GroupInviteSyncService {
    private static final Logger log = LoggerFactory.getLogger(GroupInviteSyncServiceImpl.class);
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private GroupInviteTaskMapper groupInviteTaskMapper;
    @Autowired
    private GroupInviteContactDetailMapper groupInviteContactDetailMapper;

    @Override
    public void startAll() {
        log.info("start sync group msg task");
        List corpList = this.weworkCorpMapper.selectAllAuthed();
        if (CollectionUtils.isEmpty((Collection)corpList)) {
            log.info("no authed corp found");
            return;
        }
        for (WeworkCorp corp : corpList) {
            this.start(corp.getBizId(), corp.getCorpId());
        }
    }

    public void start(Long bizId, String corpId) {
        List taskList = this.groupInviteTaskMapper.queryByDeadline(corpId, new Date());
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            return;
        }
        for (GroupInviteTask task : taskList) {
            this.start(bizId, corpId, task);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void start(Long bizId, String corpId, GroupInviteTask task) {
        Long taskId = task.getId();
        log.info("sync group invite task, corpId:{}, taskId:{}", (Object)corpId, (Object)taskId);
        List list = this.groupInviteContactDetailMapper.queryJoinStatusByTaskId(taskId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("nothing to sync, taskId:{}", (Object)taskId);
            return;
        }
        ArrayList ids = Lists.newArrayListWithCapacity((int)list.size());
        for (GroupInviteContactJoinStatusDto it : list) {
            if (it.getJoinTime() == null) continue;
            if (it.getQuitTime() == null) {
                ids.add(it.getId());
                continue;
            }
            if (!it.getQuitTime().after(it.getCreateTime())) continue;
            ids.add(it.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            log.info("update join status, ids={}", (Object)ids);
            this.groupInviteContactDetailMapper.updateJoinStatusByIds((Collection)ids, Integer.valueOf(1), Long.valueOf(-1L));
        }
    }
}

