/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.service.dto.resp.MeetingEncryRespDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.service.MeetingCusParamEncryRelService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MeetingCusParamEncryRelServiceImpl
implements MeetingCusParamEncryRelService {
    private static final Logger log = LoggerFactory.getLogger(MeetingCusParamEncryRelServiceImpl.class);
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private DistributedLock lock;

    @Override
    public void insertWhenInsertParamEncry(Long bizId, String encryNum, Long meetingId, String contactId, Long channelId) {
        log.info("insertWhenInsertParamEncry bizId:{} encryNum:{} meetingId:{} contactId:{} channelId:{}", new Object[]{bizId, encryNum, meetingId, contactId, channelId});
        if (this.relationExist(bizId, meetingId, contactId, channelId, encryNum)) {
            log.info("insertWhenInsertParamEncry exist");
            return;
        }
        MeetingCustomerParamEncryRelation relation = new MeetingCustomerParamEncryRelation();
        relation.setNum(this.idGen.getNum());
        relation.setBizId(bizId);
        relation.setEncryNum(encryNum);
        relation.setMeetingId(meetingId);
        relation.setContactId(contactId);
        relation.setChannelId(channelId);
        this.meetingCustomerParamEncryRelationMapper.insertSelective((Object)relation);
    }

    @Override
    public void batchInsertWhenGroupTaskFillExtField(Long bizId, List<MeetingEncryRespDto> list) {
        log.info("batchInsertWhenGroupTaskFillExtField list:{}", list);
        ArrayList<MeetingCustomerParamEncryRelation> insertList = new ArrayList<MeetingCustomerParamEncryRelation>();
        for (MeetingEncryRespDto meetingEncryRespDto : list) {
            String encryNum = meetingEncryRespDto.getEncryParam().replace("&customstr=", "");
            if (this.relationExist(bizId, meetingEncryRespDto.getMeetingId(), meetingEncryRespDto.getTargetId(), meetingEncryRespDto.getChannelId(), encryNum)) {
                log.info("batchInsertWhenGroupTaskFillExtField exist meetingEncryRespDto:{}", (Object)meetingEncryRespDto);
                continue;
            }
            MeetingCustomerParamEncryRelation relation = new MeetingCustomerParamEncryRelation();
            relation.setNum(this.idGen.getNum());
            relation.setBizId(bizId);
            relation.setEncryNum(encryNum);
            relation.setMeetingId(meetingEncryRespDto.getMeetingId());
            relation.setContactId(meetingEncryRespDto.getTargetId());
            relation.setChannelId(Long.valueOf(meetingEncryRespDto.getChannelId()));
            insertList.add(relation);
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            this.meetingCustomerParamEncryRelationMapper.batchInsert(insertList);
        }
    }

    private boolean relationExist(Long bizId, Long meetingId, String contactId, Long channelId, String encryNum) {
        MeetingCustomerParamEncryRelation select = new MeetingCustomerParamEncryRelation();
        select.setBizId(bizId);
        select.setMeetingId(meetingId);
        select.setContactId(contactId);
        select.setChannelId(channelId);
        select.setEncryNum(encryNum);
        MeetingCustomerParamEncryRelation exist = (MeetingCustomerParamEncryRelation)this.meetingCustomerParamEncryRelationMapper.selectOne((Object)select);
        return exist != null;
    }
}

