/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.common.enums.MeetingWatchType;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.ParamEncryTypeEnum;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.SignUtil;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dto.MeetingCustomerInfoDto;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.service.MeetingUrlService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service
public class MeetingUrlCommonServiceImpl
implements MeetingUrlCommonService {
    private static final Logger log = LoggerFactory.getLogger(MeetingUrlCommonServiceImpl.class);
    @Resource
    private ShortUrlService shortUrlService;
    @Resource
    private IdGen idGen;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private ExternalContactClient externalContactClient;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private ParamEncryService paramEncryService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private ParamEncryMapper paramEncryMapper;
    @Resource
    private MeetingUrlService meetingUrlService;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Value(value="${scrm.meeting.authMiddlePage:}")
    private String authMiddlePage;
    @Value(value="${scrm.meeting.commonDomainSiteUrl}")
    private String commonDomainSiteUrl;
    @Value(value="${baijiacloud.quickenter.url}")
    private String quickEnterUrl;
    @Value(value="${baijiacloud.private.meeting.url}")
    private String privateEnterUrl;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(4096), (ThreadFactory)new NamedThreadFactory("meetingUrlCommonService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getMeetingAuthUrl(Long bizId, String channelNum, String meetingNum, String weworkUserNum, boolean isPlayback, String roomId, String meetingLiveUrl, Integer authMode) {
        log.info("getMeetingAuthUrl,bizId:{},channelNum:{},meetingNum:{},weworkUserNum:{},isPlayback:{}", new Object[]{bizId, channelNum, meetingNum, weworkUserNum, isPlayback});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingNum), (Object)"meetingNum\u4e0d\u80fd\u4e3a\u7a7a");
        MeetingLiveDeliveryAuthMode liveDeliveryAuthMode = authMode == null ? MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT : MeetingLiveDeliveryAuthMode.getByMode((Integer)authMode);
        log.info("getMeetingAuthUrl,bizId:{},meetingNum:{},authMode:{}", new Object[]{bizId, meetingNum, authMode});
        if (isPlayback) {
            Meeting meeting = this.meetingCacheService.getMeetingByNum(meetingNum);
            Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u4f1a\u8bae\u4e0d\u5b58\u5728");
            return this.getMeetingPlaybackUrl(meeting, liveDeliveryAuthMode);
        }
        return this.getMeetingLiveUrl(bizId, meetingNum, roomId, meetingLiveUrl, channelNum, weworkUserNum, liveDeliveryAuthMode);
    }

    private String getMeetingPlaybackUrl(Meeting meeting, MeetingLiveDeliveryAuthMode authMode) {
        if (MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.equals((Object)authMode)) {
            return this.meetingUrlService.getBackendMeetingCommerceUrl(meeting.getBizId(), meeting.getNum(), meeting.getPlaybackUrl(), null, null, true);
        }
        return this.getMeetingAppletAuthUrl(meeting.getBizId(), meeting.getNum(), meeting.getRoomId(), meeting.getPlaybackUrl(), null, null, true);
    }

    private String getMeetingLiveUrl(Long bizId, String meetingNum, String roomId, String meetingUrl, String channelNum, String weworkUserNum, MeetingLiveDeliveryAuthMode authMode) {
        if (MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.equals((Object)authMode)) {
            return this.meetingUrlService.getBackendMeetingCommerceUrl(bizId, meetingNum, meetingUrl, channelNum, weworkUserNum, false);
        }
        return this.getMeetingAppletAuthUrl(bizId, meetingNum, roomId, meetingUrl, channelNum, weworkUserNum, false);
    }

    private String getMeetingAppletAuthUrl(Long bizId, String meetingNum, String roomId, String meetingUrl, String channelNum, String weworkUserNum, boolean isPlayback) {
        String authMiddlePageUrl;
        OauthShortUrl byOriginUrl;
        log.info("getMeetingAppletAuthUrl,meetingNum:{},channelNum:{},weworkUserNum:{}", new Object[]{meetingNum, channelNum, weworkUserNum});
        AppletInfo appletInfo = this.appletInfoMapper.selectNewestAppletByBizIdAndStatus(bizId, AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
        if (appletInfo == null) {
            log.info("getMeetingOfficialAuthUrl,appletInfo is null,meetingNum:{}", (Object)meetingNum);
            return meetingUrl;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.authMiddlePage).append("&meetingNum=").append(meetingNum).append("&isPlayback=").append(isPlayback ? "1" : "0");
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            stringBuilder.append("&channelNum=").append(channelNum);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            stringBuilder.append("&weworkUserNum=").append(weworkUserNum);
        }
        if ((byOriginUrl = this.shortUrlService.getByOriginUrl(authMiddlePageUrl = stringBuilder.toString())) != null) {
            String shortUrl = this.shortUrlService.getShortUlr(byOriginUrl.getShortUrl());
            log.info("getMeetingAppletAuthUrl getShortUrl ByOriginUrl longUrl:{} shortUlr:{}", (Object)authMiddlePageUrl, (Object)shortUrl);
            return shortUrl;
        }
        String shortUrlNum = this.idGen.getNum();
        this.shortUrlService.recordShortUrl(appletInfo.getAppId(), Integer.valueOf(OauthShortUrlTypeEnum.MEETING_AUTH_URL.getValue()), authMiddlePageUrl, authMiddlePageUrl, shortUrlNum);
        String shortUrl = this.shortUrlService.getShortUlr(shortUrlNum);
        log.info("getMeetingAppletAuthUrl,meetingNum:{}, shortUrl:{} authMiddlePageUrl:{}", new Object[]{meetingNum, shortUrl, authMiddlePageUrl});
        return shortUrl;
    }

    @Override
    public void unionId2contactId(String corpId, String unionId, String openId) {
        this.threadPool.submit(() -> {
            try {
                this.unionId2contactIdInner(corpId, unionId, openId);
            }
            catch (Exception e) {
                log.error("unionId2contactId error", (Throwable)e);
            }
        });
    }

    private void unionId2contactIdInner(String corpId, String unionId, String openId) {
        String externalUserId;
        log.info("unionId2contactId, corpId:{}, unionId:{}, openId:{}", new Object[]{corpId, unionId, openId});
        if (StringUtils.isBlank((CharSequence)corpId)) {
            log.warn("corpId is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)unionId)) {
            log.warn("unionId is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)openId)) {
            log.warn("openId is null");
            return;
        }
        WeworkContact exist = this.weworkContactMapper.selectByCorpIdAndUnionId(corpId, unionId);
        if (exist != null) {
            log.info("found exist wework contact, corpId:{}, contactId:{}, unionId:{}", new Object[]{corpId, exist.getContactId(), unionId});
            return;
        }
        try {
            externalUserId = this.externalContactClient.unionIdToExternalUserId(corpId, unionId, openId);
        }
        catch (WeworkException e) {
            if (Objects.equals(84084, e.getErrorCode())) {
                log.warn("\u8be5\u7528\u6237\u5c1a\u672a\u6dfb\u52a0\u4e3a\u4f01\u5fae\u5ba2\u6237, unionId:{}, openId:{}", (Object)unionId, (Object)openId);
            }
            log.error("Failed getting external_userid with, unionId:{}, openId:{}", new Object[]{unionId, openId, e});
            return;
        }
        catch (Exception e) {
            log.error("Failed getting external_userid with, unionId:{}, openId:{}", new Object[]{unionId, openId, e});
            return;
        }
        try {
            exist = this.weworkContactMapper.selectByCorpIdAndContactId(corpId, externalUserId);
            if (exist == null) {
                log.warn("weworkContact not found, corpId:{}, externalUserId:{}", (Object)corpId, (Object)externalUserId);
                return;
            }
            exist.setUnionid(unionId);
            exist.setUpdateTime(new Date());
            this.weworkContactMapper.updateByPrimaryKeySelective((Object)exist);
            this.ccCustomerNumService.getCustomerNumByWeworkContactId(exist.getBizId(), externalUserId, unionId);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5ba2\u6237unionId\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public MeetingCustomerInfoDto handleCustomerInfoWhenAuthorized(String channelNum, String weworkUserNum, Meeting meeting, String appId, String openId, String unionId, String headImgUrl, String nickname, Integer sex, MeetingLiveDeliveryAuthMode authMode) {
        Long finalInviteUserId;
        String finalCustomerStr;
        StopWatchDto timer = new StopWatchDto("meetingHandleCustomerInfoWhenAuthorized", true, log);
        timer.start("genUserNumber");
        Long bizId = meeting.getBizId();
        long userNumber = this.idGen.nextId();
        String customerStr = null;
        Long channelId = 0L;
        String contactId = null;
        timer.stop();
        Long inviteUserId = null;
        if (StringUtils.isNotBlank((CharSequence)channelNum)) {
            timer.start("selectChannel");
            channelId = this.meetingCacheService.getInviteChannel(bizId, channelNum);
            timer.stop();
            log.info("authRedirect getChannelIdByNum channelId:{}", (Object)channelId);
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            inviteUserId = this.meetingCacheService.getInviteUserId(meeting.getBizId(), weworkUserNum);
        }
        boolean newCustomerStr = false;
        if (channelId != 0L) {
            timer.start("selectParamEncryRelationWithChannelId");
            MeetingCustomerParamEncryRelation relation = this.selectParamEncryRelation(bizId, meeting.getId(), appId, openId, unionId, channelId);
            timer.stop();
            if (relation != null) {
                customerStr = relation.getEncryNum();
                userNumber = StringUtils.isBlank((CharSequence)relation.getBjyNumber()) ? userNumber : Long.parseLong(relation.getBjyNumber());
                headImgUrl = relation.getBjyAvatar();
                nickname = relation.getBjyName();
                finalCustomerStr = customerStr;
                finalInviteUserId = inviteUserId;
                this.threadPool.submit(() -> {
                    try {
                        this.setWeworkUserNum(weworkUserNum, finalCustomerStr, finalInviteUserId);
                    }
                    catch (Exception e) {
                        log.error("setWeworkUserNum error", (Throwable)e);
                    }
                });
            } else {
                timer.start("getCustomerStrByChannel");
                customerStr = this.getCustomerStrByChannel(bizId, appId, openId, unionId, userNumber, channelId, meeting, weworkUserNum, nickname, inviteUserId);
                timer.stop();
                newCustomerStr = true;
            }
        } else {
            timer.start("selectParamEncryRelation");
            MeetingCustomerParamEncryRelation relation = this.selectParamEncryRelation(bizId, meeting.getId(), appId, openId, unionId, null);
            timer.stop();
            if (relation != null) {
                customerStr = relation.getEncryNum();
                userNumber = Long.parseLong(relation.getBjyNumber());
                headImgUrl = relation.getBjyAvatar();
                nickname = relation.getBjyName();
                finalCustomerStr = customerStr;
                finalInviteUserId = inviteUserId;
                this.threadPool.submit(() -> {
                    try {
                        this.setWeworkUserNum(weworkUserNum, finalCustomerStr, finalInviteUserId);
                    }
                    catch (Exception e) {
                        log.error("setWeworkUserNum error", (Throwable)e);
                    }
                });
            } else if (StringUtils.isNotBlank((CharSequence)unionId)) {
                ParamEncry paramEncry = this.meetingCacheService.getMeetingParamBySidebarInvite(bizId, meeting.getId(), unionId);
                if (paramEncry != null) {
                    customerStr = paramEncry.getNum();
                    String finalNickname1 = nickname;
                    long finalUserNumber = userNumber;
                    Long finalInviteUserId1 = inviteUserId;
                    String finalCustomerStr1 = customerStr;
                    this.threadPool.submit(() -> {
                        try {
                            MeetingParams meetingParams = (MeetingParams)JSONObject.parseObject((String)paramEncry.getParams(), MeetingParams.class);
                            this.updateMeetingParams(meetingParams, appId, openId, unionId, finalNickname1, weworkUserNum, finalUserNumber, finalInviteUserId1, finalCustomerStr1);
                        }
                        catch (Exception e) {
                            log.error("getCustomerStr,updateMeetingParams error", (Throwable)e);
                        }
                    });
                }
                if (StringUtils.isBlank((CharSequence)customerStr)) {
                    customerStr = this.getCustomerStr(bizId, appId, openId, unionId, userNumber, meeting, weworkUserNum, nickname, inviteUserId);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)customerStr)) {
            log.info("authRedirect getCustomerStr customerStr is null");
            timer.start("generateCustomerStr");
            customerStr = this.generateCustomerStr(appId, openId, unionId, userNumber, meeting, contactId, channelId, weworkUserNum, nickname, inviteUserId);
            timer.stop();
            newCustomerStr = true;
        }
        if (newCustomerStr) {
            MeetingCustomerParamEncryRelation insert = new MeetingCustomerParamEncryRelation();
            insert.setAppId(appId);
            insert.setOpenId(openId);
            insert.setBizId(bizId);
            insert.setMeetingId(meeting.getId());
            insert.setUnionId(StringUtils.isNotBlank((CharSequence)unionId) ? unionId : null);
            insert.setEncryNum(customerStr);
            insert.setNum(this.idGen.getNum());
            insert.setContactId(contactId);
            insert.setChannelId(channelId);
            insert.setBjyName(nickname);
            insert.setBjyNumber(String.valueOf(userNumber));
            insert.setBjyAvatar(headImgUrl);
            timer.start("insertParamEncryRelation");
            this.meetingCustomerParamEncryRelationMapper.insertSelective((Object)insert);
            timer.stop();
            this.meetingCacheService.setParamEncryRelation(insert, meeting.getEndTime());
            String finalHeadImgUrl = headImgUrl;
            String finalNickname = nickname;
            this.threadPool.submit(() -> {
                try {
                    this.syncCustomerDetailToCustomer(bizId, appId, openId, unionId, channelNum, finalHeadImgUrl, finalNickname, sex, authMode);
                }
                catch (Exception e) {
                    log.error("authRedirect,syncCustomerDetailToCustomer error", (Throwable)e);
                }
            });
        } else {
            MeetingCustomerParamEncryRelation update = new MeetingCustomerParamEncryRelation();
            update.setEncryNum(customerStr);
            update.setAppId(appId);
            update.setOpenId(openId);
            update.setUnionId(StringUtils.isNotBlank((CharSequence)unionId) ? unionId : null);
            update.setBjyName(nickname);
            update.setBjyNumber(String.valueOf(userNumber));
            update.setBjyAvatar(headImgUrl);
            timer.start("updateParamEncryRelation");
            this.meetingCustomerParamEncryRelationMapper.updateByCustomerStr(update);
            timer.stop();
            this.meetingCacheService.setParamEncryRelation(update, meeting.getEndTime());
        }
        MeetingCustomerInfoDto dto = new MeetingCustomerInfoDto();
        dto.setCustomerStr(customerStr);
        dto.setUserNumber(userNumber);
        timer.print();
        return dto;
    }

    @Override
    public MeetingCustomerInfoDto handlePlaybackCustomerInfoWhenAuthorized(Meeting meeting, String appId, String openId, String unionId, String headImgUrl, String nickname, MeetingLiveDeliveryAuthMode authMode) {
        String encryNum;
        Long bizId = meeting.getBizId();
        MeetingCustomerParamEncryRelation relation = this.selectParamEncryRelation(bizId, meeting.getId(), appId, openId, unionId, null);
        if (relation != null) {
            encryNum = relation.getEncryNum();
        } else {
            MeetingParams meetingParams = new MeetingParams();
            meetingParams.setMeetingId(meeting.getId());
            meetingParams.setMeetingType(meeting.getType().intValue());
            meetingParams.setAppId(appId);
            meetingParams.setOpenId(openId);
            meetingParams.setUnionId(unionId);
            encryNum = this.paramEncryService.encryMeetingParamByPlayback(meetingParams);
            MeetingCustomerParamEncryRelation insert = new MeetingCustomerParamEncryRelation();
            insert.setAppId(appId);
            insert.setOpenId(openId);
            insert.setBizId(bizId);
            insert.setMeetingId(meeting.getId());
            insert.setUnionId(StringUtils.isNotBlank((CharSequence)unionId) ? unionId : null);
            insert.setEncryNum(encryNum);
            insert.setNum(this.idGen.getNum());
            insert.setContactId(null);
            insert.setChannelId(null);
            if (StringUtils.isNotBlank((CharSequence)headImgUrl)) {
                insert.setBjyAvatar(headImgUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)nickname)) {
                insert.setBjyName(nickname);
            }
            insert.setWatchType(Integer.valueOf(MeetingWatchType.PLAY_BACK.getValue()));
            long userNumber = this.idGen.nextId();
            insert.setBjyNumber(String.valueOf(userNumber));
            this.meetingCustomerParamEncryRelationMapper.insertSelective((Object)insert);
            relation = insert;
            this.meetingCacheService.setParamEncryRelation(insert, meeting.getEndTime());
        }
        MeetingCustomerInfoDto dto = new MeetingCustomerInfoDto();
        dto.setCustomerStr(encryNum);
        dto.setUserNumber(Long.parseLong(relation.getBjyNumber()));
        return dto;
    }

    private MeetingCustomerParamEncryRelation selectParamEncryRelation(Long bizId, Long meetingId, String appId, String openId, String unionId, Long channelId) {
        log.info("selectParamEncryRelation bizId:{} meetingId:{} appId:{} openId:{} unionId:{} channelId:{}", new Object[]{bizId, meetingId, appId, openId, unionId, channelId});
        MeetingCustomerParamEncryRelation paramEncryRelation = this.meetingCacheService.getParamEncryRelation(bizId, meetingId, appId, openId, unionId, channelId);
        if (paramEncryRelation == null) {
            MeetingCustomerParamEncryRelation relation = new MeetingCustomerParamEncryRelation();
            relation.setAppId(appId);
            relation.setOpenId(openId);
            relation.setBizId(bizId);
            relation.setMeetingId(meetingId);
            relation.setUnionId(StringUtils.isNotBlank((CharSequence)unionId) ? unionId : null);
            relation.setChannelId(Long.valueOf(channelId == null ? 0L : channelId));
            List select = this.meetingCustomerParamEncryRelationMapper.select((Object)relation);
            log.info("selectParamEncryRelation from db,relations:{}", (Object)select);
            return CollectionUtils.isEmpty((Collection)select) ? null : (MeetingCustomerParamEncryRelation)select.get(0);
        }
        return paramEncryRelation;
    }

    private void setWeworkUserNum(String weworkUserNum, String customerStr, Long inviteUserId) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            return;
        }
        MeetingParams meetingParams = this.paramEncryService.getMeetingParamsByNum(customerStr);
        if (meetingParams == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)meetingParams.getWeworkUserNum()) && !"-1".equals(meetingParams.getWeworkUserNum())) {
            return;
        }
        meetingParams.setWeworkUserNum(weworkUserNum);
        meetingParams.setUserId(inviteUserId);
        this.paramEncryService.updateMeetingParam(customerStr, meetingParams);
    }

    private void syncCustomerDetailToCustomer(Long bizId, String appId, String openId, String unionId, String channelNum, String headImgUrl, String nickname, Integer sex, MeetingLiveDeliveryAuthMode authMode) {
        String customerNumByType = MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.equals((Object)authMode) ? this.ccCustomerNumService.getCustomerNumByOfficialFans(bizId, appId, openId, unionId) : this.ccCustomerNumService.getCustomerNumByMiniProgram(bizId, appId, openId, unionId);
        if (StringUtils.isBlank((CharSequence)customerNumByType)) {
            log.warn("\u4ece\u5ba2\u6237\u4e2d\u5fc3\u67e5\u4e0d\u5230customerNum");
            return;
        }
        log.info("queryContactId customerNum:{}", (Object)customerNumByType);
        CustomerDetailReq customerDetailReq = new CustomerDetailReq();
        if (StringUtils.isNotBlank((CharSequence)headImgUrl)) {
            customerDetailReq.setAvatar(headImgUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            customerDetailReq.setName(nickname);
        }
        if (sex != null) {
            customerDetailReq.setGender(sex);
        }
        customerDetailReq.setChannelId(channelNum);
        customerDetailReq.setType(Integer.valueOf(1));
        customerDetailReq.setBizId(bizId);
        customerDetailReq.setCustomerNum(customerNumByType);
        try {
            this.ccCustomerDetailService.add(customerDetailReq);
        }
        catch (Exception e) {
            log.error("syncCustomerDetailToCustomer add CustomerDetail error", (Throwable)e);
        }
    }

    private String getCustomerStrByChannel(Long bizId, String appId, String openId, String unionId, long userNumber, Long channelId, Meeting meeting, String weworkUserNum, String nickname, Long inviteUserId) {
        log.info("getCustomerStrByChannel bizId:{} userNumber:{} appId:{} openId:{} unionId:{} channelId:{} inviteUserId:{}", new Object[]{bizId, userNumber, appId, openId, unionId, channelId, inviteUserId});
        MeetingParams oldMeetingParams = this.meetingCacheService.getMeetingParamByChannel(bizId, meeting.getId(), channelId);
        if (oldMeetingParams == null) {
            MeetingCustomerParamEncryRelation paramEncryRelation;
            log.info("getCustomerStrByChannel from db");
            MeetingCustomerParamEncryRelation relation = new MeetingCustomerParamEncryRelation();
            relation.setBizId(bizId);
            relation.setContactId(null);
            relation.setChannelId(channelId);
            relation.setMeetingId(meeting.getId());
            relation.setAppId("-1");
            relation.setOpenId("-1");
            relation.setUnionId(null);
            List paramEncryRelations = this.meetingCustomerParamEncryRelationMapper.select((Object)relation);
            if (CollectionUtils.isEmpty((Collection)paramEncryRelations)) {
                log.info("getCustomerStrByChannel \u901a\u8fc7channelId\u67e5\u4e0d\u5230customerStr");
                return null;
            }
            if (paramEncryRelations.size() > 1) {
                log.info("getCustomerStrByChannel \u67e5\u8be2\u5230\u591a\u6761paramEncryRelations:{}", (Object)paramEncryRelations);
            }
            if ((paramEncryRelation = (MeetingCustomerParamEncryRelation)paramEncryRelations.get(0)) == null || StringUtils.isBlank((CharSequence)paramEncryRelation.getEncryNum())) {
                log.warn("\u67e5\u8be2\u4e0d\u5230\u6e20\u9053\u5165\u4f1a\u94fe\u63a5\u7684customerStr");
                return null;
            }
            String oldCustomerStr = paramEncryRelation.getEncryNum();
            oldMeetingParams = this.paramEncryService.getMeetingParamsByNum(oldCustomerStr);
            if (oldMeetingParams == null) {
                log.warn("\u901a\u8fc7customerStr\u67e5\u8be2\u4e0d\u5230MeetingParams customerStr:{}", (Object)oldCustomerStr);
                return null;
            }
        }
        if (oldMeetingParams.getMeetingId() == null || !oldMeetingParams.getMeetingId().equals(meeting.getId())) {
            log.warn("\u901a\u8fc7customerStr\u67e5\u8be2\u5230MeetingParams\u7684 \u4e0d\u5c5e\u4e8e\u5f53\u524d\u4f1a\u8bae meetingParams:{}", (Object)oldMeetingParams);
            return null;
        }
        log.info("getCustomerStrByChannel bizId:{} openId:{} oldMeetingParams:{}", new Object[]{bizId, openId, oldMeetingParams});
        String newCustomerStr = this.idGen.getNum();
        MeetingParams newMeetingParams = new MeetingParams();
        BeanUtils.copyProperties((Object)oldMeetingParams, (Object)newMeetingParams);
        newMeetingParams.setAppId(appId);
        newMeetingParams.setOpenId(openId);
        newMeetingParams.setUnionId(unionId);
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            newMeetingParams.setUserName(nickname);
        }
        newMeetingParams.setUserNumber(Long.valueOf(userNumber));
        newMeetingParams.setWeworkUserNum(weworkUserNum == null ? "-1" : weworkUserNum);
        newMeetingParams.setUserId(inviteUserId);
        String paramsJsonStr = JsonUtil.toStr((Object)newMeetingParams);
        ParamEncry paramEncry = new ParamEncry();
        paramEncry.setNum(newCustomerStr);
        paramEncry.setParams(paramsJsonStr);
        paramEncry.setType(Integer.valueOf(ParamEncryTypeEnum.MEETING_TYPE.getValue()));
        paramEncry.setCreateTime(new Date());
        this.paramEncryMapper.insertSelective((Object)paramEncry);
        log.info("getCustomerStrByChannel bizId:{} openId:{} oldMeetingParams:{} newParamEncry:{}", new Object[]{bizId, openId, oldMeetingParams, paramEncry});
        return newCustomerStr;
    }

    private String getCustomerStr(Long bizId, String appId, String openId, String unionId, long userNumber, Meeting meeting, String weworkUserNum, String nickname, Long inviteUserId) {
        MeetingCustomerParamEncryRelation paramEncryRelation;
        log.info("getCustomerStr bizId:{} userNumber:{} appId:{} openId:{} unionId:{} meetingId:{} weworkUserNum:{} inviteUserId:{}", new Object[]{bizId, userNumber, appId, openId, unionId, meeting.getId(), weworkUserNum, inviteUserId});
        WeworkContact select = new WeworkContact();
        select.setBizId(bizId);
        select.setUnionid(unionId);
        WeworkContact weworkContact = (WeworkContact)this.weworkContactMapper.selectOne((Object)select);
        if (weworkContact == null) {
            log.warn("getCustomerStr weworkContact is null");
            return null;
        }
        MeetingCustomerParamEncryRelation relation = new MeetingCustomerParamEncryRelation();
        relation.setBizId(bizId);
        relation.setMeetingId(meeting.getId());
        relation.setContactId(weworkContact.getContactId());
        relation.setChannelId(Long.valueOf(0L));
        List paramEncryRelations = this.meetingCustomerParamEncryRelationMapper.select((Object)relation);
        if (CollectionUtils.isEmpty((Collection)paramEncryRelations)) {
            log.info("getCustomerStr \u901a\u8fc7contactId\u67e5\u4e0d\u5230customerStr");
            return null;
        }
        if (paramEncryRelations.size() > 1) {
            log.info("getCustomerStr \u67e5\u8be2\u5230\u591a\u6761paramEncryRelations:{}", (Object)paramEncryRelations);
        }
        if ((paramEncryRelation = (MeetingCustomerParamEncryRelation)paramEncryRelations.get(0)) == null || StringUtils.isBlank((CharSequence)paramEncryRelation.getEncryNum())) {
            log.warn("getCustomerStr \u901a\u8fc7contactId\u67e5\u4e0d\u5230customerStr");
            return null;
        }
        String customerStr = paramEncryRelation.getEncryNum();
        MeetingParams meetingParams = this.paramEncryService.getMeetingParamsByNum(customerStr);
        if (meetingParams == null) {
            log.warn("getCustomerStr \u901a\u8fc7customerStr\u67e5\u8be2\u4e0d\u5230MeetingParams customerStr:{}", (Object)customerStr);
            return null;
        }
        if (meetingParams.getMeetingId() == null || !meetingParams.getMeetingId().equals(meeting.getId())) {
            log.warn("getCustomerStr \u901a\u8fc7customerStr\u67e5\u8be2\u5230MeetingParams\u7684 \u4e0d\u5c5e\u4e8e\u5f53\u524d\u4f1a\u8bae customerStr:{} meetingParams:{}", (Object)customerStr, (Object)meetingParams);
            return null;
        }
        this.threadPool.submit(() -> {
            try {
                this.updateMeetingParams(meetingParams, appId, openId, unionId, nickname, weworkUserNum, userNumber, inviteUserId, customerStr);
            }
            catch (Exception e) {
                log.error("getCustomerStr,updateMeetingParams error", (Throwable)e);
            }
        });
        return customerStr;
    }

    private void updateMeetingParams(MeetingParams meetingParams, String appId, String openId, String unionId, String nickname, String weworkUserNum, long userNumber, Long inviteUserId, String customerStr) {
        meetingParams.setAppId(appId);
        meetingParams.setOpenId(openId);
        meetingParams.setUnionId(unionId);
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            meetingParams.setUserName(nickname);
        }
        meetingParams.setUserNumber(Long.valueOf(userNumber));
        meetingParams.setWeworkUserNum(weworkUserNum == null ? "-1" : weworkUserNum);
        meetingParams.setUserId(inviteUserId);
        this.paramEncryService.updateMeetingParam(customerStr, meetingParams);
    }

    private String generateCustomerStr(String appId, String openId, String unionId, long userNumber, Meeting meeting, String contactId, Long channelId, String weworkUserNum, String nickname, Long inviteUserId) {
        MeetingParams meetingParams = new MeetingParams();
        meetingParams.setAppId(appId);
        meetingParams.setOpenId(openId);
        meetingParams.setUnionId(unionId);
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            meetingParams.setUserName(nickname);
        }
        meetingParams.setUserNumber(Long.valueOf(userNumber));
        meetingParams.setMeetingId(meeting.getId());
        meetingParams.setMeetingType(meeting.getType().intValue());
        meetingParams.setGroupSendNum("-1");
        meetingParams.setType(Integer.valueOf(-1));
        meetingParams.setTargetId(StringUtils.isBlank((CharSequence)contactId) ? null : contactId);
        meetingParams.setChannelId(channelId.longValue());
        meetingParams.setWeworkUserNum(weworkUserNum == null ? "-1" : weworkUserNum);
        meetingParams.setUserId(inviteUserId);
        String numStr = this.paramEncryService.encryMeetingParam(meetingParams);
        return numStr.replace("&customstr=", "");
    }

    @Override
    public String buildMeetingIntoUrl(String customerStr, Long roomId, String headImgUrl, String nickName, MeetingSetting meetingSetting, Long userNumber, String meetingNum, int isPrivate) {
        String domainSite;
        log.info("buildMeetingIntoUrl customerStr:{} roomId:{} userNumber:{} meetingNum:{}", new Object[]{customerStr, roomId, userNumber, meetingNum});
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("room_id", roomId);
        signMap.put("user_avatar", "");
        if (StringUtils.isNotBlank((CharSequence)headImgUrl)) {
            signMap.put("user_avatar", headImgUrl);
        }
        signMap.put("user_name", "");
        if (StringUtils.isNotBlank((CharSequence)nickName)) {
            signMap.put("user_name", nickName);
        }
        signMap.put("user_number", userNumber);
        signMap.put("user_role", 0);
        String concatString = SignUtil.formatUrlMap(signMap, (boolean)false, (boolean)false);
        String encodeConcatString = SignUtil.formatUrlMap(signMap, (boolean)true, (boolean)false);
        concatString = concatString + "&partner_key=" + meetingSetting.getBjyKey();
        String sign = DigestUtils.md5DigestAsHex((byte[])concatString.getBytes());
        StringBuilder intoUrl = new StringBuilder();
        String string = domainSite = StringUtils.isBlank((CharSequence)this.commonDomainSiteUrl) ? meetingSetting.getDominSite() : this.commonDomainSiteUrl;
        if (isPrivate == 0) {
            intoUrl.append(domainSite).append("web/room/enter?").append(encodeConcatString).append("&sign=").append(sign).append("&pay_channel=1&meeting_id=").append(meetingNum);
            if (StringUtils.isNotBlank((CharSequence)customerStr)) {
                intoUrl.append("&customstr=").append(customerStr);
            }
        } else {
            intoUrl.append(domainSite).append("web/room/prepare?room_id=").append(roomId).append("&pay_channel=1&meeting_id=").append(meetingNum);
            if (StringUtils.isNotBlank((CharSequence)customerStr)) {
                intoUrl.append("&customstr=").append(customerStr);
            }
        }
        log.info("buildMeetingIntoUrl concatString:{} sign:{} intoUrl:{}", new Object[]{concatString, sign, intoUrl});
        return intoUrl.toString();
    }

    @Override
    public String buildPlaybackUrlToCommonDomainUrl(Long bizId, String originPlaybackUrl, String meetingNum, String customerStr, String roomId) {
        log.info("buildPlaybackUrlToCommonDomainUrl,originPlaybackUrl:{},bizId:{},meetingNum:{},customerStr:{}", new Object[]{originPlaybackUrl, bizId, meetingNum, customerStr});
        MeetingSetting meetingSetting = this.meetingCacheService.getMeetingSetting(bizId);
        if (meetingSetting == null) {
            log.info("buildPlaybackUrlToCommonDomainUrl meetingSetting is empty");
            return originPlaybackUrl;
        }
        String domainSite = StringUtils.isBlank((CharSequence)this.commonDomainSiteUrl) ? meetingSetting.getDominSite() : this.commonDomainSiteUrl;
        String commonPlaybackUrl = originPlaybackUrl.replaceAll(meetingSetting.getDominSite(), domainSite);
        StringBuilder playbackUrl = new StringBuilder().append(commonPlaybackUrl).append("&pay_channel=1&meeting_id=").append(meetingNum).append("&room_id=").append(roomId);
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            playbackUrl.append("&customstr=").append(customerStr);
        }
        log.info("buildPlaybackUrlToCommonDomainUrl,commonPlaybackUrl:{}", (Object)playbackUrl.toString());
        return playbackUrl.toString();
    }

    @Override
    public String buildOriginMeetingUrlAndGenCustomerStr(Meeting meeting, String channelNum, String weworkUserNum, String appId, String openId, String unionId, String customerStr, boolean isPlayback, boolean genCustomerStr) {
        String originMeetingUrl;
        log.info("buildOriginMeetingUrlAndGenCustomerStr,meetingId:{},channelNum:{},weworkUserNum:{},appId:{},openId:{},unionId:{},customerStr:{},isPlayback:{},genCustomerStr:{}", new Object[]{meeting.getId(), channelNum, weworkUserNum, appId, openId, unionId, customerStr, isPlayback, genCustomerStr});
        try {
            Long channelId = 0L;
            if (StringUtils.isNotBlank((CharSequence)channelNum)) {
                channelId = this.meetingCacheService.getInviteChannel(meeting.getBizId(), channelNum);
            }
            Long inviteUserId = null;
            if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
                inviteUserId = this.meetingCacheService.getInviteUserId(meeting.getBizId(), weworkUserNum);
            }
            boolean isNewCustomer = true;
            MeetingCustomerParamEncryRelation relation = null;
            if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)openId) && (relation = this.meetingCacheService.getParamEncryRelation(meeting.getBizId(), meeting.getId(), appId, openId, unionId, channelId)) != null) {
                log.info("buildOriginMeetingUrlAndGenCustomerStr,getParamEncryRelation from cache,relation:{}", (Object)relation);
                isNewCustomer = false;
                customerStr = relation.getEncryNum();
                String finalCustomerStr = relation.getEncryNum();
                Long finalInviteUserId = inviteUserId;
                this.threadPool.submit(() -> {
                    try {
                        this.setWeworkUserNum(weworkUserNum, finalCustomerStr, finalInviteUserId);
                    }
                    catch (Exception e) {
                        log.error("setWeworkUserNum error", (Throwable)e);
                    }
                });
            }
            if (isNewCustomer && genCustomerStr) {
                if (StringUtils.isBlank((CharSequence)customerStr)) {
                    customerStr = this.idGen.getNum();
                }
                this.insertParamEncry(meeting.getId(), appId, openId, unionId, customerStr, channelId, weworkUserNum, inviteUserId);
                relation = this.insertParamEncryRelation(StringUtils.isBlank((CharSequence)appId) ? "-1" : appId, StringUtils.isBlank((CharSequence)openId) ? "-1" : openId, meeting.getBizId(), meeting.getId(), StringUtils.isBlank((CharSequence)unionId) ? null : unionId, customerStr, channelId, isPlayback);
            }
            if (relation != null && StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)openId)) {
                this.meetingCacheService.setParamEncryRelation(relation, meeting.getEndTime());
            }
        }
        catch (Exception e) {
            log.error("buildOriginMeetingUrlAndGenCustomerStr,\u63d2\u5165paramEncry\u5f02\u5e38", (Throwable)e);
        }
        if (isPlayback || MeetingStatus.FINISHED.getValue() == meeting.getStatus().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
            originMeetingUrl = meeting.getPlaybackUrl();
            if (StringUtils.isNotBlank((CharSequence)customerStr)) {
                originMeetingUrl = meeting.getPlaybackUrl() + "&customstr=" + customerStr;
            }
        } else {
            originMeetingUrl = meeting.getOriginMeetingUrl();
            originMeetingUrl = StringUtils.isNotBlank((CharSequence)customerStr) ? originMeetingUrl.replace("${customstr}", "&customstr=" + customerStr) : originMeetingUrl.replace("${customstr}", "");
        }
        originMeetingUrl = originMeetingUrl + "&meeting_id=" + meeting.getNum();
        log.info("buildOriginMeetingUrlAndGenCustomerStr,meetingId:{},originMeetingUrl:{}", (Object)meeting.getId(), (Object)originMeetingUrl);
        return originMeetingUrl;
    }

    @Override
    public MeetingCustomerParamEncryRelation insertParamEncryRelation(String appId, String openId, Long bizId, Long meetingId, String unionId, String customerStr, Long channelId, boolean isPlayback) {
        MeetingCustomerParamEncryRelation insert = new MeetingCustomerParamEncryRelation();
        insert.setAppId(appId);
        insert.setOpenId(openId);
        insert.setBizId(bizId);
        insert.setMeetingId(meetingId);
        insert.setUnionId(StringUtils.isNotBlank((CharSequence)unionId) ? unionId : null);
        insert.setEncryNum(customerStr);
        insert.setNum(this.idGen.getNum());
        insert.setContactId(null);
        insert.setChannelId(Long.valueOf(0L));
        insert.setBjyName("");
        insert.setBjyNumber("");
        insert.setBjyAvatar("");
        insert.setChannelId(Long.valueOf(channelId == null ? 0L : channelId));
        insert.setWatchType(Integer.valueOf(isPlayback ? MeetingWatchType.PLAY_BACK.getValue() : MeetingWatchType.LIVE.getValue()));
        this.meetingCustomerParamEncryRelationMapper.insertSelective((Object)insert);
        log.info("insertParamEncryRelation relation:{}", (Object)insert);
        return insert;
    }

    @Override
    public void insertParamEncry(Long meetingId, String appId, String openId, String unionId, String customerStr, Long channelId, String weworkUserNum, Long userId) {
        MeetingParams meetingParams = new MeetingParams();
        meetingParams.setMeetingId(meetingId);
        meetingParams.setGroupSendNum("-1");
        meetingParams.setWeworkUserNum(null);
        meetingParams.setUserId(null);
        meetingParams.setTargetId("-1");
        meetingParams.setAppId(appId);
        meetingParams.setOpenId(openId);
        meetingParams.setUnionId(unionId);
        meetingParams.setUserNumber(Long.valueOf(this.idGen.nextId()));
        meetingParams.setChannelId(channelId == null ? 0L : channelId);
        meetingParams.setWeworkUserNum(weworkUserNum);
        meetingParams.setUserId(userId);
        ParamEncry paramEncry = new ParamEncry();
        paramEncry.setNum(customerStr);
        paramEncry.setParams(JSONObject.toJSONString((Object)meetingParams));
        paramEncry.setType(Integer.valueOf(ParamEncryTypeEnum.MEETING_TYPE.getValue()));
        paramEncry.setCreateTime(new Date());
        this.paramEncryMapper.insertSelective((Object)paramEncry);
        log.info("insert paramEncry:{}", (Object)paramEncry);
    }

    @Override
    public String buildQuickEnterUrl(String studentCode) {
        log.info("buildQuickEnterUrl,studentCode:{}", (Object)studentCode);
        return this.commonDomainSiteUrl + this.quickEnterUrl + "?code=" + studentCode + "${customstr}";
    }

    @Override
    public String buildPrepareUrl(String roomId) {
        log.info("buildQuickEnterUrl,roomId:{}", (Object)roomId);
        return this.commonDomainSiteUrl + this.privateEnterUrl + "?room_id=" + roomId + "${customstr}";
    }
}

