/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service.impl;

import cn.kinyun.customer.center.dto.req.TuitionReportReq;
import cn.kinyun.customer.center.dto.resp.TuitionReportDto;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.ExportTaskType;
import com.kuaike.scrm.dal.exporttask.entity.ExportTask;
import com.kuaike.scrm.dal.exporttask.mapper.ExportTaskMapper;
import com.kuaike.scrm.order.service.TuitionReportService;
import com.kuaike.scrm.wework.contact.service.impl.AbstractExportService;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tuitionReportExport")
public class TuitionReportExportServiceImpl
extends AbstractExportService {
    private static final Logger log = LoggerFactory.getLogger(TuitionReportExportServiceImpl.class);
    @Autowired
    private ExportTaskMapper exportTaskMapper;
    @Autowired
    private TuitionReportService tuitionReportService;

    protected Runnable buildTask(ExportTask task, String json) {
        return () -> {
            if (Objects.isNull(task)) {
                log.error("build status is null");
                return;
            }
            try {
                log.info("run task num: {},json:{}", (Object)task.getNum(), (Object)json);
                String filePath = this.createExportFile(task, json);
                task.setFilePath(filePath);
            }
            catch (BusinessException e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg(e.getMessage());
            }
            catch (Exception e) {
                log.error("build task error: ", (Throwable)e);
                task.setErrorMsg("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            finally {
                task.setStatus(Integer.valueOf(2));
                task.setUpdateTime(new Date());
                this.exportTaskMapper.updateByPrimaryKeySelective((Object)task);
            }
        };
    }

    private String createExportFile(ExportTask task, String json) {
        String corpId = task.getCorpId();
        this.createCorpDir(corpId);
        String filePath = this.createFilePath(corpId, ExportTaskType.TUITION_REPORT, "\u5b66\u8d39\u62a5\u8868\u5bfc\u51fa");
        String sheetName = "\u5b66\u8d39\u62a5\u8868";
        ExcelWriter excelWriter = null;
        String url = null;
        try {
            excelWriter = EasyExcel.write((String)filePath, TuitionReportDto.class).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0, (String)sheetName).build();
            TuitionReportReq queryParam = (TuitionReportReq)JSON.parseObject((String)json, TuitionReportReq.class);
            queryParam.setIsExport(Boolean.valueOf(true));
            queryParam.setBizId(task.getBizId());
            queryParam.setIsMainBizId(task.getIsMainBizId());
            queryParam.setExcludeBizIds(task.getExcludeBizIds());
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(100));
            int pageNum = 1;
            while (true) {
                pageDto.setPageNum(Integer.valueOf(pageNum));
                queryParam.setPageDto(pageDto);
                List<TuitionReportDto> tuitionReports = this.tuitionReportService.tuitionReport(queryParam);
                int size = CollectionUtils.size(tuitionReports);
                if (size == 0) break;
                ++pageNum;
                excelWriter.write(tuitionReports, writeSheet);
            }
            excelWriter.finish();
            File file = new File(filePath);
            if (file.exists()) {
                url = this.uploadOss(corpId, file);
            }
        }
        catch (BusinessException e) {
            log.error("export payRecord BusinessException error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        catch (Exception e) {
            log.error("export payRecord error: ", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            File file;
            if (excelWriter != null) {
                excelWriter.finish();
            }
            if ((file = new File(filePath)).exists()) {
                file.delete();
            }
        }
        return url;
    }
}

