/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.coupon.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum CouponType {
    PRODUCT_CONDITION_DISCOUNT(1, "\u5546\u54c1\u6761\u4ef6\u6298\u6263\u5238"),
    PRODUCT_FULL_DISCOUNT(2, "\u5546\u54c1\u6ee1\u51cf\u5238"),
    PRODUCT_FLAT_DISCOUNT(3, "\u5546\u54c1\u7edf\u4e00\u6298\u6263\u5238"),
    PRODUCT_DIRECT_DISCOUNT(4, "\u5546\u54c1\u76f4\u51cf\u5238"),
    STORE_CONDITION_DISCOUNT(101, "\u5e97\u94fa\u6761\u4ef6\u6298\u6263\u5238"),
    STORE_FULL_DISCOUNT(102, "\u5e97\u94fa\u6ee1\u51cf\u5238"),
    STORE_FLAT_DISCOUNT(103, "\u5e97\u94fa\u7edf\u4e00\u6298\u6263\u5238"),
    STORE_DIRECT_DISCOUNT(104, "\u5e97\u94fa\u76f4\u51cf\u5238");

    private Integer type;
    private String desc;
    private static Map<Integer, CouponType> map;

    private CouponType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public static String getDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        map = Maps.newHashMap();
        for (CouponType type : CouponType.values()) {
            map.put(type.type, type);
        }
    }
}

