/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.constant.OrderNotifyConstant;
import com.kuaike.scrm.common.service.NotificationSettingService;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.NotificationConfigDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.order.dto.ExtInfo;
import com.kuaike.scrm.order.dto.OrderNotifyDto;
import com.kuaike.scrm.order.model.OrderEsModel;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.order.service.GoodsOrderService;
import com.kuaike.scrm.order.service.OrderNotificationService;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindBizTypeEnum;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.dto.req.RemindTypeEnum;
import com.kuaike.scrm.remind.service.RemindService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OrderNotificationServiceImpl
implements OrderNotificationService {
    private static final Logger log = LoggerFactory.getLogger(OrderNotificationServiceImpl.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private NotificationSettingService notificationSettingService;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private ParamEncryService paramEncryService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private GoodsOrderService goodsOrderService;
    @Value(value="${notify.pay.unpaid}")
    private String unpaidNotifyTemplate;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;
    private static final String KEY_PREFIX = "OVERTIME_LIMIT_PREFIX_OVERTIME_ORDER_";
    @Autowired
    private SettingService settingService;

    @Override
    public void startTask() {
        List configDtos = this.notificationSettingService.notifyConfigList();
        for (NotificationConfigDto configDto : configDtos) {
            this.endTimeNotify(configDto);
        }
    }

    private void endTimeNotify(NotificationConfigDto config) {
        if (Objects.isNull(config) || Objects.isNull(config.getDelay())) {
            log.warn("\u5f53\u524d\u5546\u5bb6\u672a\u914d\u7f6e\u8ba2\u5355\u8d85\u65f6\u901a\u77e5: config{}", (Object)config);
            return;
        }
        String key = KEY_PREFIX + config.getBizId();
        Long baseScore = System.currentTimeMillis() - OrderNotifyConstant.START_SCORE;
        log.info("\u3010orderNotificationService\u3011 bizId:{}; redisKey:{}", (Object)JSON.toJSONString((Object)config.getBizId()), (Object)key);
        Long overtimeLimit = (long)(config.getDelay() * 60) * 1000L;
        if (baseScore < overtimeLimit) {
            return;
        }
        Long maxScore = baseScore - overtimeLimit;
        Set orderSetsStr = this.redisTemplate.opsForZSet().rangeByScore((Object)key, 0.0, (double)maxScore.longValue(), 0L, 100L);
        if (CollectionUtils.isEmpty((Collection)orderSetsStr)) {
            return;
        }
        List<String> orderList = orderSetsStr.stream().collect(Collectors.toList());
        this.notification(orderList, config);
    }

    private void notification(List<String> orderList, NotificationConfigDto config) {
        Map<String, OrderEsModel> esModelMap = this.goodsOrderEsService.queryOrderByOrderIds(orderList, 0, orderList.size());
        if (MapUtils.isEmpty(esModelMap)) {
            log.error("\u3010orderNotificationService\u3011 \u7f13\u5b58\u4e2d\u6709\u8ba2\u5355\u53f7\uff0ces\u4e2d\u4e3a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f orderIdStr:{},bizId:{}", (Object)JSON.toJSONString(orderList), (Object)config.getBizId());
            return;
        }
        for (OrderEsModel orderEsModel : esModelMap.values()) {
            this.notifyOrderWeworkUser(orderEsModel, config.getBizId(), config.getDelay());
        }
    }

    private void notifyOrderWeworkUser(OrderEsModel orderEsModel, Long bizId, Integer delay) {
        ExtInfo extInfo = orderEsModel.getExtInfo();
        log.info("notifyOrderWeworkUser job:orderId:{}, bizId:{}", (Object)orderEsModel.getOrderId(), (Object)bizId);
        if (Objects.isNull(extInfo) || StringUtils.isBlank((CharSequence)extInfo.getCustomerStr())) {
            log.warn("\u3010orderNotificationService\u3011 es\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684extInfo orderId:{},bizId:{}", (Object)orderEsModel.getOrderId(), (Object)bizId);
            return;
        }
        MeetingParams meetingParams = this.paramEncryService.getMeetingParamsByNum(extInfo.getCustomerStr());
        if (Objects.isNull(meetingParams)) {
            log.warn("\u3010orderNotificationService\u3011 es\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684 MeetingParams orderId:{}", (Object)orderEsModel.getOrderId());
            this.removeByOrderId(bizId, orderEsModel.getOrderId());
            return;
        }
        String weworkUserNum = meetingParams.getWeworkUserNum();
        if (StringUtils.isBlank((CharSequence)weworkUserNum) || StringUtils.equals((CharSequence)weworkUserNum, (CharSequence)"-1")) {
            log.warn("\u3010orderNotificationService\u3011es\u4e2d\u7684\u52a0\u5bc6\u53c2\u6570\u672a\u627e\u5230\u4e1a\u7ee9\u5f52\u8c01\u4eba\uff1aorderId: {};meeting:{}", (Object)orderEsModel.getOrderId(), (Object)meetingParams);
            this.removeByOrderId(bizId, orderEsModel.getOrderId());
            return;
        }
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)meetingParams.getMeetingId());
        RemindDetailReqDto remindDetailReqDto = new RemindDetailReqDto();
        remindDetailReqDto.setWeworkUserNum(weworkUserNum);
        remindDetailReqDto.setSendTime(new Date());
        remindDetailReqDto.setExtraType(Integer.valueOf(1));
        String remind = this.buildNotifyContent(orderEsModel, this.unpaidNotifyTemplate, bizId);
        if (remind.contains("{timeout}")) {
            remind = remind.replace("{timeout}", String.valueOf(delay));
        }
        log.info("\u672a\u652f\u4ed8\u901a\u77e5 job:weworkNum:{}, orderInfo:{}, bizId:{}, remind:{}", new Object[]{weworkUserNum, orderEsModel.getOrderId(), bizId, remind});
        AddRemindReqDto remindReqDto = new AddRemindReqDto(Long.valueOf(-1L), meeting.getBizId(), meeting.getCorpId(), Integer.valueOf(RemindBizTypeEnum.ORDER_BIZ.getValue()), Integer.valueOf(RemindTypeEnum.SINGLE_REMIND.getValue()), remind, orderEsModel.getOrderId(), Long.valueOf(-1L), Integer.valueOf(1), (List)Lists.newArrayList((Object[])new RemindDetailReqDto[]{remindDetailReqDto}));
        this.remindService.addRemind(remindReqDto);
        this.removeByOrderId(bizId, orderEsModel.getOrderId());
    }

    @Override
    public void addOrder(Long bizId, Date createTime, String orderId) {
        log.info("\u3010orderNotificationService\u3011 add order,bizId:{},createTime:{},orderid:{}", new Object[]{bizId, createTime, orderId});
        String key = KEY_PREFIX + bizId;
        long scoure = createTime.getTime() - OrderNotifyConstant.START_SCORE;
        this.redisTemplate.opsForZSet().add((Object)key, (Object)orderId, (double)scoure);
    }

    @Override
    public void removeByOrderId(Long bizId, String orderId) {
        log.info("\u3010orderNotificationService\u3011,remove order by id,bizId:{},orderId:{}", (Object)bizId, (Object)orderId);
        String key = KEY_PREFIX + bizId;
        this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{orderId});
    }

    private String buildNotifyContent(OrderEsModel orderEsModel, String template, Long bizId) {
        OrderNotifyDto notifyModel = this.goodsOrderService.buildOrderNotifyModel(orderEsModel, bizId);
        notifyModel.wrapNull();
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("{orderTitle}", notifyModel.getOrderTitle());
        params.put("{name}", notifyModel.getCustomer());
        params.put("{wechat}", notifyModel.getWechatName());
        params.put("{orderId}", notifyModel.getOrderId());
        String orderAmountStr = "--";
        if (notifyModel.getOrderAmount() != null) {
            orderAmountStr = BigDecimal.valueOf(notifyModel.getOrderAmount()).divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_DOWN).toString();
        }
        params.put("{orderAmount}", orderAmountStr);
        params.put("{product}", notifyModel.getProduct());
        String phone = notifyModel.getPhone();
        if (this.settingService.getMobileEncrypt(notifyModel.getBizId())) {
            phone = MobileUtils.encryptMobile((String)notifyModel.getPhone());
        }
        params.put("{phone}", phone);
        String orderTimeStr = "--";
        if (notifyModel.getOrderTime() != null) {
            orderTimeStr = DateUtil.dateToDateString((Date)new Date(notifyModel.getOrderTime()));
        }
        params.put("{orderTime}", orderTimeStr);
        params.put("{saleman}", "--");
        String customerDetail = notifyModel.getContactId() != null && notifyModel.getCorpId() != null ? MessageFormat.format("<a href=\"{0}/clientSide?contactId={1}&corpId={2}\">\u5ba2\u6237\u8be6\u60c5</a>", this.scrmManagerHost, notifyModel.getContactId(), notifyModel.getCorpId()) : "";
        params.put("{customerDetail}", customerDetail);
        return TemplateReplaceUtil.render((String)template, (Map)params);
    }
}

