/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.order.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmOrderService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmOrderReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.req.CustomerNumReq;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.dto.resp.CustomerNumResp;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.dto.vo.PayMessageDto;
import cn.kinyun.pay.business.enums.PayMessageType;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.MeetingWatchType;
import com.kuaike.scrm.common.enums.NetSchoolGoodsTypeEnum;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.ParamEncryTypeEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.OrderDetailParam;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingCommercePerformanceRecord;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerCoupon;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCommercePerformanceRecordMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerCouponMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerOrderRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.shop.entity.ShopCoupon;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopCouponMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.order.dto.AddressInfo;
import com.kuaike.scrm.order.dto.CouponInfoDto;
import com.kuaike.scrm.order.dto.DeliveryInfoDto;
import com.kuaike.scrm.order.dto.ExtInfo;
import com.kuaike.scrm.order.dto.JudgeOrderBelongUserIdDto;
import com.kuaike.scrm.order.dto.MeetingOrderListRep;
import com.kuaike.scrm.order.dto.MeetingOrderListReq;
import com.kuaike.scrm.order.dto.OrderDetail;
import com.kuaike.scrm.order.dto.OrderDetailDto;
import com.kuaike.scrm.order.dto.OrderNotifyDto;
import com.kuaike.scrm.order.dto.PayInfoDto;
import com.kuaike.scrm.order.dto.PerformanceRecordProductInfoDto;
import com.kuaike.scrm.order.dto.PriceInfoDto;
import com.kuaike.scrm.order.dto.ProductInfo;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.model.OrderEsModel;
import com.kuaike.scrm.order.req.DetailWithoutLoginReq;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.order.service.GoodsOrderService;
import com.kuaike.scrm.order.service.OrderNotificationService;
import com.kuaike.scrm.order.service.OrderPayNotificationService;
import com.kuaike.scrm.sms.service.SmsTaskService;
import com.kuaike.scrm.system.dto.request.AddNetSchoolOrderReq;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import com.kuaike.scrm.system.utils.NetSchoolGoodsId;
import com.kuaike.trace.utils.TraceIdUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsOrderServiceImpl
implements GoodsOrderService {
    private static final Logger log = LoggerFactory.getLogger(GoodsOrderServiceImpl.class);
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private DistributedLock lock;
    @Resource
    private ShopCouponMapper shopCouponMapper;
    @Resource
    private MeetingCustomerCouponMapper meetingCustomerCouponMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Resource
    private MeetingCommercePerformanceRecordMapper meetingCommercePerformanceRecordMapper;
    @Resource
    private IdGen idGen;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private CcCustomerDetailService customerDetailService;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private ParamEncryMapper paramEncryMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private MeetingMapper meetingMapper;
    @Resource
    private ScrmUserService scrmUserService;
    @Value(value="${scrm.meeting.orderDetailUrl:}")
    private String orderDetailUrl;
    @Resource
    private ParamEncryService paramEncryService;
    @Resource
    private ShortUrlService shortUrlService;
    @Resource
    private SmsTaskService smsTaskService;
    @Resource
    private OrderNotificationService orderNotificationService;
    @Resource
    private OrderPayNotificationService orderPayNotificationService;
    private static final String UPDATE_COUPON_USED_NUM = "updateShopCouponUsedNum:";
    @Resource
    private CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private CrmOrderService crmOrderService;
    @Resource
    private MeetingCustomerOrderRelationMapper meetingCustomerOrderRelationMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private SettingService settingService;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Resource
    private ScrmNetSchoolService scrmNetSchoolService;
    @Resource
    private OrganizationMapper organizationMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handlePayCallBack(PayMessageDto payMessageDto) {
        String traceId = TraceIdUtils.getTraceId();
        traceId = UUID.randomUUID().toString().replace("-", "");
        TraceIdUtils.setTraceId((String)traceId);
        log.info("handlePayCallBack payMessageDto:{}", (Object)payMessageDto);
        String orderNum = payMessageDto.getOrderNum();
        if (!Objects.equals(payMessageDto.getMsgType(), PayMessageType.ORDER.getValue())) {
            log.info("\u975e\u4e0b\u5355\u56de\u8c03\uff0c\u76f4\u64ad\u5904\u7406\u903b\u8f91exit");
            return;
        }
        if (StringUtils.isBlank((CharSequence)orderNum)) {
            log.error("\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\uff0c\uff1a{}", (Object)JSON.toJSONString((Object)payMessageDto));
        }
        ShopOrder exist = new ShopOrder();
        exist.setOutOrderId(orderNum);
        ShopOrder shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
        if (Objects.isNull(shopOrder)) {
            log.warn("handlePayCallBack order not found, orderNum:{}", (Object)orderNum);
            return;
        }
        if (OrderStatus.PAID.getStatus().equals(shopOrder.getStatus())) {
            log.info("handlePayCallBack \u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8 \u4e0d\u5904\u7406");
            return;
        }
        OrderEsModel orderEsModel = this.goodsOrderEsService.getOneById(shopOrder.getOrderId());
        if (Objects.isNull(orderEsModel)) {
            log.warn("handlePayCallBack order es not found, id:{}", (Object)shopOrder.getId());
            return;
        }
        PayMessageType payMessageType = PayMessageType.getType((Integer)payMessageDto.getMsgType());
        if (!payMessageType.getValue().equals(PayMessageType.ORDER.getValue())) {
            log.info("handlePayCallBack orderNum:{} \u975e\u4e0b\u5355\u56de\u8c03", (Object)orderNum);
            return;
        }
        String key = "handlePayCallBack-" + shopOrder.getOrderId();
        try {
            this.lock.lock(key);
            shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)exist);
            if (OrderStatus.PAID.getStatus().equals(shopOrder.getStatus())) {
                log.info("handlePayCallBack \u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u652f\u4ed8 \u4e0d\u5904\u7406");
                return;
            }
            try {
                this.orderNotificationService.removeByOrderId(shopOrder.getBizId(), shopOrder.getOrderId());
            }
            catch (Exception e) {
                log.error("orderNotificationService removeByOrderId error", (Throwable)e);
            }
            shopOrder.setStatus(OrderStatus.PAID.getStatus());
            shopOrder.setPayTime(new Date());
            this.shopOrderMapper.updateByPrimaryKeySelective((Object)shopOrder);
            String payTime = DateUtil.dateToDateString((Date)shopOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss");
            orderEsModel.setStatus(shopOrder.getStatus());
            orderEsModel.getOrderDetail().getPayInfo().setPayTime(payTime);
            try {
                this.paySuccessHandleCoupon(orderEsModel, shopOrder.getBizId());
            }
            catch (Exception e) {
                log.error("handlePayCallBack handleCoupon error", (Throwable)e);
            }
            try {
                this.handlePerformanceAndLeads(orderEsModel, shopOrder.getBizId(), shopOrder.getCorpId(), orderNum);
            }
            catch (Exception e) {
                log.error("handlePayCallBack handlePerformanceAndLeads error", (Throwable)e);
            }
            this.goodsOrderEsService.batchUpdateOrderAsync(Collections.singletonList(orderEsModel));
            try {
                ExtInfo extInfo = orderEsModel.getExtInfo();
                Long meetingId = extInfo.getMeetingId();
                if (meetingId != null) {
                    String mobile = orderEsModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo().getTelNumber();
                    this.handleSmsNotice(meetingId, mobile, orderEsModel.getOrderId());
                }
            }
            catch (Exception e) {
                log.error("handlePayCallBack handleSmsNotice error", (Throwable)e);
            }
            try {
                OrderNotifyDto orderNotifyDto = this.buildOrderNotifyModel(orderEsModel, shopOrder.getBizId());
                orderNotifyDto.setIsNetSchoolOrder(false);
                this.orderPayNotificationService.sendPaySuccessNotify(orderNotifyDto);
            }
            catch (Exception e) {
                log.error("sendPaySuccessNotice error,orderId:{}", (Object)orderEsModel.getOrderId(), (Object)e);
            }
            try {
                List<ProductInfo> productInfos = orderEsModel.getOrderDetail().getProductInfos();
                String productId = productInfos.get(0).getProductId();
                this.pushOrderToNetSchool(shopOrder.getBizId(), shopOrder.getCorpId(), productId, shopOrder, orderEsModel.getExtInfo());
            }
            catch (Exception e) {
                log.error("sync net school order error");
            }
        }
        catch (Exception e) {
            log.error("handlePayCallBack error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }

    @Override
    public void pushOrderToNetSchool(Long bizId, String corpId, String productId, ShopOrder shopOrder, ExtInfo extInfo) {
        MeetingParams meetingParams;
        Long inviteUserNetSchoolId;
        String orderId = shopOrder.getOrderId();
        Long payTime = shopOrder.getPayTime().getTime();
        AddressInfo addressInfo = (AddressInfo)JSON.parseObject((String)shopOrder.getAddressinfo(), AddressInfo.class);
        if (addressInfo == null) {
            log.error("pushOrderToNetSchool,\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a,orderId:{}", (Object)orderId);
            return;
        }
        String mobile = addressInfo.getTelNumber();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.error("pushOrderToNetSchool,\u624b\u673a\u53f7\u4e3a\u7a7a,orderId:{}", (Object)orderId);
            return;
        }
        if (StringUtils.isBlank((CharSequence)productId)) {
            log.warn("pushOrderToNetSchool productId is null,orderId:{}", (Object)orderId);
            return;
        }
        ShopSpu selectShopSpu = new ShopSpu();
        selectShopSpu.setBizId(bizId);
        selectShopSpu.setProductId(productId);
        selectShopSpu.setSource(Integer.valueOf(GoodsOrderSource.NET_SCHOOL.getSource()));
        ShopSpu shopSpu = (ShopSpu)this.shopSpuMapper.selectOne((Object)selectShopSpu);
        if (shopSpu == null || shopSpu.getSource() == null || GoodsOrderSource.NET_SCHOOL.getSource() != shopSpu.getSource().intValue()) {
            log.info("pushOrderToNetSchool,\u8ba2\u5355\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u662f\u7f51\u6821\u8bfe\u7a0b,orderId:{},productId:{}", (Object)orderId, (Object)productId);
            return;
        }
        String addressDetailInfo = addressInfo.getDetailInfo();
        AddNetSchoolOrderReq addOrderReq = new AddNetSchoolOrderReq();
        addOrderReq.setMobile(mobile);
        addOrderReq.setAddress(addressDetailInfo);
        if (addressInfo.getProvinceCode() != null) {
            addOrderReq.setProvinceCode(Integer.valueOf(Integer.parseInt(addressInfo.getProvinceCode())));
        }
        if (addressInfo.getCityCode() != null) {
            addOrderReq.setCityCode(Integer.valueOf(Integer.parseInt(addressInfo.getCityCode())));
        }
        if (addressInfo.getCountyCode() != null) {
            addOrderReq.setDistrictCode(Integer.valueOf(Integer.parseInt(addressInfo.getCountyCode())));
        }
        addOrderReq.setOrderNo(orderId);
        addOrderReq.setPayStatus(Integer.valueOf(2));
        Long netSchoolGoodsId = NetSchoolGoodsId.getOriginId((String)shopSpu.getOutProductId());
        addOrderReq.setShopId(netSchoolGoodsId);
        Integer goodsType = NetSchoolGoodsId.getGoodsType((String)shopSpu.getOutProductId());
        Long schoolId = (long)NetSchoolGoodsId.getSchoolId((String)shopSpu.getOutProductId());
        if (Objects.nonNull(extInfo) && (inviteUserNetSchoolId = this.getInviteUserNetSchoolId(bizId, corpId, extInfo.getCustomerStr())) != null) {
            schoolId = inviteUserNetSchoolId;
        }
        if (NetSchoolGoodsTypeEnum.COURSE.getValue() == goodsType.intValue()) {
            addOrderReq.setShopType(Integer.valueOf(1));
        } else if (NetSchoolGoodsTypeEnum.CLASS.getValue() == goodsType.intValue()) {
            addOrderReq.setShopType(Integer.valueOf(19));
        }
        addOrderReq.setPaidPrice(Long.valueOf(shopOrder.getOrderPrice() / 100L));
        addOrderReq.setLogisticConsignee(addressInfo.getUserName());
        if (StringUtils.isBlank((CharSequence)addOrderReq.getLogisticConsignee())) {
            addOrderReq.setLogisticConsignee(mobile);
        }
        addOrderReq.setLogisticMobile(mobile);
        addOrderReq.setPayType(Integer.valueOf(1));
        addOrderReq.setCreatedAt(Long.valueOf(shopOrder.getCreateTime().getTime() / 1000L));
        addOrderReq.setPaidAt(Long.valueOf(payTime / 1000L));
        if (extInfo != null) {
            addOrderReq.setNickname(extInfo.getCustomerName());
        }
        addOrderReq.setUserId("0");
        addOrderReq.setScrmAdminId(Integer.valueOf(0));
        addOrderReq.setSchoolId(String.valueOf(schoolId));
        CrmLeadsInfoReq infoReq = new CrmLeadsInfoReq();
        infoReq.setBizId(bizId);
        infoReq.setCorpId(corpId);
        infoReq.setMobile(mobile);
        try {
            CrmLeadsInfoResp leads = this.crmLeadsService.getLeads(infoReq);
            if (leads != null) {
                addOrderReq.setScrmId(leads.getNum());
            }
        }
        catch (Exception e) {
            log.info("infoReq: {}", (Object)infoReq);
            log.error("get leads num error", (Throwable)e);
        }
        if (extInfo != null && StringUtils.isNotBlank((CharSequence)extInfo.getCustomerStr()) && (meetingParams = this.paramEncryService.getMeetingParamsByNum(extInfo.getCustomerStr())) != null) {
            addOrderReq.setOpenId(meetingParams.getOpenId());
            addOrderReq.setUnionId(meetingParams.getUnionId());
        }
        this.scrmNetSchoolService.addNetSchoolOrder(bizId, addOrderReq, null);
    }

    @Override
    public void handlePayOrderChange(PayOrder payOrder) {
        log.info("handlePayOrderChange with payOrder={}", (Object)payOrder);
        if (Objects.isNull(payOrder)) {
            log.warn("payOrder is null");
            return;
        }
        ShopOrder shopOrder = this.shopOrderMapper.queryByOrderId(payOrder.getOrderNum());
        if (Objects.isNull(shopOrder)) {
            log.warn("handlePayOrderChange order not found, orderNum:{}", (Object)payOrder.getOrderNum());
            return;
        }
    }

    private void handleSmsNotice(Long meetingId, String mobile, String orderId) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            log.info("handleSmsNotice mobile is blank");
            return;
        }
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)meetingId);
        if (meeting == null) {
            log.info("handleSmsNotice meeting is null meetingId:{}", (Object)meetingId);
            return;
        }
        String orderSmsContent = meeting.getOrderSmsTemplate();
        if (StringUtils.isBlank((CharSequence)orderSmsContent)) {
            log.info("handleSmsNotice sms template is null meetingId:{}", (Object)meetingId);
            return;
        }
        String orderSmsSign = null;
        if (orderSmsContent.contains("${sign}")) {
            orderSmsContent = orderSmsContent.replace("${sign}", "");
            orderSmsSign = meeting.getOrderSmsSign();
            if (StringUtils.isBlank((CharSequence)orderSmsSign)) {
                log.info("handleSmsNotice sms sign is null meetingId:{}", (Object)meetingId);
                return;
            }
        }
        if (orderSmsContent.contains("${meetingTitle}")) {
            orderSmsContent = orderSmsContent.replace("${meetingTitle}", meeting.getTitle());
        }
        if (orderSmsContent.contains("${orderDetailUrl}")) {
            OrderDetailParam param = new OrderDetailParam();
            param.setOrderId(orderId);
            String num = this.paramEncryService.encryMeetingOrderDetailParam(param);
            String longOrderDetailUrl = this.orderDetailUrl + "?num=" + num;
            String shortUrlNum = this.idGen.getNum();
            this.shortUrlService.recordShortUrl("-1", Integer.valueOf(OauthShortUrlTypeEnum.MEETING_ORDER_DETAIL_URL.getValue()), longOrderDetailUrl, longOrderDetailUrl, shortUrlNum);
            String shortOrderDetailUrl = this.shortUrlService.getShortUlr(shortUrlNum);
            orderSmsContent = orderSmsContent.replace("${orderDetailUrl}", shortOrderDetailUrl);
            log.info("handleSmsNotice orderId:{} orderDetailUrlPrefix:{} longOrderDetailUrl:{} shortOrderDetailUrl:{}", new Object[]{orderId, this.orderDetailUrl, longOrderDetailUrl, shortOrderDetailUrl});
        }
        ScrmSendSmsReqDto smsReqDto = new ScrmSendSmsReqDto();
        smsReqDto.setBizId(meeting.getBizId());
        smsReqDto.setCorpId(meeting.getCorpId());
        smsReqDto.setContent(orderSmsContent);
        smsReqDto.setUserId(Long.valueOf(-1L));
        smsReqDto.setMobile(mobile);
        smsReqDto.setSignature(orderSmsSign);
        Long smsTaskDetailId = this.smsTaskService.sendCustomSms(smsReqDto);
        log.info("handleSmsNotice smsReqDto:{} smsTaskDetailId:{}", (Object)smsReqDto, (Object)smsTaskDetailId);
    }

    @Override
    public void handlePerformanceAndLeads(OrderEsModel orderEsModel, Long bizId, String corpId, String orderNum) {
        ExtInfo extInfo = orderEsModel.getExtInfo();
        String customerStr = extInfo.getCustomerStr();
        String bjyNumber = extInfo.getBjyNumber();
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        if (orderDetail == null) {
            log.info("handlePerformanceAndLeads orderDetail \u4e3a\u7a7a \u4e0d\u5904\u7406");
            return;
        }
        DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
        if (deliveryInfoDto == null) {
            log.info("handlePerformanceAndLeads deliveryInfoDto \u4e3a\u7a7a \u4e0d\u5904\u7406");
            return;
        }
        AddressInfo addressInfo = deliveryInfoDto.getAddressInfo();
        if (addressInfo == null) {
            log.info("handlePerformanceAndLeads addressInfo \u4e3a\u7a7a \u4e0d\u5904\u7406");
            return;
        }
        if (StringUtils.isBlank((CharSequence)addressInfo.getUserName()) || StringUtils.isBlank((CharSequence)addressInfo.getTelNumber())) {
            log.info("handlePerformanceAndLeads \u83b7\u53d6\u4e0d\u5230\u4e0b\u5355\u65f6\u586b\u5199\u7684\u59d3\u540d\u6216\u624b\u673a\u53f7 addressInfo:{}", (Object)addressInfo);
            return;
        }
        Long meetingId = extInfo.getMeetingId();
        String customerInfoNum = this.selectCustomerInfoNum(customerStr, bjyNumber, meetingId, bizId);
        boolean existLeads = this.judgeIsExistLeads(corpId, addressInfo);
        JudgeOrderBelongUserIdDto dto = new JudgeOrderBelongUserIdDto();
        if (existLeads && (dto = this.judgeOrderBelongUserId(bizId, corpId, addressInfo.getTelNumber(), customerStr)).getBelongUserId() != null) {
            extInfo.setBelongUserId(dto.getBelongUserId());
            this.insertMeetingPerformance(orderEsModel, bizId, dto, customerInfoNum);
            try {
                SetOrderReq setOrderReq = new SetOrderReq();
                setOrderReq.setBizId(bizId);
                setOrderReq.setOrderNo(orderEsModel.getOrderId().toString());
                setOrderReq.setBelongUserId(dto.getBelongUserId());
                this.ccCustomerOrderService.setOrder(setOrderReq);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5ba2\u6237\u4e2d\u5fc3\u4e1a\u7ee9\u5f52\u5c5e\u5f02\u5e38 orderId:{} belongUserId:{}", (Object)orderEsModel.getOrderId(), (Object)dto.getBelongUserId());
            }
        }
        try {
            this.handleLeadsByCrmRuleType(orderEsModel, bizId, corpId, dto, orderNum);
        }
        catch (Exception e) {
            log.error("handlePerformanceAndLeads handleLeads error", (Throwable)e);
        }
    }

    private String selectCustomerInfoNum(String customerStr, String bjyNumber, Long meetingId, Long bizId) {
        log.info("selectCustomerInfoNum customerStr:{} bjyNumber:{} meetingId:{}", new Object[]{customerStr, bjyNumber, meetingId});
        String customerInfoNum = this.idGen.getNum();
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            MeetingCustomerInfo selectInfo = new MeetingCustomerInfo();
            selectInfo.setCustomerStr(customerStr);
            selectInfo.setMeetingId(meetingId);
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
            if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
                log.info("selectCustomerInfoNum meetingCustomerInfo:{}", (Object)meetingCustomerInfos);
                return ((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getNum();
            }
            MeetingCustomerParamEncryRelation selectRelation = new MeetingCustomerParamEncryRelation();
            selectRelation.setMeetingId(meetingId);
            selectRelation.setEncryNum(customerStr);
            List relations = this.meetingCustomerParamEncryRelationMapper.select((Object)selectRelation);
            if (CollectionUtils.isEmpty((Collection)relations)) {
                log.info("selectCustomerInfoNum \u901a\u8fc7meetingId\u548ccustomerStr\u67e5\u8be2\u4e0d\u5230MeetingCustomerParamEncryRelation \u968f\u673a\u751f\u6210");
                return this.idGen.getNum();
            }
            MeetingCustomerParamEncryRelation relation = (MeetingCustomerParamEncryRelation)relations.get(0);
            log.info("selectCustomerInfoNum relation:{}", (Object)relation);
            if (MeetingWatchType.PLAY_BACK.getValue() == relation.getWatchType().intValue()) {
                log.info("selectCustomerInfoNum \u901a\u8fc7\u56de\u653e\u4e0b\u7684\u5355 \u6ca1\u6709meetingCustomerInfo \u968f\u673a\u751f\u6210");
                return this.idGen.getNum();
            }
            MeetingCustomerInfo select = new MeetingCustomerInfo();
            select.setMeetingId(meetingId);
            select.setCustomerStr(customerStr);
            List customerInfos = this.meetingCustomerInfoMapper.select((Object)select);
            if (CollectionUtils.isEmpty((Collection)customerInfos)) {
                return this.insertOrUpdateMeetingCustomerInfo(relation, meetingId);
            }
            return ((MeetingCustomerInfo)customerInfos.get(0)).getNum();
        }
        if (StringUtils.isNotBlank((CharSequence)bjyNumber)) {
            MeetingCustomerInfo selectInfo = new MeetingCustomerInfo();
            selectInfo.setBizId(bizId);
            selectInfo.setBjyNumber(bjyNumber);
            selectInfo.setMeetingId(meetingId);
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
            if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
                log.info("selectCustomerInfoNum,\u901a\u8fc7bjyNumber\u67e5\u8be2\u4e0d\u5230MeetingCustomerInfo");
                return customerInfoNum;
            }
            MeetingCustomerInfo meetingCustomerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
            log.info("selectCustomerInfoNum,customerInfoNum:{}", (Object)meetingCustomerInfo.getNum());
            return meetingCustomerInfo.getNum();
        }
        return customerInfoNum;
    }

    private String insertOrUpdateMeetingCustomerInfo(MeetingCustomerParamEncryRelation relation, Long meetingId) {
        Date curTime = new Date();
        MeetingCustomerInfo select = new MeetingCustomerInfo();
        select.setBizId(relation.getBizId());
        select.setMeetingId(meetingId);
        select.setBjyNumber(relation.getBjyNumber());
        MeetingCustomerInfo meetingCustomerInfo = (MeetingCustomerInfo)this.meetingCustomerInfoMapper.selectOne((Object)select);
        if (meetingCustomerInfo != null) {
            log.info("insertOrUpdateMeetingCustomerInfo \u901a\u8fc7bjyNumber\u5339\u914d\u5230\u4e86meetingCustomerInfo");
            meetingCustomerInfo.setCustomerStr(relation.getEncryNum());
            this.meetingCustomerInfoMapper.updateByPrimaryKeySelective((Object)meetingCustomerInfo);
            return meetingCustomerInfo.getNum();
        }
        String unionId = relation.getUnionId();
        String appId = relation.getAppId();
        String openId = relation.getOpenId();
        MeetingCustomerInfo customerInfo = new MeetingCustomerInfo();
        customerInfo.setNum(this.idGen.getNum());
        customerInfo.setBizId(relation.getBizId());
        customerInfo.setRoomId("-1");
        customerInfo.setMeetingId(meetingId);
        customerInfo.setAppId(appId);
        customerInfo.setOpenId(openId);
        customerInfo.setContactId(relation.getContactId());
        customerInfo.setCustomerStr(relation.getEncryNum());
        customerInfo.setName(relation.getBjyName());
        customerInfo.setBjyNumber(relation.getBjyNumber());
        if (MobileUtils.isPhone((String)relation.getBjyNumber())) {
            customerInfo.setBjyMobile(relation.getBjyNumber());
        }
        String infoId = relation.getBjyNumber();
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            infoId = unionId;
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appId, openId})) {
            infoId = appId + openId;
        }
        customerInfo.setInfoId(infoId);
        customerInfo.setArrivalTime(curTime);
        customerInfo.setCreateTime(curTime);
        customerInfo.setUpdateTime(curTime);
        this.meetingCustomerInfoMapper.insertSelective((Object)customerInfo);
        log.info("insertMeetingCustomerInfo :{}", (Object)customerInfo);
        return customerInfo.getNum();
    }

    private void handleLeadsByCrmRuleType(OrderEsModel orderEsModel, Long bizId, String corpId, JudgeOrderBelongUserIdDto dto, String outOrderNum) {
        log.info("handleLeadsByCrmRuleType orderId:{} bizId:{} corpId:{} JudgeOrderBelongUserIdDto:{}", new Object[]{orderEsModel.getOrderId(), bizId, corpId, dto});
        if (!this.openCrm(bizId)) {
            log.info("handleLeads \u672a\u5f00\u901acrm");
            return;
        }
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
        AddressInfo addressInfo = deliveryInfoDto.getAddressInfo();
        PriceInfoDto priceInfo = orderDetail.getPriceInfo();
        PayInfoDto payInfo = orderDetail.getPayInfo();
        ExtInfo extInfo = orderEsModel.getExtInfo();
        String telNumber = addressInfo.getTelNumber();
        if (StringUtils.isBlank((CharSequence)telNumber)) {
            log.info("handleLeadsByCrmRuleType telNumber is blank");
            return;
        }
        CrmOrderReq crmOrderReq = new CrmOrderReq();
        crmOrderReq.setBizId(bizId);
        crmOrderReq.setCorpId(corpId);
        crmOrderReq.setUserId(dto.getBelongUserId());
        crmOrderReq.setSource(SourceType.LIVE_COMMERCE.getCode());
        crmOrderReq.setMobile(telNumber);
        crmOrderReq.setName(addressInfo.getUserName());
        crmOrderReq.setOrderNo(orderEsModel.getOrderId().toString());
        crmOrderReq.setOrderAmount(Long.valueOf(priceInfo != null ? priceInfo.getProductPrice() : 0L));
        crmOrderReq.setOrderTime(orderEsModel.getCreateTime());
        crmOrderReq.setOrderRemark("");
        List<ProductInfo> productInfos = orderDetail.getProductInfos();
        if (CollectionUtils.isNotEmpty(productInfos)) {
            ProductInfo productInfo = productInfos.get(0);
            crmOrderReq.setSkuNo(productInfo.getSkuId().toString());
            crmOrderReq.setSkuName(productInfo.getTitle());
        }
        crmOrderReq.setTradeNo(outOrderNum);
        crmOrderReq.setTradeType(Integer.valueOf(0));
        crmOrderReq.setTradeChannel(payInfo != null ? payInfo.getPayMethod() : "");
        crmOrderReq.setTradeAmount(Long.valueOf(priceInfo != null ? priceInfo.getOrderPrice() : 0L));
        crmOrderReq.setTradeTime(Long.valueOf(new Date().getTime()));
        crmOrderReq.setRuleType(Integer.valueOf(2));
        crmOrderReq.setInContract(Boolean.valueOf(true));
        String customerStr = extInfo.getCustomerStr();
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            ParamEncry selectParamEncry = new ParamEncry();
            selectParamEncry.setNum(customerStr);
            ParamEncry paramEncry = (ParamEncry)this.paramEncryMapper.selectOne((Object)selectParamEncry);
            if (paramEncry != null) {
                MeetingParams meetingParams = (MeetingParams)JSON.parseObject((String)paramEncry.getParams(), MeetingParams.class);
                crmOrderReq.setChannelId(Long.valueOf(meetingParams.getChannelId()));
            }
        }
        if (dto.getBelongUserId() != null) {
            UserSimpleInfo userInfo = this.scrmUserService.getById(dto.getBelongUserId());
            Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)extInfo.getMeetingId());
            if (userInfo != null && meeting != null) {
                String releaseReason = userInfo.getName() + "\u9080\u8bf7" + addressInfo.getUserName() + "\u53c2\u52a0\u76f4\u64ad\u300c" + meeting.getTitle() + "\u300d\uff0c\u5ba2\u6237\u4e0b\u5355\uff0c\u8be5\u5ba2\u6237\u5f52\u5c5e" + userInfo.getName();
                crmOrderReq.setReleaseReason(releaseReason);
            }
        }
        log.info("handleLeadsByCrmRuleType crmOrderReq:{}", (Object)crmOrderReq);
        this.crmOrderService.addLeadsByOrder(crmOrderReq);
    }

    private boolean openCrm(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        log.info("isOpenCrm businessCustomer: {}", (Object)businessCustomer);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    private void insertMeetingPerformance(OrderEsModel orderEsModel, Long bizId, JudgeOrderBelongUserIdDto belongUserIdDto, String meetingCustomerNum) {
        MeetingCommercePerformanceRecord performanceRecord = new MeetingCommercePerformanceRecord();
        performanceRecord.setNum(this.idGen.getNum());
        performanceRecord.setBizId(bizId);
        ExtInfo extInfo = orderEsModel.getExtInfo();
        performanceRecord.setMeetingId(extInfo.getMeetingId());
        performanceRecord.setUserId(belongUserIdDto.getBelongUserId());
        User user = (User)this.userMapper.selectByPrimaryKey((Object)belongUserIdDto.getBelongUserId());
        performanceRecord.setUserName(user != null ? user.getName() : "");
        performanceRecord.setOrderId(String.valueOf(orderEsModel.getOrderId()));
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        StringBuilder productIds = new StringBuilder();
        StringBuilder productTitles = new StringBuilder();
        if (orderDetail != null) {
            PayInfoDto payInfo = orderDetail.getPayInfo();
            performanceRecord.setOrderTime(DateUtil.getDate((String)payInfo.getPayTime()));
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            performanceRecord.setPaidAmount(priceInfo.getOrderPrice());
            List<ProductInfo> productInfos = orderDetail.getProductInfos();
            ArrayList<PerformanceRecordProductInfoDto> pInfos = new ArrayList<PerformanceRecordProductInfoDto>();
            productIds.append(",");
            productTitles.append(",");
            for (ProductInfo productInfo : productInfos) {
                PerformanceRecordProductInfoDto dto = new PerformanceRecordProductInfoDto();
                dto.setTitle(productInfo.getTitle());
                dto.setProductId(productInfo.getProductId());
                dto.setSkuId(productInfo.getSkuId());
                pInfos.add(dto);
                productIds.append(productInfo.getProductId()).append(",");
                productTitles.append(productInfo.getTitle()).append(",");
            }
            performanceRecord.setProductInfo(JSON.toJSONString(pInfos));
        }
        performanceRecord.setMeetingCustomerNum(meetingCustomerNum);
        performanceRecord.setMeetingCustomerName(extInfo.getCustomerName());
        Date now = new Date();
        performanceRecord.setCreateTime(now);
        performanceRecord.setProductIds(productIds.toString());
        performanceRecord.setProductTitles(productTitles.toString());
        performanceRecord.setUpdateTime(now);
        this.meetingCommercePerformanceRecordMapper.insertSelective((Object)performanceRecord);
        log.info("insertMeetingPerformance performanceRecord:{}", (Object)performanceRecord);
    }

    private boolean judgeIsExistLeads(String corpId, AddressInfo addressInfo) {
        log.info("judgeIsExistLeads mobile:{}", (Object)addressInfo.getTelNumber());
        String mobile = addressInfo.getTelNumber();
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setCorpId(corpId);
        req.setMobile(mobile);
        boolean exists = this.crmLeadsService.exists(req);
        log.info("judgeIsExistLeads exists:{}", (Object)exists);
        return exists;
    }

    @Override
    public JudgeOrderBelongUserIdDto judgeOrderBelongUserId(Long bizId, String corpId, String mobile, String customerStr) {
        log.info("judgeOrderBelongUserId mobile:{} customerStr:{}", (Object)mobile, (Object)customerStr);
        Long belongUserId = null;
        JudgeOrderBelongUserIdDto dto = new JudgeOrderBelongUserIdDto();
        belongUserId = this.selectInviteUserId(bizId, customerStr);
        dto.setBelongUserId(belongUserId);
        log.info("judgeOrderBelongUserId JudgeOrderBelongUserIdDto:{}", (Object)dto);
        return dto;
    }

    @Override
    public Long selectInviteUserId(Long bizId, String customerStr) {
        if (StringUtils.isBlank((CharSequence)customerStr)) {
            return null;
        }
        ParamEncry selectParamEncry = new ParamEncry();
        selectParamEncry.setNum(customerStr);
        ParamEncry paramEncry = (ParamEncry)this.paramEncryMapper.selectOne((Object)selectParamEncry);
        if (paramEncry == null) {
            return null;
        }
        MeetingParams meetingParams = (MeetingParams)JSON.parseObject((String)paramEncry.getParams(), MeetingParams.class);
        String weworkUserNum = meetingParams.getWeworkUserNum();
        log.info("judgeOrderBelongUserId \u7ebf\u7d22\u6ca1\u6709\u5f52\u5c5e \u67e5\u5230\u4e86\u9080\u8bf7\u4eba meetingParams:{}", (Object)meetingParams);
        Long weworkUserId = null;
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            WeworkUser select = new WeworkUser();
            select.setBizId(bizId);
            select.setNum(weworkUserNum);
            WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)select);
            if (weworkUser != null) {
                weworkUserId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUser.getWeworkUserId());
            }
        }
        log.info("selectInviteUserId \u7ebf\u7d22\u6ca1\u6709\u7ed1\u5b9a\u4eba \u67e5\u8be2\u9080\u8bf7\u4eba\u7684userId\u4e3a:{}", weworkUserId);
        return weworkUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paySuccessHandleCoupon(OrderEsModel orderEsModel, Long bizId) {
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        if (orderDetail == null) {
            return;
        }
        CouponInfoDto couponInfo = orderDetail.getCouponInfo();
        if (couponInfo == null) {
            return;
        }
        List<String> couponIds = couponInfo.getCouponId();
        ExtInfo extInfo = orderEsModel.getExtInfo();
        log.info("handleCoupon orderId:{} couponIds:{}", (Object)orderEsModel.getOrderId(), couponIds);
        for (String couponId : couponIds) {
            String key = UPDATE_COUPON_USED_NUM + couponId;
            try {
                this.lock.lock(key);
                ShopCoupon select = new ShopCoupon();
                select.setBizId(bizId);
                select.setCouponId(couponId);
                ShopCoupon shopCoupon = (ShopCoupon)this.shopCouponMapper.selectOne((Object)select);
                if (shopCoupon == null) {
                    log.info("handleCoupon \u67e5\u4e0d\u5230\u4f18\u60e0\u5238\u4fe1\u606f couponId:{}", (Object)couponId);
                    continue;
                }
                shopCoupon.setUsedNum(Integer.valueOf(shopCoupon.getUsedNum() + 1));
                shopCoupon.setUpdateTime(new Date());
                this.shopCouponMapper.updateByPrimaryKey((Object)shopCoupon);
                if (!StringUtils.isNotBlank((CharSequence)extInfo.getCustomerStr()) && !StringUtils.isNotBlank((CharSequence)extInfo.getBjyNumber())) continue;
                this.updateMeetingCustomerCoupon(extInfo.getCustomerStr(), extInfo.getBjyNumber(), shopCoupon.getNum(), bizId, extInfo.getMeetingId());
            }
            catch (Exception e) {
                log.error("handleCoupon error couponId:{}", (Object)couponId, (Object)e);
            }
            finally {
                this.lock.unlock(key);
            }
        }
    }

    private void updateMeetingCustomerCoupon(String customerStr, String bjyNumber, String couponNum, Long bizId, Long meetingId) {
        List meetingCustomerCoupons;
        List meetingCustomerInfos;
        MeetingCustomerInfo selectInfo;
        log.info("updateMeetingCustomerCoupon customerStr:{} couponNum:{} bjyNumber:{} bizId:{} meetingId:{}", new Object[]{customerStr, couponNum, bjyNumber, bizId, meetingId});
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{customerStr, bjyNumber})) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            selectInfo = new MeetingCustomerInfo();
            selectInfo.setCustomerStr(customerStr);
            meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo);
            if (CollectionUtils.isEmpty((Collection)meetingCustomerInfos)) {
                log.info("updateMeetingCustomerCoupon by customerStr meetingCustomerInfos is null");
                return;
            }
            log.info("updateMeetingCustomerCoupon by customerStr,meetingCustomerInfos:{}", (Object)meetingCustomerInfos);
            meetingCustomerCoupons = this.meetingCustomerCouponMapper.queryUnUseByMeetingCustomerNums(bizId, Collections.singletonList(((MeetingCustomerInfo)meetingCustomerInfos.get(0)).getNum()), couponNum);
            if (CollectionUtils.isEmpty((Collection)meetingCustomerCoupons)) {
                log.info("updateMeetingCustomerCoupon by customerStr meetingCustomerCoupon is null");
                return;
            }
        } else {
            selectInfo = new MeetingCustomerInfo();
            selectInfo.setBizId(bizId);
            selectInfo.setBjyNumber(bjyNumber);
            if (meetingId != null) {
                selectInfo.setMeetingId(meetingId);
            }
            if (CollectionUtils.isEmpty((Collection)(meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)selectInfo)))) {
                log.info("updateMeetingCustomerCoupon by bjyNumber meetingCustomerInfos is null");
                return;
            }
            MeetingCustomerInfo meetingCustomerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
            meetingCustomerCoupons = this.meetingCustomerCouponMapper.queryUnUseByMeetingCustomerNums(bizId, Collections.singletonList(meetingCustomerInfo.getNum()), couponNum);
            if (CollectionUtils.isEmpty((Collection)meetingCustomerCoupons)) {
                log.info("updateMeetingCustomerCoupon by bjyNumber meetingCustomerCoupon is null");
                return;
            }
        }
        MeetingCustomerCoupon meetingCustomerCoupon = (MeetingCustomerCoupon)meetingCustomerCoupons.get(0);
        Date date = new Date();
        meetingCustomerCoupon.setIsUse(Integer.valueOf(1));
        meetingCustomerCoupon.setUpdateTime(date);
        meetingCustomerCoupon.setUseTime(date);
        this.meetingCustomerCouponMapper.updateByPrimaryKeySelective((Object)meetingCustomerCoupon);
    }

    @Override
    public List<MeetingOrderListRep> orderList(MeetingOrderListReq params) {
        log.info("meeting order list params: {}", (Object)params);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        PageDto pageDto = null;
        List<Object> orderEsModelList = Lists.newArrayList();
        HashSet customerStrsParam = Sets.newHashSet();
        String queryMobile = null;
        if (StringUtils.isNotEmpty((CharSequence)params.getName())) {
            if (MobileUtils.isPhone((String)params.getName())) {
                queryMobile = params.getName();
            }
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryByContactName(bizId, params.getName(), params.getMeetingId());
            List queryCustomerNums = meetingCustomerInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerStr())).map(item -> item.getCustomerStr()).collect(Collectors.toList());
            log.info("queryCustomerNums:{}", queryCustomerNums);
            customerStrsParam.addAll(queryCustomerNums);
        }
        do {
            List<OrderEsModel> pageOrderModels = this.goodsOrderEsService.queryMeetingOrderList(params.getMeetingId(), params.getStatus(), params.getName(), params.getSkuName(), queryMobile, customerStrsParam, params.getPageDto());
            orderEsModelList.addAll(pageOrderModels);
            pageDto = params.getPageDto();
            log.info("query pageOrderModels pageDto:{}", (Object)JSON.toJSONString((Object)pageDto));
            if (!Objects.nonNull(pageDto) || !YnEnum.YES.getValue().equals(params.getIsExport())) continue;
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
        } while (YnEnum.YES.getValue().equals(params.getIsExport()) && Objects.nonNull(pageDto) && pageDto.getPageSize() == pageDto.getCurPageCount());
        if (CollectionUtils.isEmpty((Collection)(orderEsModelList = orderEsModelList.stream().filter(it -> it.getExtInfo() != null).collect(Collectors.toList())))) {
            log.info("es order list is empty");
            return Lists.newArrayList();
        }
        ArrayList customerStrs = Lists.newArrayList();
        ArrayList customerNums = Lists.newArrayList();
        HashSet<String> orderIds = new HashSet<String>();
        for (OrderEsModel orderEsModel : orderEsModelList) {
            if (StringUtils.isNotBlank((CharSequence)orderEsModel.getExtInfo().getCustomerStr())) {
                customerStrs.add(orderEsModel.getExtInfo().getCustomerStr());
            }
            if (StringUtils.isNotBlank((CharSequence)orderEsModel.getCustomerNum())) {
                customerNums.add(orderEsModel.getCustomerNum());
            }
            orderIds.add(orderEsModel.getOrderId());
        }
        List customerInfos = this.meetingCustomerInfoMapper.queryCustomerByStr(bizId, params.getMeetingId(), (Collection)customerStrs);
        Map map = customerInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerStr())).collect(Collectors.toMap(MeetingCustomerInfo::getCustomerStr, Function.identity()));
        Set userIds = orderEsModelList.stream().map(it -> it.getExtInfo().getBelongUserId()).collect(Collectors.toSet());
        List contactIds = customerInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getContactId())).map(MeetingCustomerInfo::getContactId).collect(Collectors.toList());
        List customerNumReqs = customerInfos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getContactId()) && StringUtils.isNotBlank((CharSequence)item.getOpenId())).map(item -> {
            CustomerNumReq customerNumReq = new CustomerNumReq();
            customerNumReq.setAppId(item.getAppId());
            customerNumReq.setOpenId(item.getOpenId());
            return customerNumReq;
        }).collect(Collectors.toList());
        List customerNumResps = null;
        try {
            customerNumResps = this.ccCustomerNumService.onlyQueryByOpenId(bizId, customerNumReqs);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528  ccCustomerNumService.onlyQueryByOpenId error, param:{}", (Object)JSON.toJSONString(customerNumReqs), (Object)e);
        }
        Map<String, List<CustomerNumResp>> customerGroupByContactId = customerNumResps.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getContactId())).collect(Collectors.groupingBy(item -> item.getContactId()));
        if (MapUtils.isNotEmpty(customerGroupByContactId)) {
            contactIds.addAll(customerGroupByContactId.keySet());
        }
        Map customerByContactId = this.ccCustomerNumService.butchGetCustomerNumByContactId(bizId, contactIds);
        Map<Object, Object> contactInfos = Maps.newHashMap();
        Map<Object, Object> detailRespMap = Maps.newHashMap();
        Map promoterNames = Maps.newHashMap();
        Map userNameMap = this.userMapper.selectUserIdAndNameByIds(bizId, userInfo.getCorpId(), userIds);
        if (MapUtils.isNotEmpty((Map)customerByContactId)) {
            Set cotactIds = customerByContactId.keySet();
            List weworkContacts = this.weworkContactMapper.queryWeworkContactList(userInfo.getCorpId(), cotactIds);
            contactInfos = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
            List customerDetailResps = this.customerDetailService.queryCustomerDetails(bizId, customerByContactId.values());
            detailRespMap = customerDetailResps.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCustomerNum())).collect(Collectors.toMap(item -> item.getCustomerNum(), Function.identity()));
        }
        List respList = null;
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        try {
            orderListReq.setBizId(bizId);
            orderListReq.setOrderNos((List)Lists.newArrayList(orderIds));
            respList = this.ccCustomerOrderService.pureQueryOrderList(orderListReq);
        }
        catch (Exception e) {
            log.error("ccCustomerOrderService.pureQueryOrderList param:{}:", (Object)orderListReq, (Object)e);
        }
        if (CollectionUtils.isNotEmpty(respList)) {
            List promoterIds = respList.stream().map(item -> item.getPromoterId()).filter(Objects::nonNull).collect(Collectors.toList());
            promoterNames = this.scrmUserService.getNameByIds(promoterIds);
        }
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        ArrayList result = Lists.newArrayList();
        for (OrderEsModel orderEsModel : orderEsModelList) {
            Long promoterId;
            Map promoteDetailRespMap;
            OrderListResp orderListResp;
            AddressInfo addressInfo;
            MeetingOrderListRep rep = new MeetingOrderListRep();
            rep.setName(orderEsModel.getExtInfo().getCustomerName());
            DeliveryInfoDto deliveryInfoDto = orderEsModel.getOrderDetail().getDeliveryInfoDto();
            String telNumber = null;
            if (Objects.nonNull(deliveryInfoDto) && Objects.nonNull(addressInfo = deliveryInfoDto.getAddressInfo())) {
                telNumber = addressInfo.getTelNumber();
            }
            if (mobileEncrypt && StringUtils.isNotBlank(telNumber)) {
                rep.setCustomerMobile(MobileUtils.encryptMobile(telNumber));
            } else {
                rep.setCustomerMobile(telNumber);
            }
            MeetingCustomerInfo customerInfo = (MeetingCustomerInfo)map.get(orderEsModel.getExtInfo().getCustomerStr());
            if (customerInfo != null) {
                String customerNum;
                CustomerDetailResp customerDetailResp;
                String contactId;
                WeworkContact weworkContact;
                rep.setAvatar(customerInfo.getAvatar());
                if (MapUtils.isNotEmpty((Map)contactInfos) && Objects.nonNull(weworkContact = (WeworkContact)contactInfos.get(contactId = customerInfo.getContactId()))) {
                    rep.setWeworkContactName(weworkContact.getName());
                    rep.setAvatar(weworkContact.getAvatar());
                }
                if (StringUtils.isBlank((CharSequence)rep.getWeworkContactName()) && StringUtils.isNotBlank((CharSequence)customerInfo.getUnionId())) {
                    rep.setWeworkContactName(customerInfo.getName());
                }
                if (MapUtils.isNotEmpty((Map)customerByContactId) && MapUtils.isNotEmpty((Map)detailRespMap) && Objects.nonNull(customerDetailResp = (CustomerDetailResp)detailRespMap.get(customerNum = (String)customerByContactId.get(customerInfo.getContactId())))) {
                    if (StringUtils.isNotBlank((CharSequence)rep.getAvatar())) {
                        rep.setAvatar(customerDetailResp.getAvatar());
                    }
                    rep.setCustomerNum(customerDetailResp.getCustomerNum());
                }
            }
            if (MapUtils.isNotEmpty((Map)promoterNames) && CollectionUtils.isNotEmpty((Collection)respList) && Objects.nonNull(orderListResp = (OrderListResp)(promoteDetailRespMap = respList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOrderNo())).collect(Collectors.toMap(item -> item.getOrderNo(), Function.identity()))).get(orderEsModel.getOrderId())) && Objects.nonNull(promoterId = orderListResp.getPromoterId())) {
                String promoteName = (String)promoterNames.get(promoterId);
                rep.setPromoterName(promoteName);
            }
            rep.setOrderNo(String.valueOf(orderEsModel.getOrderId()));
            OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
            PayInfoDto payInfoDto = orderDetail.getPayInfo();
            List<ProductInfo> productInfos = orderDetail.getProductInfos();
            List skuList = productInfos.stream().map(it -> it.getTitle()).collect(Collectors.toList());
            rep.setSkuName(Joiner.on((String)";").join(skuList));
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            rep.setOrderAmount(priceInfo.getProductPrice());
            rep.setDiscountAmount(priceInfo.getDiscountedPrice());
            rep.setPaidAmount(priceInfo.getOrderPrice());
            if (orderEsModel.getStatus() != null && (orderEsModel.getStatus().intValue() == OrderStatus.WAIT_PAY.getStatus().intValue() || orderEsModel.getStatus().intValue() == OrderStatus.FAIL.getStatus().intValue())) {
                rep.setPaidAmount(0L);
            }
            String payType = payInfoDto.getPayMethod();
            rep.setPayTypeDesc(payType);
            Long userId = orderEsModel.getExtInfo().getBelongUserId();
            rep.setUserId(userId);
            rep.setUserName((String)userNameMap.get(userId));
            rep.setStatus(orderEsModel.getStatus());
            if (OrderStatus.isExistByStatus(orderEsModel.getStatus())) {
                rep.setStatusDesc(OrderStatus.getByStatus(orderEsModel.getStatus()).getDesc());
            }
            result.add(rep);
        }
        return result;
    }

    @Override
    public void orderExport(HttpServletResponse response, MeetingOrderListReq params) {
        params.validate();
        String fileName = "\u76f4\u64ad\u8ba2\u5355.xlsx";
        params.setIsExport(YnEnum.YES.getValue());
        PageDto pageDto = new PageDto();
        params.setPageDto(pageDto);
        try {
            List<MeetingOrderListRep> resList = this.orderList(params);
            for (MeetingOrderListRep rep : resList) {
                if (rep.getOrderAmount() != null) {
                    BigDecimal orderAmount = BigDecimal.valueOf(rep.getOrderAmount()).divide(BigDecimal.valueOf(10000L));
                    rep.setExportOrderAmount(orderAmount);
                }
                if (rep.getDiscountAmount() != null) {
                    BigDecimal discountAmount = BigDecimal.valueOf(rep.getDiscountAmount()).divide(BigDecimal.valueOf(10000L));
                    rep.setExportDiscountAmount(discountAmount);
                }
                if (rep.getPaidAmount() == null) continue;
                BigDecimal paidAmount = BigDecimal.valueOf(rep.getPaidAmount()).divide(BigDecimal.valueOf(10000L));
                rep.setExportPaidAmount(paidAmount);
            }
            OutputStream fileWriter = this.getWebOutputStream(response, fileName);
            EasyExcel.write((OutputStream)fileWriter, MeetingOrderListRep.class).sheet("sheet").doWrite(resList);
        }
        catch (Exception e) {
            log.error("export order list error: ", (Throwable)e);
        }
    }

    @Override
    public OrderDetail queryOrderDetailUnLogin(DetailWithoutLoginReq req) {
        log.info("queryOrderDetailUnLogin req:{}", (Object)req);
        String orderDetailParamStr = this.paramEncryMapper.getParamsByTypeAndNum(Integer.valueOf(ParamEncryTypeEnum.ORDER_TYPE.getValue()), req.getNum());
        if (StringUtils.isBlank((CharSequence)orderDetailParamStr)) {
            return null;
        }
        OrderDetailParam param = (OrderDetailParam)JSON.parseObject((String)orderDetailParamStr, OrderDetailParam.class);
        OrderEsModel orderEsModel = this.goodsOrderEsService.getOneById(param.getOrderId());
        OrderDetailDto orderDetailDto = orderEsModel.getOrderDetail();
        PayInfoDto payInfo = orderDetailDto.getPayInfo();
        PriceInfoDto priceInfo = orderDetailDto.getPriceInfo();
        List<ProductInfo> productInfos = orderDetailDto.getProductInfos();
        long totalProductPrice = productInfos.stream().collect(Collectors.summarizingLong(ProductInfo::getSalePrice)).getSum();
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setOrderId(String.valueOf(param.getOrderId()));
        orderDetail.setProductInfos(productInfos);
        orderDetail.setPayType(payInfo.getPayMethod());
        orderDetail.setCreateTime(orderEsModel.getCreateTime());
        orderDetail.setTotalPrice(totalProductPrice);
        orderDetail.setRealPay(priceInfo.getOrderPrice());
        return orderDetail;
    }

    private OutputStream getWebOutputStream(HttpServletResponse response, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + new String(fileName.getBytes(), StandardCharsets.ISO_8859_1) + "\"");
        ServletOutputStream fileWriter = response.getOutputStream();
        return fileWriter;
    }

    @Override
    public OrderNotifyDto buildOrderNotifyModel(OrderEsModel orderEsModel, Long bizId) {
        OrderNotifyDto orderNotifyDto = new OrderNotifyDto();
        String corpId = null;
        if (orderEsModel.getExtInfo().getMeetingId() != null) {
            Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)orderEsModel.getExtInfo().getMeetingId());
            corpId = meeting.getCorpId();
            orderNotifyDto.setOrderTitle("\u76f4 \u64ad \u95f4\uff1a" + meeting.getTitle());
        } else {
            orderNotifyDto.setOrderTitle("");
            log.warn("\u8ba2\u5355\u6ca1\u6709meetingId,\u4e5f\u4e0d\u662f\u7f51\u6821\u8ba2\u5355?? orderId:{}", (Object)orderEsModel.getOrderId());
        }
        String weworkNum = this.getInviteUser(orderEsModel);
        if (StringUtils.isNotEmpty((CharSequence)weworkNum)) {
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkNum);
            if (weworkUser != null) {
                orderNotifyDto.setWeworkUserName(weworkUser.getName());
                corpId = weworkUser.getCorpId();
            }
            orderNotifyDto.setInviteNum(weworkNum);
        }
        AddressInfo addressInfo = orderEsModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo();
        String weworkContactId = this.ccCustomerNumService.getWeworkContactId(bizId, orderEsModel.getCustomerNum());
        log.info("buildOrderNotifyModel corpId:{}, contactId:{}", (Object)corpId, (Object)weworkContactId);
        if (StringUtils.isNotEmpty((CharSequence)weworkContactId) && StringUtils.isNotEmpty((CharSequence)corpId)) {
            WeworkContact weworkContact = this.weworkContactMapper.queryContactByContactId(corpId, weworkContactId);
            log.info("buildOrderNotifyModel weworkContact:{}", (Object)weworkContact);
            if (weworkContact != null) {
                orderNotifyDto.setWechatName(weworkContact.getName());
                orderNotifyDto.setContactId(weworkContact.getContactId());
                orderNotifyDto.setCorpId(weworkContact.getCorpId());
            }
        }
        orderNotifyDto.setBizId(bizId);
        String customerNum = orderEsModel.getCustomerNum();
        String mobile = orderEsModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo().getTelNumber();
        if (StringUtils.isEmpty((CharSequence)customerNum) && StringUtils.isNotEmpty((CharSequence)mobile)) {
            customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerNum)) {
            CustomerDetailResp detailResp = this.ccCustomerDetailService.queryCustomerDetail(bizId, customerNum);
            orderNotifyDto.setCustomer(detailResp.getName());
        }
        orderNotifyDto.setPhone(orderEsModel.getOrderDetail().getDeliveryInfoDto().getAddressInfo().getTelNumber());
        orderNotifyDto.setOrderId(String.valueOf(orderEsModel.getOrderId()));
        orderNotifyDto.setOrderTime(orderEsModel.getCreateTime());
        orderNotifyDto.setOrderAmount(orderEsModel.getOrderDetail().getPriceInfo().getOrderPrice());
        orderNotifyDto.setProduct(orderEsModel.getOrderDetail().getProductInfos().get(0).getTitle());
        if (orderEsModel.getExtInfo() != null && orderEsModel.getExtInfo().getBelongUserId() != null) {
            orderNotifyDto.setBindUserId(orderEsModel.getExtInfo().getBelongUserId());
        }
        return orderNotifyDto;
    }

    @Override
    public String getInviteUser(OrderEsModel orderEsModel) {
        String inviteUser = "";
        if (orderEsModel.getExtInfo() != null && StringUtils.isNotBlank((CharSequence)orderEsModel.getExtInfo().getCustomerStr())) {
            String inviteEncryptNum = orderEsModel.getExtInfo().getCustomerStr();
            String params = null;
            try {
                params = this.paramEncryMapper.getParamsByTypeAndNum(Integer.valueOf(ParamEncryTypeEnum.MEETING_TYPE.getValue()), inviteEncryptNum);
                log.info("\u83b7\u53d6\u9080\u8bf7\u4eba\u4f01\u4e1a\u5fae\u4fe1num\uff0corderId:{}, param:{}", (Object)orderEsModel.getOrderId(), (Object)params);
                MeetingParams meetingParams = (MeetingParams)JacksonUtil.str2Obj((String)params, MeetingParams.class);
                if (StringUtils.isNotBlank((CharSequence)meetingParams.getWeworkUserNum())) {
                    inviteUser = meetingParams.getWeworkUserNum();
                }
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u9080\u8bf7\u4eba\u4f01\u4e1a\u5fae\u4fe1num\u5931\u8d25\uff0corderId:{}, param:{}", (Object)orderEsModel.getOrderId(), (Object)params);
            }
        }
        return inviteUser;
    }

    private Long getInviteUserNetSchoolId(Long bizId, String corpId, String customerStr) {
        log.info("getInviteUserNetSchoolId corpId:{}, customerStr:{}", (Object)corpId, (Object)customerStr);
        if (StringUtils.isBlank((CharSequence)customerStr)) {
            return null;
        }
        String inviteUser = null;
        try {
            String params = this.paramEncryMapper.getParamsByTypeAndNum(Integer.valueOf(ParamEncryTypeEnum.MEETING_TYPE.getValue()), customerStr);
            MeetingParams meetingParams = (MeetingParams)JacksonUtil.str2Obj((String)params, MeetingParams.class);
            if (StringUtils.isNotBlank((CharSequence)meetingParams.getWeworkUserNum())) {
                inviteUser = meetingParams.getWeworkUserNum();
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u9080\u8bf7\u4eba\u4f01\u4e1a\u5fae\u4fe1num\u5931\u8d25\uff0ccustomerStr:{},\u5f02\u5e38\u4fe1\u606f:", (Object)customerStr, (Object)e);
        }
        if (StringUtils.isBlank(inviteUser)) {
            log.info("inviteUser is null");
            return null;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(inviteUser);
        if (weworkUser == null) {
            log.info("\u6839\u636eweworkUserNum:{}\u67e5\u8be2weworkUser\u4e3a\u7a7a", (Object)inviteUser);
            return null;
        }
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
        if (user == null || Objects.isNull(user.getNodeId())) {
            log.info("\u6839\u636eweworkUserId:{}\u67e5\u8be2user\u4e3a\u7a7a", (Object)weworkUser.getWeworkUserId());
            return null;
        }
        List organizations = this.organizationMapper.findAll(bizId);
        Map orgId2OrgMap = organizations.stream().collect(Collectors.toMap(Organization::getId, Functions.identity()));
        Organization organization = (Organization)orgId2OrgMap.get(user.getNodeId());
        while (organization != null) {
            if (organization.getNetSchoolId() != null) {
                return organization.getNetSchoolId();
            }
            organization = (Organization)orgId2OrgMap.get(organization.getPid());
        }
        return null;
    }
}

