/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.netschool.service.impl;

import cn.kinyun.scrm.netschool.config.NetSchoolProperties;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.dto.NetSchoolGoodsDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.coupon.service.impl.HandleBjyApiService;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.dto.MeetingGoodsRelDto;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsRel;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsRelMapper;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.goods.dto.SkuItemDto;
import com.kuaike.scrm.goods.enums.GoodsSpuStatus;
import com.kuaike.scrm.goods.model.ProductEsModel;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.goods.service.GoodsEsService;
import com.kuaike.scrm.goods.service.GoodsService;
import com.kuaike.scrm.netschool.service.NetSchoolGoodsService;
import com.kuaike.scrm.system.utils.NetSchoolGoodsId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NetSchoolGoodsServiceImpl
implements NetSchoolGoodsService {
    private static final Logger log = LoggerFactory.getLogger(NetSchoolGoodsServiceImpl.class);
    public static final String DEFAULT_APP_ID = "-1";
    private static final String NET_SCHOOL_COURSE_LOCK = ":nsc:lock:";
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private ShopSpuMapper shopSpuMapper;
    @Autowired
    private ShopSkuMapper shopSkuMapper;
    @Autowired
    private NetSchoolProperties netSchoolProperties;
    @Autowired
    private IdGen idGen;
    @Autowired
    private GoodsEsService goodsEsService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private MeetingGoodsRelMapper meetingGoodsRelMapper;
    @Autowired
    private HandleBjyApiService handleBjyApiService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectNeedUpdate(Long bizId, List<NetSchoolGoodsDto> goodsList) {
        log.info("collectNeedUpdate, bizId:{},courseList:{}", (Object)bizId, goodsList);
        if (CollectionUtils.isEmpty(goodsList)) {
            log.warn("course list is empty, bizId:{}", (Object)bizId);
            return;
        }
        List outProductIds = goodsList.stream().map(it -> NetSchoolGoodsId.getId((Long)bizId, (NetSchoolGoodsDto)it)).collect(Collectors.toList());
        log.info("collect outProductIds:{}", outProductIds);
        HashSet<String> keys = new HashSet<String>();
        for (String outProductId : outProductIds) {
            keys.add(this.redisKeyPrefix + NET_SCHOOL_COURSE_LOCK + outProductId);
        }
        try {
            log.info("lock keys:{}", keys);
            this.distributedLock.multiLock(keys);
            List existsSpuList = this.shopSpuMapper.queryNetSchoolCourse(bizId, DEFAULT_APP_ID, outProductIds, Integer.valueOf(GoodsOrderSource.NET_SCHOOL.getSource()));
            HashMap existsSpuMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)existsSpuList)) {
                existsSpuList.forEach(spu -> existsSpuMap.put(spu.getOutProductId(), spu));
                log.info("found exists spu, count:{}, outProductIds:{}", (Object)existsSpuList.size(), existsSpuMap.keySet());
            }
            List existsSkuList = this.shopSkuMapper.queryNetSchoolCourse(bizId, DEFAULT_APP_ID, outProductIds, Integer.valueOf(GoodsOrderSource.NET_SCHOOL.getSource()));
            HashMap existsSkuMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)existsSkuList)) {
                existsSkuList.forEach(sku -> existsSkuMap.put(sku.getOutProductId(), sku));
                log.info("found exists sku, count:{}, outProductIds:{}", (Object)existsSpuList.size(), existsSpuMap.keySet());
            }
            ArrayList needAddSpuList = Lists.newArrayList();
            ArrayList needUpdateSpuList = Lists.newArrayList();
            ArrayList needAddSkuList = Lists.newArrayList();
            ArrayList needUpdateSkuList = Lists.newArrayList();
            ArrayList needAddProductList = Lists.newArrayList();
            for (NetSchoolGoodsDto goods : goodsList) {
                String goodsId = NetSchoolGoodsId.getId((Long)bizId, (NetSchoolGoodsDto)goods);
                Integer status = this.convertStatus(goodsId, goods);
                ShopSpu existsSpu = (ShopSpu)existsSpuMap.get(goodsId);
                ShopSku existsSku = (ShopSku)existsSkuMap.get(goodsId);
                ShopSpu spu2 = this.buildSpu(bizId, goodsId, status, goods, existsSpu);
                if (existsSpu == null) {
                    log.info("insert net school spu, goodsId:{}, data:{}", (Object)goodsId, (Object)JacksonUtil.obj2Str((Object)spu2));
                    needAddSpuList.add(spu2);
                } else {
                    log.info("update net school spu, goodsId:{}, data:{}", (Object)goodsId, (Object)JacksonUtil.obj2Str((Object)spu2));
                    needUpdateSpuList.add(spu2);
                }
                ShopSku sku2 = this.buildSku(bizId, goodsId, status, goods, existsSku);
                if (existsSku == null) {
                    log.info("insert net school sku, courseId:{}, data:{}", (Object)goodsId, (Object)JacksonUtil.obj2Str((Object)sku2));
                    needAddSkuList.add(sku2);
                } else {
                    log.info("update net school sku, courseId:{}, data:{}", (Object)goodsId, (Object)JacksonUtil.obj2Str((Object)sku2));
                    needUpdateSkuList.add(sku2);
                }
                ProductEsModel productEsModel = this.buildProductEsModel(bizId, goods, spu2, sku2);
                needAddProductList.add(productEsModel);
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddSpuList)) {
                log.info("batch insert net school spu, size:{}", (Object)needAddSpuList.size());
                this.shopSpuMapper.batchInsert((List)needAddSpuList);
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddSkuList)) {
                log.info("batch insert net school sku, size:{}", (Object)needAddSkuList.size());
                this.shopSkuMapper.batchInsert((Collection)needAddSkuList);
            }
            if (CollectionUtils.isNotEmpty((Collection)needUpdateSkuList)) {
                log.info("batch update net school sku, size:{}", (Object)needUpdateSkuList.size());
                this.shopSkuMapper.batchUpdate((Collection)needUpdateSkuList);
            }
            if (CollectionUtils.isNotEmpty((Collection)needUpdateSpuList)) {
                log.info("batch update net school spu, size:{}", (Object)needUpdateSpuList.size());
                this.shopSpuMapper.batchUpdate((List)needUpdateSpuList);
                for (ShopSpu shopSpu : needUpdateSpuList) {
                    log.info("\u66f4\u65b0\u76f4\u64ad\u95f4\u5546\u54c1\u4fe1\u606fproductId:{}", (Object)shopSpu.getProductId());
                    this.goodsService.updateMeetingGoods(shopSpu.getProductId(), shopSpu);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)needAddProductList)) {
                log.info("batch index net school ProductEsModel, size:{}", (Object)needAddProductList.size());
                this.goodsEsService.batchInsertProduct(needAddProductList);
            }
        }
        catch (Exception e) {
            log.error("lock failed", (Throwable)e);
        }
        finally {
            log.info("unlock keys:{}", keys);
            this.distributedLock.unlockMultiLock(keys);
        }
    }

    @Override
    public void delGoods(NetSchoolGoodsDto goodsDto) {
        log.info("delGoods,goodsDto:{}", (Object)goodsDto);
        if (goodsDto == null) {
            log.info("goodsDto is null");
            return;
        }
        String outProductId = NetSchoolGoodsId.getId((Long)goodsDto.getBizId(), (NetSchoolGoodsDto)goodsDto);
        this.shopSkuMapper.deleteByProductId(outProductId);
        this.shopSpuMapper.deleteByProductId(outProductId);
        this.goodsEsService.delProduct(outProductId, goodsDto.getBizId());
        List meetingGoodsRels = this.meetingGoodsRelMapper.queryByGoodsProductIdAndStatus(outProductId, YnEnum.YES.getValue());
        if (CollectionUtils.isEmpty((Collection)meetingGoodsRels)) {
            log.info("\u7f51\u6821\u5546\u54c1outProductId:{}\u4e0d\u5728\u4efb\u52a1\u76f4\u64ad\u95f4\u4e2d\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u5220\u9664\u76f4\u64ad\u95f4\u5546\u54c1", (Object)outProductId);
            return;
        }
        String corpId = this.businessCustomerMapper.getCorpIdById(((MeetingGoodsRel)meetingGoodsRels.get(0)).getBizId());
        ArrayList meetingGoodsRelIds = Lists.newArrayList();
        MeetingGoodsRelDto meetingGoodsRelDto = new MeetingGoodsRelDto();
        meetingGoodsRelDto.setCorpId(corpId);
        for (MeetingGoodsRel meetingGoodsRel : meetingGoodsRels) {
            meetingGoodsRelIds.add(meetingGoodsRel.getId());
            meetingGoodsRelDto.setRoomId(meetingGoodsRel.getRoomId());
            if (StringUtils.isBlank((CharSequence)meetingGoodsRel.getBjyGoodsId())) {
                log.info("meetingGoodsRelId:{}\u5bf9\u5e94\u7684bjyGoodsId\u4e3a\u7a7a", (Object)meetingGoodsRel.getId());
                continue;
            }
            meetingGoodsRelDto.setBjyGoodsId(meetingGoodsRel.getBjyGoodsId());
            this.handleBjyApiService.handDelBjyGoodsRoom(meetingGoodsRelDto);
        }
        this.meetingGoodsRelMapper.updateStatusByIds(YnEnum.NO.getValue(), (Collection)meetingGoodsRelIds);
    }

    private Integer convertStatus(String goodsId, NetSchoolGoodsDto course) {
        Integer courseStatus = course.getStatus();
        Integer status = (Integer)this.netSchoolProperties.getStatusMap().get(courseStatus);
        if (status == null) {
            status = GoodsSpuStatus.INIT.getStatus();
            log.warn("sku status mapping goodsId:{}, courseStatus:{}, status:{}", new Object[]{goodsId, courseStatus, status});
        }
        return status;
    }

    private Date convertTimestamp(Long unixTimestamp) {
        if (unixTimestamp != null) {
            return new Date(unixTimestamp * 1000L);
        }
        return new Date();
    }

    public ProductEsModel buildProductEsModel(Long bizId, NetSchoolGoodsDto goodsDto, ShopSpu spu, ShopSku sku) {
        ProductEsModel model = new ProductEsModel();
        model.setBizId(bizId);
        model.setAppId(DEFAULT_APP_ID);
        model.setProductId(spu.getProductId());
        model.setOutProductId(spu.getOutProductId());
        model.setTitle(spu.getTitle());
        model.setSubTitle(StringUtils.isBlank((CharSequence)goodsDto.getIntro()) ? "" : goodsDto.getIntro());
        model.setStatus(spu.getStatus());
        model.setEditStatus(spu.getStatus());
        model.setPrice(sku.getSalePrice());
        model.setCategoryIdL1(goodsDto.getCourseClassifyId());
        model.setSource(spu.getSource());
        model.setShopId(spu.getShopId());
        model.setUpdateTime(this.convertTimestamp(goodsDto.getUpdatedAt()));
        model.setIsDeleted(0);
        model.setCreateTime(this.convertTimestamp(goodsDto.getCreatedAt()));
        return model;
    }

    public SpuCreateReq buildSpuBody(String courseId, NetSchoolGoodsDto course) {
        SpuCreateReq dto = new SpuCreateReq();
        dto.setSource(GoodsOrderSource.NET_SCHOOL.getSource());
        dto.setOutProductId(courseId);
        dto.setTitle(course.getTitle());
        dto.setSubTitle(StringUtils.isBlank((CharSequence)course.getIntro()) ? "" : course.getIntro());
        dto.setHeadImg(Collections.singletonList(course.getCoverImg()));
        dto.setNeedAddress(course.getIsMaterials());
        dto.setInitSaleCount((long)course.getSalesBase());
        dto.setHtmlDetails(course.getCourseDetails());
        SkuItemDto sku = new SkuItemDto();
        sku.setSkuId(courseId);
        sku.setProductId(courseId);
        sku.setOutSkuId(courseId);
        sku.setOutProductId(courseId);
        sku.setThumbImg(course.getCoverImg());
        sku.setSalePrice(course.getPrice() * 100L);
        if (course.getUnderlinedPrice() != null) {
            sku.setMarketPrice((long)course.getUnderlinedPrice().intValue() * 100L);
        } else {
            sku.setMarketPrice(0L);
        }
        if (course.getStock() != null) {
            sku.setStockNum((long)course.getStock());
        } else {
            sku.setStockNum(0L);
        }
        dto.setSkus(Collections.singletonList(sku));
        dto.setAttrs(Collections.emptyList());
        return dto;
    }

    private ShopSpu buildSpu(Long bizId, String goodsId, Integer status, NetSchoolGoodsDto goodsDto, ShopSpu existsSpu) {
        ShopSpu shopSpu;
        if (existsSpu == null) {
            shopSpu = new ShopSpu();
            shopSpu.setNum(this.idGen.getNum());
            shopSpu.setBizId(bizId);
            shopSpu.setAppId(DEFAULT_APP_ID);
            shopSpu.setSource(Integer.valueOf(GoodsOrderSource.NET_SCHOOL.getSource()));
            shopSpu.setProductId(goodsId);
            shopSpu.setOutProductId(goodsId);
            if (goodsDto.getSchoolId() != null) {
                shopSpu.setShopId(String.valueOf(goodsDto.getSchoolId()));
            }
            shopSpu.setCreateBy(Long.valueOf(-1L));
            shopSpu.setCreateTime(this.convertTimestamp(goodsDto.getCreatedAt()));
        } else {
            shopSpu = existsSpu;
        }
        shopSpu.setTitle(goodsDto.getTitle());
        shopSpu.setSpuBody(JacksonUtil.obj2Str((Object)this.buildSpuBody(goodsId, goodsDto)));
        shopSpu.setStatus(status);
        shopSpu.setEditStatus(Integer.valueOf(-1));
        shopSpu.setUpdateBy(Long.valueOf(-1L));
        shopSpu.setUpdateTime(this.convertTimestamp(goodsDto.getUpdatedAt()));
        shopSpu.setIsDeleted(Integer.valueOf(0));
        return shopSpu;
    }

    private ShopSku buildSku(Long bizId, String courseId, Integer status, NetSchoolGoodsDto goodsDto, ShopSku existsSku) {
        ShopSku shopSku;
        if (existsSku == null) {
            shopSku = new ShopSku();
            shopSku.setNum(this.idGen.getNum());
            shopSku.setBizId(bizId);
            shopSku.setAppId(DEFAULT_APP_ID);
            shopSku.setSource(Integer.valueOf(GoodsOrderSource.NET_SCHOOL.getSource()));
            shopSku.setProductId(courseId);
            shopSku.setSkuId(courseId);
            shopSku.setOutProductId(courseId);
            shopSku.setOutSkuId(courseId);
            shopSku.setCreateBy(Long.valueOf(-1L));
            shopSku.setCreateTime(this.convertTimestamp(goodsDto.getCreatedAt()));
        } else {
            shopSku = existsSku;
        }
        shopSku.setSalePrice(Long.valueOf(goodsDto.getPrice() * 100L));
        if (goodsDto.getUnderlinedPrice() != null) {
            shopSku.setMarketPrice(Long.valueOf((long)goodsDto.getUnderlinedPrice().intValue() * 100L));
        } else {
            shopSku.setMarketPrice(Long.valueOf(0L));
        }
        if (goodsDto.getStock() != null) {
            shopSku.setStockNum(Long.valueOf(goodsDto.getStock().intValue()));
        } else {
            shopSku.setStockNum(Long.valueOf(0L));
        }
        shopSku.setSkuBody(JacksonUtil.obj2Str((Object)goodsDto));
        shopSku.setStatus(status);
        shopSku.setUpdateBy(Long.valueOf(-1L));
        shopSku.setUpdateTime(this.convertTimestamp(goodsDto.getUpdatedAt()));
        shopSku.setIsDeleted(Integer.valueOf(0));
        return shopSku;
    }
}

