/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.coupon.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.GoodsValidType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.coupon.dto.CouponDiscountInfoDto;
import com.kuaike.scrm.coupon.dto.CouponExtInfoDto;
import com.kuaike.scrm.coupon.dto.CouponPromoteInfoDto;
import com.kuaike.scrm.coupon.dto.CouponReceiveInfoDto;
import com.kuaike.scrm.coupon.dto.CouponValidInfoDto;
import com.kuaike.scrm.coupon.enums.CouponPromoteType;
import com.kuaike.scrm.coupon.enums.CouponType;
import com.kuaike.scrm.coupon.enums.CouponUsageScenario;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CouponCreateOrUpdateReq {
    private String couponId;
    private Integer type;
    private String name;
    private Integer usageScenario;
    private CouponDiscountInfoDto discountInfo;
    private CouponExtInfoDto extInfo;
    private CouponPromoteInfoDto promoteInfo;
    private CouponReceiveInfoDto receiveInfo;
    private CouponValidInfoDto validInfo;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.name.length() <= 10 ? 1 : 0) != 0, (Object)"name\u957f\u5ea6\u4e0d\u80fd\u8d8510");
        Preconditions.checkArgument((this.type != null && CouponType.isExistByType(this.type) ? 1 : 0) != 0, (Object)"type\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((this.usageScenario != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u4f7f\u7528\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        boolean usageScenarioType = CouponUsageScenario.isExistByType(this.usageScenario);
        Preconditions.checkArgument((boolean)usageScenarioType, (Object)"\u4f18\u60e0\u5238\u4f7f\u7528\u573a\u666f\u8303\u56f4\u9519\u8bef");
        Preconditions.checkArgument((this.validInfo != null ? 1 : 0) != 0, (Object)"validInfo\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.promoteInfo != null ? 1 : 0) != 0, (Object)"promoteInfo\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.type.equals(CouponType.PRODUCT_FULL_DISCOUNT.getType()) || this.type.equals(CouponType.PRODUCT_DIRECT_DISCOUNT.getType()) ? 1 : 0) != 0, (Object)"\u6682\u65f6\u53ea\u652f\u6301\u5546\u54c1\u6ee1\u51cf\u5238\u548c\u5546\u54c1\u76f4\u51cf\u5238");
        if (this.discountInfo.getDiscountFee() != null) {
            Preconditions.checkArgument((this.discountInfo.getDiscountFee() <= 429496720000L ? 1 : 0) != 0, (Object)"discountFee\u4e0d\u80fd\u8d85\u8fc742949672");
        }
        if (this.discountInfo.getDiscountNum() != null) {
            Preconditions.checkArgument((this.discountInfo.getDiscountNum() <= 42949672 ? 1 : 0) != 0, (Object)"discountNum\u4e0d\u80fd\u8d85\u8fc742949672");
        }
        int noteMaxLen = 1000;
        if (StringUtils.isNotBlank((CharSequence)this.extInfo.getNotes())) {
            Preconditions.checkArgument((this.extInfo.getNotes().length() <= noteMaxLen ? 1 : 0) != 0, (Object)"\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc71\u5343\u5b57");
        }
        if (CouponType.PRODUCT_CONDITION_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.discountInfo.getProductIds()), (Object)"\u5546\u54c1\u6761\u4ef6\u6298\u5238productIds\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getProductCnt() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6761\u4ef6\u6298\u5238productCnt\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountNum() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6761\u4ef6\u6298\u5238discountNum\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.PRODUCT_FULL_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.discountInfo.getProductIds()), (Object)"\u5546\u54c1\u6ee1\u51cf\u5238productIds\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getProductPrice() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6ee1\u51cf\u5238productPrice\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountFee() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6ee1\u51cf\u5238discountFee\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.PRODUCT_FLAT_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.discountInfo.getProductIds()), (Object)"\u5546\u54c1\u7edf\u4e00\u6298\u6263\u5238productIds\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountNum() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u7edf\u4e00\u6298\u6263\u5238discountNum\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.PRODUCT_DIRECT_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.discountInfo.getProductIds()), (Object)"\u5546\u54c1\u76f4\u51cf\u5238productIds\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountFee() != null ? 1 : 0) != 0, (Object)"\u5546\u54c1\u6ee1\u51cf\u5238discountFee\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.STORE_CONDITION_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((this.discountInfo.getProductCnt() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u6761\u4ef6\u6298\u6263\u5238productCnt\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountNum() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u6761\u4ef6\u6298\u6263\u5238discountNum\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.STORE_FULL_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((this.discountInfo.getProductPrice() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u6ee1\u51cf\u5238productPrice\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.discountInfo.getDiscountFee() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u6ee1\u51cf\u5238discountFee\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.STORE_FLAT_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((this.discountInfo.getDiscountNum() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u7edf\u4e00\u6298\u6263\u5238discountNum\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (CouponType.STORE_DIRECT_DISCOUNT.getType().equals(this.type)) {
            Preconditions.checkArgument((this.discountInfo.getDiscountFee() != null ? 1 : 0) != 0, (Object)"\u5e97\u94fa\u76f4\u51cf\u5238discountFee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((this.receiveInfo != null ? 1 : 0) != 0, (Object)"receiveInfo\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.receiveInfo.getLimitNumOnePerson() != null ? 1 : 0) != 0, (Object)"\u5355\u4eba\u9650\u9886\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.receiveInfo.getTotalNum() != null ? 1 : 0) != 0, (Object)"\u4f18\u60e0\u5238\u9886\u7528\u603b\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.receiveInfo.getStartTime()), (Object)"\u4f18\u60e0\u5238\u9886\u7528\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.receiveInfo.getEndTime()), (Object)"\u4f18\u60e0\u5238\u9886\u7528\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.validInfo.getValidType() != null && GoodsValidType.isExistByType((int)this.validInfo.getValidType()) ? 1 : 0) != 0, (Object)"validType\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
        Date now = new Date();
        Date receiveInfoStartTime = null;
        Date receiveInfoEndTime = null;
        try {
            receiveInfoStartTime = DateUtil.getDate((String)this.receiveInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            receiveInfoEndTime = DateUtil.getDate((String)this.receiveInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9886\u5238\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        Preconditions.checkArgument((receiveInfoStartTime != null && receiveInfoEndTime != null ? 1 : 0) != 0, (Object)"\u9886\u5238\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        Preconditions.checkArgument((receiveInfoStartTime.getTime() < receiveInfoEndTime.getTime() ? 1 : 0) != 0, (Object)"\u9886\u5238\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u9886\u5238\u7ed3\u675f\u65f6\u95f4");
        Preconditions.checkArgument((receiveInfoEndTime.getTime() > now.getTime() ? 1 : 0) != 0, (Object)"\u9886\u5238\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f53\u524d\u65f6\u95f4");
        if (GoodsValidType.COUPON_VALID_TYPE_TIME.getType().equals(this.validInfo.getValidType())) {
            Preconditions.checkArgument((this.validInfo.getValidStartTime() != null ? 1 : 0) != 0, (Object)"validStartTime\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.validInfo.getValidEndTime() != null ? 1 : 0) != 0, (Object)"validEndTime\u4e0d\u80fd\u4e3a\u7a7a");
            Date endTime = null;
            Date startTime = null;
            try {
                startTime = DateUtil.getDate((String)this.validInfo.getValidStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
                endTime = DateUtil.getDate((String)this.validInfo.getValidEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            catch (Exception e) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6709\u6548\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            Preconditions.checkArgument((startTime != null && endTime != null ? 1 : 0) != 0, (Object)"\u6709\u6548\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            Preconditions.checkArgument((startTime.getTime() < endTime.getTime() ? 1 : 0) != 0, (Object)"\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4");
            Preconditions.checkArgument((endTime.getTime() > now.getTime() ? 1 : 0) != 0, (Object)"\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f53\u524d\u65f6\u95f4");
            Preconditions.checkArgument((startTime.getTime() > receiveInfoStartTime.getTime() ? 1 : 0) != 0, (Object)"\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u9886\u5238\u5f00\u59cb\u65f6\u95f4");
            Preconditions.checkArgument((endTime.getTime() > receiveInfoEndTime.getTime() ? 1 : 0) != 0, (Object)"\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u9886\u5238\u7ed3\u675f\u65f6\u95f4");
        } else if (GoodsValidType.COUPON_VALID_TYPE_DAY.getType().equals(this.type)) {
            Preconditions.checkArgument((this.validInfo.getValidDayNum() != null ? 1 : 0) != 0, (Object)"validDayNum\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((this.promoteInfo.getPromoteType() != null && CouponPromoteType.isExistByType(this.promoteInfo.getPromoteType()) ? 1 : 0) != 0, (Object)"promoteType\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728");
    }

    public String getCouponId() {
        return this.couponId;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Integer getUsageScenario() {
        return this.usageScenario;
    }

    public CouponDiscountInfoDto getDiscountInfo() {
        return this.discountInfo;
    }

    public CouponExtInfoDto getExtInfo() {
        return this.extInfo;
    }

    public CouponPromoteInfoDto getPromoteInfo() {
        return this.promoteInfo;
    }

    public CouponReceiveInfoDto getReceiveInfo() {
        return this.receiveInfo;
    }

    public CouponValidInfoDto getValidInfo() {
        return this.validInfo;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsageScenario(Integer usageScenario) {
        this.usageScenario = usageScenario;
    }

    public void setDiscountInfo(CouponDiscountInfoDto discountInfo) {
        this.discountInfo = discountInfo;
    }

    public void setExtInfo(CouponExtInfoDto extInfo) {
        this.extInfo = extInfo;
    }

    public void setPromoteInfo(CouponPromoteInfoDto promoteInfo) {
        this.promoteInfo = promoteInfo;
    }

    public void setReceiveInfo(CouponReceiveInfoDto receiveInfo) {
        this.receiveInfo = receiveInfo;
    }

    public void setValidInfo(CouponValidInfoDto validInfo) {
        this.validInfo = validInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouponCreateOrUpdateReq)) {
            return false;
        }
        CouponCreateOrUpdateReq other = (CouponCreateOrUpdateReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$usageScenario = this.getUsageScenario();
        Integer other$usageScenario = other.getUsageScenario();
        if (this$usageScenario == null ? other$usageScenario != null : !((Object)this$usageScenario).equals(other$usageScenario)) {
            return false;
        }
        String this$couponId = this.getCouponId();
        String other$couponId = other.getCouponId();
        if (this$couponId == null ? other$couponId != null : !this$couponId.equals(other$couponId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CouponDiscountInfoDto this$discountInfo = this.getDiscountInfo();
        CouponDiscountInfoDto other$discountInfo = other.getDiscountInfo();
        if (this$discountInfo == null ? other$discountInfo != null : !((Object)this$discountInfo).equals(other$discountInfo)) {
            return false;
        }
        CouponExtInfoDto this$extInfo = this.getExtInfo();
        CouponExtInfoDto other$extInfo = other.getExtInfo();
        if (this$extInfo == null ? other$extInfo != null : !((Object)this$extInfo).equals(other$extInfo)) {
            return false;
        }
        CouponPromoteInfoDto this$promoteInfo = this.getPromoteInfo();
        CouponPromoteInfoDto other$promoteInfo = other.getPromoteInfo();
        if (this$promoteInfo == null ? other$promoteInfo != null : !((Object)this$promoteInfo).equals(other$promoteInfo)) {
            return false;
        }
        CouponReceiveInfoDto this$receiveInfo = this.getReceiveInfo();
        CouponReceiveInfoDto other$receiveInfo = other.getReceiveInfo();
        if (this$receiveInfo == null ? other$receiveInfo != null : !((Object)this$receiveInfo).equals(other$receiveInfo)) {
            return false;
        }
        CouponValidInfoDto this$validInfo = this.getValidInfo();
        CouponValidInfoDto other$validInfo = other.getValidInfo();
        return !(this$validInfo == null ? other$validInfo != null : !((Object)this$validInfo).equals(other$validInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouponCreateOrUpdateReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $usageScenario = this.getUsageScenario();
        result = result * 59 + ($usageScenario == null ? 43 : ((Object)$usageScenario).hashCode());
        String $couponId = this.getCouponId();
        result = result * 59 + ($couponId == null ? 43 : $couponId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CouponDiscountInfoDto $discountInfo = this.getDiscountInfo();
        result = result * 59 + ($discountInfo == null ? 43 : ((Object)$discountInfo).hashCode());
        CouponExtInfoDto $extInfo = this.getExtInfo();
        result = result * 59 + ($extInfo == null ? 43 : ((Object)$extInfo).hashCode());
        CouponPromoteInfoDto $promoteInfo = this.getPromoteInfo();
        result = result * 59 + ($promoteInfo == null ? 43 : ((Object)$promoteInfo).hashCode());
        CouponReceiveInfoDto $receiveInfo = this.getReceiveInfo();
        result = result * 59 + ($receiveInfo == null ? 43 : ((Object)$receiveInfo).hashCode());
        CouponValidInfoDto $validInfo = this.getValidInfo();
        result = result * 59 + ($validInfo == null ? 43 : ((Object)$validInfo).hashCode());
        return result;
    }

    public String toString() {
        return "CouponCreateOrUpdateReq(couponId=" + this.getCouponId() + ", type=" + this.getType() + ", name=" + this.getName() + ", usageScenario=" + this.getUsageScenario() + ", discountInfo=" + this.getDiscountInfo() + ", extInfo=" + this.getExtInfo() + ", promoteInfo=" + this.getPromoteInfo() + ", receiveInfo=" + this.getReceiveInfo() + ", validInfo=" + this.getValidInfo() + ")";
    }
}

