/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.follow.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import com.google.common.base.Functions;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.FollowRecordType;
import com.kuaike.scrm.common.enums.NoticeType;
import com.kuaike.scrm.common.service.AreaService;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.NoticeService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.req.AddNoticeReq;
import com.kuaike.scrm.common.service.dto.req.notice.NoticeExtendParam;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.follow.entity.WeworkUserLastFollow;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.follow.mapper.WeworkUserLastFollowMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.entity.CustomerStageReason;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageReasonMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.follow.dto.AllocateInfo;
import com.kuaike.scrm.follow.dto.CorpTagDto;
import com.kuaike.scrm.follow.dto.CustomerBaseInfo;
import com.kuaike.scrm.follow.dto.CustomerStageInfo;
import com.kuaike.scrm.follow.dto.CustomerTagInfo;
import com.kuaike.scrm.follow.dto.FollowInfo;
import com.kuaike.scrm.follow.dto.FollowReqDto;
import com.kuaike.scrm.follow.service.FollowService;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FollowServiceImpl
implements FollowService {
    private static final Logger log = LoggerFactory.getLogger(FollowServiceImpl.class);
    private static final String MID_SEPARATOR = " -> ";
    private static final String ARRAY_SEPARATOR = ",";
    private static final String CHANGE_ROW = "\n";
    @Autowired
    private FollowRecordMapper followRecordMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private CustomerStageReasonMapper customerStageReasonMapper;
    @Autowired
    private WeworkUserLastFollowMapper weworkUserLastFollowMapper;
    @Autowired
    private CustomerCenterService centerService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private AreaService areaService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ScrmBizService scrmBizService;

    @Override
    public void saveFollowRecord(FollowReqDto reqDto, CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        reqDto.setBizId(currentUserInfo.getBizId());
        reqDto.setCorpId(currentUserInfo.getCorpId());
        reqDto.setOperatorId(currentUserInfo.getId());
        reqDto.setUserId(currentUserInfo.getId());
        this.saveFollowRecord(reqDto);
    }

    @Override
    public void saveFollowRecord(FollowReqDto reqDto) {
        log.info("saveFollowRecord, operatorId:{}, reqDto:{}", (Object)reqDto.getOperatorId(), (Object)reqDto);
        FollowRecordType followRecordType = FollowRecordType.get((int)reqDto.getType());
        String content = "";
        switch (followRecordType) {
            case EDIT_CONTACT_INFO: {
                content = this.buildEditContactInfoContent(reqDto.getCustomerBaseInfo());
                break;
            }
            case UPDATE_CONTACT_STAGE: {
                content = this.buildUpdateStageInfoContent(reqDto.getCustomerStageInfo());
                break;
            }
            case FOLLOW_INFO: {
                content = this.buildFollowInfoContent(reqDto.getFollowInfo());
                break;
            }
            case EDIT_CONTACT_TAG: {
                content = this.buildEditContactTagContent(reqDto.getCustomerTagInfo());
                break;
            }
            case TRANSFER_CONTACT: {
                content = this.buildTransferContactContent(reqDto.getAllocateInfo(), reqDto.getCorpId());
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            User user;
            FollowRecord followRecord = this.buildFollowRecord(reqDto, content);
            this.followRecordMapper.insert((Object)followRecord);
            this.saveLastFollow(followRecord);
            FollowInfo followInfo = reqDto.getFollowInfo();
            String remark = "";
            if (Objects.nonNull(followInfo)) {
                remark = reqDto.getFollowInfo().getRemark();
                this.saveNotice(reqDto);
            }
            String operatorName = "";
            if (Objects.nonNull(reqDto.getOperatorId()) && Objects.nonNull(user = this.userMapper.selectUserByIdAndCorpId(reqDto.getOperatorId(), reqDto.getCorpId()))) {
                operatorName = user.getName();
            }
            followRecord.setUserId(reqDto.getUserId());
            this.centerService.pushFollowRecord(followRecord, remark, operatorName);
            if (followRecordType.getValue() == FollowRecordType.FOLLOW_INFO.getValue() && this.scrmBizService.isOpenCrm(followRecord.getBizId()).booleanValue()) {
                this.crmLeadsService.updateLeadsToFollowed(followRecord.getBizId(), followRecord.getWeworkContactId());
            }
        } else {
            log.info("saveFollowRecord,\u4fee\u6539\u7684\u524d\u540e\u4fe1\u606f\u76f8\u540c");
        }
    }

    private void saveNotice(FollowReqDto reqDto) {
        FollowInfo followInfo = reqDto.getFollowInfo();
        if (followInfo.getAppointmentTime() == null || StringUtils.isBlank((CharSequence)reqDto.getCustomerNum())) {
            return;
        }
        Date appointmentTime = followInfo.getAppointmentTime();
        AddNoticeReq addNoticeReq = new AddNoticeReq();
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        addNoticeReq.setNoticeTime(appointmentTime);
        addNoticeReq.setBizId(currentUserInfo.getBizId());
        addNoticeReq.setType(Integer.valueOf(NoticeType.CRM_APPOINTMENT.getType()));
        addNoticeReq.setReceiveUserId(LoginUtils.getCurrentUserId());
        addNoticeReq.setCustomerNum(reqDto.getCustomerNum());
        NoticeExtendParam noticeExtendParam = new NoticeExtendParam();
        noticeExtendParam.setContactId(reqDto.getContactId());
        addNoticeReq.setNoticeExtendParam(noticeExtendParam);
        this.noticeService.addNotice(addNoticeReq);
    }

    private void saveLastFollow(FollowRecord followRecord) {
        WeworkUserLastFollow lastFollow = new WeworkUserLastFollow();
        lastFollow.setBizId(followRecord.getBizId());
        lastFollow.setCorpId(followRecord.getCorpId());
        lastFollow.setWeworkUserNum(followRecord.getWeworkUserNum());
        lastFollow.setContactId(followRecord.getWeworkContactId());
        lastFollow.setType(followRecord.getType());
        lastFollow.setLastFollowTime(followRecord.getCreateTime());
        lastFollow.setFollowRecordId(followRecord.getId());
        lastFollow.setCreateBy(followRecord.getCreateBy());
        lastFollow.setCreateTime(new Date());
        this.weworkUserLastFollowMapper.save(lastFollow);
    }

    private String buildEditContactInfoContent(CustomerBaseInfo customerBaseInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        String oldRemarkName = customerBaseInfo.getOldRemarkName();
        String newRemarkName = customerBaseInfo.getNewRemarkName();
        this.appendContent("\u3010\u5ba2\u6237\u540d\u79f0\u3011:", stringBuilder, oldRemarkName, newRemarkName);
        String oldRegionId = customerBaseInfo.getOldRegion();
        String newRegionId = customerBaseInfo.getNewRegion();
        String oldRg = this.areaService.getFullName(oldRegionId);
        String newRg = this.areaService.getFullName(newRegionId);
        this.appendContent("\u3010\u5730\u533a\u3011:", stringBuilder, oldRg, newRg);
        Set<String> oldRemarkMobiles = customerBaseInfo.getOldRemarkMobiles();
        Set<String> newRemarkMobiles = customerBaseInfo.getNewRemarkMobiles();
        String oldMobile = null;
        String newMobile = null;
        if (CollectionUtils.isNotEmpty(oldRemarkMobiles)) {
            oldMobile = StringUtils.join((Object[])oldRemarkMobiles.toArray(), (String)ARRAY_SEPARATOR);
        }
        if (CollectionUtils.isNotEmpty(newRemarkMobiles)) {
            newMobile = StringUtils.join((Object[])newRemarkMobiles.toArray(), (String)ARRAY_SEPARATOR);
        }
        this.appendContent("\u3010\u624b\u673a\u53f7\u3011:", stringBuilder, oldMobile, newMobile);
        String oldDescription = customerBaseInfo.getOldDescription();
        String newDescription = customerBaseInfo.getNewDescription();
        this.appendContent("\u3010\u63cf\u8ff0\u3011:", stringBuilder, oldDescription, newDescription);
        String oldGender = this.getGenderInfo(customerBaseInfo.getOldGender());
        String newGender = this.getGenderInfo(customerBaseInfo.getNewGender());
        this.appendContent("\u3010\u6027\u522b\u3011:", stringBuilder, oldGender, newGender);
        return stringBuilder.toString();
    }

    private String getGenderInfo(Integer gender) {
        if (gender == null) {
            return "\u672a\u77e5";
        }
        String genderInfo = "";
        genderInfo = gender == 1 ? "\u7537" : (gender == 2 ? "\u5973" : "\u672a\u77e5");
        return genderInfo;
    }

    private String buildUpdateStageInfoContent(CustomerStageInfo customerStageInfo) {
        String reason;
        CustomerStage customerStage;
        Long oldStageId = customerStageInfo.getOldStageId();
        Long newStageId = customerStageInfo.getNewStageId();
        Long oldStageReasonId = customerStageInfo.getOldStageReasonId();
        Long newStageReasonId = customerStageInfo.getNewStageReasonId();
        String oldRemark = customerStageInfo.getOldRemark();
        String newRemark = customerStageInfo.getNewRemark();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSame(oldStageId, newStageId) && this.isSame(oldStageReasonId, newStageReasonId) && this.isSame(oldRemark, newRemark)) {
            return stringBuilder.toString();
        }
        HashSet stageIds = Sets.newHashSet();
        if (Objects.nonNull(oldStageId)) {
            stageIds.add(oldStageId);
        }
        if (Objects.nonNull(newStageId)) {
            stageIds.add(newStageId);
        }
        List customerStages = this.customerStageMapper.selectByIds((Collection)stageIds);
        Map id2StageMap = null;
        if (CollectionUtils.isNotEmpty((Collection)customerStages)) {
            id2StageMap = customerStages.stream().collect(Collectors.toMap(CustomerStage::getId, Function.identity()));
        }
        HashSet stageReasonIds = Sets.newHashSet();
        if (Objects.nonNull(oldStageReasonId)) {
            stageReasonIds.add(oldStageReasonId);
        }
        if (Objects.nonNull(newStageReasonId)) {
            stageReasonIds.add(newStageReasonId);
        }
        List customerStageReasons = this.customerStageReasonMapper.selectByIds((Collection)stageReasonIds);
        Map reasonId2StageReasonMap = null;
        if (CollectionUtils.isNotEmpty((Collection)customerStageReasons)) {
            reasonId2StageReasonMap = customerStageReasons.stream().collect(Collectors.toMap(CustomerStageReason::getId, Functions.identity()));
        }
        StringBuilder oldStageVal = new StringBuilder();
        StringBuilder newStageVal = new StringBuilder();
        if (Objects.nonNull(oldStageId) && id2StageMap != null) {
            customerStage = (CustomerStage)id2StageMap.get(oldStageId);
            if (customerStage.getType() == 1) {
                oldStageVal.append(customerStage.getStageValue());
            } else {
                oldStageVal.append(customerStage.getStageName());
                if (Objects.nonNull(oldStageReasonId) && reasonId2StageReasonMap != null && reasonId2StageReasonMap.get(oldStageReasonId) != null) {
                    reason = ((CustomerStageReason)reasonId2StageReasonMap.get(oldStageReasonId)).getReason();
                    oldStageVal.append('\uff08').append(reason);
                }
                if (StringUtils.isNotBlank((CharSequence)oldRemark)) {
                    oldStageVal.append("\uff0c\u5907\u6ce8\uff1a").append(oldRemark);
                }
                if (Objects.nonNull(oldStageReasonId)) {
                    oldStageVal.append('\uff09');
                }
            }
        }
        if (Objects.nonNull(newStageId) && id2StageMap != null) {
            customerStage = (CustomerStage)id2StageMap.get(newStageId);
            if (customerStage.getType() == 1) {
                newStageVal.append(customerStage.getStageValue());
            } else {
                newStageVal.append(customerStage.getStageName());
                if (Objects.nonNull(newStageReasonId) && reasonId2StageReasonMap != null && reasonId2StageReasonMap.get(newStageReasonId) != null) {
                    reason = ((CustomerStageReason)reasonId2StageReasonMap.get(newStageReasonId)).getReason();
                    newStageVal.append('\uff08').append(reason);
                }
                if (StringUtils.isNotBlank((CharSequence)newRemark)) {
                    newStageVal.append("\uff0c\u5907\u6ce8\uff1a").append(newRemark);
                }
                if (Objects.nonNull(newStageReasonId)) {
                    newStageVal.append('\uff09');
                }
            }
        }
        this.appendContent("\u3010\u5ba2\u6237\u9636\u6bb5\u3011:", stringBuilder, oldStageVal.toString(), newStageVal.toString());
        return stringBuilder.toString();
    }

    private String buildFollowInfoContent(FollowInfo followInfo) {
        CustomerTagInfo customerTagInfo;
        String tag;
        StringBuilder stringBuilder = new StringBuilder();
        CustomerStageInfo customerStageInfo = followInfo.convert2StageInfo();
        String stage = this.buildUpdateStageInfoContent(customerStageInfo);
        if (StringUtils.isNotBlank((CharSequence)stage)) {
            stringBuilder.append(stage);
        }
        if (StringUtils.isNotBlank((CharSequence)(tag = this.buildEditContactTagContent(customerTagInfo = followInfo.convert2TagInfo())))) {
            stringBuilder.append(tag);
        }
        if (StringUtils.isNotBlank((CharSequence)followInfo.getRemark())) {
            stringBuilder.append("\u3010\u8ddf\u8fdb\u8bb0\u5f55\u3011: ").append(followInfo.getRemark()).append(CHANGE_ROW);
        }
        return stringBuilder.toString();
    }

    private String buildEditContactTagContent(CustomerTagInfo customerTagInfo) {
        List<CorpTagDto> oldTags = customerTagInfo.getOldTags();
        List<CorpTagDto> newTags = customerTagInfo.getNewTags();
        String oldTagNames = null;
        String newTagNames = null;
        if (CollectionUtils.isNotEmpty(oldTags)) {
            oldTagNames = StringUtils.join((Object[])oldTags.stream().map(CorpTagDto::getTagName).collect(Collectors.toList()).toArray(), (String)"/");
        }
        if (CollectionUtils.isNotEmpty(newTags)) {
            newTagNames = StringUtils.join((Object[])newTags.stream().map(CorpTagDto::getTagName).collect(Collectors.toList()).toArray(), (String)"/");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isSame(oldTags, newTags)) {
            this.appendContent("", stringBuilder, oldTagNames, newTagNames);
        }
        return stringBuilder.toString();
    }

    private String buildTransferContactContent(AllocateInfo allocateInfo, String corpId) {
        String handoverUserNum = allocateInfo.getHandoverUserId();
        String handoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(handoverUserNum);
        String takeoverUserNum = allocateInfo.getTakeoverUserId();
        String takeoverUserId = this.weworkUserMapper.queryWeworkUserIdByNum(takeoverUserNum);
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMap(corpId, (Collection)Sets.newHashSet((Object[])new String[]{handoverUserId, takeoverUserId}));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u7531\u300c");
        String handoverUserName = (String)weworkUserNameMap.get(handoverUserId);
        String takeoverUserName = (String)weworkUserNameMap.get(takeoverUserId);
        stringBuilder.append(handoverUserName).append("\u300d\u8f6c\u4ea4\u7ed9\u300c").append(takeoverUserName).append('\u300d');
        return stringBuilder.toString();
    }

    private boolean isSame(Object oldValue, Object newValue) {
        if (Objects.isNull(oldValue) && Objects.isNull(newValue)) {
            return true;
        }
        if (Objects.nonNull(oldValue)) {
            return oldValue.equals(newValue);
        }
        return false;
    }

    private FollowRecord buildFollowRecord(FollowReqDto reqDto, String content) {
        FollowRecord followRecord = new FollowRecord();
        followRecord.setBizId(reqDto.getBizId());
        followRecord.setCorpId(reqDto.getCorpId());
        followRecord.setWeworkUserNum(reqDto.getWeworkUserNum());
        followRecord.setWeworkContactId(reqDto.getContactId());
        followRecord.setType(reqDto.getType());
        followRecord.setContent(content);
        followRecord.setCreateBy(reqDto.getOperatorId());
        followRecord.setCreateTime(new Date());
        followRecord.setParams(JsonUtil.toStr((Object)reqDto));
        return followRecord;
    }

    private void appendContent(String head, StringBuilder sb, String oldVal, String newVal) {
        if (!this.isSame(oldVal, newVal) && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{oldVal, newVal})) {
            sb.append(head);
            if (StringUtils.isBlank((CharSequence)oldVal)) {
                sb.append("\u65b0\u589e\"").append(newVal).append('\"');
            } else if (StringUtils.isBlank((CharSequence)newVal)) {
                sb.append("\u5220\u9664\"").append(oldVal).append('\"');
            } else {
                sb.append(oldVal).append(MID_SEPARATOR).append(newVal);
            }
            sb.append(CHANGE_ROW);
        }
    }
}

