/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.contactanalyse.entity.WeworkRoomJoinQuitLog;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkRoomJoinQuitLogMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.RoomLogService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoomLogServiceImpl
implements RoomLogService {
    private static final Logger log = LoggerFactory.getLogger(RoomLogServiceImpl.class);
    @Resource
    private WeworkChatRoomRelationMapper weworkChatRoomRelationMapper;
    @Resource
    private WeworkRoomJoinQuitLogMapper weworkRoomJoinQuitLogMapper;
    @Resource
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkUserService weworkUserService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    @Resource
    private WeworkContactMapper weworkContactMapper;

    @Override
    @Transactional
    public void onUpdateExternalChat(UpdateExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long bizId = ctx.getBizId();
        if (bizId == null) {
            log.warn("handRoomChange bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        try {
            String updateDetail = event.getUpdateDetail();
            if ("add_member".equals(updateDetail)) {
                this.handleJoinRoom(event);
            } else if ("del_member".equals(updateDetail)) {
                this.handleQuitRoom(event);
            }
        }
        catch (Exception e) {
            log.error("handRoomChange error: {}", (Object)event, (Object)e);
            throw e;
        }
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        log.info("handleCreateRoom params: {}", (Object)event);
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        Long bizId = ctx.getBizId();
        if (bizId == null) {
            log.warn("handleCreateRoom bizId is null, corpId: {}", (Object)corpId);
            return;
        }
        try {
            String chatId = event.getChatId();
            Map chatNumMap = this.weworkChatRoomRelationMapper.getRoomIdAndMemberCountByCorpIdAndRoomIds(corpId, (Collection)Lists.newArrayList((Object[])new String[]{chatId}));
            int memNum = chatNumMap.getOrDefault(chatId, 0);
            WeworkChatRoom weworkChatRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, chatId);
            String weworkUserNum = this.weworkUserService.getWeworkUserNumById(corpId, weworkChatRoom.getOwner());
            log.info("handleCreateRoom weworkUserNum: {}, ownerId: {}, memNum: {}", new Object[]{weworkUserNum, weworkChatRoom.getOwner(), memNum});
            if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
                log.warn("weworkUserNum is empty, \u5546\u6237\u5df2\u8fc7\u671f\uff0c\u4e0d\u7ee7\u7eed\u4ea7\u751f\u8fdb\u7fa4\u65e5\u5fd7\u3002bizId={}, corpId={}", (Object)bizId, (Object)corpId);
                return;
            }
            WeworkRoomJoinQuitLog weworkRoomJoinQuitLog = new WeworkRoomJoinQuitLog();
            weworkRoomJoinQuitLog.setBizId(bizId);
            weworkRoomJoinQuitLog.setCorpId(corpId);
            weworkRoomJoinQuitLog.setNum(this.idGen.getNum());
            weworkRoomJoinQuitLog.setCreateTime(new Date());
            weworkRoomJoinQuitLog.setMemChangeNum(Integer.valueOf(memNum));
            weworkRoomJoinQuitLog.setWeworkRoomId(chatId);
            weworkRoomJoinQuitLog.setOwnerId(weworkUserNum);
            weworkRoomJoinQuitLog.setJoinTime(ctx.getTimestamp());
            weworkRoomJoinQuitLog.setJoinScene(Integer.valueOf(1));
            weworkRoomJoinQuitLog.setIsDeleted(Integer.valueOf(0));
            this.weworkRoomJoinQuitLogMapper.insertSelective((Object)weworkRoomJoinQuitLog);
        }
        catch (Exception e) {
            log.error("handleCreateRoom error: {}", (Object)event, (Object)e);
            throw e;
        }
    }

    private void handleJoinRoom(UpdateExternalChat changeDto) {
        WeworkRoomJoinQuitLog weworkRoomJoinQuitLog = this.build(changeDto);
        weworkRoomJoinQuitLog.setJoinScene(changeDto.getJoinScene());
        weworkRoomJoinQuitLog.setJoinTime(new Date(changeDto.getCreateTime() * 1000L));
        weworkRoomJoinQuitLog.setIsDeleted(Integer.valueOf(0));
        this.weworkRoomJoinQuitLogMapper.insertSelective((Object)weworkRoomJoinQuitLog);
        ReplyContext ctx = ReplyContextUtil.get();
        Set existMemberIds = ctx.getExistMemberIds();
        Set newMemberIds = ctx.getNewMemberIds();
        Collection joinMemberIds = CollectionUtils.subtract((Iterable)newMemberIds, (Iterable)existMemberIds);
        ArrayList eventReqList = Lists.newArrayList();
        for (String memberId : joinMemberIds) {
            WeworkContact contact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), memberId);
            if (contact == null || StringUtils.isBlank((CharSequence)contact.getCustomerNum())) continue;
            CustomerEventReq eventReq = new CustomerEventReq();
            eventReq.setEventType(EventType.JOIN_ROOM.getCode());
            eventReq.setSource("scrm");
            eventReq.setEventTime(new Date());
            eventReq.setBizId(contact.getBizId());
            eventReq.setCustomerNum(contact.getCustomerNum());
            EventData eventData = new EventData();
            eventReq.setEventData(eventData);
            eventData.setWeworkRoomId(weworkRoomJoinQuitLog.getWeworkRoomId());
            eventData.setMemberId(memberId);
            eventData.setJoinTime(weworkRoomJoinQuitLog.getJoinTime());
            eventData.setJoinScene(weworkRoomJoinQuitLog.getJoinScene());
            eventData.setOwnerId(weworkRoomJoinQuitLog.getOwnerId());
            eventReqList.add(eventReq);
        }
        if (CollectionUtils.isEmpty((Collection)eventReqList)) {
            log.info("join room members is null");
            return;
        }
        try {
            this.ccCustomerEventService.addBatch(ctx.getBizId(), "scrm", (List)eventReqList);
        }
        catch (Exception e) {
            log.error("save join room event error: ", (Throwable)e);
        }
    }

    private void handleQuitRoom(UpdateExternalChat changeDto) {
        WeworkRoomJoinQuitLog weworkRoomJoinQuitLog = this.build(changeDto);
        weworkRoomJoinQuitLog.setQuitScene(changeDto.getQuitScene());
        weworkRoomJoinQuitLog.setQuitTime(new Date(changeDto.getCreateTime() * 1000L));
        weworkRoomJoinQuitLog.setIsDeleted(Integer.valueOf(1));
        this.weworkRoomJoinQuitLogMapper.insertSelective((Object)weworkRoomJoinQuitLog);
        ReplyContext ctx = ReplyContextUtil.get();
        Set existMemberIds = ctx.getExistMemberIds();
        Set newMemberIds = ctx.getNewMemberIds();
        Collection quitMemberIds = CollectionUtils.subtract((Iterable)existMemberIds, (Iterable)newMemberIds);
        ArrayList eventReqList = Lists.newArrayList();
        for (String memberId : quitMemberIds) {
            WeworkContact contact = this.weworkContactMapper.queryWeworkContact(ctx.getBizId(), ctx.getCorpId(), memberId);
            if (contact == null || StringUtils.isBlank((CharSequence)contact.getCustomerNum())) continue;
            CustomerEventReq eventReq = new CustomerEventReq();
            eventReq.setEventType(EventType.QUIT_ROOM.getCode());
            eventReq.setSource("scrm");
            eventReq.setEventTime(new Date());
            eventReq.setBizId(contact.getBizId());
            eventReq.setCustomerNum(contact.getCustomerNum());
            EventData eventData = new EventData();
            eventReq.setEventData(eventData);
            eventData.setWeworkRoomId(weworkRoomJoinQuitLog.getWeworkRoomId());
            eventData.setMemberId(memberId);
            eventData.setQuitTime(weworkRoomJoinQuitLog.getQuitTime());
            eventData.setQuitScene(weworkRoomJoinQuitLog.getQuitScene());
            eventData.setOwnerId(weworkRoomJoinQuitLog.getOwnerId());
            eventReqList.add(eventReq);
        }
        if (CollectionUtils.isEmpty((Collection)eventReqList)) {
            log.info("quit room members is null");
            return;
        }
        try {
            this.ccCustomerEventService.addBatch(ctx.getBizId(), "scrm", (List)eventReqList);
        }
        catch (Exception e) {
            log.error("save quit room event error: ", (Throwable)e);
        }
    }

    private WeworkRoomJoinQuitLog build(UpdateExternalChat params) {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        WeworkRoomJoinQuitLog weworkRoomJoinQuitLog = new WeworkRoomJoinQuitLog();
        weworkRoomJoinQuitLog.setBizId(bizId);
        weworkRoomJoinQuitLog.setCorpId(corpId);
        weworkRoomJoinQuitLog.setNum(this.idGen.getNum());
        weworkRoomJoinQuitLog.setCreateTime(new Date());
        weworkRoomJoinQuitLog.setMemChangeNum(params.getMemChangeCnt());
        weworkRoomJoinQuitLog.setWeworkRoomId(params.getChatId());
        String ownerId = this.weworkChatRoomRelationMapper.queryRoomOwner(corpId, params.getChatId());
        String weworkUserNum = this.weworkUserService.getWeworkUserNumById(corpId, ownerId);
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("wework room ownerId is empty, corpId: {}, chatRoomId: {}", (Object)corpId, (Object)params.getChatId());
        }
        weworkRoomJoinQuitLog.setOwnerId(weworkUserNum);
        return weworkRoomJoinQuitLog;
    }
}

