/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.wework.sdk.api.external.TransferClient;
import cn.kinyun.wework.sdk.callback.corp.contact.DeleteUser;
import cn.kinyun.wework.sdk.entity.external.transfer.UnassignedCustomer;
import cn.kinyun.wework.sdk.entity.external.transfer.UnassignedListResp;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUser;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserCustomer;
import com.kuaike.scrm.dal.transfer.entity.DimissionWeworkUserRoom;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserCustomerMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserMapper;
import com.kuaike.scrm.dal.transfer.mapper.DimissionWeworkUserRoomMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.DismissUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DismissUserServiceImpl
implements DismissUserService {
    private static final Logger log = LoggerFactory.getLogger(DismissUserServiceImpl.class);
    @Autowired
    private DimissionWeworkUserMapper dimissionWeworkUserMapper;
    @Autowired
    private TransferClient transferClient;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private DimissionWeworkUserCustomerMapper dimissionWeworkUserCustomerMapper;
    @Autowired
    private DimissionWeworkUserRoomMapper dimissionWeworkUserRoomMapper;

    @Override
    public void onDeleteUser(DeleteUser event) {
        log.info("begin handle del user, delUserDto:{}", (Object)event);
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserId = ctx.getWeworkUserId();
        String weworkUserNum = ctx.getWeworkUserNum();
        if (Objects.isNull(bizId)) {
            log.info("\u6839\u636ecorpId:{}\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f", (Object)corpId);
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("\u6839\u636ecorpId:{}, weworkUserId:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)corpId, (Object)weworkUserId);
            return;
        }
        DimissionWeworkUser dimissionWeworkUser = this.dimissionWeworkUserMapper.selectByCorpIdAndWeworkUserNum(corpId, weworkUserNum);
        if (Objects.nonNull(dimissionWeworkUser)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserId:{}\u67e5\u8be2\u5230\u8bb0\u5f55,\u66f4\u65b0\u62c9\u53d6\u72b6\u6001\u4e3a\u672a\u62c9\u53d6", (Object)corpId, (Object)weworkUserId);
            this.dimissionWeworkUserMapper.updateIsPulledById(NumberUtils.INTEGER_ZERO, dimissionWeworkUser.getId());
            return;
        }
        Date curDate = new Date();
        dimissionWeworkUser = new DimissionWeworkUser();
        dimissionWeworkUser.setBizId(bizId);
        dimissionWeworkUser.setCorpId(corpId);
        if (Objects.nonNull(event.getCreateTime())) {
            dimissionWeworkUser.setDimissionTime(new Date(event.getCreateTime() * 1000L));
        } else {
            dimissionWeworkUser.setDimissionTime(curDate);
        }
        dimissionWeworkUser.setWaitAllocateCustomerCount(NumberUtils.INTEGER_ZERO);
        dimissionWeworkUser.setWaitAllocateRoomCount(NumberUtils.INTEGER_ZERO);
        dimissionWeworkUser.setCreateBy(NumberUtils.LONG_MINUS_ONE);
        dimissionWeworkUser.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
        dimissionWeworkUser.setIsDeleted(NumberUtils.INTEGER_ZERO);
        dimissionWeworkUser.setCreateTime(curDate);
        dimissionWeworkUser.setUpdateTime(curDate);
        dimissionWeworkUser.setAllocatedCustomerCount(NumberUtils.INTEGER_ZERO);
        dimissionWeworkUser.setAllocatedRoomCount(NumberUtils.INTEGER_ZERO);
        dimissionWeworkUser.setWeworkUserNum(weworkUserNum);
        dimissionWeworkUser.setIsPulled(NumberUtils.INTEGER_ZERO);
        this.dimissionWeworkUserMapper.batchInsert(Collections.singletonList(dimissionWeworkUser));
    }

    @Override
    public void pullDimissionCustomerAndRoom() {
        DateTime dimissionTime = DateUtil.offsetMinute((Date)new Date(), (int)-10);
        List dimissionWeworkUsers = this.dimissionWeworkUserMapper.queryByIsPulledAndDimissionTime(NumberUtils.INTEGER_ZERO, (Date)dimissionTime);
        if (CollectionUtils.isEmpty((Collection)dimissionWeworkUsers)) {
            log.info("\u6839\u636edimissionTime:{}\u672a\u67e5\u8be2\u5230\u9700\u8981\u62c9\u53d6\u5ba2\u6237\u548c\u7fa4\u7684\u79bb\u804c\u6210\u5458", (Object)dimissionWeworkUsers);
            return;
        }
        Map<String, List<DimissionWeworkUser>> corpId2DimissionWeworkUsersMap = dimissionWeworkUsers.stream().collect(Collectors.groupingBy(DimissionWeworkUser::getCorpId));
        for (Map.Entry<String, List<DimissionWeworkUser>> entry : corpId2DimissionWeworkUsersMap.entrySet()) {
            List<DimissionWeworkUserRoom> dimissionWeworkUserRooms;
            Date curDate = new Date();
            String corpId = entry.getKey();
            List<DimissionWeworkUser> corpDimissionWeworkUsers = entry.getValue();
            Long bizId = corpDimissionWeworkUsers.get(0).getBizId();
            Set<String> weworkUserIds = corpDimissionWeworkUsers.stream().map(DimissionWeworkUser::getWeworkUserId).collect(Collectors.toSet());
            Map<String, String> weworkUserId2NumMap = corpDimissionWeworkUsers.stream().collect(Collectors.toMap(DimissionWeworkUser::getWeworkUserId, DimissionWeworkUser::getWeworkUserNum));
            HashMap weworkUserId2CustomerIdsMap = Maps.newHashMap();
            this.getDimissionUserCustomers(corpId, weworkUserId2CustomerIdsMap);
            Map<String, Set<String>> weworkUserId2RoomIdsMap = this.getDimissionUserRooms(corpId, weworkUserIds);
            for (DimissionWeworkUser dimissionWeworkUser : corpDimissionWeworkUsers) {
                dimissionWeworkUser.setIsPulled(NumberUtils.INTEGER_ONE);
                dimissionWeworkUser.setUpdateTime(curDate);
                if (MapUtils.isNotEmpty((Map)weworkUserId2CustomerIdsMap) && weworkUserId2CustomerIdsMap.containsKey(dimissionWeworkUser.getWeworkUserId())) {
                    dimissionWeworkUser.setWaitAllocateCustomerCount(Integer.valueOf(((Set)weworkUserId2CustomerIdsMap.get(dimissionWeworkUser.getWeworkUserId())).size()));
                } else {
                    dimissionWeworkUser.setWaitAllocateCustomerCount(NumberUtils.INTEGER_ZERO);
                }
                if (MapUtils.isNotEmpty(weworkUserId2RoomIdsMap) && weworkUserId2RoomIdsMap.containsKey(dimissionWeworkUser.getWeworkUserId())) {
                    dimissionWeworkUser.setWaitAllocateRoomCount(Integer.valueOf(weworkUserId2RoomIdsMap.get(dimissionWeworkUser.getWeworkUserId()).size()));
                    continue;
                }
                dimissionWeworkUser.setWaitAllocateRoomCount(NumberUtils.INTEGER_ZERO);
            }
            this.dimissionWeworkUserMapper.updateWaitAllocCount(corpDimissionWeworkUsers);
            List<DimissionWeworkUserCustomer> dimissionWeworkUserCustomers = this.buildDimissionWeworkUserCustomers(bizId, corpId, weworkUserId2CustomerIdsMap, weworkUserId2NumMap, curDate);
            if (CollectionUtils.isNotEmpty(dimissionWeworkUserCustomers)) {
                Lists.partition(dimissionWeworkUserCustomers, (int)500).forEach(pagedUserCustomers -> this.dimissionWeworkUserCustomerMapper.batchInsert((Collection)pagedUserCustomers));
            }
            if (!CollectionUtils.isNotEmpty(dimissionWeworkUserRooms = this.buildDimissionWeworkUserRooms(bizId, corpId, weworkUserId2RoomIdsMap, weworkUserId2NumMap, curDate))) continue;
            Lists.partition(dimissionWeworkUserRooms, (int)500).forEach(pagedUserRooms -> this.dimissionWeworkUserRoomMapper.batchInsert((Collection)pagedUserRooms));
        }
    }

    private void getDimissionUserCustomers(String corpId, Map<String, Set<String>> weworkUserId2CustomerIdsMap) {
        boolean flag = true;
        String cursor = null;
        while (flag) {
            try {
                List unassignedCustomers;
                log.info("getUnassignedList,corpId:{}, cursor:{}", (Object)corpId, cursor);
                UnassignedListResp unassignedListResp = this.transferClient.getUnassignedList(corpId, null, null, cursor);
                log.info("unassignedListResp:{},", (Object)unassignedListResp);
                if (Objects.isNull(unassignedListResp) || !NumberUtils.INTEGER_ZERO.equals(unassignedListResp.getErrCode())) {
                    log.warn("\u6839\u636ecorpId:{},cursor:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)corpId, cursor);
                    break;
                }
                cursor = unassignedListResp.getNextCursor();
                if (StringUtils.isBlank((CharSequence)cursor)) {
                    flag = false;
                }
                if (!CollectionUtils.isNotEmpty((Collection)(unassignedCustomers = unassignedListResp.getInfo()))) continue;
                Map<String, List<UnassignedCustomer>> pagedUserId2CustomerIdsMap = unassignedCustomers.stream().collect(Collectors.groupingBy(UnassignedCustomer::getHandoverUserId));
                for (Map.Entry<String, List<UnassignedCustomer>> entry : pagedUserId2CustomerIdsMap.entrySet()) {
                    if (weworkUserId2CustomerIdsMap.containsKey(entry.getKey())) {
                        Set<String> customerIds = weworkUserId2CustomerIdsMap.get(entry.getKey());
                        customerIds.addAll(entry.getValue().stream().map(UnassignedCustomer::getExternalUserId).collect(Collectors.toSet()));
                        weworkUserId2CustomerIdsMap.put(entry.getKey(), customerIds);
                        continue;
                    }
                    weworkUserId2CustomerIdsMap.put(entry.getKey(), entry.getValue().stream().map(UnassignedCustomer::getExternalUserId).collect(Collectors.toSet()));
                }
            }
            catch (Exception ex) {
                flag = false;
                log.error("getUnassignedList,\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    private Map<String, Set<String>> getDimissionUserRooms(String corpId, Set<String> weworkUserIds) {
        List chatRooms = this.weworkChatRoomMapper.selectByCorpIdAndOwner(corpId, weworkUserIds);
        if (CollectionUtils.isEmpty((Collection)chatRooms)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserIds:{}\u672a\u83b7\u53d6\u5230\u7fa4\u4fe1\u606f", (Object)corpId, weworkUserIds);
            return Maps.newHashMap();
        }
        return chatRooms.stream().collect(Collectors.groupingBy(WeworkChatRoom::getOwner, Collectors.mapping(WeworkChatRoom::getWeworkRoomId, Collectors.toSet())));
    }

    private List<DimissionWeworkUserCustomer> buildDimissionWeworkUserCustomers(Long bizId, String corpId, Map<String, Set<String>> weworkUserId2CustomerIdsMap, Map<String, String> weworkUserId2NumMap, Date curDate) {
        if (MapUtils.isEmpty(weworkUserId2CustomerIdsMap)) {
            return Collections.emptyList();
        }
        ArrayList userCustomers = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : weworkUserId2CustomerIdsMap.entrySet()) {
            String weworkUserId = entry.getKey();
            if (!weworkUserId2NumMap.containsKey(weworkUserId)) {
                log.warn("\u6210\u5458weworkUserId:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)weworkUserId);
                continue;
            }
            Set<String> customerIds = entry.getValue();
            for (String customerId : customerIds) {
                DimissionWeworkUserCustomer dimissionWeworkUserCustomer = new DimissionWeworkUserCustomer();
                userCustomers.add(dimissionWeworkUserCustomer);
                dimissionWeworkUserCustomer.setBizId(bizId);
                dimissionWeworkUserCustomer.setCorpId(corpId);
                dimissionWeworkUserCustomer.setWeworkUserNum(weworkUserId2NumMap.get(weworkUserId));
                dimissionWeworkUserCustomer.setWeworkContactId(customerId);
                dimissionWeworkUserCustomer.setCreateTime(curDate);
                dimissionWeworkUserCustomer.setUpdateTime(curDate);
            }
        }
        return userCustomers;
    }

    private List<DimissionWeworkUserRoom> buildDimissionWeworkUserRooms(Long bizId, String corpId, Map<String, Set<String>> weworkUserId2RoomIdsMap, Map<String, String> weworkUserId2NumMap, Date curDate) {
        if (MapUtils.isEmpty(weworkUserId2RoomIdsMap)) {
            return Collections.emptyList();
        }
        ArrayList userRooms = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : weworkUserId2RoomIdsMap.entrySet()) {
            String weworkUserId = entry.getKey();
            if (!weworkUserId2NumMap.containsKey(weworkUserId)) {
                log.warn("\u6210\u5458weworkUserId:{}\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (Object)weworkUserId);
                continue;
            }
            Set<String> roomIds = entry.getValue();
            for (String roomId : roomIds) {
                DimissionWeworkUserRoom dimissionWeworkUserRoom = new DimissionWeworkUserRoom();
                userRooms.add(dimissionWeworkUserRoom);
                dimissionWeworkUserRoom.setBizId(bizId);
                dimissionWeworkUserRoom.setCorpId(corpId);
                dimissionWeworkUserRoom.setWeworkUserNum(weworkUserId2NumMap.get(weworkUserId));
                dimissionWeworkUserRoom.setWeworkRoomId(roomId);
                dimissionWeworkUserRoom.setCreateTime(curDate);
                dimissionWeworkUserRoom.setUpdateTime(curDate);
            }
        }
        return userRooms;
    }
}

