/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.handler;

import cn.kinyun.wework.sdk.callback.corp.contact.DeleteUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.DismissUserService;
import com.kuaike.scrm.event.utils.MsgLock;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserEventHandler {
    private static final Logger log = LoggerFactory.getLogger(UserEventHandler.class);
    @Autowired
    private MsgLock msgLock;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private DismissUserService dismissUserService;

    public void onDeleteUser(DeleteUser event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 600L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.dismissUserService.onDeleteUser(event);
    }
}

