/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.service.DelContactCallbackService;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DelContactCallbackServiceImpl
implements DelContactCallbackService {
    private static final Logger log = LoggerFactory.getLogger(DelContactCallbackServiceImpl.class);
    @Resource
    private AppletMarketingMaterialUserInfoMapper appletMarketingMaterialUserInfoMapper;
    @Resource
    private AppletContactInfoMapper appletContactInfoMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void callbackEventToMarketingMaterialApplet(Long bizId, Date deletedTime, String contactId, String weworkUserId) {
        log.info("delContactCallbackEventToMarketingMaterialApplet bizId:{} deletedTime:{} contactId:{} weworkUserId:{}", new Object[]{bizId, deletedTime, contactId, weworkUserId});
        if (bizId == null) {
            return;
        }
        if (deletedTime == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)contactId)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            return;
        }
        AppletContactInfo select = new AppletContactInfo();
        select.setBizId(bizId);
        select.setContactId(contactId);
        List appletContactInfos = this.appletContactInfoMapper.select((Object)select);
        if (CollectionUtils.isEmpty((Collection)appletContactInfos)) {
            return;
        }
        WeworkUser selectWeworkUser = new WeworkUser();
        selectWeworkUser.setBizId(bizId);
        selectWeworkUser.setIsDeleted(Integer.valueOf(0));
        selectWeworkUser.setWeworkUserId(weworkUserId);
        WeworkUser weworkUser = (WeworkUser)this.weworkUserMapper.selectOne((Object)selectWeworkUser);
        if (weworkUser == null) {
            log.info("delContactCallbackEventToMarketingMaterialApplet bizId:{} deletedTime:{} contactId:{} weworkUserId:{}, weworkUser is null", new Object[]{bizId, deletedTime, contactId, weworkUserId});
            return;
        }
        HashSet<String> unionIds = new HashSet<String>();
        HashSet<String> openIds = new HashSet<String>();
        for (AppletContactInfo appletContactInfo : appletContactInfos) {
            log.info("delContactCallbackEventToMarketingMaterialApplet bizId:{} deletedTime:{} contactId:{} weworkUserId:{}, appletContactInfoId:{}", new Object[]{bizId, deletedTime, contactId, weworkUserId, appletContactInfo.getContactId()});
            if (StringUtils.isNotBlank((CharSequence)appletContactInfo.getUnionId())) {
                unionIds.add(appletContactInfo.getUnionId());
                continue;
            }
            openIds.add(appletContactInfo.getOpenId());
        }
        log.info("delContactCallbackEventToMarketingMaterialApplet bizId:{} deletedTime:{} contactId:{} weworkUserId:{}, unionIds:{}, openIds:{}, weworkUserNum:{}", new Object[]{bizId, deletedTime, contactId, weworkUserId, unionIds, openIds, weworkUser.getNum()});
        if (CollectionUtils.isNotEmpty(unionIds)) {
            int i = this.appletMarketingMaterialUserInfoMapper.updateToDelFriendByUnionIds(bizId, deletedTime, unionIds, weworkUser.getNum());
            log.info("delContactCallbackEventToMarketingMaterialApplet contactId:{} updateToDelFriendByUnionIds Count:{}", (Object)contactId, (Object)i);
        }
        if (CollectionUtils.isNotEmpty(openIds)) {
            int i = this.appletMarketingMaterialUserInfoMapper.updateToDelFriendByOpenIds(bizId, deletedTime, openIds, weworkUser.getNum());
            log.info("delContactCallbackEventToMarketingMaterialApplet contactId:{} updateToDelFriendByOpenIds Count:{}", (Object)contactId, (Object)i);
        }
    }
}

