/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.service.impl;

import cn.kinyun.ad.common.req.AddFriendSuccReq;
import cn.kinyun.ad.common.service.MSWeworkCardDetailService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialUserInfo;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.AddContactCallbackAdService;
import com.kuaike.scrm.material.service.MarketingMaterialService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddContactCallbackAdServiceImp
implements AddContactCallbackAdService {
    private static final Logger log = LoggerFactory.getLogger(AddContactCallbackAdServiceImp.class);
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired(required=false)
    private MSWeworkCardDetailService mSWeworkCardDetailService;
    @Resource
    private AppletMarketingMaterialUserInfoMapper appletMarketingMaterialUserInfoMapper;
    @Resource
    private AppletContactInfoMapper appletContactInfoMapper;
    @Resource
    private ContactOpService contactOpService;
    @Resource
    private AppletMarketingMaterialMapper appletMarketingMaterialMapper;
    @Resource
    private MarketingMaterialService marketingMaterialService;

    @Override
    public void callbackEventToAd() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String weworkUserNum = ctx.getWeworkUserNum();
        String contactId = ctx.getContactId();
        if (!ctx.isAdQrcode()) {
            return;
        }
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        if (weworkContact == null) {
            log.info("callbackEventToAd contact is null");
            return;
        }
        Integer gender = weworkContact.getGender();
        String nickName = weworkContact.getName();
        Map nameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, (Collection)Lists.newArrayList((Object[])new String[]{weworkUserNum}));
        String weworkUserName = (String)nameMap.get(weworkUserNum);
        AddFriendSuccReq req = new AddFriendSuccReq();
        req.setCorpId(corpId);
        req.setContactId(contactId);
        req.setAvatar(weworkContact.getAvatar());
        req.setGender(gender);
        req.setNickName(nickName);
        req.setState(ctx.getState());
        req.setUnionId(weworkContact.getUnionid());
        req.setWeworkUserName(weworkUserName);
        req.setWeworkUserNum(weworkUserNum);
        log.info("addFriendCallback params: {}", (Object)req);
        this.mSWeworkCardDetailService.addFriendCallback(req);
    }

    @Override
    public void callbackEventToMarketingMaterialApplet() {
        List userInfos;
        int count;
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String contactId = ctx.getContactId();
        if (!ctx.isAdQrcode()) {
            return;
        }
        log.info("addContactCallbackEventToMarketingMaterialApplet ReplyContext:{}", (Object)ctx);
        String state = ctx.getState();
        if (StringUtils.isBlank((CharSequence)state)) {
            return;
        }
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        if (weworkContact == null) {
            log.info("addContactCallbackEventToMarketingMaterialApplet contact is null");
            return;
        }
        String unionId = weworkContact.getUnionid();
        log.info("addContactCallbackEventToMarketingMaterialApplet contactId:{}, select unionId form weworkContact, unionId:{}", (Object)contactId, (Object)unionId);
        boolean canUseUnionIdConnect = StringUtils.isNotBlank((CharSequence)unionId);
        AppletMarketingMaterialUserInfo select = new AppletMarketingMaterialUserInfo();
        select.setQrcodeState(state);
        select.setIsAddFriend(Integer.valueOf(0));
        select.setIsDeleted(Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            select.setUnionId(unionId);
        }
        if ((count = this.appletMarketingMaterialUserInfoMapper.selectCount((Object)select)) == 0) {
            if (StringUtils.isBlank((CharSequence)unionId)) {
                log.info("addContactCallbackEventToMarketingMaterialApplet count:{} contactId:{} \u4e0d\u662f\u901a\u8fc7\u8425\u9500\u8d44\u6599\u5c0f\u7a0b\u5e8f\u52a0\u7684\u597d\u53cb", (Object)count, (Object)contactId);
                return;
            }
            select.setUnionId(null);
            canUseUnionIdConnect = false;
        }
        if (CollectionUtils.isEmpty((Collection)(userInfos = this.appletMarketingMaterialUserInfoMapper.select((Object)select)))) {
            return;
        }
        log.info("addContactCallbackEventToMarketingMaterialApplet contactId:{} userInfosCount:{} unionId:{} canUseUnionIdConnect:{}", new Object[]{contactId, userInfos.size(), unionId, canUseUnionIdConnect});
        if (userInfos.size() == 1) {
            unionId = StringUtils.isBlank((CharSequence)unionId) ? ((AppletMarketingMaterialUserInfo)userInfos.get(0)).getUnionId() : unionId;
            canUseUnionIdConnect = canUseUnionIdConnect || StringUtils.isNotBlank((CharSequence)((AppletMarketingMaterialUserInfo)userInfos.get(0)).getUnionId());
            log.info("addContactCallbackEventToMarketingMaterialApplet contactId:{} first userInfoId:{}, unionId:{} canUseUnionIdConnect:{}", new Object[]{contactId, ((AppletMarketingMaterialUserInfo)userInfos.get(0)).getId(), ((AppletMarketingMaterialUserInfo)userInfos.get(0)).getUnionId(), canUseUnionIdConnect});
        }
        if (StringUtils.isNotBlank((CharSequence)unionId) && canUseUnionIdConnect) {
            int updateMaterialUserInfoCount = this.appletMarketingMaterialUserInfoMapper.updateToAddFriendByUnionId(unionId);
            int updateContactInfoCount = this.appletContactInfoMapper.updateByUnionId(unionId, contactId, weworkContact.getName(), weworkContact.getAvatar());
            log.info("addContactCallbackEventToMarketingMaterialApplet contactId:{}, update by unionId, updateMaterialUserInfoCount:{} updateContactInfoCount:{}", new Object[]{contactId, updateMaterialUserInfoCount, updateContactInfoCount});
            AppletContactInfo appletContactInfo = this.appletContactInfoMapper.queryContactInfoByUnionId(bizId, unionId);
            if (appletContactInfo != null && StringUtils.isNotBlank((CharSequence)appletContactInfo.getPhone()) && StringUtils.isNotBlank((CharSequence)appletContactInfo.getCustomerNum())) {
                this.marketingMaterialService.bindMobileAndContactId(bizId, appletContactInfo.getPhone(), contactId, appletContactInfo.getCustomerNum());
            }
        } else {
            AppletMarketingMaterialUserInfo appletMarketingMaterialUserInfo = (AppletMarketingMaterialUserInfo)userInfos.get(userInfos.size() - 1);
            int updateMaterialUserInfoCount = this.appletMarketingMaterialUserInfoMapper.updateToAddFriendByOpenId(appletMarketingMaterialUserInfo.getBizId(), appletMarketingMaterialUserInfo.getOpenId(), appletMarketingMaterialUserInfo.getMaterialNum());
            int updateContactInfoCount = this.appletContactInfoMapper.updateByOpenId(appletMarketingMaterialUserInfo.getBizId(), appletMarketingMaterialUserInfo.getOpenId(), contactId, weworkContact.getName(), weworkContact.getAvatar());
            log.info("addContactCallbackEventToMarketingMaterialApplet contactId:{}, update by no unionId, updateMaterialUserInfoCount:{} updateContactInfoCount:{}, appletMarketingMaterialUserInfoId:{}", new Object[]{contactId, updateMaterialUserInfoCount, updateContactInfoCount, appletMarketingMaterialUserInfo.getId()});
            AppletContactInfo appletContactInfo = this.appletContactInfoMapper.queryContactInfo(bizId, appletMarketingMaterialUserInfo.getOpenId());
            if (appletContactInfo != null && StringUtils.isNotBlank((CharSequence)appletContactInfo.getPhone()) && StringUtils.isNotBlank((CharSequence)appletContactInfo.getCustomerNum())) {
                this.marketingMaterialService.bindMobileAndContactId(bizId, appletContactInfo.getPhone(), contactId, appletContactInfo.getCustomerNum());
            }
        }
        try {
            this.addTag(ctx, bizId, contactId, weworkContact, userInfos);
        }
        catch (Exception e) {
            log.error("addContactCallbackEventToMarketingMaterialApplet addTag error", (Throwable)e);
        }
        try {
            this.marketingMaterialService.updateIntoGroupStatusByContactId(bizId, corpId, contactId);
        }
        catch (Exception e) {
            log.error("addContactCallbackEventToMarketingMaterialApplet updateIntoGroupStatusByContactId error", (Throwable)e);
        }
    }

    private void addTag(ReplyContext ctx, Long bizId, String contactId, WeworkContact weworkContact, List<AppletMarketingMaterialUserInfo> userInfos) {
        Set materialNums = userInfos.stream().map(AppletMarketingMaterialUserInfo::getMaterialNum).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(materialNums)) {
            return;
        }
        List tagIds = this.appletMarketingMaterialMapper.selectTagByNums(bizId, materialNums);
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            return;
        }
        ModifyTagDto modifyTagDto = new ModifyTagDto();
        modifyTagDto.setBizId(bizId);
        modifyTagDto.setCorpId(weworkContact.getCorpId());
        modifyTagDto.setContactId(contactId);
        modifyTagDto.setAddTagIds(tagIds);
        modifyTagDto.setWeworkUserId(ctx.getWeworkUserId());
        this.contactOpService.modifyTag(modifyTagDto);
        log.info("addContactCallbackEventToMarketingMaterialApplet addTag, modifyTagDto:{}", (Object)modifyTagDto);
    }
}

