/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.handler;

import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.DismissExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.RoomLogService;
import com.kuaike.scrm.event.service.VipIdTranslateService;
import com.kuaike.scrm.event.utils.MsgLock;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoomEventHandler {
    private static final Logger log = LoggerFactory.getLogger(RoomEventHandler.class);
    @Autowired
    private MsgLock msgLock;
    @Autowired
    private RoomLogService roomLogService;
    @Autowired
    private VipIdTranslateService vipIdTranslateService;

    public void onCreateExternalChat(CreateExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String chatId = event.getChatId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + chatId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        ctx.setMsgKey(msgKey);
        ctx.setChatId(chatId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.roomLogService.onCreateExternalChat(event);
        this.vipIdTranslateService.onCreateExternalChat(event);
    }

    public void onUpdateExternalChat(UpdateExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String chatId = event.getChatId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + chatId + ":" + event.getUpdateDetail() + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        ctx.setMsgKey(msgKey);
        ctx.setChatId(chatId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.roomLogService.onUpdateExternalChat(event);
        this.vipIdTranslateService.onUpdateExternalChat(event);
    }

    public void onDismissExternalChat(DismissExternalChat event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String chatId = event.getChatId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + chatId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        ctx.setMsgKey(msgKey);
        ctx.setChatId(chatId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
    }
}

