/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.event.handler;

import cn.kinyun.customer.center.dto.req.ModMobileReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.wework.sdk.callback.corp.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.TransferFail;
import com.alibaba.fastjson.JSONObject;
import com.kuaike.scrm.acquisition.service.WeworkAcquisitionService;
import com.kuaike.scrm.chat.service.QualityCheckEsService;
import com.kuaike.scrm.common.dto.WeworkAddFriendEvent;
import com.kuaike.scrm.common.dto.WeworkDelFriendEvent;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.addfriend.TelAddType;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionClickRecord;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionSharePlan;
import com.kuaike.scrm.dal.customeracquisition.entity.WeworkCustomerAcquisitionShareRecord;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionClickRecordMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionSharePlanMapper;
import com.kuaike.scrm.dal.customeracquisition.mapper.WeworkCustomerAcquisitionShareRecordMapper;
import com.kuaike.scrm.dal.marketing.entity.MarketingJoin;
import com.kuaike.scrm.dal.marketing.entity.MarketingPlan;
import com.kuaike.scrm.dal.marketing.entity.MarketingQrcode;
import com.kuaike.scrm.dal.marketing.mapper.MarketingJoinMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.marketing.mapper.MarketingQrcodeMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.vip.mapper.VipFriendSendRecordMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.event.context.ReplyContext;
import com.kuaike.scrm.event.context.ReplyContextUtil;
import com.kuaike.scrm.event.service.AddContactCallbackAdService;
import com.kuaike.scrm.event.service.AttachTagService;
import com.kuaike.scrm.event.service.FriendFissionService;
import com.kuaike.scrm.event.service.FriendLogService;
import com.kuaike.scrm.event.service.RemarkService;
import com.kuaike.scrm.event.service.VipIdTranslateService;
import com.kuaike.scrm.event.service.WelcomeService;
import com.kuaike.scrm.event.utils.MsgLock;
import com.kuaike.scrm.service.MeetingCustomerInfoService;
import com.kuaike.scrm.wework.contact.service.ContactCenterService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FriendEventHandler {
    private static final Logger log = LoggerFactory.getLogger(FriendEventHandler.class);
    @Autowired
    private MsgLock msgLock;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MarketingJoinMapper marketingJoinMapper;
    @Autowired
    private MarketingQrcodeMapper marketingQrcodeMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Resource
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private FriendLogService friendLogService;
    @Autowired
    private WelcomeService welcomeService;
    @Autowired
    private RemarkService remarkService;
    @Autowired
    private AttachTagService attachTagService;
    @Autowired
    private FriendFissionService friendFissionService;
    @Autowired
    private VipIdTranslateService vipIdTranslateService;
    @Autowired
    private QualityCheckEsService qualityCheckEsService;
    @Autowired
    private AddContactCallbackAdService addContactCallbackAdService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ContactCenterService contactCenterService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private UserMapper userMapper;
    @Autowired
    private VipFriendSendRecordMapper vipFriendSendRecordMapper;
    @Autowired
    private MeetingCustomerInfoService meetingCustomerInfoService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private WeworkCustomerAcquisitionSharePlanMapper weworkCustomerAcquisitionSharePlanMapper;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;
    @Resource
    private WeworkAcquisitionService weworkAcquisitionService;
    @Resource
    private WeworkCustomerAcquisitionClickRecordMapper weworkCustomerAcquisitionClickRecordMapper;
    @Resource
    private WeworkCustomerAcquisitionShareRecordMapper weworkCustomerAcquisitionShareRecordMapper;
    @Value(value="${kafka.topic.wework_add_friend_event}")
    private String weworkAddFriendEventTopic;
    @Value(value="${kafka.topic.wework_del_friend_event}")
    private String weworkDelFriendEventTopic;
    @Resource
    private KafkaClientUtils kafkaClientUtils;

    public void initMarketingPlan() {
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String corpId = ctx.getCorpId();
        String state = ctx.getState();
        if (!StringUtils.isBlank((CharSequence)state)) {
            MarketingQrcode marketingQrcode = new MarketingQrcode();
            marketingQrcode.setBizId(bizId);
            marketingQrcode.setCorpId(corpId);
            marketingQrcode.setState(ctx.getState());
            marketingQrcode = (MarketingQrcode)this.marketingQrcodeMapper.selectOne((Object)marketingQrcode);
            if (marketingQrcode != null) {
                ctx.setChannelId(marketingQrcode.getChannelId());
                ctx.setPlanId(marketingQrcode.getPlanId());
                ctx.setPlanGroupId(marketingQrcode.getPlanGroupId());
                ctx.setPlanActive(marketingQrcode.getIsDeleted() == 0);
            } else {
                MarketingJoin marketingJoin = this.marketingJoinMapper.queryByQrcodeState(corpId, state);
                if (marketingJoin != null) {
                    ctx.setChannelId(marketingJoin.getChannelId());
                    ctx.setPlanId(marketingJoin.getPlanId());
                    ctx.setPlanGroupId(Long.valueOf(-1L));
                    ctx.setPlanActive(true);
                    ctx.setPContactId(marketingJoin.getContactId());
                }
            }
            if (ctx.getPlanId() != null) {
                MarketingPlan marketingPlan = (MarketingPlan)this.marketingPlanMapper.selectByPrimaryKey((Object)ctx.getPlanId());
                if (marketingPlan != null) {
                    ctx.setPlanName(marketingPlan.getName());
                    ctx.setPlanNum(marketingPlan.getNum());
                    ctx.setPlanType(marketingPlan.getType());
                    ctx.setIsFissionDraft(marketingPlan.getIsDraft().intValue());
                    ctx.setIsFissionDeleted(marketingPlan.getIsDeleted().intValue());
                    ctx.setIsFissionEnabled(marketingPlan.getIsEnabled().intValue());
                    if (this.friendFissionService.isMarketingEndTime(marketingPlan) || this.friendFissionService.isMarketingNoReward()) {
                        if (marketingPlan.getStatus() == 1) {
                            marketingPlan.setStatus(Integer.valueOf(2));
                            marketingPlan.setUpdateTime(new Date());
                            this.marketingPlanMapper.updateByPrimaryKeySelective((Object)marketingPlan);
                        }
                        ctx.setPlanActive(false);
                        ctx.setFissionEnd(true);
                    }
                }
                if (marketingPlan == null || marketingPlan.getIsDraft() == 1 || marketingPlan.getIsDeleted() == 1 || marketingPlan.getIsEnabled() == 0 || marketingPlan.getStatus() == 2) {
                    ctx.setPlanActive(false);
                }
            }
        }
    }

    public void initAdQrcode() {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("initAdQrcode,ctx:{}", (Object)ctx);
        String state = ctx.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("AD_")) {
            ctx.setAdQrcode(true);
        }
    }

    public void initRadar() {
        ReplyContext ctx = ReplyContextUtil.get();
        String state = ctx.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith("RD_")) {
            ctx.setRadar(true);
        }
    }

    public void initWeworkCustomerAcquisition() {
        WeworkCustomerAcquisitionSharePlan sharePlan;
        ReplyContext ctx = ReplyContextUtil.get();
        String state = ctx.getState();
        if (StringUtils.isBlank((CharSequence)state)) {
            log.warn("init wework customer acquisition state is blank");
            return;
        }
        WeworkCustomerAcquisitionShareRecord shareRecord = null;
        if (state.startsWith("CA_")) {
            ctx.setWeworkCustomerAcquisition(true);
            String clickNum = state.replaceAll("CA_", "");
            WeworkCustomerAcquisitionClickRecord select = new WeworkCustomerAcquisitionClickRecord();
            select.setNum(clickNum);
            WeworkCustomerAcquisitionClickRecord acquisitionClickRecord = (WeworkCustomerAcquisitionClickRecord)this.weworkCustomerAcquisitionClickRecordMapper.selectOne((Object)select);
            if (acquisitionClickRecord == null) {
                log.warn("acquisitionClickRecord is null");
                return;
            }
            shareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectByPrimaryKey((Object)acquisitionClickRecord.getCustomerAcquisitionShareRecordId());
        } else if (state.startsWith("CS_")) {
            ctx.setWeworkCustomerAcquisition(true);
            String shareNum = state.replaceAll("CS_", "");
            WeworkCustomerAcquisitionShareRecord share = new WeworkCustomerAcquisitionShareRecord();
            share.setNum(shareNum);
            shareRecord = (WeworkCustomerAcquisitionShareRecord)this.weworkCustomerAcquisitionShareRecordMapper.selectOne((Object)share);
        }
        if (shareRecord != null && shareRecord.getFkId() != null && (sharePlan = (WeworkCustomerAcquisitionSharePlan)this.weworkCustomerAcquisitionSharePlanMapper.selectByPrimaryKey((Object)shareRecord.getCustomerAcquisitionSharePlanId())) != null) {
            ctx.setChannelId(sharePlan.getChannelId());
        }
    }

    public void initTelAddFriend() {
        String channelStr;
        String mobile;
        ReplyContext replyContext = ReplyContextUtil.get();
        String state = replyContext.getState();
        if (StringUtils.isNotEmpty((CharSequence)state)) {
            return;
        }
        String corpId = replyContext.getCorpId();
        Long bizId = replyContext.getBizId();
        String weworkUserNum = replyContext.getWeworkUserNum();
        String contactId = replyContext.getContactId();
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, contactId);
        String string = mobile = weworkContact == null ? null : weworkContact.getMobile();
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            log.warn("\u6839\u636ecorpId:{},contactId:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7", (Object)corpId, (Object)contactId);
            return;
        }
        List telAddFriendTaskDetails = this.telAddFriendTaskDetailMapper.selectByCorpIdWeworkUserNumAndTel(corpId, weworkUserNum, mobile);
        if (CollectionUtils.isEmpty((Collection)telAddFriendTaskDetails)) {
            log.info("\u6839\u636ecorpId:{}, weworkUserNum:{}, tel:{}\u672a\u67e5\u8be2\u5230\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1", new Object[]{corpId, weworkUserNum, mobile});
            return;
        }
        TelAddFriendTaskDetail taskDetail = null;
        for (TelAddFriendTaskDetail detail : telAddFriendTaskDetails) {
            WeworkContactRelation weworkContactRelation;
            WeworkUser weworkUser;
            if (TelAddFriendStatus.EXPIRE.getStatus() == detail.getStatus().intValue()) {
                log.info("detail.num:{}\u5df2\u8fc7\u671f", (Object)detail.getNum());
                continue;
            }
            taskDetail = detail;
            detail.setStatus(Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()));
            detail.setAddSuccessTime(new Date());
            detail.setContactId(contactId);
            if (detail.getStatus().intValue() == TelAddFriendStatus.SUCCESS.getStatus() && StringUtils.isNotBlank((CharSequence)detail.getContactId()) && StringUtils.isNotBlank((CharSequence)detail.getUserDigitId()) && (weworkUser = this.weworkUserMapper.queryWeworkUserByDigitId(detail.getUserDigitId())) != null && (weworkContactRelation = this.weworkContactRelationMapper.queryWeworkContactDetail(detail.getCorpId(), weworkUser.getWeworkUserId(), detail.getContactId(), YnEnum.NO.getValue())) != null) {
                detail.setAddSuccessTime(weworkContactRelation.getAddTime());
            }
            detail.setUpdateTime(new Date());
            this.telAddFriendTaskDetailMapper.updateByPrimaryKey((Object)detail);
            TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
            if (task != null) {
                this.sopTaskStatusService.sendSopTaskStatusMsg(task.getId(), taskDetail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, null);
            }
            if (!StringUtils.isNotBlank((CharSequence)detail.getRequestId())) continue;
            log.info("initTelAddFriend detailId:{}, requestId:{}", (Object)detail.getId(), (Object)detail.getRequestId());
            this.vipFriendSendRecordMapper.updateSuccessByRequestId(bizId, detail.getRequestId(), new Date(), TelAddFriendStatus.SUCCESS.getDesc());
        }
        if (taskDetail == null) {
            return;
        }
        replyContext.setTelAddFriend(true);
        replyContext.setMobile(mobile);
        replyContext.setTaskDetailId(taskDetail.getId());
        replyContext.setTelAddFriendTaskNum(taskDetail.getTaskNum());
        String customerNum = weworkContact.getCustomerNum();
        TelAddFriendTask telAddFriendTask = this.telAddFriendTaskMapper.selectByNum(taskDetail.getTaskNum());
        String taskName = telAddFriendTask == null ? null : telAddFriendTask.getTaskName();
        String taskNum = taskDetail.getTaskNum();
        replyContext.setTelAddFriendTaskName(taskName);
        Integer taskAddType = taskDetail.getAddType();
        String string2 = channelStr = telAddFriendTask == null ? null : telAddFriendTask.getChannelNums();
        if (StringUtils.isNotBlank((CharSequence)channelStr)) {
            replyContext.setChannelId(this.channelMapper.getIdByNum(bizId, channelStr));
        }
        CompletableFuture.runAsync(() -> {
            String channelNums;
            this.customerCenterService.saveAddMobile(bizId, customerNum, mobile, ModuleType.BATCH_ADD_FRIEND.getCode(), taskNum, taskName);
            if (Objects.nonNull(taskAddType) && taskAddType.equals(TelAddType.LEADS.getValue())) {
                return;
            }
            CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
            log.info("\u6dfb\u52a0\u624b\u673a\u53f7\u5fae\u4fe1\u597d\u53cb\u6210\u529f,\u5c06\u624b\u673a\u53f7\u6dfb\u52a0\u5230\u7ebf\u7d22");
            ModMobileReq modMobileReq = new ModMobileReq();
            modMobileReq.setBizId(bizId);
            modMobileReq.setCustomerNum(customerNum);
            modMobileReq.setName(weworkContact.getName());
            modMobileReq.setMobile1(detailResp.getMobile1());
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
            if (Objects.nonNull(weworkUser)) {
                Long userId = this.userMapper.getUserIdByWeworkUserId(bizId, weworkUser.getWeworkUserId());
                modMobileReq.setUserId(userId);
                modMobileReq.setWeworkUserNum(weworkUser.getNum());
            }
            String string = channelNums = Objects.nonNull(telAddFriendTask) ? telAddFriendTask.getChannelNums() : null;
            if (StringUtils.isNotBlank((CharSequence)channelNums)) {
                String channelNum = Arrays.stream(channelNums.split(",")).findAny().orElse(null);
                modMobileReq.setChannelId(channelNum);
            }
            this.ccCustomerInfoService.modCustomerMobiles(modMobileReq);
        });
    }

    public void onAddExternalInit(AddExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, userId);
        if (Objects.nonNull(weworkUser)) {
            String weworkUserNum = weworkUser.getNum();
            String weworkUserName = weworkUser.getName();
            ctx.setWeworkUserNum(weworkUserNum);
            ctx.setWeworkUserName(weworkUserName);
        }
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        ctx.setState(event.getState());
        ctx.setWelcomeCode(event.getWelcomeCode());
    }

    public void onAddHalfExternalInit(AddHalfExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, userId);
        if (Objects.nonNull(weworkUser)) {
            String weworkUserNum = weworkUser.getNum();
            String weworkUserName = weworkUser.getName();
            ctx.setWeworkUserNum(weworkUserNum);
            ctx.setWeworkUserName(weworkUserName);
        }
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        ctx.setState(event.getState());
        ctx.setWelcomeCode(event.getWelcomeCode());
    }

    public void onAddExternalContact(AddExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        if (this.friendLogService.isExist()) {
            return;
        }
        this.initAdQrcode();
        this.initRadar();
        this.initWeworkCustomerAcquisition();
        if (!(ctx.isAdQrcode() || ctx.isRadar() || ctx.isWeworkCustomerAcquisition())) {
            this.initMarketingPlan();
            this.initTelAddFriend();
        }
        this.remarkService.onAddExternalContact();
        this.attachTagService.onAddExternalContact();
        this.friendFissionService.incrInviteCount();
        this.addContactCallbackAdService.callbackEventToAd();
        try {
            this.addContactCallbackAdService.callbackEventToMarketingMaterialApplet();
        }
        catch (Exception e) {
            log.error("addContactCallbackAdService callbackEventToMarketingMaterialApplet error", (Throwable)e);
        }
        this.vipIdTranslateService.onAddExternalContact();
        try {
            this.weworkAcquisitionService.saveAcquisitionJoinRecord();
            this.weworkAcquisitionService.addFriendCallback(ctx);
        }
        catch (Exception e) {
            log.error("weworkAcquisitionService,addFriendCallback error", (Throwable)e);
        }
        try {
            this.sendWeworkAddFriendEventMessage();
        }
        catch (Exception e) {
            log.error("onAddExternalContact,sendWeworkAddFriendEventMessage error", (Throwable)e);
        }
        this.friendLogService.onAddExternalContact();
        CompletableFuture.runAsync(() -> this.meetingCustomerInfoService.syncMeetingCustomerInfoByContactId(ctx.getBizId(), externalUserId));
    }

    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        this.initAdQrcode();
        this.initRadar();
        this.initWeworkCustomerAcquisition();
        if (!(ctx.isAdQrcode() || ctx.isRadar() || ctx.isWeworkCustomerAcquisition())) {
            this.initMarketingPlan();
            this.initTelAddFriend();
        }
        this.remarkService.onAddExternalContact();
        this.attachTagService.onAddExternalContact();
        this.friendFissionService.incrInviteCount();
        this.addContactCallbackAdService.callbackEventToAd();
        try {
            this.addContactCallbackAdService.callbackEventToMarketingMaterialApplet();
        }
        catch (Exception e) {
            log.error("addContactCallbackAdService callbackEventToMarketingMaterialApplet error", (Throwable)e);
        }
        this.vipIdTranslateService.onAddExternalContact();
        try {
            this.weworkAcquisitionService.addFriendCallback(ctx);
        }
        catch (Exception e) {
            log.error("weworkAcquisitionService,addFriendCallback error", (Throwable)e);
        }
        try {
            this.sendWeworkAddFriendEventMessage();
        }
        catch (Exception e) {
            log.error("onAddHalfExternalContact,sendWeworkAddFriendEventMessage error", (Throwable)e);
        }
        this.friendLogService.onAddExternalContact();
    }

    public void onEditExternalContact(EditExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
    }

    public void onDelExternalContact(DelExternalContact event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.friendLogService.onDelExternalContact();
        this.qualityCheckEsService.handleDelContact(event);
        try {
            this.sendWeworkDelFriendEventMessage(userId, externalUserId, new Date(timestamp * 1000L));
        }
        catch (Exception e) {
            log.error("onDelExternalContact,sendWeworkDelFriendEventMessage error", (Throwable)e);
        }
    }

    public void onDelFollowUser(DelFollowUser event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
        this.friendFissionService.onDelFollowUser();
        this.qualityCheckEsService.handleDelByContact(event);
        try {
            this.sendWeworkDelFriendEventMessage(userId, externalUserId, new Date(timestamp * 1000L));
        }
        catch (Exception e) {
            log.error("onDelExternalContact,sendWeworkDelFriendEventMessage error", (Throwable)e);
        }
    }

    public void onTransferFail(TransferFail event) {
        ReplyContext ctx = ReplyContextUtil.get();
        String corpId = ctx.getCorpId();
        String msgType = ctx.getMsgType();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String msgKey = msgType + ":" + corpId + ":" + userId + ":" + externalUserId + ":" + timestamp;
        if (!this.msgLock.locked(msgKey, 30L)) {
            log.info("Not locked, msgKey={}", (Object)msgKey);
            return;
        }
        String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(corpId, userId);
        ctx.setMsgKey(msgKey);
        ctx.setWeworkUserId(userId);
        ctx.setWeworkUserNum(weworkUserNum);
        ctx.setContactId(externalUserId);
        ctx.setTimestamp(new Date(timestamp * 1000L));
    }

    private void sendWeworkAddFriendEventMessage() {
        String contactId;
        String corpId;
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(bizId, corpId = ctx.getCorpId(), contactId = ctx.getContactId());
        if (weworkContact == null) {
            log.info("sendWeworkAddFriendEventMessage contact is null");
            return;
        }
        WeworkAddFriendEvent event = new WeworkAddFriendEvent();
        event.setBizId(bizId);
        event.setCorpId(corpId);
        event.setState(ctx.getState());
        event.setContactId(contactId);
        event.setUnionId(weworkContact.getUnionid());
        event.setNickName(weworkContact.getName());
        event.setAvatar(weworkContact.getAvatar());
        event.setGender(weworkContact.getGender());
        event.setMobile(weworkContact.getMobile());
        event.setWeworkUserId(ctx.getWeworkUserId());
        event.setWeworkUserName(ctx.getWeworkUserName());
        event.setWeworkUserNum(ctx.getWeworkUserNum());
        Date addFriendTime = ctx.getTimestamp();
        if (addFriendTime == null) {
            addFriendTime = new Date();
        }
        event.setAddFriendTime(addFriendTime);
        String eventString = JSONObject.toJSONString((Object)event);
        log.info("sendWeworkAddFriendEventMessage,event:{}", (Object)eventString);
        this.kafkaClientUtils.sendMessage(this.weworkAddFriendEventTopic, eventString);
    }

    private void sendWeworkDelFriendEventMessage(String userId, String contactId, Date delTime) {
        ReplyContext ctx = ReplyContextUtil.get();
        WeworkDelFriendEvent event = new WeworkDelFriendEvent();
        event.setCorpId(ctx.getCorpId());
        event.setBizId(ctx.getBizId());
        event.setWeworkUserId(userId);
        event.setContactId(contactId);
        event.setDelFriendTime(delTime);
        event.setWeworkUserNum(ctx.getWeworkUserNum());
        String eventString = JSONObject.toJSONString((Object)event);
        log.info("sendWeworkDelFriendEventMessage,event:{}", (Object)eventString);
        this.kafkaClientUtils.sendMessage(this.weworkDelFriendEventTopic, eventString);
    }
}

