/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dynamicform.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormGroup;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormGroupMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormMapper;
import com.kuaike.scrm.dynamicform.dto.FormGroupDto;
import com.kuaike.scrm.dynamicform.service.FormGroupService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormGroupServiceImpl
implements FormGroupService {
    private static final Logger log = LoggerFactory.getLogger(FormGroupServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Resource
    private DynamicFormGroupMapper dynamicFormGroupMapper;
    @Resource
    private DynamicFormMapper dynamicFormMapper;

    @Override
    @Transactional
    public void add(FormGroupDto params) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getName().length() <= 10 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57");
        this.insertGroup(user, params.getName(), false);
    }

    private DynamicFormGroup insertGroup(CurrentUserInfo user, String groupName, boolean isSystemGroup) {
        int nameCount = this.dynamicFormGroupMapper.queryGroupNameCount(user.getBizId(), groupName);
        Preconditions.checkArgument((nameCount <= 0 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        DynamicFormGroup formGroup = new DynamicFormGroup();
        formGroup.setNum(this.idGen.getNum());
        formGroup.setBizId(user.getBizId());
        formGroup.setCorpId(user.getCorpId());
        formGroup.setCreateBy(user.getId());
        formGroup.setUpdateBy(user.getId());
        formGroup.setCreateTime(new Date());
        formGroup.setUpdateTime(new Date());
        formGroup.setIsDeleted(Integer.valueOf(0));
        formGroup.setGroupName(groupName);
        if (isSystemGroup) {
            formGroup.setGroupType(Integer.valueOf(1));
        } else {
            formGroup.setGroupType(Integer.valueOf(0));
        }
        this.dynamicFormGroupMapper.insert((Object)formGroup);
        return formGroup;
    }

    @Override
    @Transactional
    public void mod(FormGroupDto params) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getName().length() <= 10 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc710\u4e2a\u5b57");
        DynamicFormGroup formGroup = new DynamicFormGroup();
        formGroup.setBizId(user.getBizId());
        formGroup.setNum(params.getId());
        formGroup = (DynamicFormGroup)this.dynamicFormGroupMapper.selectOne((Object)formGroup);
        if (formGroup == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5206\u7ec4");
        }
        if (formGroup.getGroupName().equals(params.getName())) {
            return;
        }
        int nameCount = this.dynamicFormGroupMapper.queryGroupNameCount(formGroup.getBizId(), params.getName());
        Preconditions.checkArgument((nameCount <= 0 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        formGroup.setGroupName(params.getName());
        formGroup.setUpdateBy(user.getId());
        formGroup.setUpdateTime(new Date());
        this.dynamicFormGroupMapper.updateByPrimaryKeySelective((Object)formGroup);
    }

    @Override
    @Transactional
    public void del(FormGroupDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicFormGroup formGroup = new DynamicFormGroup();
        formGroup.setNum(params.getId());
        formGroup.setBizId(userInfo.getBizId());
        formGroup = (DynamicFormGroup)this.dynamicFormGroupMapper.selectOne((Object)formGroup);
        if (formGroup == null) {
            return;
        }
        if (formGroup.getGroupType() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7cfb\u7edf\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u80fd\u5220\u9664");
        }
        int count = this.dynamicFormMapper.queryFormCountByGroup(userInfo.getBizId(), params.getId());
        Preconditions.checkArgument((count <= 0 ? 1 : 0) != 0, (Object)"\u8bf7\u5148\u5220\u9664\u5206\u7ec4\u4e0b\u7684\u6570\u636e\u540e\u518d\u5220\u9664\u5206\u7ec4");
        formGroup.setIsDeleted(Integer.valueOf(1));
        this.dynamicFormGroupMapper.updateByPrimaryKeySelective((Object)formGroup);
    }

    @Override
    @Transactional
    public List<FormGroupDto> list(FormGroupDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List allGroup = this.dynamicFormGroupMapper.queryList(userInfo.getBizId(), null);
        List sysList = allGroup.stream().filter(it -> it.getGroupType() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sysList)) {
            this.insertGroup(userInfo, "\u9ed8\u8ba4\u5206\u7ec4", true);
        }
        List list = this.dynamicFormGroupMapper.queryList(userInfo.getBizId(), params.getName());
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (DynamicFormGroup formGroup : list) {
            FormGroupDto dto = new FormGroupDto();
            dto.setId(formGroup.getNum());
            dto.setName(formGroup.getGroupName());
            dto.setType(formGroup.getGroupType());
            int count = this.dynamicFormMapper.queryFormCountByGroup(userInfo.getBizId(), formGroup.getNum());
            if (count > 0) {
                dto.setEnableDel(0);
            } else {
                dto.setEnableDel(1);
            }
            result.add(dto);
        }
        return result;
    }
}

