/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dynamicform.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.CrmProductLineService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.dto.req.event.EventSharer;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.dto.req.follow.FormInfoDto;
import cn.kinyun.customer.center.dto.req.follow.FormSubmitDto;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.page.auth.dto.WoauthUserDto;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.scrm.page.auth.utils.WoauthParseUtil;
import cn.kinyun.wework.sdk.entity.agent.SendMsgResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.enums.DynamicFormMoment;
import com.kuaike.scrm.common.enums.DynamicFormStatus;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmContactService;
import com.kuaike.scrm.common.service.dto.req.ModMobileSyncReq;
import com.kuaike.scrm.common.service.dto.req.ScrmSendSmsReqDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicForm;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormAccessLog;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormRelease;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormShare;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormSubmit;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormAccessLogMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormReleaseMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormShareMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormSubmitMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormTagMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormTitleTagMapper;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.follow.mapper.FollowRecordMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dynamicform.dto.ClientSubmitDto;
import com.kuaike.scrm.dynamicform.dto.CrmConfigDto;
import com.kuaike.scrm.dynamicform.dto.CrmFieldDto;
import com.kuaike.scrm.dynamicform.dto.DynamicFormDto;
import com.kuaike.scrm.dynamicform.dto.DynamicValueDto;
import com.kuaike.scrm.dynamicform.dto.FormEleDto;
import com.kuaike.scrm.dynamicform.dto.FormInfoReq;
import com.kuaike.scrm.dynamicform.dto.SubmitDataDto;
import com.kuaike.scrm.dynamicform.dto.SubmitSkipDto;
import com.kuaike.scrm.dynamicform.service.FormClientService;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.sms.service.SmsTaskService;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormClientServiceImpl
implements FormClientService {
    private static final Logger log = LoggerFactory.getLogger(FormClientServiceImpl.class);
    @Autowired
    private WoauthParseUtil woauthParseUtil;
    @Autowired
    private IdGen idGen;
    @Resource
    private DynamicFormShareMapper dynamicFormShareMapper;
    @Resource
    private DynamicFormMapper dynamicFormMapper;
    @Resource
    private DynamicFormReleaseMapper dynamicFormReleaseMapper;
    @Resource
    private DynamicFormTagMapper dynamicFormTagMapper;
    @Resource
    private DynamicFormAccessLogMapper dynamicFormAccessLogMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private DynamicFormSubmitMapper dynamicFormSubmitMapper;
    @Resource
    private FollowRecordMapper followRecordMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Resource
    private ScrmContactService scrmContactService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private CustomerCenterService customerCenterService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private UserMapper userMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private DynamicFormTitleTagMapper dynamicFormTitleTagMapper;
    @Autowired
    private ShortUrlService shortUrlService;
    @Autowired
    private SmsTaskService smsTaskService;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CrmProductLineService crmProductLineService;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String scrmManagerHost;
    private static final String VERIFICATION_MSG_TEMPLATE = "\u60a8\u7684\u9a8c\u8bc1\u7801{1}\uff0c\u6709\u6548\u65f6\u95f415\u5206\u949f\uff0c\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u672c\u77ed\u4fe1\u3002";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    private Random random = new Random();
    private static final String FORM_SUBMIT_REMIND_CONTENT = "\u3010\u52a8\u6001\u8868\u5355\u3011\n {0}\u63d0\u4ea4\u4e86\u60a8\u7684\u8868\u5355\u300a{1}\u300b\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\uff01\n \u5ba2\u6237\u7c7b\u578b\uff1a{2} \n <a href=\"{3}/formRender?id={4}&corpId={5}\">>>\u67e5\u770b\u5206\u4eab\u94fe\u63a5</a>";
    private static final String CUSTOMER_DETAIL_CONTENT = " <a href=\"{0}/smartFormDetail?id={1}&corpId={2}\">>>\u67e5\u770b\u5ba2\u6237\u8be6\u60c5</a>";
    @Autowired
    private ScrmBizService scrmBizService;

    @Override
    @Transactional
    public DynamicFormDto info(FormInfoReq params, HttpServletRequest request) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355\u5206\u4eabid\u4e0d\u80fd\u4e3a\u7a7a");
        WoauthUserDto userDto = this.woauthParseUtil.getWoauthInfo(request);
        log.info("dynamic form client info userDto: {}", (Object)userDto);
        DynamicFormShare dynamicFormShare = new DynamicFormShare();
        dynamicFormShare.setNum(params.getId());
        dynamicFormShare = (DynamicFormShare)this.dynamicFormShareMapper.selectOne((Object)dynamicFormShare);
        if (dynamicFormShare == null) {
            log.info("dynamic form share is null...");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u8868\u5355\u5206\u4eab\u8bb0\u5f55");
        }
        request.getSession().setAttribute("bizId", (Object)dynamicFormShare.getBizId());
        Enumeration referer = request.getHeaders("Referer");
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(dynamicForm.getBizId());
        dynamicForm.setNum(dynamicFormShare.getDynamicFormNum());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm == null || dynamicForm.getIsDeleted() == 1) {
            log.info("dynamic form is null...");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u8868\u5355\u8bb0\u5f55");
        }
        if (dynamicForm.getStatus().intValue() != DynamicFormStatus.RELEASE.getValue()) {
            log.info("dynamic form status is not release...");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03");
        }
        DynamicFormRelease formRelease = this.dynamicFormReleaseMapper.queryByDynamicFormNum(dynamicForm.getBizId(), dynamicForm.getNum());
        if (formRelease.getValidType() == 1 && formRelease.getDeadline().before(new Date())) {
            log.info("dynamic form status is end...");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03");
        }
        Date curTime = new Date();
        DynamicFormAccessLog accessLog = new DynamicFormAccessLog();
        if (StringUtils.isNotBlank((CharSequence)params.getAccessNum())) {
            accessLog.setNum(params.getAccessNum());
        } else {
            accessLog.setNum(this.idGen.getNum());
        }
        accessLog.setBizId(dynamicForm.getBizId());
        accessLog.setCorpId(dynamicForm.getCorpId());
        accessLog.setDynamicFormNum(dynamicForm.getNum());
        accessLog.setDynamicFormShareNum(dynamicFormShare.getNum());
        accessLog.setOpenId(userDto.getOpenId());
        accessLog.setContactId(userDto.getExternalUserId());
        accessLog.setCookie(userDto.getCookie());
        accessLog.setUniqId(userDto.getUniqId());
        accessLog.setNickname(userDto.getName());
        accessLog.setAvatar(userDto.getAvatar());
        accessLog.setIp(userDto.getIp());
        accessLog.setCity(this.bjyPartnerService.getCityByIp(userDto.getIp()));
        accessLog.setSubmit(Integer.valueOf(0));
        accessLog.setCreateTime(curTime);
        accessLog.setUpdateTime(curTime);
        String tagIds = this.attachTag(formRelease, dynamicFormShare, userDto.getExternalUserId(), DynamicFormMoment.OPEN_FORM.getValue());
        accessLog.setAccessTagIds(tagIds);
        this.dynamicFormAccessLogMapper.insertSelective((Object)accessLog);
        this.customerCenterService.pushFormAccessLog(accessLog);
        this.writeVisitPageEvent(accessLog.getCustomerNum(), accessLog.getNum(), dynamicForm, params.getId(), userDto, (String)referer.nextElement(), dynamicFormShare);
        DynamicFormDto result = new DynamicFormDto();
        result.setBizId(accessLog.getBizId());
        result.setId(accessLog.getNum());
        result.setName(dynamicForm.getName());
        result.setFormAvatarSwitch(dynamicForm.getFormAvatarSwitch());
        result.setFormAvatar(dynamicForm.getFormAvatar());
        result.setFormDescSwitch(dynamicForm.getFormDescSwitch());
        result.setFormDesc(dynamicForm.getFormDesc());
        result.setFormSubmitSwitch(dynamicForm.getFormSubmitSwitch());
        result.setFormSubmit(dynamicForm.getFormSubmit());
        result.setForm(dynamicForm.getForm());
        return result;
    }

    private void writeVisitPageEvent(String customerNum, String accessNum, DynamicForm form, String shortNum, WoauthUserDto woauthInfo, String referer, DynamicFormShare formShare) {
        if (StringUtils.isBlank((CharSequence)customerNum) || StringUtils.isBlank((CharSequence)accessNum)) {
            log.info("form write event customerNum or accessNum is empty, {}, {}", (Object)customerNum, (Object)accessNum);
            return;
        }
        EventPage eventPage = new EventPage();
        eventPage.setTitle(form.getName());
        eventPage.setUrl(this.shortUrlService.getOriginUrl(shortNum));
        String shortUrl = this.shortUrlService.getShortUlr(shortNum);
        eventPage.setShortUrl(shortUrl);
        EventModule module = new EventModule();
        module.setType(ModuleType.DYNAMIC_FORM.getCode());
        module.setName(form.getName());
        module.setNum(form.getNum());
        EventSharer sharer = new EventSharer();
        WeworkUser weworkUser = null;
        if (StringUtils.isNotBlank((CharSequence)formShare.getWeworkUserNum())) {
            weworkUser = this.weworkUserMapper.queryWeworkUserByNum(formShare.getWeworkUserNum());
        }
        if (weworkUser != null) {
            sharer.setName(weworkUser.getName());
            sharer.setWeworkUserId(weworkUser.getWeworkUserId());
        }
        if (StringUtils.isBlank((CharSequence)sharer.getName())) {
            User user = (User)this.userMapper.selectByPrimaryKey((Object)formShare.getUserId());
            sharer.setName(user.getName());
        }
        sharer.setUserId(formShare.getUserId());
        sharer.setWeworkUserNum(formShare.getWeworkUserNum());
        EventVisitor visitor = this.woauthParseUtil.buildVisitor(woauthInfo, referer);
        this.customerCenterService.saveVisitPage(form.getBizId(), customerNum, accessNum, eventPage, module, sharer, visitor);
    }

    private String attachTag(DynamicFormRelease formRelease, DynamicFormShare dynamicFormShare, String contactId, Integer type) {
        String tagIds = "";
        if (formRelease.getAttachTag() == 0) {
            return tagIds;
        }
        List list = this.dynamicFormTagMapper.queryTagList(formRelease.getBizId(), formRelease.getDynamicFormNum(), type);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List addTagIds = list.stream().map(it -> it.getTagId()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(addTagIds)) {
                log.info("attachTag addTagIds is empty");
                return tagIds;
            }
            String weworkUserNum = dynamicFormShare.getWeworkUserNum();
            if (StringUtils.isBlank((CharSequence)contactId)) {
                log.info("dynamic form weworkUserNum or contactId is empty weworkUserNum: {}, contactId: {}", (Object)weworkUserNum, (Object)contactId);
                return tagIds;
            }
            List relationList = this.weworkContactRelationMapper.queryListByContactId(formRelease.getCorpId(), contactId);
            if (CollectionUtils.isEmpty((Collection)relationList)) {
                log.info("contactId not find weworkUsers");
                return tagIds;
            }
            for (WeworkContactRelation relation : relationList) {
                ModifyTagDto modifyTagDto = new ModifyTagDto();
                modifyTagDto.setBizId(formRelease.getBizId());
                modifyTagDto.setCorpId(formRelease.getCorpId());
                modifyTagDto.setAddTagIds(addTagIds);
                modifyTagDto.setWeworkUserId(relation.getWeworkUserId());
                modifyTagDto.setContactId(contactId);
                try {
                    this.contactOpService.modifyTag(modifyTagDto);
                }
                catch (Exception e) {
                    log.error("dynamic form attach tag error: ", (Throwable)e);
                }
            }
            tagIds = Joiner.on((String)",").join(addTagIds);
        }
        return tagIds;
    }

    @Override
    @Transactional
    public SubmitSkipDto submit(ClientSubmitDto params) {
        int submitCount;
        log.info("dynamic form client submit params: {}", (Object)params);
        params.validate();
        DynamicFormAccessLog accessLog = new DynamicFormAccessLog();
        accessLog.setNum(params.getId());
        accessLog = (DynamicFormAccessLog)this.dynamicFormAccessLogMapper.selectOne((Object)accessLog);
        if (accessLog == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u8868\u5355\u8bbf\u95ee\u8bb0\u5f55");
        }
        this.validateCode(accessLog.getBizId(), params.getSubmitList());
        String dynamicFormNum = accessLog.getDynamicFormNum();
        DynamicFormRelease formRelease = new DynamicFormRelease();
        formRelease.setBizId(accessLog.getBizId());
        formRelease.setDynamicFormNum(dynamicFormNum);
        formRelease = (DynamicFormRelease)this.dynamicFormReleaseMapper.selectOne((Object)formRelease);
        if (formRelease.getSubmitLimit() == 1 && (submitCount = this.dynamicFormAccessLogMapper.queryCustomerOfSubmitLogCount(accessLog.getBizId(), dynamicFormNum, accessLog.getUniqId())) > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5355\u53ea\u80fd\u63d0\u4ea4\u4e00\u6b21\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
        }
        DynamicFormShare formShare = new DynamicFormShare();
        formShare.setNum(accessLog.getDynamicFormShareNum());
        formShare = (DynamicFormShare)this.dynamicFormShareMapper.selectOne((Object)formShare);
        String tagIds = this.attachTag(formRelease, formShare, accessLog.getContactId(), DynamicFormMoment.SUBMIT_FORM.getValue());
        this.addTitleTagAndAttachTag(formRelease.getBizId(), formRelease.getCorpId(), dynamicFormNum, formShare.getWeworkUserNum(), accessLog.getContactId(), params.getSubmitList());
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setNum(formRelease.getDynamicFormNum());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        accessLog.setSubmit(Integer.valueOf(1));
        accessLog.setSubmitTagIds(tagIds);
        accessLog.setUpdateTime(new Date());
        this.dynamicFormAccessLogMapper.updateByPrimaryKeySelective((Object)accessLog);
        this.writeSubmit(accessLog, params.getSubmitList());
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.DYNAMIC_FORM.getCode());
        List formEleDtos = Lists.newArrayList();
        try {
            formEleDtos = JacksonUtil.str2List((String)dynamicForm.getFormStruct(), FormEleDto.class);
        }
        catch (IOException e) {
            log.error("form struct json  parse error: , submit params:{}", (Object)e, (Object)params);
        }
        try {
            this.writeMobileCustomerCenter(accessLog, params.getSubmitList(), formEleDtos, dynamicForm.getUseCrm(), channelId, formShare.getUserId(), dynamicForm);
        }
        catch (Exception e) {
            log.error("submit mobile write customer center error: ", (Throwable)e);
        }
        try {
            if (dynamicForm.getLeadsSyncSwitch() == null || dynamicForm.getLeadsSyncSwitch() == 1) {
                this.addCrmCustomer(dynamicForm, accessLog, params.getSubmitList(), channelId, formShare.getUserId());
            }
        }
        catch (Exception e) {
            log.error("add crm customer error: , submit params:{}", (Object)params, (Object)e);
        }
        if (formRelease.getSendRemind() == 1) {
            this.sendRemind(accessLog, formShare.getWeworkUserNum(), dynamicForm.getName());
        }
        if (formRelease.getWriteFollow() == 1) {
            this.writeFollow(accessLog, formShare.getWeworkUserNum(), dynamicForm.getName(), params.getSubmitList());
        }
        this.saveVisitPageSubmit(accessLog, accessLog.getNum(), params.getSubmitList());
        SubmitSkipDto result = new SubmitSkipDto();
        result.setId(params.getId());
        result.setSkip(formRelease.getSkip());
        result.setSkipType(formRelease.getSkipType());
        result.setSkipUrl(formRelease.getSkipUrl());
        result.setSkipDesc(formRelease.getSkipDesc());
        return result;
    }

    private void addTitleTagAndAttachTag(Long bizId, String corpId, String dynamicNum, String weworkUserNum, String contactId, List<SubmitDataDto> submitList) {
        log.info("addTitleTagAndAttachTag dynamicNum: {}, contactId: {}, submitList: {}", new Object[]{dynamicNum, contactId, submitList});
        if (StringUtils.isBlank((CharSequence)weworkUserNum) || StringUtils.isBlank((CharSequence)contactId) || CollectionUtils.isEmpty(submitList)) {
            log.info("addTitleTagAndAttachTag weworkUserNum or contactId is empty weworkUserNum: {}, contactId: {}, submitList: {}", new Object[]{weworkUserNum, contactId, submitList});
            return;
        }
        ArrayList tagIds = Lists.newArrayList();
        for (SubmitDataDto dataDto : submitList) {
            String key = dataDto.getKey();
            String value = dataDto.getValue();
            DynamicValueDto dto = null;
            try {
                dto = (DynamicValueDto)JSON.parseObject((String)value, DynamicValueDto.class);
            }
            catch (Exception e) {
                log.error("addTitleTagAndAttachTag e", (Throwable)e);
            }
            ArrayList titles = Lists.newArrayList();
            if (dto != null) {
                String titleValue = dto.getVal();
                if (StringUtils.isNotBlank((CharSequence)titleValue)) {
                    if (titleValue.contains(",")) {
                        String[] titleList = titleValue.split(",");
                        titles.addAll(Arrays.asList(titleList));
                    } else {
                        titles.add(titleValue);
                    }
                }
            } else {
                log.info("addTitleTagAndAttachTag dto is null");
            }
            log.info("addTitleTagAndAttachTag get key : {}, titles: {}", (Object)key, (Object)titles);
            List tags = this.dynamicFormTitleTagMapper.queryTagsByTypeAndValues(bizId, dynamicNum, key, (List)titles);
            if (!CollectionUtils.isNotEmpty((Collection)tags)) continue;
            tagIds.addAll(tags);
        }
        log.info("addTitleTagAndAttachTag get tagIds: {}", (Object)tagIds);
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            log.info("addTitleTagAndAttachTag tagIds is empty");
            return;
        }
        List relationList = this.weworkContactRelationMapper.queryListByContactId(corpId, contactId);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            log.info("contactId not find weworkUsers");
            return;
        }
        for (WeworkContactRelation relation : relationList) {
            ModifyTagDto modifyTagDto = new ModifyTagDto();
            modifyTagDto.setBizId(bizId);
            modifyTagDto.setCorpId(corpId);
            modifyTagDto.setAddTagIds(new ArrayList(tagIds));
            modifyTagDto.setWeworkUserId(relation.getWeworkUserId());
            modifyTagDto.setContactId(contactId);
            try {
                this.contactOpService.modifyTag(modifyTagDto);
            }
            catch (Exception e) {
                log.error("dynamic form attach tag error: ", (Throwable)e);
            }
        }
    }

    private void addCrmCustomer(DynamicForm form, DynamicFormAccessLog accessLog, List<SubmitDataDto> submitList, Long channelId, Long shareUserId) {
        String productLineNum;
        if (form.getLeadsSyncSwitch() == null || form.getLeadsSyncSwitch() != 1) {
            log.warn("leads sync switch is close");
            return;
        }
        boolean isOpenCrm = this.scrmBizService.isOpenCrm(form.getBizId());
        if (!isOpenCrm) {
            log.info("not open crm, bizId: {}", (Object)form.getBizId());
            return;
        }
        List crmFieldList = null;
        List formEleDtoList = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)form.getCrmFieldList())) {
                crmFieldList = JacksonUtil.str2List((String)form.getCrmFieldList(), CrmFieldDto.class);
            }
        }
        catch (Exception e) {
            log.error("crm field json parse error: ", (Throwable)e);
        }
        if (crmFieldList == null || crmFieldList.isEmpty()) {
            log.info("crmFieldList is empty");
            try {
                formEleDtoList = JacksonUtil.str2List((String)form.getFormStruct(), FormEleDto.class);
            }
            catch (Exception e) {
                log.error("form struct json parse error: ", (Throwable)e);
            }
            if (formEleDtoList == null || formEleDtoList.isEmpty()) {
                log.info("formEleDtoList is empty");
                return;
            }
        }
        log.info("crmFieldList:{}, formEleDtoList: {}", (Object)crmFieldList, formEleDtoList);
        if (StringUtils.isBlank((CharSequence)form.getCrmConfig())) {
            productLineNum = this.crmProductLineService.validateProductLineNum(accessLog.getBizId(), null);
        } else {
            CrmConfigDto crmConfigDto = null;
            try {
                crmConfigDto = (CrmConfigDto)JacksonUtil.str2Obj((String)form.getCrmConfig(), CrmConfigDto.class);
            }
            catch (Exception e) {
                log.error("crmConfigDto json parse error: {}", (Object)crmConfigDto, (Object)e);
            }
            if (crmConfigDto == null || StringUtils.isBlank((CharSequence)crmConfigDto.getCrmProductLine())) {
                log.info("crmConfigDto is null or productLine is null");
                return;
            }
            productLineNum = crmConfigDto.getCrmProductLine();
        }
        CrmProductLineResp productLineResp = this.crmProductLineService.getByNum(accessLog.getBizId(), productLineNum);
        Long productLineId = null;
        if (productLineResp != null) {
            productLineId = productLineResp.getId();
        }
        if (productLineId == null) {
            log.info("productLineId is null");
            return;
        }
        CrmLeadsReq crmLeadsReq = this.buildLeadsParams(crmFieldList, formEleDtoList, submitList);
        log.info("buildLeadsParams crmLeadsReq: {}", (Object)crmLeadsReq);
        Map submitDataDtoMap = submitList.stream().collect(Collectors.toMap(SubmitDataDto::getKey, Function.identity()));
        if (submitDataDtoMap.containsKey("mobile") || submitDataDtoMap.containsKey("verificationCode")) {
            SubmitDataDto dataDto;
            if (StringUtils.isBlank((CharSequence)crmLeadsReq.getMobile())) {
                dataDto = (SubmitDataDto)submitDataDtoMap.get("mobile");
                if (dataDto == null) {
                    dataDto = (SubmitDataDto)submitDataDtoMap.get("verificationCode");
                }
                crmLeadsReq.setMobile(JSONObject.parseObject((String)dataDto.getValue()).getString("val"));
            }
            if (StringUtils.isBlank((CharSequence)crmLeadsReq.getName()) && (dataDto = (SubmitDataDto)submitDataDtoMap.get("name")) != null) {
                crmLeadsReq.setName(JSONObject.parseObject((String)dataDto.getValue()).getString("val"));
            }
            if (StringUtils.isBlank((CharSequence)crmLeadsReq.getWechat()) && (dataDto = (SubmitDataDto)submitDataDtoMap.get("wechat")) != null) {
                crmLeadsReq.setWechat(JSONObject.parseObject((String)dataDto.getValue()).getString("val"));
            }
            if (crmLeadsReq.getGender() == null && (dataDto = (SubmitDataDto)submitDataDtoMap.get("sex")) != null) {
                String sex = JSONObject.parseObject((String)dataDto.getValue()).getString("val");
                crmLeadsReq.setGender(Integer.valueOf("\u7537".equals(sex) ? 1 : 2));
            }
        }
        crmLeadsReq.setCorpId(form.getCorpId());
        crmLeadsReq.setCreatorId(Long.valueOf(-1L));
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.DYNAMIC_FORM_SYNC.getValue()));
        crmLeadsReq.setProductLineId(productLineId);
        crmLeadsReq.setChannelId(channelId);
        crmLeadsReq.setAllocUserId(shareUserId);
        log.info("crmLeadsReq info: {}", (Object)crmLeadsReq);
        if (StringUtils.isBlank((CharSequence)crmLeadsReq.getMobile())) {
            log.warn("crm mobile is empty");
            return;
        }
        try {
            Long centerChannelId;
            String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(accessLog.getBizId(), crmLeadsReq.getMobile());
            CustomerDetailResp detail = this.ccCustomerDetailService.queryCustomerDetail(accessLog.getBizId(), customerNum);
            if (detail != null && detail.getChannelId() != null && (centerChannelId = this.channelMapper.getIdByNum(accessLog.getBizId(), detail.getChannelId())) != null) {
                crmLeadsReq.setChannelId(centerChannelId);
            }
        }
        catch (Exception e) {
            log.error("get mobile customer channelId error: ", (Throwable)e);
        }
        try {
            String leadsLibNum;
            crmLeadsReq.setCoverFieldValue(form.getFieldUpdateSwitch());
            CrmLeadsInfoResp crmLeadsInfoResp = this.crmLeadsService.addLeads(crmLeadsReq);
            if (crmLeadsInfoResp != null && StringUtils.isNotBlank((CharSequence)(leadsLibNum = crmLeadsInfoResp.getNum()))) {
                accessLog.setCrmAlloc(leadsLibNum);
                this.dynamicFormAccessLogMapper.updateByPrimaryKeySelective((Object)accessLog);
            }
        }
        catch (Exception e) {
            if (e.getMessage().equals("\u8be5\u5ba2\u6237\u5df2\u5b58\u5728")) {
                accessLog.setCrmAlloc("-1");
                this.dynamicFormAccessLogMapper.updateByPrimaryKeySelective((Object)accessLog);
            }
            log.error("add leads error: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrmLeadsReq buildLeadsParams(List<CrmFieldDto> crmFieldList, List<FormEleDto> formEleDtoList, List<SubmitDataDto> submitList) {
        SubmitDataDto dto;
        Map submitDataMap = submitList.stream().collect(Collectors.toMap(SubmitDataDto::getKey, Function.identity()));
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        Field[] fields = CrmLeadsReq.class.getDeclaredFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getName(), field);
        }
        if (CollectionUtils.isNotEmpty(crmFieldList)) {
            for (CrmFieldDto crmFieldDto : crmFieldList) {
                Field field;
                String fieldName = null;
                fieldName = StringUtils.isNotBlank((CharSequence)crmFieldDto.getFieldName()) ? crmFieldDto.getFieldName() : crmFieldDto.getKey();
                dto = (SubmitDataDto)submitDataMap.get(fieldName);
                if (dto == null) continue;
                String val = JSONObject.parseObject((String)dto.getValue()).getString("val");
                if (fieldName.equals("area_id")) {
                    val = JSONObject.parseObject((String)dto.getValue()).getString("areaId");
                    crmLeadsReq.setAreaId(val);
                }
                if ((field = (Field)fieldMap.get(fieldName)) == null) continue;
                boolean reset = false;
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                        reset = true;
                    }
                    if (field.getType() == String.class) {
                        field.set(crmLeadsReq, val);
                        continue;
                    }
                    if (field.getType() == Integer.class) {
                        field.set(crmLeadsReq, Integer.parseInt(val));
                        continue;
                    }
                    if (field.getType() != Long.class) continue;
                    field.set(crmLeadsReq, Long.parseLong(val));
                }
                catch (Exception e) {
                    log.error("crmLeadsReq set field error: ", (Throwable)e);
                }
                finally {
                    if (!reset) continue;
                    field.setAccessible(false);
                }
            }
        } else {
            for (FormEleDto formEleDto : formEleDtoList) {
                String fieldName = formEleDto.getKey();
                dto = (SubmitDataDto)submitDataMap.get(fieldName);
                if (dto == null || fieldMap.get(fieldName) == null) continue;
                String val = JSONObject.parseObject((String)dto.getValue()).getString("val");
                if (fieldName.equals("area_id")) {
                    val = JSONObject.parseObject((String)dto.getValue()).getString("areaId");
                    crmLeadsReq.setAreaId(val);
                }
                Field field = (Field)fieldMap.get(fieldName);
                boolean reset = false;
                try {
                    field.setAccessible(true);
                    reset = true;
                    if (field.getType() == String.class) {
                        field.set(crmLeadsReq, val);
                        continue;
                    }
                    if (field.getType() == Integer.class) {
                        field.set(crmLeadsReq, Integer.parseInt(val));
                        continue;
                    }
                    if (field.getType() != Long.class) continue;
                    field.set(crmLeadsReq, Long.parseLong(val));
                }
                catch (Exception e) {
                    log.error("crmLeadsReq set field error: ", (Throwable)e);
                }
                finally {
                    if (!reset) continue;
                    field.setAccessible(false);
                }
            }
        }
        return crmLeadsReq;
    }

    @Override
    public boolean getVerificationCode(Long bizId, String mobile) {
        log.info("get verification code bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
        if (this.redisTemplate.hasKey((Object)this.getKey(bizId, mobile)).booleanValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5546\u6237");
        }
        String corpId = businessCustomer.getCorpId();
        String name = businessCustomer.getName();
        String verificationCode = this.getCode();
        String content = MessageFormat.format(VERIFICATION_MSG_TEMPLATE, name, verificationCode);
        ScrmSendSmsReqDto smsReqDto = new ScrmSendSmsReqDto();
        smsReqDto.setBizId(bizId);
        smsReqDto.setCorpId(corpId);
        smsReqDto.setMobile(mobile);
        smsReqDto.setUserId(Long.valueOf(-1L));
        smsReqDto.setContent(content);
        this.smsTaskService.sendNoticeSms(smsReqDto);
        this.redisTemplate.opsForValue().set((Object)this.getKey(bizId, mobile), (Object)verificationCode, 15L, TimeUnit.MINUTES);
        return false;
    }

    private void validateCode(Long bizId, List<SubmitDataDto> submitList) {
        String mobile = null;
        String verificationCode = null;
        for (SubmitDataDto submitDataDto : submitList) {
            if (!submitDataDto.getKey().equals("verificationCode")) continue;
            mobile = JSONObject.parseObject((String)submitDataDto.getValue()).getString("val");
            verificationCode = JSONObject.parseObject((String)submitDataDto.getValue()).getString("code");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mobile, verificationCode})) {
            String redisValue = (String)this.redisTemplate.opsForValue().get((Object)this.getKey(bizId, mobile));
            if (StringUtils.isBlank((CharSequence)redisValue)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u8fc7\u671f");
            }
            if (!verificationCode.equals(redisValue)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        }
    }

    private String getCode() {
        int[] digit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int j = this.random.nextInt(10);
            if (i == 0 && j == 0) {
                j = 1;
            }
            stringBuilder.append(digit[j]);
        }
        return stringBuilder.toString();
    }

    private String getKey(Long bizId, String mobile) {
        return this.redisKeyPrefix + ':' + bizId + ":formVerificationCode:" + mobile;
    }

    private void saveVisitPageSubmit(DynamicFormAccessLog accessLog, String accessNum, List<SubmitDataDto> submitList) {
        String customerNum = accessLog.getCustomerNum();
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.VISIT_PAGE.getCode());
        eventReq.setEventTime(accessLog.getUpdateTime());
        eventReq.setBizId(accessLog.getBizId());
        eventReq.setSource("scrm");
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventData.setAccessNum(accessNum);
        ArrayList submitResult = Lists.newArrayList();
        for (SubmitDataDto submitDataDto : submitList) {
            FormSubmitDto submitDto = new FormSubmitDto();
            submitDto.setKey(submitDataDto.getKey());
            submitDto.setValue(submitDataDto.getValue());
            submitResult.add(submitDto);
        }
        eventData.setSubmitList((List)submitResult);
        eventReq.setEventData(eventData);
        log.info("form submit event write: {}", (Object)eventReq);
        try {
            this.ccCustomerEventService.updateVisitPage(eventReq);
        }
        catch (Exception e) {
            log.error("save visit page submit: ", (Throwable)e);
        }
    }

    private void writeSubmit(DynamicFormAccessLog accessLog, List<SubmitDataDto> submitList) {
        ArrayList submits = Lists.newArrayList();
        Date curTime = new Date();
        for (SubmitDataDto dto : submitList) {
            DynamicFormSubmit formSubmit = new DynamicFormSubmit();
            formSubmit.setNum(this.idGen.getNum());
            formSubmit.setBizId(accessLog.getBizId());
            formSubmit.setCorpId(accessLog.getCorpId());
            formSubmit.setDynamicFormNum(accessLog.getDynamicFormNum());
            formSubmit.setDynamicFormAccessLogNum(accessLog.getNum());
            formSubmit.setFormKey(dto.getKey());
            formSubmit.setFormValue(dto.getValue());
            formSubmit.setCreateTime(curTime);
            submits.add(formSubmit);
        }
        this.dynamicFormSubmitMapper.batchInsert((Collection)submits);
    }

    private void sendRemind(DynamicFormAccessLog accessLog, String weworkUserNum, String formName) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.info("share weworkUserNum is empty");
            return;
        }
        String sendTarget = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        if (StringUtils.isBlank((CharSequence)sendTarget)) {
            log.info("send form remind send target is null");
            return;
        }
        String sendContent = "";
        if (StringUtils.isNotBlank((CharSequence)accessLog.getContactId())) {
            sendContent = MessageFormat.format(FORM_SUBMIT_REMIND_CONTENT, accessLog.getNickname(), formName, "\u4f01\u4e1a\u5ba2\u6237", this.scrmManagerHost, accessLog.getDynamicFormNum(), accessLog.getCorpId());
            sendContent = sendContent + MessageFormat.format(CUSTOMER_DETAIL_CONTENT, this.scrmManagerHost, accessLog.getDynamicFormShareNum(), accessLog.getCorpId());
        } else {
            String cusName = StringUtils.isNotBlank((CharSequence)accessLog.getNickname()) ? accessLog.getNickname() : "\u6e38\u5ba2";
            sendContent = MessageFormat.format(FORM_SUBMIT_REMIND_CONTENT, cusName, formName, "\u975e\u4f01\u4e1a\u5ba2\u6237", this.scrmManagerHost, accessLog.getDynamicFormNum(), accessLog.getCorpId());
        }
        try {
            log.info("form send remind msg sendTarget: {}, sendContent: {}", (Object)sendTarget, (Object)sendContent);
            SendMsgResult result = this.remindService.sendMsg(accessLog.getCorpId(), sendTarget, sendContent);
            log.info("sendFormRemind SendMsgResult errCode: {}, errMsg: {}", (Object)result.getErrCode(), (Object)result.getErrMsg());
        }
        catch (Exception e) {
            log.error("sendFormRemind error:", (Throwable)e);
        }
    }

    private void writeFollow(DynamicFormAccessLog accessLog, String weworkUserNum, String formName, List<SubmitDataDto> submitList) {
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.info("form save follow record weworkUserNum is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)accessLog.getContactId())) {
            log.info("form save follow record contactId is null");
            return;
        }
        WeworkUser shareUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        String weworkUserId = shareUser.getWeworkUserId();
        String weworkUserName = shareUser.getName();
        Integer firendRela = this.weworkContactRelationMapper.isFriendRelation(accessLog.getCorpId(), accessLog.getContactId(), (Collection)Lists.newArrayList((Object[])new String[]{weworkUserId}));
        if (firendRela <= 0) {
            log.info("form save follow sharer with contactId is not friend relation...");
            return;
        }
        String content = "\u63d0\u4ea4\u4e86\u8868\u5355\u300a" + formName + "\u300b";
        FormInfoDto paramsDto = new FormInfoDto();
        paramsDto.setFormName(formName);
        paramsDto.setViewTime(accessLog.getCreateTime());
        paramsDto.setShareName(weworkUserName);
        paramsDto.setWeworkUserNum(weworkUserNum);
        paramsDto.setDynamicFormId(accessLog.getDynamicFormNum());
        ArrayList submitDtos = Lists.newArrayList();
        for (SubmitDataDto submitDataDto : submitList) {
            FormSubmitDto dto = new FormSubmitDto();
            dto.setKey(submitDataDto.getKey());
            dto.setValue(submitDataDto.getValue());
            submitDtos.add(dto);
        }
        paramsDto.setSubmitList((List)submitDtos);
        FollowRecord followRecord = new FollowRecord();
        followRecord.setBizId(accessLog.getBizId());
        followRecord.setCorpId(accessLog.getCorpId());
        followRecord.setWeworkUserNum(weworkUserNum);
        followRecord.setWeworkContactId(accessLog.getContactId());
        followRecord.setType(Integer.valueOf(CustomerFollowType.FORM_CUSTOMER_FOLLOW.getValue()));
        followRecord.setContent(content);
        followRecord.setCreateBy(Long.valueOf(-1L));
        followRecord.setCreateTime(new Date());
        followRecord.setParams(JacksonUtil.obj2Str((Object)paramsDto));
        this.followRecordMapper.insertSelective((Object)followRecord);
        this.customerCenterService.pushFollowRecord(followRecord, "", weworkUserName);
    }

    private void writeMobileCustomerCenter(DynamicFormAccessLog accessLog, List<SubmitDataDto> submitList, List<FormEleDto> formEleDtoList, Integer useCrm, Long channelId, Long shareUserId, DynamicForm dynamicForm) {
        String mobile = null;
        String name = null;
        String sex = null;
        Long bizId = accessLog.getBizId();
        String contactId = accessLog.getContactId();
        Integer mobileBind = 0;
        Integer nameUpdate = 0;
        int gender = 0;
        for (SubmitDataDto dataDto : submitList) {
            if (dataDto.getKey().equals("mobile") || dataDto.getKey().equals("verificationCode")) {
                mobile = JSONObject.parseObject((String)dataDto.getValue()).getString("val");
            }
            if (dataDto.getKey().equals("name")) {
                name = JSONObject.parseObject((String)dataDto.getValue()).getString("val");
            }
            if (!dataDto.getKey().equals("sex")) continue;
            sex = JSONObject.parseObject((String)dataDto.getValue()).getString("val");
        }
        for (FormEleDto formEleDto : formEleDtoList) {
            if (formEleDto.getKey().equals("mobile") || formEleDto.getKey().equals("verificationCode")) {
                mobileBind = formEleDto.getOpenSync();
            }
            if (!formEleDto.getKey().equals("name")) continue;
            nameUpdate = formEleDto.getOpenSync();
        }
        if (StringUtils.isNotBlank(sex)) {
            gender = "\u7537".equals(sex) ? 1 : 2;
        }
        log.info("writeMobileCustomerCenter get mobile: {}, mobileBind: {}", mobile, (Object)mobileBind);
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            boolean isExist = this.ccCustomerNumService.mobileIsExist(bizId, mobile);
            String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
            CustomerEventReq req = new CustomerEventReq();
            req.setBizId(bizId);
            req.setCustomerNum(customerNum);
            req.setEventType(EventType.ADD_MOBILE.getCode());
            EventData eventData = new EventData();
            EventModule eventModule = new EventModule();
            eventModule.setType(ModuleType.DYNAMIC_FORM.getCode());
            eventData.setMobile(mobile);
            eventData.setNewMobile(!isExist);
            eventData.setModule(eventModule);
            req.setEventData(eventData);
            req.setEventTime(new Date());
            this.ccCustomerEventService.add(req);
            log.info("submit mobile write customer center: {}", (Object)mobile);
            if (StringUtils.isNotBlank((CharSequence)contactId) && mobileBind == 1 && !this.checkMobileBindCustomer(bizId, mobile) && this.checkContactBindMobiles(bizId, accessLog.getCustomerNum())) {
                this.ccCustomerNumService.bindWeworkContactAndMobile(bizId, contactId, mobile, ModuleType.DYNAMIC_FORM.getCode());
            }
            try {
                if (nameUpdate == 1 && StringUtils.isNotBlank((CharSequence)name)) {
                    CustomerDetailResp customerDetailResp;
                    CustomerDetailReq detailReq = new CustomerDetailReq();
                    detailReq.setBizId(bizId);
                    detailReq.setCustomerNum(customerNum);
                    detailReq.setName(name);
                    detailReq.setGender(Integer.valueOf(gender));
                    detailReq.setCoverValue(dynamicForm.getFieldUpdateSwitch());
                    log.info("submit mobile of detail write customer center: {}", (Object)detailReq);
                    this.ccCustomerDetailService.add(detailReq);
                    if (dynamicForm.getFieldUpdateSwitch() != null && dynamicForm.getFieldUpdateSwitch() == 1 && (customerDetailResp = this.ccCustomerDetailService.queryCustomerDetail(bizId, customerNum)) != null && !customerDetailResp.getCustomerNum().equals(customerNum)) {
                        CustomerDetailReq mainDetailReq = new CustomerDetailReq();
                        mainDetailReq.setBizId(bizId);
                        mainDetailReq.setCustomerNum(customerDetailResp.getCustomerNum());
                        mainDetailReq.setName(name);
                        mainDetailReq.setCoverValue(Integer.valueOf(1));
                        log.info("update main customer name: {}", (Object)mainDetailReq);
                        this.ccCustomerDetailService.add(mainDetailReq);
                    }
                }
            }
            catch (Exception e) {
                log.error("submit mobile of detail write customer center error", (Throwable)e);
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)contactId) && mobileBind == 1) {
                    ModMobileSyncReq syncReq = new ModMobileSyncReq();
                    syncReq.setCorpId(accessLog.getCorpId());
                    syncReq.setContactId(contactId);
                    syncReq.setMobiles((List)Lists.newArrayList((Object[])new String[]{mobile}));
                    this.scrmContactService.modMobileByAllWeworkUserIds(syncReq);
                }
            }
            catch (Exception e) {
                log.error("modMobileByAllWeworkUserIds error", (Throwable)e);
            }
            if (useCrm == null || useCrm == 0 && (dynamicForm.getLeadsSyncSwitch() == null || dynamicForm.getLeadsSyncSwitch() == 1)) {
                String syncName = accessLog.getNickname();
                if (nameUpdate == 1 && StringUtils.isNotBlank((CharSequence)name)) {
                    syncName = name;
                }
                CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
                crmLeadsReq.setCorpId(accessLog.getCorpId());
                crmLeadsReq.setMobile(mobile);
                crmLeadsReq.setName(syncName);
                crmLeadsReq.setSourceType(Integer.valueOf(SourceType.DYNAMIC_FORM_SYNC.getValue()));
                crmLeadsReq.setChannelId(channelId);
                crmLeadsReq.setAllocUserId(shareUserId);
                if (StringUtils.isNotBlank((CharSequence)dynamicForm.getCrmConfig())) {
                    CrmProductLineResp productLineResp;
                    CrmConfigDto crmConfigDto = null;
                    try {
                        crmConfigDto = (CrmConfigDto)JacksonUtil.str2Obj((String)dynamicForm.getCrmConfig(), CrmConfigDto.class);
                    }
                    catch (Exception e) {
                        log.error("crmConfigDto json parse error: {}", (Object)crmConfigDto, (Object)e);
                    }
                    if (crmConfigDto != null && StringUtils.isNotBlank((CharSequence)crmConfigDto.getCrmProductLine()) && (productLineResp = this.crmProductLineService.getByNum(bizId, crmConfigDto.getCrmProductLine())) != null) {
                        crmLeadsReq.setProductLineId(productLineResp.getId());
                    }
                }
                this.crmLeadsService.addLeads(crmLeadsReq);
            }
        }
    }

    private boolean checkMobileBindCustomer(Long bizId, String mobile) {
        boolean ret = false;
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            return false;
        }
        String contactId = this.ccCustomerNumService.getWeworkContactId(bizId, customerNum);
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            ret = true;
        }
        return ret;
    }

    private boolean checkContactBindMobiles(Long bizId, String customerNum) {
        CustomerDetailResp detailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNum);
        return !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{detailResp.getMobile1(), detailResp.getMobile2()});
    }
}

