/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dynamicform.service.impl;

import cn.kinyun.ad.common.dto.IdAndNameDto;
import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.BaseDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.DynamicFormMoment;
import com.kuaike.scrm.common.enums.DynamicFormStatus;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.dynamicform.dto.DynamicFormListDto;
import com.kuaike.scrm.dal.dynamicform.dto.QueryFormListDto;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicForm;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormAccessLog;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormRelease;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormShare;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormTag;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormTitleTag;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormAccessLogMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormGroupMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormReleaseMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormShareMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormTagMapper;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormTitleTagMapper;
import com.kuaike.scrm.dal.transfer.dto.ContactQueryParams;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.dynamicform.dto.CrmConfigDto;
import com.kuaike.scrm.dynamicform.dto.DynamicFormDto;
import com.kuaike.scrm.dynamicform.dto.DynamicTitleTagDto;
import com.kuaike.scrm.dynamicform.dto.FormEleDto;
import com.kuaike.scrm.dynamicform.dto.FormListItemDto;
import com.kuaike.scrm.dynamicform.dto.FormReleaseDto;
import com.kuaike.scrm.dynamicform.dto.ShareCardDto;
import com.kuaike.scrm.dynamicform.dto.SubmitCustomerRes;
import com.kuaike.scrm.dynamicform.dto.WeworkSubmitCustomerDto;
import com.kuaike.scrm.dynamicform.service.DynamicFormService;
import com.kuaike.scrm.system.service.UserService;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicFormServiceImpl
implements DynamicFormService {
    private static final Logger log = LoggerFactory.getLogger(DynamicFormServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Resource
    private DynamicFormMapper dynamicFormMapper;
    @Resource
    private DynamicFormReleaseMapper dynamicFormReleaseMapper;
    @Resource
    private DynamicFormTagMapper dynamicFormTagMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private DynamicFormGroupMapper dynamicFormGroupMapper;
    @Resource
    private DynamicFormShareMapper dynamicFormShareMapper;
    @Resource
    private DynamicFormAccessLogMapper dynamicFormAccessLogMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private DynamicFormTitleTagMapper dynamicFormTitleTagMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${dynamic-form.url.format:/smartForm?id={0}}")
    private String dynamicFormUlr;

    @Override
    @Transactional
    public String add(DynamicFormDto params) {
        log.info("dynamic form add params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setNum(this.idGen.getNum());
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setCorpId(userInfo.getCorpId());
        dynamicForm.setName(params.getName());
        dynamicForm.setFormType(params.getType());
        dynamicForm.setFormAvatarSwitch(params.getFormAvatarSwitch());
        dynamicForm.setLeadsSyncSwitch(params.getLeadsSyncSwitch());
        dynamicForm.setFieldUpdateSwitch(params.getFieldUpdateSwitch());
        if (dynamicForm.getFormAvatarSwitch() == 1) {
            dynamicForm.setFormAvatar(params.getFormAvatar());
        }
        dynamicForm.setFormDescSwitch(params.getFormDescSwitch());
        if (dynamicForm.getFormDescSwitch() == 1) {
            dynamicForm.setFormDesc(params.getFormDesc());
        }
        dynamicForm.setFormSubmitSwitch(params.getFormSubmitSwitch());
        if (dynamicForm.getFormSubmitSwitch() == 1) {
            dynamicForm.setFormSubmit(params.getFormSubmit());
        }
        String formStruct = JacksonUtil.obj2Str(params.getFormStruct());
        dynamicForm.setFormStruct(formStruct);
        dynamicForm.setForm(params.getForm());
        dynamicForm.setStatus(Integer.valueOf(DynamicFormStatus.DRAFT.getValue()));
        Date curTime = new Date();
        dynamicForm.setCreateBy(userInfo.getId());
        dynamicForm.setUpdateBy(userInfo.getId());
        dynamicForm.setCreateTime(curTime);
        dynamicForm.setUpdateTime(curTime);
        dynamicForm.setIsDeleted(Integer.valueOf(0));
        this.addCrmField(dynamicForm, params);
        this.dynamicFormMapper.insertSelective((Object)dynamicForm);
        this.addOrModTitleTag(userInfo, dynamicForm.getNum(), params.getTitleTags(), false);
        return dynamicForm.getNum();
    }

    private void addOrModTitleTag(CurrentUserInfo userInfo, String num, List<DynamicTitleTagDto> titleTagDtos, boolean isMod) {
        List titleTags;
        log.info("addOrModTitleTag bizId: {}, num : {}, titleTagDtos: {}, isMod: {}", new Object[]{userInfo.getBizId(), num, titleTagDtos, isMod});
        if (isMod && CollectionUtils.isNotEmpty((Collection)(titleTags = this.dynamicFormTitleTagMapper.queryTagsByNum(userInfo.getBizId(), num)))) {
            List tagNums = titleTags.stream().map(DynamicFormTitleTag::getNum).collect(Collectors.toList());
            this.dynamicFormTitleTagMapper.deleteTagsByNums(userInfo.getBizId(), tagNums);
        }
        if (CollectionUtils.isEmpty(titleTagDtos)) {
            log.info("addOrModTitleTag isAdd titleTagDtos is empty");
            return;
        }
        for (DynamicTitleTagDto dto : titleTagDtos) {
            List<IdAndNameDto> tagDto = dto.getTags();
            if (!CollectionUtils.isNotEmpty(tagDto)) continue;
            for (IdAndNameDto tag : tagDto) {
                if (!StringUtils.isNotBlank((CharSequence)tag.getId())) continue;
                DynamicFormTitleTag titleTag = this.buildDynamicTitle(userInfo, num, dto.getTitle(), tag.getId(), dto.getType());
                this.dynamicFormTitleTagMapper.insertSelective((Object)titleTag);
            }
        }
    }

    private DynamicFormTitleTag buildDynamicTitle(CurrentUserInfo userInfo, String num, String title, String tagId, String type) {
        DynamicFormTitleTag titleTag = new DynamicFormTitleTag();
        titleTag.setNum(this.idGen.getNum());
        titleTag.setBizId(userInfo.getBizId());
        titleTag.setCorpId(userInfo.getCorpId());
        titleTag.setDynamicFormNum(num);
        titleTag.setTitle(title);
        titleTag.setType(type);
        titleTag.setTagId(tagId);
        Date curTime = new Date();
        titleTag.setCreateBy(userInfo.getId());
        titleTag.setUpdateBy(userInfo.getId());
        titleTag.setCreateTime(curTime);
        titleTag.setUpdateTime(curTime);
        titleTag.setIsDeleted(Integer.valueOf(0));
        return titleTag;
    }

    @Override
    @Transactional
    public String mod(DynamicFormDto params) {
        log.info("dynamic form mod params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        params.validate();
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        Preconditions.checkArgument((dynamicForm != null && dynamicForm.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8868\u5355");
        if (dynamicForm.getStatus().intValue() != DynamicFormStatus.DRAFT.getValue()) {
            List formEleDtos = null;
            try {
                formEleDtos = JacksonUtil.str2List((String)dynamicForm.getFormStruct(), FormEleDto.class);
            }
            catch (IOException e) {
                log.error("dynamic form struct parse error: ", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty((Collection)formEleDtos)) {
                Set eleKeys = formEleDtos.stream().map(it -> it.getKey()).collect(Collectors.toSet());
                Set newEleKeys = params.getFormStruct().stream().map(it -> it.getKey()).collect(Collectors.toSet());
                if (!newEleKeys.containsAll(eleKeys)) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u53d1\u5e03\u8fc7\u7684\u8868\u5355\u4e0d\u80fd\u5220\u9664\u539f\u5148\u7684\u8868\u5355\u5143\u7d20");
                }
            }
        }
        dynamicForm.setName(params.getName());
        dynamicForm.setFormAvatarSwitch(params.getFormAvatarSwitch());
        dynamicForm.setLeadsSyncSwitch(params.getLeadsSyncSwitch());
        dynamicForm.setFieldUpdateSwitch(params.getFieldUpdateSwitch());
        if (dynamicForm.getFormAvatarSwitch() == 1) {
            dynamicForm.setFormAvatar(params.getFormAvatar());
        }
        dynamicForm.setFormDescSwitch(params.getFormDescSwitch());
        if (dynamicForm.getFormDescSwitch() == 1) {
            dynamicForm.setFormDesc(params.getFormDesc());
        }
        dynamicForm.setFormSubmitSwitch(params.getFormSubmitSwitch());
        if (dynamicForm.getFormSubmitSwitch() == 1) {
            dynamicForm.setFormSubmit(params.getFormSubmit());
        }
        String formStruct = JacksonUtil.obj2Str(params.getFormStruct());
        dynamicForm.setFormStruct(formStruct);
        dynamicForm.setForm(params.getForm());
        dynamicForm.setUpdateBy(userInfo.getId());
        dynamicForm.setUpdateTime(new Date());
        this.addCrmField(dynamicForm, params);
        this.dynamicFormMapper.updateByPrimaryKeySelective((Object)dynamicForm);
        this.addOrModTitleTag(userInfo, dynamicForm.getNum(), params.getTitleTags(), true);
        return dynamicForm.getNum();
    }

    private void addCrmField(DynamicForm dynamicForm, DynamicFormDto params) {
        if (StringUtils.isBlank((CharSequence)params.getCrmProductLine()) && CollectionUtils.isEmpty(params.getCrmFieldList())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getCrmProductLine())) {
            CrmConfigDto crmConfigDto = new CrmConfigDto();
            crmConfigDto.setCrmProductLine(params.getCrmProductLine());
            crmConfigDto.setAllocRule(params.getAllocRule());
            crmConfigDto.setCrmProductLineName(params.getCrmProductLineName());
            dynamicForm.setCrmConfig(JacksonUtil.obj2Str((Object)crmConfigDto));
        }
        if (CollectionUtils.isNotEmpty(params.getCrmFieldList())) {
            dynamicForm.setUseCrm(Integer.valueOf(1));
            dynamicForm.setCrmFieldList(JacksonUtil.obj2Str(params.getCrmFieldList()));
        }
    }

    @Override
    @Transactional
    public void del(BaseDto params) {
        log.info("dynamic form del parmas: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm == null || dynamicForm.getIsDeleted() == 1) {
            return;
        }
        dynamicForm.setUpdateBy(userInfo.getId());
        dynamicForm.setUpdateTime(new Date());
        dynamicForm.setIsDeleted(Integer.valueOf(1));
        this.dynamicFormMapper.updateByPrimaryKeySelective((Object)dynamicForm);
        this.dynamicFormTitleTagMapper.deleteTagsByDynamicNum(userInfo.getBizId(), params.getId());
    }

    @Override
    public List<FormListItemDto> list(QueryFormListDto params) {
        List list;
        log.info("dynamic form list params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        this.dynamicFormMapper.updateFormStatus(userInfo.getBizId());
        params.setBizId(userInfo.getBizId());
        PageDto pageDto = params.getPageDto();
        if (pageDto != null) {
            int count = this.dynamicFormMapper.queryListCount(params);
            pageDto.setCount(Integer.valueOf(count));
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.dynamicFormMapper.queryList(params)))) {
            return Lists.newArrayList();
        }
        Set groupNums = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getGroupNum())).map(it -> it.getGroupNum()).collect(Collectors.toSet());
        Map groupMap = this.dynamicFormGroupMapper.queryGroupNameMap(userInfo.getBizId(), groupNums);
        Set createBys = list.stream().map(it -> it.getCreateBy()).collect(Collectors.toSet());
        Map userMap = this.userService.getUserIdAndNameByUserIds(createBys);
        Set dynamicFormNums = list.stream().map(it -> it.getNum()).collect(Collectors.toSet());
        Map openCountMap = this.dynamicFormAccessLogMapper.queryOpenCountByFormNums(userInfo.getBizId(), dynamicFormNums);
        Map submitCountMap = this.dynamicFormAccessLogMapper.querySubmitCountByFormNums(userInfo.getBizId(), dynamicFormNums);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (DynamicFormListDto listDto : list) {
            FormListItemDto itemDto = new FormListItemDto();
            itemDto.setId(listDto.getNum());
            itemDto.setName(listDto.getName());
            if (listDto.getAvatarSwitch() == 1) {
                itemDto.setAvatar(listDto.getAvatar());
            }
            itemDto.setType(listDto.getFormType());
            itemDto.setGroupId(listDto.getGroupNum());
            itemDto.setGroupName((String)groupMap.get(listDto.getGroupNum()));
            if (listDto.getValidType() != null && listDto.getValidType() == 1) {
                itemDto.setDeadline(listDto.getDeadline());
            }
            itemDto.setClickCount(openCountMap.getOrDefault(listDto.getNum(), 0));
            itemDto.setSubmitCount(submitCountMap.getOrDefault(listDto.getNum(), 0));
            itemDto.setTags(this.getDynamicFormTags(userInfo.getBizId(), listDto.getNum(), null));
            itemDto.setStatus(listDto.getStatus());
            itemDto.setCreateTime(listDto.getCreateTime());
            itemDto.setCreateBy((String)userMap.get(listDto.getCreateBy()));
            result.add(itemDto);
        }
        return result;
    }

    @Override
    public DynamicFormDto detail(BaseDto params) {
        log.info("dynamic form detail params: {}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        if (dynamicForm == null || dynamicForm.getIsDeleted() == 1) {
            return null;
        }
        DynamicFormDto result = new DynamicFormDto();
        result.setId(dynamicForm.getNum());
        result.setName(dynamicForm.getName());
        result.setType(dynamicForm.getFormType());
        result.setFormAvatarSwitch(dynamicForm.getFormAvatarSwitch());
        if (result.getFormAvatarSwitch() == 1) {
            result.setFormAvatar(dynamicForm.getFormAvatar());
        }
        result.setFormDescSwitch(dynamicForm.getFormDescSwitch());
        result.setLeadsSyncSwitch(dynamicForm.getLeadsSyncSwitch());
        result.setFieldUpdateSwitch(dynamicForm.getFieldUpdateSwitch());
        if (result.getFormDescSwitch() == 1) {
            result.setFormDesc(dynamicForm.getFormDesc());
        }
        result.setFormSubmitSwitch(dynamicForm.getFormSubmitSwitch());
        if (result.getFormSubmitSwitch() == 1) {
            result.setFormSubmit(dynamicForm.getFormSubmit());
        }
        if (dynamicForm.getUseCrm() == 1 && StringUtils.isNotBlank((CharSequence)dynamicForm.getCrmConfig())) {
            try {
                CrmConfigDto crmConfigDto = (CrmConfigDto)JacksonUtil.str2Obj((String)dynamicForm.getCrmConfig(), CrmConfigDto.class);
                if (crmConfigDto != null) {
                    result.setCrmProductLine(crmConfigDto.getCrmProductLine());
                    result.setAllocRule(crmConfigDto.getAllocRule());
                    result.setCrmProductLineName(crmConfigDto.getCrmProductLineName());
                }
            }
            catch (IOException e) {
                log.error("crm config json parse error: ", (Throwable)e);
            }
        }
        result.setForm(dynamicForm.getForm());
        ArrayList titleTagResp = Lists.newArrayList();
        List titleTags = this.dynamicFormTitleTagMapper.queryTagsByNum(dynamicForm.getBizId(), params.getId());
        if (CollectionUtils.isNotEmpty((Collection)titleTags)) {
            List tagIds = titleTags.stream().map(DynamicFormTitleTag::getTagId).collect(Collectors.toList());
            Map tagMap = this.weworkTagMapper.selectTagIdAndNameTagIds(dynamicForm.getCorpId(), tagIds);
            log.info("dynamic form detail tagIds: {}, tagMaps: {}", tagIds, (Object)tagMap);
            Set typeList = titleTags.stream().map(DynamicFormTitleTag::getType).collect(Collectors.toSet());
            log.info("dynamic form detail typeList: {}", typeList);
            if (CollectionUtils.isEmpty(typeList)) {
                return result;
            }
            for (String type : typeList) {
                List<DynamicFormTitleTag> filterTitleTags = titleTags.stream().filter(a -> type.equals(a.getType())).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(filterTitleTags)) continue;
                List<DynamicTitleTagDto> filterTagDto = this.buildTitleTagDtos(filterTitleTags, tagMap, type);
                log.info("dynamic form detail filterTagDto: {}", filterTagDto);
                titleTagResp.addAll(filterTagDto);
            }
            result.setTitleTags(titleTagResp);
        }
        return result;
    }

    private List<DynamicTitleTagDto> buildTitleTagDtos(List<DynamicFormTitleTag> titleTags, Map<String, String> tagMap, String type) {
        ArrayList titleTagDtos = Lists.newArrayList();
        Map<String, List<DynamicFormTitleTag>> titleTagMaps = titleTags.stream().collect(Collectors.groupingBy(DynamicFormTitleTag::getTitle));
        log.info("buildTitleTagDtos titleTagMaps: {}, type: {}", titleTagMaps, (Object)type);
        for (Map.Entry<String, List<DynamicFormTitleTag>> entry : titleTagMaps.entrySet()) {
            String title = entry.getKey();
            ArrayList tagNames = Lists.newArrayList();
            for (DynamicFormTitleTag titleTag : entry.getValue()) {
                String tagId = titleTag.getTagId();
                String tagName = tagMap.get(tagId);
                if (!StringUtils.isNotBlank((CharSequence)tagName)) continue;
                IdAndNameDto dto = new IdAndNameDto();
                dto.setId(tagId);
                dto.setName(tagName);
                tagNames.add(dto);
            }
            DynamicTitleTagDto dto = new DynamicTitleTagDto();
            dto.setTitle(title);
            dto.setType(type);
            dto.setTags(tagNames);
            titleTagDtos.add(dto);
        }
        return titleTagDtos;
    }

    @Override
    @Transactional
    public String release(FormReleaseDto params) {
        log.info("dynamic form release params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        Preconditions.checkArgument((dynamicForm != null && dynamicForm.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8868\u5355");
        DynamicFormRelease formRelease = new DynamicFormRelease();
        formRelease.setBizId(userInfo.getBizId());
        formRelease.setDynamicFormNum(dynamicForm.getNum());
        formRelease = (DynamicFormRelease)this.dynamicFormReleaseMapper.selectOne((Object)formRelease);
        if (formRelease == null) {
            formRelease = new DynamicFormRelease();
            formRelease.setDynamicFormNum(dynamicForm.getNum());
            formRelease.setBizId(userInfo.getBizId());
            formRelease.setCorpId(userInfo.getCorpId());
            Date curTime = new Date();
            formRelease.setCreateBy(userInfo.getId());
            formRelease.setUpdateBy(userInfo.getId());
            formRelease.setCreateTime(curTime);
            formRelease.setUpdateTime(curTime);
        }
        formRelease.setValidType(params.getValidType());
        if (formRelease.getValidType() == 1) {
            formRelease.setDeadline(params.getDeadline());
        }
        formRelease.setGroupNum(params.getGroupId());
        formRelease.setSendRemind(params.getSendRemind());
        formRelease.setWriteFollow(params.getWriteFollow());
        formRelease.setAttachTag(params.getAttachTag());
        if (formRelease.getAttachTag() == 1) {
            this.saveDynamicFormTag(dynamicForm, params.getAccessTagIds(), 1);
            this.saveDynamicFormTag(dynamicForm, params.getSubmitTagIds(), 2);
        }
        formRelease.setSubmitLimit(params.getSubmitLimit());
        formRelease.setSkip(params.getSkip());
        if (formRelease.getSkip() == 1) {
            formRelease.setSkipType(params.getSkipType());
            formRelease.setSkipUrl(params.getSkipUrl());
            formRelease.setSkipDesc(params.getSkipDesc());
        }
        if (formRelease.getId() == null) {
            this.dynamicFormReleaseMapper.insertSelective((Object)formRelease);
        } else {
            this.dynamicFormReleaseMapper.updateByPrimaryKeySelective((Object)formRelease);
        }
        dynamicForm.setStatus(Integer.valueOf(DynamicFormStatus.RELEASE.getValue()));
        this.dynamicFormMapper.updateByPrimaryKey((Object)dynamicForm);
        return dynamicForm.getNum();
    }

    private void saveDynamicFormTag(DynamicForm dynamicForm, List<String> tagIds, Integer type) {
        if (tagIds == null) {
            tagIds = Lists.newArrayList();
        }
        List exists = this.dynamicFormTagMapper.queryTagList(dynamicForm.getBizId(), dynamicForm.getNum(), type);
        Map existsTagMap = exists.stream().collect(Collectors.toMap(it -> it.getTagId(), Function.identity()));
        HashSet addTagIds = Sets.newHashSet();
        for (String tagId : tagIds) {
            if (existsTagMap.containsKey(tagId)) {
                existsTagMap.remove(tagId);
                continue;
            }
            addTagIds.add(tagId);
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Date curTime = new Date();
        if (CollectionUtils.isNotEmpty((Collection)addTagIds)) {
            ArrayList addList = Lists.newArrayList();
            for (String tagId : addTagIds) {
                DynamicFormTag formTag = new DynamicFormTag();
                formTag.setNum(this.idGen.getNum());
                formTag.setDynamicFormNum(dynamicForm.getNum());
                formTag.setBizId(dynamicForm.getBizId());
                formTag.setCorpId(dynamicForm.getCorpId());
                formTag.setAttachMoment(type);
                formTag.setTagId(tagId);
                formTag.setCreateBy(userInfo.getId());
                formTag.setUpdateBy(userInfo.getId());
                formTag.setCreateTime(curTime);
                formTag.setUpdateTime(curTime);
                addList.add(formTag);
            }
            this.dynamicFormTagMapper.batchInsert((Collection)addList);
        }
        if (!existsTagMap.isEmpty()) {
            List delIds = existsTagMap.values().stream().map(it -> it.getId()).collect(Collectors.toList());
            this.dynamicFormTagMapper.batchDel(delIds);
        }
    }

    @Override
    public FormReleaseDto getReleaseInfo(BaseDto params) {
        log.info("dynamic form getReleaseInfo params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355\u5217\u8868id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicFormRelease formRelease = new DynamicFormRelease();
        formRelease.setBizId(userInfo.getBizId());
        formRelease.setDynamicFormNum(params.getId());
        formRelease = (DynamicFormRelease)this.dynamicFormReleaseMapper.selectOne((Object)formRelease);
        if (formRelease == null) {
            return null;
        }
        FormReleaseDto formReleaseDto = new FormReleaseDto();
        formReleaseDto.setId(formRelease.getDynamicFormNum());
        formReleaseDto.setValidType(formRelease.getValidType());
        if (formRelease.getValidType() == 1) {
            formReleaseDto.setDeadline(formRelease.getDeadline());
        }
        formReleaseDto.setGroupId(formRelease.getGroupNum());
        formReleaseDto.setSendRemind(formRelease.getSendRemind());
        formReleaseDto.setWriteFollow(formRelease.getWriteFollow());
        formReleaseDto.setAttachTag(formRelease.getAttachTag());
        if (formRelease.getAttachTag() == 1) {
            formReleaseDto.setAccessTags(this.getDynamicFormTags(userInfo.getBizId(), params.getId(), DynamicFormMoment.OPEN_FORM.getValue()));
            formReleaseDto.setSubmitTags(this.getDynamicFormTags(userInfo.getBizId(), params.getId(), DynamicFormMoment.SUBMIT_FORM.getValue()));
        }
        formReleaseDto.setSubmitLimit(formRelease.getSubmitLimit());
        formReleaseDto.setSkip(formRelease.getSkip());
        if (formReleaseDto.getSkip() == 1) {
            formReleaseDto.setSkipType(formRelease.getSkipType());
            formReleaseDto.setSkipUrl(formRelease.getSkipUrl());
            formReleaseDto.setSkipDesc(formRelease.getSkipDesc());
        }
        return formReleaseDto;
    }

    @Override
    public List<WeworkTagDto> getDynamicFormTags(Long bizId, String dynamicFormNum, Integer type) {
        List list = this.dynamicFormTagMapper.queryTagList(bizId, dynamicFormNum, type);
        Set tagIds = list.stream().map(DynamicFormTag::getTagId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(tagIds)) {
            return Lists.newArrayList();
        }
        String corpId = ((DynamicFormTag)list.get(0)).getCorpId();
        Map map = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(corpId, tagIds);
        ArrayList result = Lists.newArrayList();
        map.forEach((key, value) -> {
            WeworkTagDto tagDto = new WeworkTagDto();
            tagDto.setId(key);
            tagDto.setName(value);
            result.add(tagDto);
        });
        return result;
    }

    @Override
    public SubmitCustomerRes submitCustomerList(BaseDto params) {
        log.info("dynamic form wework submit customer list: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u5206\u4eabid\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicFormShare formShare = new DynamicFormShare();
        formShare.setBizId(userInfo.getBizId());
        formShare.setNum(params.getId());
        formShare = (DynamicFormShare)this.dynamicFormShareMapper.selectOne((Object)formShare);
        if (formShare == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5206\u4eab\u8bb0\u5f55");
        }
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setNum(formShare.getDynamicFormNum());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        SubmitCustomerRes result = new SubmitCustomerRes();
        result.setFormName(dynamicForm.getName());
        List list = this.dynamicFormAccessLogMapper.querySubmitList(userInfo.getBizId(), params.getId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            result.setSubmitCustomers(Lists.newArrayList());
            return result;
        }
        Set contactIds = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getContactId())).map(it -> it.getContactId()).collect(Collectors.toSet());
        Map corpNameMap = this.weworkContactMapper.queryContactCorpNameMap(userInfo.getCorpId(), contactIds);
        ArrayList customerDtos = Lists.newArrayListWithCapacity((int)list.size());
        String sharerWeworkUserNum = formShare.getWeworkUserNum();
        String weworkUserId = null;
        if (StringUtils.isNotBlank((CharSequence)sharerWeworkUserNum)) {
            weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(sharerWeworkUserNum);
        }
        Set contactIdSet = Sets.newHashSet();
        if (StringUtils.isNotBlank(weworkUserId)) {
            ContactQueryParams queryParams = new ContactQueryParams();
            queryParams.setCorpId(formShare.getCorpId());
            queryParams.setWeworkUserId(weworkUserId);
            contactIdSet = this.weworkContactRelationMapper.selectContactIdByCustomerQueryParams(queryParams);
        }
        for (DynamicFormAccessLog accessLog : list) {
            WeworkSubmitCustomerDto customerDto = new WeworkSubmitCustomerDto();
            customerDto.setNickname(accessLog.getNickname());
            customerDto.setAvatar(accessLog.getAvatar());
            customerDto.setContactId(accessLog.getContactId());
            customerDto.setCorpName((String)corpNameMap.get(accessLog.getContactId()));
            customerDto.setSubmitTime(accessLog.getUpdateTime());
            customerDto.setIsFriend(0);
            if (StringUtils.isNotBlank((CharSequence)accessLog.getContactId()) && StringUtils.isNotBlank((CharSequence)weworkUserId) && contactIdSet.contains(accessLog.getContactId())) {
                customerDto.setIsFriend(1);
            }
            customerDtos.add(customerDto);
        }
        result.setSubmitCustomers(customerDtos);
        return result;
    }

    @Override
    public String share(BaseDto params) {
        log.info("dynamic form share params: {}", (Object)params);
        ShareCardDto shareCardDto = this.sidebarShare(params);
        return shareCardDto.getUrl();
    }

    @Override
    @Transactional
    public ShareCardDto sidebarShare(BaseDto params) {
        log.info("dynamic form sidebar share params: {}", (Object)params);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setBizId(userInfo.getBizId());
        dynamicForm.setNum(params.getId());
        dynamicForm = (DynamicForm)this.dynamicFormMapper.selectOne((Object)dynamicForm);
        Preconditions.checkArgument((dynamicForm != null && dynamicForm.getIsDeleted() == 0 ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8868\u5355");
        if (dynamicForm.getStatus().intValue() != DynamicFormStatus.RELEASE.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5355\u72b6\u6001\u4e0d\u662f\u5df2\u53d1\u5e03\u7684\u4e0d\u80fd\u5206\u4eab");
        }
        ShareCardDto shareCardDto = new ShareCardDto();
        shareCardDto.setFormName(dynamicForm.getName());
        if (dynamicForm.getFormAvatarSwitch() == 1) {
            shareCardDto.setAvatar(dynamicForm.getFormAvatar());
        }
        if (dynamicForm.getFormDescSwitch() == 1) {
            shareCardDto.setFormDesc(dynamicForm.getFormDesc());
        }
        DynamicFormShare dynamicFormShare = this.dynamicFormShareMapper.queryShare(userInfo.getBizId(), params.getId(), userInfo.getId(), userInfo.getWeworkUserNum());
        Date curTime = new Date();
        if (dynamicFormShare == null) {
            dynamicFormShare = new DynamicFormShare();
            dynamicFormShare.setNum(this.idGen.getNum());
            dynamicFormShare.setBizId(userInfo.getBizId());
            dynamicFormShare.setCorpId(userInfo.getCorpId());
            dynamicFormShare.setDynamicFormNum(dynamicForm.getNum());
            dynamicFormShare.setUserId(userInfo.getId());
            dynamicFormShare.setWeworkUserNum(userInfo.getWeworkUserNum());
            dynamicFormShare.setCreateBy(userInfo.getId());
            dynamicFormShare.setUpdateBy(userInfo.getId());
            dynamicFormShare.setUpdateTime(curTime);
            dynamicFormShare.setCreateTime(curTime);
            this.dynamicFormShareMapper.insertSelective((Object)dynamicFormShare);
        }
        String originUrl = MessageFormat.format(this.dynamicFormUlr, dynamicFormShare.getNum());
        String url = this.weworkOauthService.wrapUrl(userInfo.getBizId(), userInfo.getCorpId(), originUrl, dynamicFormShare.getNum(), Integer.valueOf(OauthShortUrlTypeEnum.DYNAMIC_FORM_URL.getValue()));
        shareCardDto.setUrl(url);
        return shareCardDto;
    }
}

