/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerOrderSimpleInfoResp;
import cn.kinyun.customer.center.enums.electricity.OrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.scrm.contract.ContractInfoDto;
import cn.kinyun.scrm.contract.dto.ContractParam;
import cn.kinyun.scrm.contract.dto.CustomerExtInfoDto;
import cn.kinyun.scrm.contract.dto.CustomizedOneYearContractParam;
import cn.kinyun.scrm.contract.dto.CustomizedTwoYearContractParam;
import cn.kinyun.scrm.contract.dto.NormalClassContractParam;
import cn.kinyun.scrm.contract.dto.OrderContractDto;
import cn.kinyun.scrm.contract.dto.TempContractParam;
import cn.kinyun.scrm.contract.dto.req.SetTemplateAndParamsReqDto;
import cn.kinyun.scrm.contract.dto.resp.OrderContractTemplateAndParamsRespDto;
import cn.kinyun.scrm.contract.dto.resp.OrderCustomerExtInfoResp;
import cn.kinyun.scrm.contract.enums.ContractBusinessDataTypeEnum;
import cn.kinyun.scrm.contract.enums.ContractStatusEnum;
import cn.kinyun.scrm.contract.enums.ContractTemplateNameEnum;
import cn.kinyun.scrm.contract.service.OrderContractService;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.ScrmContractService;
import com.kuaike.scrm.common.service.dto.req.CreateContractReqDto;
import com.kuaike.scrm.common.service.dto.resp.ContractRespDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCompany;
import com.kuaike.scrm.dal.contract.entity.ContractCustomerVerifyInfo;
import com.kuaike.scrm.dal.contract.entity.ContractOrderCustomerExtInfo;
import com.kuaike.scrm.dal.contract.entity.OrderContract;
import com.kuaike.scrm.dal.contract.mapper.ContractCompanyMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractCustomerVerifyInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.ContractOrderCustomerExtInfoMapper;
import com.kuaike.scrm.dal.contract.mapper.OrderContractMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderContractServiceImpl
implements OrderContractService {
    private static final Logger log = LoggerFactory.getLogger(OrderContractServiceImpl.class);
    @Resource
    private ScrmContractService scrmContractService;
    @Resource
    private CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private IdGen idGen;
    @Resource
    private OrderContractMapper orderContractMapper;
    @Resource
    private ContractCustomerVerifyInfoMapper contractCustomerVerifyInfoMapper;
    @Resource
    private ContractOrderCustomerExtInfoMapper customerExtInfoMapper;
    @Resource
    private ContractCompanyMapper contractCompanyMapper;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}/orderCenterContract?p=")
    private String orderDetailUrl;
    @Value(value="${refresh.sign.url.interval}")
    private Integer refreshSignUrlInterval;
    private static final List<Integer> CAN_SIGN_CONTRACT_ORDER_STATUS = Lists.newArrayList((Object[])new Integer[]{OrderStatusEnum.HAD_PAY.getValue(), OrderStatusEnum.WAIT_DELIVERY.getValue(), OrderStatusEnum.SUCCESSED.getValue(), OrderStatusEnum.PARTIAL_PAY.getValue()});
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5", Locale.CHINESE);
    private static final Map<String, Class<? extends ContractParam>> templateToParamClass = Maps.newHashMap();

    @Override
    public OrderContractTemplateAndParamsRespDto getTemplateAndParams(String orderNo) {
        log.info("getTemplateAndParams orderNo:{}", (Object)orderNo);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)orderNo) || userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u9519\u8bef");
        }
        OrderContract orderContract = this.orderContractMapper.queryByBizIdAndOrderNo(userInfo.getBizId(), orderNo);
        if (Objects.isNull(orderContract)) {
            log.info("\u6839\u636ebizId:{}, orderNo:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userInfo.getBizId(), (Object)orderNo);
            return null;
        }
        OrderContractTemplateAndParamsRespDto respDto = new OrderContractTemplateAndParamsRespDto();
        respDto.setOrderNo(orderNo);
        respDto.setTemplateId(orderContract.getTemplateId());
        respDto.setTemplateName(orderContract.getTemplateName());
        respDto.setOrderDetailUrl(orderContract.getOrderDetailUrl());
        Class<? extends ContractParam> paramClass = templateToParamClass.get(orderContract.getTemplateName());
        if (paramClass != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                respDto.setParams((ContractParam)mapper.readValue(orderContract.getParamMap(), paramClass));
            }
            catch (IOException e) {
                log.info("\u5c06paramMap:{}\u8f6c\u6362\u4e3a{}\u5f02\u5e38", new Object[]{orderContract.getParamMap(), paramClass, e});
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53c2\u6570\u9519\u8bef");
            }
        }
        return respDto;
    }

    @Override
    public String setTemplateAndParams(SetTemplateAndParamsReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (userInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237\u672a\u767b\u5f55");
        }
        log.info("setTemplateAndParams reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateParams();
        this.checkCorpCanUseContract(userInfo.getBizId());
        CustomerOrderSimpleInfoResp orderInfoResp = this.ccCustomerOrderService.queryOrderSimpleInfoByOrderNo(userInfo.getBizId(), reqDto.getOrderNo());
        if (orderInfoResp == null) {
            log.info("\u6839\u636eorderNo:{}\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f", (Object)reqDto.getOrderNo());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u5408\u6cd5\u7684\u8ba2\u5355\u7f16\u53f7");
        }
        if (orderInfoResp.getOrderStatus() == null || !CAN_SIGN_CONTRACT_ORDER_STATUS.contains(orderInfoResp.getOrderStatus())) {
            log.info("orderNo:{}\u8ba2\u5355\u72b6\u6001\u4e3a:{}\u4e0d\u80fd\u7b7e\u7f72\u5408\u540c", (Object)reqDto.getOrderNo(), (Object)orderInfoResp.getOrderStatus());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u3010\u5df2\u652f\u4ed8\u3001\u90e8\u5206\u652f\u4ed8\u3001\u5df2\u6210\u529f\u3001\u5f85\u53d1\u8d27\u3011\u72b6\u6001\u7684\u8ba2\u5355\u624d\u80fd\u7b7e\u7f72\u5408\u540c");
        }
        String personalCustomerId = this.getOrRegisterPersonalFddAccount(userInfo.getBizId(), userInfo.getCorpId(), orderInfoResp.getCustomerNum());
        OrderContract orderContract = this.orderContractMapper.queryByBizIdAndOrderNo(userInfo.getBizId(), reqDto.getOrderNo());
        if (orderContract == null) {
            orderContract = this.buildOrderContract(reqDto, userInfo);
            orderContract.setCustomerNum(orderInfoResp.getCustomerNum());
            this.orderContractMapper.insertSelective((Object)orderContract);
        } else {
            this.updateOrderContract(orderContract, reqDto, userInfo, orderInfoResp, personalCustomerId);
        }
        return orderContract.getOrderDetailUrl();
    }

    @Override
    public OrderCustomerExtInfoResp getOrderCustomerExtInfo(String orderContractNum) {
        log.info("getOrderCustomerExtInfo orderContractNum:{}", (Object)orderContractNum);
        if (StringUtils.isBlank((CharSequence)orderContractNum)) {
            log.info("orderContractNum:{}\u4e0d\u5408\u6cd5", (Object)orderContractNum);
            return null;
        }
        OrderContract orderContract = this.orderContractMapper.queryByNum(orderContractNum);
        if (Objects.isNull(orderContract)) {
            log.info("\u6839\u636eorderContractNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)orderContractNum);
            return null;
        }
        CustomerOrderSimpleInfoResp orderSimpleInfo = this.ccCustomerOrderService.queryOrderSimpleInfoByOrderNo(orderContract.getBizId(), orderContract.getOrderNo());
        ContractOrderCustomerExtInfo customerExtInfo = this.customerExtInfoMapper.selectByBizIdCustomerNumAndOrderNo(orderContract.getBizId(), orderSimpleInfo.getCustomerNum(), orderSimpleInfo.getOrderNo());
        if (!Objects.equals(NumberUtils.INTEGER_ONE, orderContract.getPersonalSignStatus()) && Objects.nonNull(orderContract.getSignUrlCreateTime()) && orderContract.getSignUrlCreateTime().getTime() + (long)(this.refreshSignUrlInterval * 3600 * 1000) < System.currentTimeMillis()) {
            String personalCustomerId = this.getOrRegisterPersonalFddAccount(orderContract.getBizId(), orderContract.getCorpId(), orderContract.getCustomerNum());
            ContractRespDto contractRespDto = this.createContract(orderContract, orderSimpleInfo, customerExtInfo, -1L, personalCustomerId);
            if (contractRespDto != null) {
                orderContract.setContractId(contractRespDto.getContractId());
                orderContract.setSignUrlCreateTime(new Date());
                orderContract.setDownloadUrl(contractRespDto.getDownloadUrl());
                orderContract.setViewUrl(contractRespDto.getViewUrl());
                this.orderContractMapper.updateByPrimaryKeySelective((Object)orderContract);
            }
        }
        return this.buildOrderCustomerExtInfoResp(orderContract, orderSimpleInfo, customerExtInfo);
    }

    private OrderCustomerExtInfoResp buildOrderCustomerExtInfoResp(OrderContract orderContract, CustomerOrderSimpleInfoResp orderSimpleInfo, ContractOrderCustomerExtInfo customerExtInfo) {
        OrderCustomerExtInfoResp extInfoResp = new OrderCustomerExtInfoResp();
        extInfoResp.setSkuName(orderSimpleInfo.getSkuName());
        extInfoResp.setOrderContractNum(orderContract.getNum());
        extInfoResp.setOrderNo(orderContract.getOrderNo());
        extInfoResp.setOrderAmount(orderSimpleInfo.getOrderAmount());
        if (Objects.nonNull(orderSimpleInfo.getDiscountAmount())) {
            extInfoResp.setDiscountAmount(orderSimpleInfo.getDiscountAmount());
        } else {
            extInfoResp.setDiscountAmount(0L);
        }
        extInfoResp.setPaidAmount(orderSimpleInfo.getPaidAmount());
        ContractInfoDto contractInfo = new ContractInfoDto();
        extInfoResp.setContractInfo(contractInfo);
        contractInfo.setSignStatus(orderContract.getPersonalSignStatus());
        contractInfo.setContractId(orderContract.getContractId());
        contractInfo.setSignUrl(orderContract.getFddSignUrl());
        contractInfo.setViewUrl(orderContract.getViewUrl());
        contractInfo.setDownloadUrl(orderContract.getDownloadUrl());
        CustomerExtInfoDto extInfoDto = new CustomerExtInfoDto();
        extInfoResp.setCustomerExtInfo(extInfoDto);
        extInfoDto.setCustomerName(orderSimpleInfo.getCustomerName());
        extInfoDto.setMobile(orderSimpleInfo.getCustomerPhone());
        if (Objects.nonNull(customerExtInfo)) {
            extInfoDto.setIdNo(customerExtInfo.getIdNo());
            extInfoDto.setExamTicketNumber(customerExtInfo.getExamTicketNumber());
            extInfoDto.setMail(customerExtInfo.getMail());
            extInfoDto.setWechat(customerExtInfo.getWechat());
            extInfoDto.setAddress(customerExtInfo.getAddress());
            extInfoDto.setEmergencyContactName(customerExtInfo.getEmergencyContactName());
            extInfoDto.setEmergencyContactPhone(customerExtInfo.getEmergencyContactPhone());
            extInfoDto.setEmergencyContactRelation(customerExtInfo.getEmergencyContactRelation());
            extInfoDto.setEmergencyContactAddress(customerExtInfo.getEmergencyContactAddress());
        }
        return extInfoResp;
    }

    @Override
    public ContractInfoDto setCustomerExtInfo(CustomerExtInfoDto reqDto) {
        boolean isNeedCreateContract;
        boolean isChanged;
        log.info("setCustomerExtInfo reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        OrderContract orderContract = this.orderContractMapper.queryByNum(reqDto.getOrderContractNum());
        if (orderContract == null) {
            log.info("\u6839\u636eorderContractNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getOrderContractNum());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        ContractOrderCustomerExtInfo customerExtInfo = this.customerExtInfoMapper.selectByBizIdCustomerNumAndOrderNo(orderContract.getBizId(), orderContract.getCustomerNum(), orderContract.getOrderNo());
        if (customerExtInfo == null) {
            customerExtInfo = this.buildCustomerExtInfo(reqDto, orderContract);
            this.customerExtInfoMapper.insertSelective((Object)customerExtInfo);
            isChanged = true;
        } else {
            isChanged = this.checkCustomerExtInfoIsChanged(reqDto, customerExtInfo);
            if (isChanged) {
                customerExtInfo.setUpdateTime(new Date());
                this.customerExtInfoMapper.updateByPrimaryKey((Object)customerExtInfo);
            }
        }
        boolean bl = isNeedCreateContract = isChanged || StringUtils.isBlank((CharSequence)orderContract.getFddSignUrl()) || orderContract.getSignUrlCreateTime().getTime() + (long)(this.refreshSignUrlInterval * 3600 * 1000) < System.currentTimeMillis();
        if (isNeedCreateContract) {
            String personalCustomerId = this.getOrRegisterPersonalFddAccount(orderContract.getBizId(), orderContract.getCorpId(), orderContract.getCustomerNum());
            CustomerOrderSimpleInfoResp orderInfoResp = this.ccCustomerOrderService.queryOrderSimpleInfoByOrderNo(orderContract.getBizId(), orderContract.getOrderNo());
            ContractRespDto contractRespDto = this.createContract(orderContract, orderInfoResp, customerExtInfo, -1L, personalCustomerId);
            orderContract.setFddSignUrl(contractRespDto.getFddSignUrl());
            orderContract.setSignUrlCreateTime(contractRespDto.getSignUrlCreateTime());
            orderContract.setContractId(contractRespDto.getContractId());
            orderContract.setDownloadUrl(contractRespDto.getDownloadUrl());
            orderContract.setViewUrl(contractRespDto.getViewUrl());
            this.orderContractMapper.updateByPrimaryKey((Object)orderContract);
        }
        ContractInfoDto contractInfoDto = new ContractInfoDto();
        contractInfoDto.setSignStatus(orderContract.getPersonalSignStatus());
        contractInfoDto.setContractId(orderContract.getContractId());
        contractInfoDto.setSignUrl(orderContract.getFddSignUrl());
        contractInfoDto.setViewUrl(orderContract.getViewUrl());
        contractInfoDto.setDownloadUrl(orderContract.getDownloadUrl());
        return contractInfoDto;
    }

    @Override
    public List<OrderContractDto> getOrderContractInfoByOrderNos(Long bizId, List<String> orderNos) {
        if (CollectionUtils.isEmpty(orderNos)) {
            return Collections.emptyList();
        }
        List orderContracts = this.orderContractMapper.queryContractInfoByBizIdAndOrderNos(bizId, orderNos);
        if (CollectionUtils.isEmpty((Collection)orderContracts)) {
            return Collections.emptyList();
        }
        return orderContracts.stream().map(orderContract -> {
            OrderContractDto orderContractDto = new OrderContractDto();
            orderContractDto.setOrderNo(orderContract.getOrderNo());
            orderContractDto.setSignStatus(orderContract.getCorpSignStatus());
            orderContractDto.setContractId(orderContract.getContractId());
            orderContractDto.setDownloadUrl(orderContract.getDownloadUrl());
            orderContractDto.setViewUrl(orderContract.getViewUrl());
            return orderContractDto;
        }).collect(Collectors.toList());
    }

    private void checkCorpCanUseContract(Long bizId) {
        boolean isOpenedContract = this.scrmContractService.isOpenedContract(bizId);
        if (!isOpenedContract) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5546\u6237\u672a\u5f00\u901a\u7535\u5b50\u5408\u540c");
        }
        boolean isCorpAutoSignAuthorized = this.scrmContractService.isCorpAutoSignAuthorized(bizId);
        if (!isCorpAutoSignAuthorized) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5546\u6237\u672a\u5b8c\u6210\u4f01\u4e1a\u8ba4\u8bc1,\u8bf7\u5148\u5b8c\u6210\u4f01\u4e1a\u8ba4\u8bc1");
        }
        ContractCompany company = this.contractCompanyMapper.selectByBizId(bizId);
        if (company == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7532\u65b9\u4fe1\u606f\u672a\u5b8c\u5584");
        }
        int restMoney = this.scrmContractService.getAccountRestMoney(bizId);
        if (restMoney <= 0) {
            log.info("\u5546\u6237\u4f59\u989d\u4e0d\u8db3,restMoney:{}", (Object)restMoney);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5546\u6237\u4f59\u989d\u4e0d\u8db3");
        }
    }

    private String getOrRegisterPersonalFddAccount(Long bizId, String corpId, String customerNum) {
        ContractCustomerVerifyInfo customerVerifyInfo = this.contractCustomerVerifyInfoMapper.selectByBizIdAndFddOpenId(bizId, customerNum);
        if (customerVerifyInfo != null) {
            return customerVerifyInfo.getCustomerId();
        }
        return this.scrmContractService.registerCustomerAccount(bizId, corpId, customerNum);
    }

    private OrderContract buildOrderContract(SetTemplateAndParamsReqDto reqDto, CurrentUserInfo userInfo) {
        String num = this.idGen.getNum();
        Date currentDate = new Date();
        OrderContract orderContract = new OrderContract();
        orderContract.setNum(num);
        orderContract.setBizId(userInfo.getBizId());
        orderContract.setCorpId(userInfo.getCorpId());
        orderContract.setOrderNo(reqDto.getOrderNo());
        orderContract.setTemplateId(reqDto.getTemplateId());
        orderContract.setTemplateName(reqDto.getTemplateName());
        orderContract.setParamMap(reqDto.getJsonParam());
        orderContract.setOrderDetailUrl(this.orderDetailUrl + num);
        orderContract.setCreateBy(userInfo.getId());
        orderContract.setCreateTime(currentDate);
        orderContract.setUpdateBy(userInfo.getId());
        orderContract.setUpdateTime(currentDate);
        return orderContract;
    }

    private void updateOrderContract(OrderContract orderContract, SetTemplateAndParamsReqDto reqDto, CurrentUserInfo userInfo, CustomerOrderSimpleInfoResp orderInfoResp, String personalCustomerId) {
        String newParamsMd5;
        String oldParamsMd5 = OrderContractServiceImpl.calculateMD5Hash(orderContract.getParamMap());
        if (oldParamsMd5.equals(newParamsMd5 = OrderContractServiceImpl.calculateMD5Hash(reqDto.getJsonParam()))) {
            log.info("\u4fee\u6539\u524d\u540e\u7684\u53c2\u6570\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
            return;
        }
        if (ContractStatusEnum.SIGNED.getValue() == orderContract.getStatus().intValue() || ContractStatusEnum.ARCHIVED.getValue() == orderContract.getStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5408\u540c\u5df2\u7b7e\u7f72\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        orderContract.setTemplateId(reqDto.getTemplateId());
        orderContract.setTemplateName(reqDto.getTemplateName());
        orderContract.setParamMap(reqDto.getJsonParam());
        orderContract.setUpdateBy(userInfo.getId());
        orderContract.setUpdateTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)orderContract.getFddSignUrl())) {
            ContractOrderCustomerExtInfo customerExtInfo = this.customerExtInfoMapper.selectByBizIdCustomerNumAndOrderNo(orderContract.getBizId(), orderContract.getCustomerNum(), orderContract.getOrderNo());
            ContractRespDto contractRespDto = this.createContract(orderContract, orderInfoResp, customerExtInfo, userInfo.getId(), personalCustomerId);
            orderContract.setFddSignUrl(contractRespDto.getFddSignUrl());
            orderContract.setSignUrlCreateTime(contractRespDto.getSignUrlCreateTime());
            orderContract.setContractId(contractRespDto.getContractId());
            orderContract.setDownloadUrl(contractRespDto.getDownloadUrl());
            orderContract.setViewUrl(contractRespDto.getViewUrl());
        }
        this.orderContractMapper.updateByPrimaryKeySelective((Object)orderContract);
    }

    private static String calculateMD5Hash(String input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.info("calculateMD5Hash,input:{}\u53d1\u751f\u5f02\u5e38", (Object)input, (Object)e);
            return "";
        }
        md.update(input.getBytes());
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private ContractRespDto createContract(OrderContract orderContract, CustomerOrderSimpleInfoResp orderInfoResp, ContractOrderCustomerExtInfo customerExtInfo, Long userId, String personalCustomerId) {
        CreateContractReqDto createContractReqDto = new CreateContractReqDto();
        createContractReqDto.setBizId(orderContract.getBizId());
        createContractReqDto.setCorpId(orderContract.getCorpId());
        createContractReqDto.setUserId(userId);
        createContractReqDto.setContractType(NumberUtils.INTEGER_ONE);
        createContractReqDto.setOriginContractId("");
        createContractReqDto.setPersonalCustomerId(personalCustomerId);
        createContractReqDto.setTemplateId(orderContract.getTemplateId());
        createContractReqDto.setIdNo(customerExtInfo.getIdNo());
        createContractReqDto.setCustomerName(orderInfoResp.getCustomerName());
        createContractReqDto.setBusinessDateType(Integer.valueOf(ContractBusinessDataTypeEnum.SCRM_ORDER_CENTER_ORDER.getValue()));
        createContractReqDto.setBusinessDateId(orderInfoResp.getCustomerOrderId());
        createContractReqDto.setBusinessDataNo(orderInfoResp.getOrderNo());
        ContractCompany contractCompany = this.contractCompanyMapper.selectByBizId(orderContract.getBizId());
        HashMap paramsMap = Maps.newHashMap();
        ContractTemplateNameEnum contractTemplateNameEnum = ContractTemplateNameEnum.get(orderContract.getTemplateName());
        switch (contractTemplateNameEnum) {
            case NORMAL_CLASS_CONTRACT: {
                NormalClassContractParam normalClassContractParam = (NormalClassContractParam)JSONObject.parseObject((String)orderContract.getParamMap(), NormalClassContractParam.class);
                this.paddingNormalClassContractParamsMap(paramsMap, normalClassContractParam, customerExtInfo, contractCompany, orderInfoResp);
                break;
            }
            case TEMP_CONTRACT: {
                TempContractParam tempContractParam = (TempContractParam)JSONObject.parseObject((String)orderContract.getParamMap(), TempContractParam.class);
                this.paddingTempContractParamsMap(paramsMap, tempContractParam, customerExtInfo, contractCompany, orderInfoResp);
                break;
            }
            case CUSTOMIZED_ONE_YEAR_CONTRACT: {
                CustomizedOneYearContractParam customizedOneYearContractParam = (CustomizedOneYearContractParam)JSONObject.parseObject((String)orderContract.getParamMap(), CustomizedOneYearContractParam.class);
                this.paddingOneYearContractParamsMap(paramsMap, customizedOneYearContractParam, customerExtInfo, contractCompany, orderInfoResp);
                break;
            }
            case CUSTOMIZED_TWO_YEAR_CONTRACT: {
                CustomizedTwoYearContractParam customizedTwoYearContractParam = (CustomizedTwoYearContractParam)JSONObject.parseObject((String)orderContract.getParamMap(), CustomizedTwoYearContractParam.class);
                this.paddingTwoYearContractParamsMap(paramsMap, customizedTwoYearContractParam, customerExtInfo, contractCompany, orderInfoResp);
                break;
            }
        }
        createContractReqDto.setParams((Map)paramsMap);
        try {
            return this.scrmContractService.createContract(createContractReqDto);
        }
        catch (Exception ex) {
            log.error("createContractReqDto:{},createContract error:", (Object)createContractReqDto, (Object)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private void paddingNormalClassContractParamsMap(Map<String, Object> paramsMap, NormalClassContractParam normalClassContractParam, ContractOrderCustomerExtInfo customerExtInfo, ContractCompany contractCompany, CustomerOrderSimpleInfoResp orderInfoResp) {
        paramsMap.put("\u7532\u65b9", contractCompany.getCompanyName());
        paramsMap.put("\u4e59\u65b9", orderInfoResp.getCustomerName());
        paramsMap.put("\u5546\u54c1\u540d\u79f0", orderInfoResp.getSkuName());
        paramsMap.put("\u5b9e\u9645\u652f\u4ed8\u91d1\u989d", String.valueOf(BigDecimal.valueOf((float)orderInfoResp.getPaidAmount().longValue() / 10000.0f).setScale(2, RoundingMode.HALF_DOWN).floatValue()));
        paramsMap.put("\u670d\u52a1\u5185\u5bb91", normalClassContractParam.getServiceContent1());
        paramsMap.put("\u670d\u52a1\u5185\u5bb92", normalClassContractParam.getServiceContent2());
        paramsMap.put("\u670d\u52a1\u5185\u5bb93", normalClassContractParam.getServiceContent3());
        paramsMap.put("\u670d\u52a1\u5185\u5bb94", normalClassContractParam.getServiceContent4());
        paramsMap.put("\u670d\u52a1\u5185\u5bb95", normalClassContractParam.getServiceContent5());
        paramsMap.put("\u670d\u52a1\u5185\u5bb96", normalClassContractParam.getServiceContent6());
        paramsMap.put("\u5907\u6ce8", normalClassContractParam.getRemark());
        paramsMap.put("\u4e59\u65b9\u7535\u8bdd", orderInfoResp.getCustomerPhone());
        paramsMap.put("\u4e59\u65b9\u5fae\u4fe1\u53f7", customerExtInfo.getWechat());
        paramsMap.put("\u4e59\u65b9\u90ae\u7bb1", customerExtInfo.getMail());
        paramsMap.put("\u4e59\u65b9\u5730\u5740", customerExtInfo.getAddress());
        paramsMap.put("\u6cd5\u5b9a\u4ee3\u8868\u4eba", normalClassContractParam.getLegalRepresentative());
        paramsMap.put("\u7532\u65b9\u7535\u8bdd", normalClassContractParam.getMobile());
        paramsMap.put("\u8eab\u4efd\u8bc1\u53f7", customerExtInfo.getIdNo());
        paramsMap.put("\u7b7e\u8ba2\u65e5\u671f", this.simpleDateFormat.format(new Date()));
        paramsMap.put("\u7b7e\u8ba2\u5730\u70b9", normalClassContractParam.getSignLocation());
    }

    private void paddingTempContractParamsMap(Map<String, Object> paramsMap, TempContractParam tempContractParam, ContractOrderCustomerExtInfo customerExtInfo, ContractCompany contractCompany, CustomerOrderSimpleInfoResp orderInfoResp) {
        paramsMap.put("\u7532\u65b9", orderInfoResp.getCustomerName());
        paramsMap.put("\u4e59\u65b9", contractCompany.getCompanyName());
        paramsMap.put("\u670d\u52a1\u91d1\u989d", tempContractParam.getServiceAmount());
        paramsMap.put("\u670d\u52a1\u91d1\u989d\u5927\u5199", tempContractParam.getServiceAmountInWords());
        paramsMap.put("\u516c\u53f8\u540d\u79f0", contractCompany.getCompanyName());
        paramsMap.put("\u5f00\u6237\u884c\u53ca\u8d26\u53f7", tempContractParam.getReceivingBankAndAccount());
        paramsMap.put("\u8eab\u4efd\u8bc1\u53f7", customerExtInfo.getIdNo());
        paramsMap.put("\u6cd5\u5b9a\u4ee3\u8868\u4eba", tempContractParam.getLegalRepresentative());
        paramsMap.put("\u7532\u65b9\u7535\u8bdd", orderInfoResp.getCustomerPhone());
        paramsMap.put("\u7b7e\u8ba2\u65e5\u671f", this.simpleDateFormat.format(new Date()));
        paramsMap.put("\u7b7e\u8ba2\u5730\u70b9", tempContractParam.getSignLocation());
        paramsMap.put("\u5546\u54c1\u540d\u79f0", orderInfoResp.getSkuName());
    }

    private void paddingOneYearContractParamsMap(Map<String, Object> paramsMap, CustomizedOneYearContractParam oneYearContractParam, ContractOrderCustomerExtInfo customerExtInfo, ContractCompany contractCompany, CustomerOrderSimpleInfoResp orderInfoResp) {
        Date currDate = new Date();
        paramsMap.put("\u8003\u8bd5\u5468\u671f", oneYearContractParam.getCycle());
        paramsMap.put("\u7532\u65b9", contractCompany.getCompanyName());
        paramsMap.put("\u4e59\u65b9", orderInfoResp.getCustomerName());
        paramsMap.put("\u8eab\u4efd\u8bc1\u53f7", customerExtInfo.getIdNo());
        paramsMap.put("\u51c6\u8003\u8bc1\u53f7", customerExtInfo.getExamTicketNumber());
        paramsMap.put("\u4e59\u65b9\u7535\u8bdd", orderInfoResp.getCustomerPhone());
        paramsMap.put("\u5fae\u4fe1\u53f7", customerExtInfo.getWechat());
        paramsMap.put("\u90ae\u7bb1", customerExtInfo.getMail());
        paramsMap.put("\u4e59\u65b9\u901a\u8baf\u5730\u5740", customerExtInfo.getAddress());
        paramsMap.put("\u79d1\u76ee", oneYearContractParam.getSubject());
        paramsMap.put("\u6536\u8d39\u91d1\u989d", oneYearContractParam.getServiceAmount());
        paramsMap.put("\u6536\u8d39\u91d1\u989d\u5927\u5199", oneYearContractParam.getServiceAmountInWords());
        paramsMap.put("\u4e59\u65b9\u62a5\u540d\u65b9\u5f0f\u4e3a\u65b9\u6848", oneYearContractParam.getEnrollmentPlan());
        paramsMap.put("\u524d\u671f\u62a5\u540d\u8bfe\u7a0b", oneYearContractParam.getPreEnrollmentCourse());
        paramsMap.put("\u524d\u671f\u6536\u8d39\u91d1\u989d", oneYearContractParam.getPreEnrollmentAmount());
        paramsMap.put("\u540e\u671f\u652f\u4ed8\u8d39\u7528", oneYearContractParam.getAfterEnrollmentAmount());
        paramsMap.put("\u540e\u671f\u652f\u4ed8\u8d39\u7528\u5927\u5199", oneYearContractParam.getAfterEnrollmentAmountInWords());
        paramsMap.put("\u4f18\u60e0\u91d1\u989d", oneYearContractParam.getDiscountAmount());
        paramsMap.put("\u8bfe\u7a0b\u540d\u79f0", oneYearContractParam.getCourseName());
        paramsMap.put("\u7532\u65b9\u8d26\u6237\u540d", oneYearContractParam.getPartyAAccountName());
        paramsMap.put("\u7532\u65b9\u5f00\u6237\u884c", oneYearContractParam.getPartyABank());
        paramsMap.put("\u7532\u65b9\u8d26\u53f7", oneYearContractParam.getPartyAAccount());
        paramsMap.put("\u65f7\u8bfe\u4e0d\u5f97\u8d85\u51fa", oneYearContractParam.getAbsentLimit());
        paramsMap.put("\u8bfe\u7a0b\u7d2f\u52a0\u4e0d\u5f97\u8d85\u51fa", oneYearContractParam.getAccumulateLimit());
        paramsMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u59d3\u540d", customerExtInfo.getEmergencyContactName());
        paramsMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u5173\u7cfb", customerExtInfo.getEmergencyContactRelation());
        paramsMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u7535\u8bdd", customerExtInfo.getEmergencyContactPhone());
        paramsMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u5730\u5740", customerExtInfo.getEmergencyContactAddress());
        paramsMap.put("\u59d4\u6258\u4ee3\u7406\u4eba", oneYearContractParam.getDelegateName());
        paramsMap.put("\u7b7e\u8ba2\u65e5\u671f", this.simpleDateFormat.format(currDate));
        paramsMap.put("\u5b9a\u5236\u73ed\u8bfe\u7a0b\u65f6\u95f4", this.simpleDateFormat.format(oneYearContractParam.getCourseDate()));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        paramsMap.put("\u5e74", year);
        paramsMap.put("\u6708", month);
        paramsMap.put("\u65e5", day);
        paramsMap.put("\u7532\u65b9\u5feb\u9012\u4fe1\u606f", oneYearContractParam.getPartyAExpressInfo());
        paramsMap.put("\u7532\u65b9\u8054\u7cfb\u4eba", oneYearContractParam.getContactPerson());
        paramsMap.put("\u7532\u65b9\u5730\u5740", oneYearContractParam.getAddress());
        paramsMap.put("\u7532\u65b9\u7535\u8bdd", oneYearContractParam.getPhone());
    }

    private void paddingTwoYearContractParamsMap(Map<String, Object> paramsMap, CustomizedTwoYearContractParam twoYearContractParam, ContractOrderCustomerExtInfo customerExtInfo, ContractCompany contractCompany, CustomerOrderSimpleInfoResp orderInfoResp) {
        this.paddingOneYearContractParamsMap(paramsMap, twoYearContractParam, customerExtInfo, contractCompany, orderInfoResp);
        paramsMap.put("\u65b9\u6848\u4e00\u9000\u8d39\u91d1\u989d", twoYearContractParam.getPlanOneRefundAmount());
        paramsMap.put("\u65b9\u6848\u4e00\u9000\u8d39\u91d1\u989d\u5927\u5199", twoYearContractParam.getPlanOneRefundAmountInWords());
        paramsMap.put("\u65b9\u6848\u4e8c\u6263\u8d39\u91d1\u989d", twoYearContractParam.getPlanTwoDeductAmount());
        paramsMap.put("\u65b9\u6848\u4e8c\u9000\u8d39\u91d1\u989d", twoYearContractParam.getPlanTwoRefundAmount());
        paramsMap.put("\u65b9\u6848\u4e8c\u9000\u8d39\u91d1\u989d\u5927\u5199", twoYearContractParam.getPlanTwoRefundAmountInWords());
        paramsMap.put("\u529e\u7406\u624b\u7eed\u622a\u6b62\u65e5\u671f", this.simpleDateFormat.format(twoYearContractParam.getDeadlineDate()));
    }

    private ContractOrderCustomerExtInfo buildCustomerExtInfo(CustomerExtInfoDto reqDto, OrderContract orderContract) {
        ContractOrderCustomerExtInfo customerExtInfo = new ContractOrderCustomerExtInfo();
        customerExtInfo.setBizId(orderContract.getBizId());
        customerExtInfo.setCorpId(orderContract.getCorpId());
        customerExtInfo.setCustomerNum(orderContract.getCustomerNum());
        customerExtInfo.setOrderNo(orderContract.getOrderNo());
        customerExtInfo.setIdNo(reqDto.getIdNo());
        customerExtInfo.setExamTicketNumber(reqDto.getExamTicketNumber());
        customerExtInfo.setMail(reqDto.getMail());
        customerExtInfo.setWechat(reqDto.getWechat());
        customerExtInfo.setAddress(reqDto.getAddress());
        customerExtInfo.setEmergencyContactName(reqDto.getEmergencyContactName());
        customerExtInfo.setEmergencyContactRelation(reqDto.getEmergencyContactRelation());
        customerExtInfo.setEmergencyContactPhone(reqDto.getEmergencyContactPhone());
        customerExtInfo.setEmergencyContactAddress(reqDto.getEmergencyContactAddress());
        Date currentDate = new Date();
        customerExtInfo.setCreateTime(currentDate);
        customerExtInfo.setUpdateTime(currentDate);
        return customerExtInfo;
    }

    private boolean checkCustomerExtInfoIsChanged(CustomerExtInfoDto reqDto, ContractOrderCustomerExtInfo customerExtInfo) {
        boolean isChanged = false;
        if (!StringUtils.equals((CharSequence)reqDto.getIdNo(), (CharSequence)customerExtInfo.getIdNo())) {
            isChanged = true;
            customerExtInfo.setIdNo(reqDto.getIdNo());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getExamTicketNumber(), (CharSequence)customerExtInfo.getExamTicketNumber())) {
            isChanged = true;
            customerExtInfo.setExamTicketNumber(reqDto.getExamTicketNumber());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getMail(), (CharSequence)customerExtInfo.getMail())) {
            isChanged = true;
            customerExtInfo.setMail(reqDto.getMail());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getWechat(), (CharSequence)customerExtInfo.getWechat())) {
            isChanged = true;
            customerExtInfo.setWechat(reqDto.getWechat());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getAddress(), (CharSequence)customerExtInfo.getAddress())) {
            isChanged = true;
            customerExtInfo.setAddress(reqDto.getAddress());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getEmergencyContactName(), (CharSequence)customerExtInfo.getEmergencyContactName())) {
            isChanged = true;
            customerExtInfo.setEmergencyContactName(reqDto.getEmergencyContactName());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getEmergencyContactRelation(), (CharSequence)customerExtInfo.getEmergencyContactRelation())) {
            isChanged = true;
            customerExtInfo.setEmergencyContactRelation(reqDto.getEmergencyContactRelation());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getEmergencyContactPhone(), (CharSequence)customerExtInfo.getEmergencyContactPhone())) {
            isChanged = true;
            customerExtInfo.setEmergencyContactPhone(reqDto.getEmergencyContactPhone());
        }
        if (!StringUtils.equals((CharSequence)reqDto.getEmergencyContactAddress(), (CharSequence)customerExtInfo.getEmergencyContactAddress())) {
            isChanged = true;
            customerExtInfo.setEmergencyContactAddress(reqDto.getEmergencyContactAddress());
        }
        return isChanged;
    }

    static {
        templateToParamClass.put(ContractTemplateNameEnum.NORMAL_CLASS_CONTRACT.getName(), NormalClassContractParam.class);
        templateToParamClass.put(ContractTemplateNameEnum.TEMP_CONTRACT.getName(), TempContractParam.class);
        templateToParamClass.put(ContractTemplateNameEnum.CUSTOMIZED_ONE_YEAR_CONTRACT.getName(), CustomizedOneYearContractParam.class);
        templateToParamClass.put(ContractTemplateNameEnum.CUSTOMIZED_TWO_YEAR_CONTRACT.getName(), CustomizedTwoYearContractParam.class);
    }
}

