/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.contract.service.impl;

import cn.kinyun.scrm.contract.dto.req.CompanyAddOrModReqDto;
import cn.kinyun.scrm.contract.dto.resp.CompanyRespDto;
import cn.kinyun.scrm.contract.service.CompanyService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.contract.entity.ContractCompany;
import com.kuaike.scrm.dal.contract.mapper.ContractCompanyMapper;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CompanyServiceImpl
implements CompanyService {
    private static final Logger log = LoggerFactory.getLogger(CompanyServiceImpl.class);
    @Resource
    private ContractCompanyMapper companyMapper;
    @Resource
    private IdGen idGen;

    @Override
    public void addOrMod(CompanyAddOrModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        log.info("addOrMod, reqDto:{}, operatorId:{}", (Object)reqDto, (Object)userId);
        reqDto.validateParams();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getId())) {
            ContractCompany contractCompany = this.companyMapper.selectByBizIdAndNum(bizId, reqDto.getId());
            Preconditions.checkArgument((boolean)Objects.nonNull(contractCompany), (Object)"\u7532\u65b9\u4fe1\u606f\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
            contractCompany.setCompanyName(reqDto.getCompanyName());
            contractCompany.setCompanyAddress(reqDto.getCompanyAddress());
            contractCompany.setCorporateAccount(reqDto.getCorporateAccount());
            contractCompany.setCustomerServiceTel(reqDto.getCustomerServiceTel());
            contractCompany.setUpdateBy(userInfo.getId());
            contractCompany.setUpdateTime(new Date());
            this.companyMapper.updateByPrimaryKey((Object)contractCompany);
        } else {
            int count = this.companyMapper.selectCountByBizId(bizId);
            Preconditions.checkArgument((count == 0 ? 1 : 0) != 0, (Object)"\u5f53\u524d\u5546\u6237\u4e0b\u5df2\u5b58\u5728\u7532\u65b9\u516c\u53f8\u4fe1\u606f\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            ContractCompany contractCompany = new ContractCompany();
            BeanUtils.copyProperties((Object)reqDto, (Object)contractCompany);
            contractCompany.setBizId(bizId);
            contractCompany.setCorpId(userInfo.getCorpId());
            contractCompany.setNum(this.idGen.getNum());
            contractCompany.setCreateBy(userId);
            contractCompany.setUpdateBy(userId);
            Date curDate = new Date();
            contractCompany.setCreateTime(curDate);
            contractCompany.setUpdateTime(curDate);
            contractCompany.setIsDeleted(NumberUtils.INTEGER_ZERO);
            this.companyMapper.insert((Object)contractCompany);
        }
    }

    @Override
    public CompanyRespDto detail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        log.info("company detail, operatorId:{}", (Object)userId);
        ContractCompany contractCompany = this.companyMapper.selectByBizId(bizId);
        CompanyRespDto companyRespDto = new CompanyRespDto();
        if (Objects.nonNull(contractCompany)) {
            BeanUtils.copyProperties((Object)contractCompany, (Object)companyRespDto);
            companyRespDto.setId(contractCompany.getNum());
        }
        return companyRespDto;
    }
}

